--> Pralable
/*
USE DB_ESPACE;
GO

CREATE SCHEMA S_GEO
GO
*/

CREATE TABLE S_GEO.T_DEPARTEMENT_ET_DOMTOM_DED
(DED_ID     INT IDENTITY PRIMARY KEY,
 DED_NOM    VARCHAR(64) NOT NULL,
 DED_CODE   CHAR(4) NOT NULL,
 DED_GEO    geography NOT NULL);
GO

CREATE SPATIAL INDEX X_DED_GEO_GEO
   ON S_GEO.T_DEPARTEMENT_ET_DOMTOM_DED (DED_GEO)
   USING GEOGRAPHY_AUTO_GRID
   WITH (CELLS_PER_OBJECT = 1024,
         FILLFACTOR = 100);
GO

/*
INSERT INTO S_GEO.T_DEPARTEMENT_ET_DOMTOM_DED VALUES
('Ain', '01', 'POLYGON ((5.06055951589488 45.811744306399461, 5.0838675518019727 45.812305282032767, 5.1825475133942973 45.781898360875786, 5.2215054845249824 45.780090283779671, 5.2406444875249747 45.7860073709743, 5.2886375635372929 45.84177736114755, 5.3225094377352775 45.86714535872288, 5.3417195528017487 45.873050300539845, 5.3808544239988123 45.868454419213904, 5.4169265477783313 45.844635397343993, 5.4426064527343385 45.7905314361539, 5.4792884856978787 45.75032037888154, 5.5114895783736415 45.723674300329279, 5.6050785144742008 45.616268324916561, 5.6284134814361835 45.613990274509817, 5.6665225082683151 45.631153277365613, 5.6887054245493971 45.658920427084652, 5.7065054436640708 45.700275438119448, 5.7593665278705544 45.739536339612513, 5.7699954935490609 45.767059349637989, 5.7689754578430552 45.79436532704473, 5.7757275837588793 45.821834298940487, 5.8043155145818162 45.890682396606437, 5.8177894909792371 45.948314325985578, 5.814487532427222 46.03844429372397, 5.8397294997065217 46.096271429245988, 5.8587595463472439 46.110271353303361, 5.8785934761750696 46.102432304094251, 5.882977429461306 46.08884831521776, 5.90288458359521 46.07827039532954, 5.9222154483587133 46.084064268547635, 5.9607015099591649 46.10112042728376, 5.9950185386524879 46.12630430797411, 5.9853525782108363 46.144939365809947, 5.9763245141278674 46.147648313094734, 5.9983345788018312 46.180042323653808, 5.9773285320169123 46.192939306600962, 5.9785344448075648 46.204147377969335, 6.0209235731456658 46.231338414337941, 6.0481295712114331 46.232242276866018, 6.0645205504940805 46.239738439180357, 6.1202145000417829 46.250133298303368, 6.1239154958579149 46.258735394067358, 6.1144264354826134 46.286232353137805, 6.1661234996504675 46.352733400570131, 6.1656225468257446 46.3798373070553, 6.1528234309799643 46.3784333718023, 6.0826734896416212 46.435440430300289, 6.0296555716449518 46.380943416524943, 6.0222674855900777 46.367180415342474, 5.9576245049243539 46.305988306120454, 5.9041894196070359 46.264095378067978, 5.8654104607823285 46.252479292417192, 5.7866925715534876 46.26197838593059, 5.72782744628887 46.263610267040221, 5.7079185319553005 46.2714343545522, 5.7113164213890855 46.285144373724719, 5.7029394551622659 46.298664291333395, 5.66333056219537 46.308818355142208, 5.6465644843640916 46.335819289946969, 5.62651457803733 46.346340355386005, 5.6072315907047141 46.337776279934772, 5.5388235429550434 46.284469337153084, 5.49618552238428 46.272659277499216, 5.4560645873347653 46.293670428863166, 5.4396875136294796 46.309719401350847, 5.4003655332080314 46.311599294593307, 5.3873914535155336 46.338646346629318, 5.3548094536322139 46.365242435511064, 5.334699524496898 46.375736393875243, 5.2950594759959131 46.383052311743839, 5.3206844627223688 46.424614322259274, 5.3205725140236666 46.448516425553393, 5.300412419197869 46.437816347808408, 5.2892525773003172 46.423900385275047, 5.2698645060476963 46.417995267438144, 5.2501045046057868 46.42027631018432, 5.1900294180913136 46.443477325951775, 5.1448024958529288 46.483383340622154, 5.0662034201014876 46.4814833811035, 4.9665185605202851 46.506340392716012, 4.9274685309471238 46.499874299245775, 4.8934065551852655 46.474407378449271, 4.868083442701419 46.432762286509629, 4.8560595187882143 46.364101298068093, 4.8246225287871312 46.292225304938015, 4.777748587721959 46.217163350413855, 4.7753534840374812 46.189758273765946, 4.7878274910050891 46.176426345481516, 4.7861674467008015 46.135402428003758, 4.7689164338617331 46.093910297415036, 4.7401144627594931 46.04938534280312, 4.7299825774664725 45.950702388871392, 4.7499164866352714 45.943042351968231, 4.7891335591566815 45.938640268625463, 4.8015535279945709 45.925308340341005, 4.7945035762953694 45.911445359817591, 4.8144244599866681 45.9037744096765, 4.8729234637208947 45.9026223589956, 4.8938154495675121 45.875816278293783, 4.9037464960787531 45.835079273361444, 4.943028519967811 45.827896426587543, 4.9817495682235347 45.8316303381374, 5.0208854955403694 45.827152390189056, 5.06055951589488 45.811744306399461))'),
('Aisne', '02', 'POLYGON ((3.1083954675119969 49.114811432157509, 3.1599395703289588 49.102298348757344, 3.1734804343136602 49.089191373990147, 3.1935424860181172 49.049053365003871, 3.1865194653738058 49.03514831570844, 3.1918335081631426 49.0217213366421, 3.2343845748704609 49.006977376186214, 3.2478935792412074 48.993847342803363, 3.26375157006521 48.953540354649263, 3.2772514213977217 48.940406272807209, 3.2982435626052791 48.935730302396493, 3.3158265491012173 48.922767311961891, 3.3370545570639081 48.915374297347952, 3.3580424737922669 48.910698326937265, 3.3783405682718239 48.914180353915029, 3.405247508414476 48.887893356094494, 3.4688114866853823 48.865673299600459, 3.4843095166778539 48.877147337138254, 3.5064964814181678 48.907955407798951, 3.5464584704378979 48.923008283296085, 3.5658715365257763 48.937347397828958, 3.587033537001048 48.981720271189786, 3.6136354345416919 49.009929407044766, 3.6038624539604029 49.0286713090003, 3.572876427113556 49.054855335140431, 3.5800145648159685 49.068748415078133, 3.6151245634584654 49.094520378476616, 3.596438459832342 49.121143398413253, 3.5953724829150815 49.134727387289743, 3.6150935839443719 49.146331327562834, 3.7206164977552305 49.171768324965043, 3.7234785824109053 49.188232352533774, 3.7100185115908459 49.201416424046343, 3.6887494909759369 49.208854323751737, 3.6461674447545249 49.275524350351944, 3.6518275427980313 49.308429346873808, 3.6673095549735422 49.32259332154, 3.686909554265867 49.336895295859946, 3.7311835044055215 49.3547664270411, 3.7558085217021642 49.358322382404779, 3.8396545766356951 49.3474693433089, 3.8597175084399566 49.356319275185754, 3.8748504730218656 49.375885302624553, 3.8949325910024868 49.384719392704412, 3.9156485568825872 49.385395309375852, 3.9837594829287468 49.363056439404446, 4.0087914583879751 49.361129372810936, 4.0291034584448937 49.367218431512882, 4.0595144280611066 49.406322323195795, 4.0731415418293864 49.447601293605075, 4.072985588139062 49.507518314189596, 4.0977834570428229 49.568229360843119, 4.0956275644928439 49.598121423598016, 4.0387815642642408 49.634475355343952, 4.0377895157328965 49.648067441138906, 4.05862359101053 49.648716426755485, 4.101418445371479 49.633705444010374, 4.12162448140856 49.642498345418076, 4.1248495192351982 49.656204316131394, 4.1197294504489435 49.669674420089549, 4.1810535746458868 49.687873300448345, 4.2212165784673914 49.710834401001435, 4.2369605083530928 49.724914414143583, 4.2595294364207632 49.760986361903164, 4.2191504561003228 49.800617433385824, 4.2256105648916957 49.828048384968795, 4.2708814921217311 49.900150387735906, 4.2732105883187614 49.927440347325685, 4.2555205816831858 49.940517398698589, 4.2340035489354477 49.948055277744984, 4.2207274189804025 49.961185311127835, 4.1991655011412092 49.960121270430179, 4.1863725459942884 49.974517415432231, 4.1492675370511733 49.981323403457807, 4.1521535604223061 50.000423330025242, 4.1269865776487507 49.9775203160611, 4.0812824652810775 49.970672435283504, 4.0391844739675946 49.972110342390025, 3.9974675658816352 50.025241441225162, 3.9796754676654587 50.03830740334017, 3.8762704260918213 50.015945298733172, 3.8550915276997841 50.018005436421348, 3.8446174595918023 50.044872420031581, 3.8267894533024673 50.057903354173263, 3.7380305050833158 50.063133435438559, 3.7108054968611555 50.035007381007787, 3.6907265472399331 50.023445333486748, 3.6701885375460108 50.017295371876386, 3.6282734309777425 50.015869434127595, 3.5660655105288868 50.005561352848062, 3.5234894489863393 50.012245359036839, 3.4820194969133809 50.00533639933083, 3.4175565846734344 50.022110398060633, 3.3139424313795303 50.0047303625861, 3.2920434353044641 50.014827395925764, 3.2496655722441972 50.018692442350684, 3.1586685301506918 50.001674303927317, 3.1983244204486425 49.981369344669062, 3.1835264218630357 49.959011288521296, 3.1333005325753618 49.957107280543411, 3.084354484464285 49.895313359055834, 3.0631954763284739 49.89723232873088, 3.0479764379829533 49.880275445255862, 3.0450495779795972 49.866546415926948, 3.0684334784922669 49.840229318692124, 3.0606585005509714 49.788150291196914, 3.102873545142188 49.784340339021512, 3.098719473932249 49.737850297503329, 3.1053434573124434 49.710865380515528, 3.11396544333266 49.615825335810953, 3.1086244694884329 49.5365644249854, 3.1235284320939058 49.509899336276746, 3.1259615560911413 49.482727310064533, 3.1493764361179331 49.453651275874435, 3.1423055380427343 49.439739361800306, 3.0786595344673913 49.453632441738009, 3.07159550117089 49.439724400103145, 3.0809155823783385 49.382846364240649, 3.0629564412139416 49.352150418298621, 3.051763507562697 49.3380813183944, 2.9917035587653231 49.313881389316904, 2.9805544540857625 49.29980841697342, 3.0239004269618874 49.279712393415437, 3.0450404249413339 49.275085356555437, 3.0404964695055412 49.234001416269095, 3.0208364474046334 49.222320379250661, 3.0002174685261025 49.221496429787365, 2.9788275221941944 49.228828365472921, 2.9718254479259087 49.21492437229729, 2.9730714932689182 49.201336334961567, 3.0297094378970826 49.170868334876204, 3.0400824705442631 49.193081350571575, 3.0388554353576467 49.2066683317875, 3.0599744869610674 49.202037422488232, 3.1007644739033253 49.209098287425334, 3.1196795795059131 49.182563277471971, 3.1412884946761608 49.1725003920058, 3.1548545295160579 49.159393417238576, 3.1560905417209995 49.145790418205721, 3.1449065850880515 49.131717269842241, 3.1083954675119969 49.114811432157509))'),
('Allier', '03', 'POLYGON ((2.5476775274335068 46.127346346175912, 2.6456995263909562 46.126354297644596, 2.6644525176043885 46.135418269800752, 2.6788104662736885 46.149749287415162, 2.710173527888827 46.192207415580171, 2.7292074469688146 46.198524420138753, 2.7240454854305369 46.211982378719213, 2.7435734925565782 46.212860366312228, 2.7841314851829395 46.198230290774674, 2.8029374584062907 46.207264339536508, 2.809505467437134 46.221241380998251, 2.8070434761653758 46.248504409533169, 2.8258725080043234 46.25752244047807, 2.8451824263918297 46.261112367695304, 2.9282525853129187 46.253746284136227, 2.9333635010608816 46.240284277096535, 2.8981285282421254 46.194992403490474, 2.904451517479572 46.1679043388023, 2.9614735376747205 46.142974278903679, 2.9677694198373104 46.115883397896042, 3.031809532117677 46.099430283565212, 3.070354560406912 46.106506286219442, 3.0905445786270036 46.099144427139564, 3.0839005289706165 46.085182347374982, 3.0979224555238432 46.058406366087453, 3.1572945182920193 46.049907418023835, 3.2152934493013561 46.057743298873547, 3.2739785061401676 46.05736133554619, 3.3400254220588863 46.062740329703175, 3.4147274157515142 46.057441424630966, 3.4547835754533196 46.045318401476592, 3.512087579634823 46.011924421487734, 3.5707124376451134 46.011428397222048, 3.6107094546381688 45.999229333442159, 3.6310235669346866 45.989040417679959, 3.63982157292142 45.97569229555863, 3.6805784681099567 45.952552358719558, 3.6984184437570207 45.975101396531, 3.7174764775724327 45.981269312177929, 3.7955445010848621 45.981342360464041, 3.8146315781947351 45.987480352716673, 3.8173495024978195 46.003990321496687, 3.769522589333917 46.232036333505206, 3.780258575152061 46.24609328803173, 3.8784375839196343 46.244072402796078, 3.9169875407679342 46.2536014197038, 3.9926335295409956 46.294468327371405, 3.9726015772508276 46.356674311600628, 3.9685904342537128 46.413974267322871, 3.9578935248681262 46.454624318391765, 3.9490835495236638 46.467998315448185, 3.8491415247713974 46.489170349061524, 3.7278245153843557 46.53135635035828, 3.7061455442674287 46.557918291366533, 3.6939795722412327 46.614917428966024, 3.632639430227357 46.694717312929086, 3.6156744498339037 46.729850370187208, 3.59485850461283 46.723400294533931, 3.5573294635703689 46.697414290856145, 3.5191785439862144 46.679588396806409, 3.4615735456619632 46.658252312584253, 3.441212436034391 46.665683347510978, 3.4193354424551217 46.69220339576718, 3.3856005117910684 46.718258399271846, 3.3282334924615498 46.694145424057851, 3.3085065827733615 46.6933864259622, 3.2478085615973669 46.710136309956582, 3.2093064821799828 46.697643292832581, 3.1986074605547969 46.683540397094774, 3.179369534333631 46.677295384702504, 3.12141443229595 46.707760392448435, 3.0599255534103804 46.732586424546852, 3.0429614531167317 46.745567369018048, 3.0315194512128585 46.78611339228668, 3.0377584789262642 46.805523290015159, 3.0073505016494835 46.790584299436389, 2.94863446529655 46.782653367804741, 2.9101235848808358 46.770076389156728, 2.834654496174096 46.72855028671448, 2.777500461004081 46.704162368312737, 2.7580495506234115 46.7005882828925, 2.7381094807557531 46.7024463496591, 2.7003445729581586 46.725391432395256, 2.6230614224764395 46.705532331712206, 2.5959034778615546 46.657787267832717, 2.5770065023155269 46.648704285520168, 2.5926794961547159 46.608387440247938, 2.5967914985926654 46.564781309861289, 2.5941504950149579 46.55097940826623, 2.5797404444355436 46.536640293733356, 2.5210564437165033 46.531204269107221, 2.3990325381439277 46.528263327506536, 2.3608145549525261 46.51551842581047, 2.3321044662728241 46.486774365277213, 2.3115365331845794 46.455692407548625, 2.29300743936858 46.443851368380635, 2.2774914553395149 46.402019343236546, 2.286140548434588 46.389557305626695, 2.3162765748630818 46.368316272186448, 2.2993994284329062 46.34012931484726, 2.3007514377957534 46.326492343960851, 2.3211305014599191 46.319259331496468, 2.3597434734562341 46.326580353944124, 2.3798375607945843 46.322063329563193, 2.3840865067664936 46.278453326737278, 2.4245274461151212 46.2666853358554, 2.4506104367944772 46.240535281568796, 2.5089615837568147 46.204940347918509, 2.5349704700302311 46.17875632177838, 2.5534335563587831 46.149505323741565, 2.5476775274335068 46.127346346175912))'),
('Alpes-De-Haute-Provence', '04', 'POLYGON ((6.8999655257629229 44.366043387793653, 6.9080605080033592 44.37974531004771, 6.9074655605164992 44.419746375500026, 6.9233705486715849 44.428039380202804, 6.9533645269870874 44.429248285332889, 6.9465585389615114 44.440742389146848, 6.9251624319307723 44.456443370160727, 6.9174684231740855 44.471035425385494, 6.8890644332161628 44.485641386187623, 6.8672694649413017 44.531131282256, 6.8896685337412862 44.554031303880706, 6.9204665712638871 44.55873543748605, 6.9414685695895457 44.576030279296774, 6.9617624395899327 44.62202834500853, 6.9730625694007813 44.622432310831712, 6.9752624669423824 44.626732302593908, 6.9560585125747423 44.650421421728524, 6.9271674753694583 44.646202399150937, 6.84776944498995 44.612655281791163, 6.6860775037417284 44.515300398506852, 6.6720925413814882 44.457737292934624, 6.6385614418387036 44.42731136162125, 6.6008625415285564 44.415912308589228, 6.56292654232351 44.415451312296895, 6.5057695148140624 44.425678424391819, 6.45176042838591 44.460510311487226, 6.4328014938116667 44.4602622993544, 6.4136125011411593 44.468197279445278, 6.4015225697405072 44.495376346456155, 6.38597243783795 44.508838353495847, 6.3671955079090878 44.500377425745015, 6.352706424364726 44.472820267846046, 6.33788448706369 44.458965384241068, 6.31913343206989 44.450496359571773, 6.2435254636095863 44.438434415345782, 6.2414464917849841 44.378276423427096, 6.2270575636015622 44.35071134462963, 6.2080114991439075 44.3531453487267, 6.1840944341526267 44.3937873028771, 6.1685305726926742 44.407222378861931, 6.1303685638506238 44.41481042359878, 6.1185614965361594 44.428287392335633, 6.0801065904697964 44.444061421635595, 5.98678150829906 44.39601941207259, 5.9132354377265983 44.326381336796871, 5.9099135889183856 44.312652307467985, 5.9221934458629164 44.285522350027762, 5.9188835664124042 44.271793320698848, 5.9002305545399736 44.263260400781704, 5.88095055954679 44.273838320669896, 5.8767054860141457 44.28742935034505, 5.8610814257256436 44.300815316759227, 5.8420615882429843 44.303196338846377, 5.8233355280844421 44.297371310094221, 5.8086915469695555 44.283435281284696, 5.8053885322977408 44.269687417819355, 5.8176984886565322 44.242607274029652, 5.8756405652166848 44.208126370747507, 5.8647924546798436 44.194259341764834, 5.8269995597075877 44.193561422597568, 5.8079175871767461 44.1986693460061, 5.7510325105155573 44.203045378393838, 5.6755574371299815 44.198814386458523, 5.6487934252001537 44.206470374902452, 5.61154355182461 44.192024416249879, 5.6201544485869306 44.164867351734827, 5.5828185014477754 44.15317135301926, 5.57851850968558 44.166729290940694, 5.5817435475122181 44.180484371224665, 5.5624174352877844 44.191005436663673, 5.5435364775587175 44.190601294820553, 5.5252025898855948 44.1765554295519, 5.53439945711645 44.13573428707555, 5.5198665446004327 44.121742283916674, 5.4832994526750269 44.110111412588722, 5.4868015459289836 44.099144312554515, 5.4814885592594464 44.044353345435056, 5.5165165325975636 44.017761305012542, 5.51762158594741 43.990451279146569, 5.5079874851196848 43.949226346867036, 5.5651885176207543 43.931305402035363, 5.5807525551006734 43.917984386988863, 5.5813075460551431 43.904300418771371, 5.5459935402714109 43.846145358051743, 5.5358104331681091 43.818592424631973, 5.5547945385975765 43.813511432278304, 5.5922255365186686 43.817051369825052, 5.6111904557717764 43.811988331507976, 5.6303935300395835 43.80144543959311, 5.65395855509783 43.774593417680038, 5.7109214325842 43.756584286845126, 5.7300834941998176 43.746044387269691, 5.7380864179977493 43.732521301301617, 5.7641294521446866 43.7385022837441, 5.7824744290757053 43.749797308975943, 5.8012365733274009 43.750148292789177, 5.8201814263043161 43.745048290279144, 5.851583564352012 43.704620376408016, 5.8701255076255734 43.710453326058669, 5.884176477473261 43.738052376709661, 5.9027715787767079 43.74385434684622, 5.9416075680705944 43.703552287251156, 5.9691705346284607 43.663036363396785, 5.9882345531227088 43.652446298130869, 6.0069625495008836 43.652759437651312, 6.0177854891825007 43.666622418174754, 6.03614648393048 43.67787132617535, 6.0733674900315009 43.686687286198676, 6.0987564339828282 43.714458308356981, 6.1171515766043285 43.72570035157888, 6.1360004986994738 43.723270395941014, 6.1729145259789107 43.742992377070138, 6.1875155582219747 43.756897426365569, 6.2246374650818552 43.7711453625558, 6.2435374329673152 43.765953301603261, 6.3198204379992262 43.720626400023875, 6.3575974911745163 43.710224324082233, 6.3761165518524194 43.718692292631729, 6.4088344391498993 43.760166293163891, 6.4649504845773151 43.766369412804139, 6.4835184788059337 43.774818371197242, 6.5213504502107469 43.761650317501633, 6.5731474937196026 43.795089358601942, 6.5919055895120664 43.795322409037638, 6.6111445718530319 43.773700292369895, 6.6672794514169027 43.78255427270598, 6.6858074891131025 43.793686303448808, 6.6704995606844761 43.807182282342026, 6.6516835543230286 43.8097072887618, 6.6438915024449727 43.823276315941158, 6.64678245437517 43.864315371136044, 6.6655104507533451 43.867267401994596, 6.72205246449974 43.859687278156244, 6.7595274674124823 43.865547334881725, 6.7782005455610772 43.871212361484325, 6.8077055404096143 43.901588303127184, 6.8265595670838195 43.899051327349682, 6.8496164224986842 43.87195234942358, 6.8871875323131349 43.872306325576247, 6.9058604344417915 43.880684347922866, 6.913141500357 43.89442429048971, 6.9091694337924423 43.90803943490026, 6.8823605367711593 43.935123275109262, 6.7878385188280674 43.958789335628282, 6.7497685684284932 43.980255322585705, 6.7374065101596159 44.0348093668302, 6.7296165705211592 44.048374345550329, 6.6872945057902768 44.088897310203365, 6.6712904183940509 44.132465420277256, 6.6738705190633425 44.189888413956126, 6.6918794738782879 44.23384130367684, 6.7067315105936132 44.2476572868692, 6.7442814980120716 44.261734307671944, 6.7997295476665442 44.333381298825586, 6.8372615810484092 44.35288642335594, 6.8787514233775653 44.364235310697538, 6.8999655257629229 44.366043387793653))'),
('Alpes-Maritimes', '06', 'POLYGON ((6.9123164947739042 43.4494664094551, 6.91786446809877 43.454197298095337, 6.9226685810450874 43.474792338258439, 6.9330634401680982 43.483593336584605, 6.9451595322675814 43.484394403452242, 6.9518625486127519 43.506492302089484, 6.9414585364514778 43.510391320367958, 6.9370675423665773 43.524200438781619, 6.9676645650874036 43.546390395861366, 6.9987535636146845 43.549598359751272, 7.0355464891571273 43.534397275442316, 7.0655464521514943 43.5617903827325, 7.0920415055724675 43.566490291858642, 7.1158445096254468 43.560489419159907, 7.1131364424404921 43.543987371278391, 7.1324435445085044 43.544086294499593, 7.1410334948947991 43.552093266756756, 7.1326355822919822 43.556892275124042, 7.1263375878897932 43.57449339167654, 7.1279435940643339 43.619884364523742, 7.1632255642141729 43.655697386912564, 7.2086364273175718 43.6576804278554, 7.2455305643407826 43.695186410282233, 7.2790845464792255 43.696113331425963, 7.2963315108590905 43.687084387243132, 7.3036254262318607 43.700683337816784, 7.3159274616921834 43.701980428950108, 7.3168244594415626 43.6855734318505, 7.3259255718106715 43.678474370580673, 7.3387324325349539 43.688072387315245, 7.3262235736139871 43.706775388858162, 7.3472384213972077 43.721763312987648, 7.3645334392279267 43.7184442804989, 7.3906445931019107 43.723404347135542, 7.4010505414828174 43.720096403904662, 7.4073615613625634 43.724979373795989, 7.3890774873399607 43.742698423726054, 7.4070774651365809 43.758400284839766, 7.42538142941541 43.763096321526618, 7.4362765372832769 43.754306412458348, 7.4497874778736843 43.751079438412077, 7.4566005066979244 43.754741357795652, 7.4804154801086042 43.749401264051258, 7.4889225250906861 43.76555232811954, 7.5274024259922783 43.78139130878715, 7.49071458436984 43.86156840353847, 7.492614543888493 43.872177302940784, 7.5107145010261149 43.887775312274258, 7.5572094711033628 43.907768364151806, 7.5669055309593034 43.943771312084507, 7.6248104673065029 43.963367438937567, 7.6506035531009786 43.980671433786583, 7.6674234930420369 43.999847400979533, 7.6593994468481128 44.016666284800792, 7.6663034779950578 44.031463403286565, 7.7013025840586522 44.045063409980017, 7.712806544990741 44.06555935090195, 7.7142984902270086 44.087761277339425, 7.6907405059674261 44.105720418503822, 7.6675025260070129 44.129562322969392, 7.6744984395764675 44.143356303665954, 7.6740055836702084 44.15895836145863, 7.6883035095309253 44.174854372595419, 7.6842045325705044 44.177257397178394, 7.6341025613392617 44.176254435409149, 7.6147044569485445 44.154560326575094, 7.5695065780045923 44.156360306752745, 7.53690856030434 44.149860417448949, 7.5267094353840776 44.143154408764346, 7.5069195105478741 44.145656356568495, 7.4720214399450526 44.127155425947151, 7.4369235866802228 44.126262300637009, 7.43142049844684 44.114357366221171, 7.3910154671713713 44.121761294073039, 7.3623175238693648 44.115459427231585, 7.3543195286304694 44.122158395117523, 7.3452314417389175 44.14595840683107, 7.3182245222552922 44.143955299612017, 7.3001224528780995 44.148357382954813, 7.2803344642615286 44.139656363969621, 7.249932471663584 44.154655377357, 7.2422314221082331 44.170852382636539, 7.2195345275249 44.172058295427192, 7.2007364752000456 44.181053267756468, 7.1957364520309852 44.197654414879125, 7.1673315819732579 44.203258362553342, 7.1445334759091566 44.200256342024275, 7.0748445308631176 44.231052267307277, 7.0233495376168378 44.223449436893233, 7.0039415761079908 44.237957354574021, 7.0109485789353414 44.243850327033257, 7.0033475087209638 44.279457406061212, 6.9938614406850945 44.28614440458945, 6.9811545593017854 44.28734943728027, 6.9683665327139011 44.299045435995836, 6.9675624735068311 44.3129503092713, 6.9394635261508881 44.333149304509689, 6.9323674572204652 44.354351437537318, 6.8999655257629229 44.366043387793653, 6.8787514233775653 44.364235310697538, 6.8372615810484092 44.35288642335594, 6.7997295476665442 44.333381298825586, 6.7442814980120716 44.261734307671944, 6.7067315105936132 44.2476572868692, 6.6918794738782879 44.23384130367684, 6.6738705190633425 44.189888413956126, 6.6712904183940509 44.132465420277256, 6.6872945057902768 44.088897310203365, 6.7296165705211592 44.048374345550329, 6.7374065101596159 44.0348093668302, 6.7497685684284932 43.980255322585705, 6.7878385188280674 43.958789335628282, 6.8823605367711593 43.935123275109262, 6.9091694337924423 43.90803943490026, 6.913141500357 43.89442429048971, 6.9058604344417915 43.880684347922866, 6.8871875323131349 43.872306325576247, 6.8496164224986842 43.87195234942358, 6.8265595670838195 43.899051327349682, 6.8077055404096143 43.901588303127184, 6.7782005455610772 43.871212361484325, 6.7595274674124823 43.865547334881725, 6.72205246449974 43.859687278156244, 6.6655104507533451 43.867267401994596, 6.64678245437517 43.864315371136044, 6.6438915024449727 43.823276315941158, 6.6516835543230286 43.8097072887618, 6.6704995606844761 43.807182282342026, 6.6858074891131025 43.793686303448808, 6.6672794514169027 43.78255427270598, 6.6111445718530319 43.773700292369895, 6.6001345229470019 43.762619307417353, 6.6119924600317859 43.735431439408146, 6.6683584538116918 43.730629438701428, 6.6872645823959829 43.722633379682165, 6.7367895601769305 43.682190328093938, 6.7410775825814255 43.65489931238433, 6.7378604656532559 43.62752539127051, 6.7456115048791219 43.613952315631948, 6.8398464342568275 43.576648404126686, 6.8809305505631357 43.579784375850252, 6.8961434282098253 43.566280300038571, 6.875325546769119 43.470413313531267, 6.8867635002137888 43.456867344967534, 6.9123164947739042 43.4494664094551))'),
('Ardche', '07', 'POLYGON ((4.6310945602737377 44.345306299517588, 4.6363755113093532 44.386493387504331, 4.6598864982378529 44.441883350569853, 4.6583714943859889 44.469185279517362, 4.6454535650628088 44.49617442098436, 4.659142461839366 44.523918336067808, 4.6424154604406453 44.550781271218838, 4.6416585745845964 44.564441300720873, 4.6484835727665654 44.578315370502182, 4.7389485065012593 44.665676368147231, 4.7488755045532685 44.693306398312345, 4.7482574984508119 44.775344376149732, 4.8385904172106109 44.873558412890659, 4.8701395319303629 44.929119291343667, 4.8648964251875384 44.956310327712274, 4.8244435164811819 44.996238344878478, 4.8330304745280444 45.0511623830926, 4.8239195050408341 45.078270338037029, 4.7917775550738213 45.104736348163513, 4.7902884261570478 45.13205341482815, 4.7965184768521567 45.159572376394394, 4.7944854462388378 45.268898377601957, 4.7898964296915949 45.282451386964354, 4.7694534707796095 45.303764412570885, 4.75332247298752 45.316986328376245, 4.7487174386233164 45.330528424500685, 4.7518504180074785 45.346496427803785, 4.6599975668367222 45.33077238817431, 4.6220835701275007 45.318748288241139, 4.6275044570365083 45.291549330974036, 4.6167265784663414 45.277565424733595, 4.597810416743954 45.271549414317761, 4.5017994459040267 45.2659683492392, 4.4831925512628459 45.2544934316016, 4.4604544680073275 45.248329388393913, 4.4491564504360781 45.179603272564762, 4.4354295333467633 45.151844395784153, 4.4165695219936936 45.1457822681371, 4.3586645856464941 45.149448411999842, 4.3595034968069513 45.135810384993633, 4.3791895698628878 45.128212307118687, 4.3915225848373041 45.114914350687783, 4.3923535750992642 45.101276323681574, 4.3548234779370318 45.086422350746616, 4.3480085128931307 45.07253631160755, 4.356502532397684 45.059131335037009, 4.3761715315168885 45.051548394879191, 4.3923315726034389 45.038356402468153, 4.3893304321742335 45.024597273724979, 4.3708384785711587 45.013069374077432, 4.3518575415011185 45.009742420690159, 4.3132204547694073 45.013992422781868, 4.2949295159681071 44.9997363896732, 4.2630554683901494 44.957687331910407, 4.2260115383754453 44.9373242860632, 4.1749305440904152 44.897365289382904, 4.1375984693904968 44.88245041353953, 4.0582794719759647 44.866092349990609, 4.0399045716506521 44.85453030246957, 4.0257435893238949 44.837627281104304, 3.9888394191625878 44.817215301706412, 3.9505045587134191 44.818592305904517, 3.9321574695428012 44.80701036812728, 3.9263924635992282 44.779445289329786, 3.8703454179986636 44.761036417150947, 3.8674875578222156 44.747261270590784, 3.892228572276764 44.720783291106571, 3.89029956946365 44.693348291064368, 3.8800094422206826 44.676571299995132, 3.8923234470387342 44.6085964373831, 3.956655576443552 44.558879421818673, 3.9737134953793714 44.532119282328111, 3.9793565194861173 44.5049513045751, 3.9731685375629979 44.494896340007429, 4.0254455875205792 44.440876340341376, 4.0319424844849436 44.400055373884996, 4.008159546708157 44.35818427230835, 4.0090544322179653 44.344551349881172, 4.0286994926217119 44.334278296574993, 4.0856475844308875 44.333492367424455, 4.1637925286687221 44.297840403305017, 4.2021335498167218 44.290893423286249, 4.2206974955861085 44.296989346766864, 4.2310214186626069 44.313736414441777, 4.2490775468285733 44.328010401587065, 4.34255453423043 44.350174307711754, 4.3547384602931913 44.336879343620282, 4.3647784631637023 44.296161348844336, 4.384334457464405 44.28583936198747, 4.4029184695099559 44.2918852957976, 4.41345942520519 44.305893316773435, 4.4299435190501413 44.347442301811341, 4.4488714741102626 44.348037425318168, 4.52588549006316 44.328498328934259, 4.5463534438104318 44.301757375620056, 4.6231014935939072 44.284885333768912, 4.6303575646738864 44.290561273609413, 4.6333775392395182 44.304348389527277, 4.6310945602737377 44.345306299517588))'),
('Ardennes', '08', 'POLYGON ((5.3723334734393688 49.623970307721876, 5.36207855018975 49.628631316435431, 5.3458885857088774 49.627937269707431, 5.327892480351494 49.616840442957894, 5.3124835164620947 49.617641333805565, 5.3061934429583744 49.635139302657691, 5.3300855131143976 49.655441269576514, 5.26729355841664 49.695037313085848, 5.2547924443742033 49.695240440127193, 5.2454934855627471 49.6902353123791, 5.21619742641451 49.691635375192831, 5.2041895203182378 49.697830397914615, 5.17150155641508 49.697139343526047, 5.1567935040323789 49.716835273700141, 5.1530655771613851 49.716945286179211, 5.1434034891589988 49.717231318624826, 5.1360974284085046 49.711830321972016, 5.1239045253274469 49.717735439808948, 5.112097458013011 49.744732326154477, 5.0957075348501633 49.759029371915361, 5.0385075584688934 49.772033375002152, 4.986410576937061 49.804332334779289, 4.9717785651799034 49.803875386946189, 4.9543154482811644 49.803333421469276, 4.916716527312019 49.79043239006289, 4.8747165791198768 49.796032289277846, 4.8553214670685918 49.79403340653802, 4.8559204630146553 49.8016323645128, 4.8743184219555928 49.820522299260162, 4.866514576739803 49.841430302923712, 4.8553195308489592 49.848026299129245, 4.8542174698385452 49.86362430846269, 4.8852184583825533 49.900020308980643, 4.88751252660623 49.910324341800944, 4.8829155891605183 49.920818300165124, 4.8460295490558 49.949916336851047, 4.8098234740817247 49.954521371215222, 4.7927254225935485 49.96221942843114, 4.7879234218868305 49.979717397283238, 4.8129224816123326 49.98881938975218, 4.8196504927927606 50.000492329852122, 4.8223305728030255 50.028717307504095, 4.8411295052277126 50.043609300751811, 4.8266224676467573 50.055111325464267, 4.8251194331526222 50.06701238744084, 4.8397164169364544 50.074817288776458, 4.8471235131477215 50.100711410031707, 4.8590275674637269 50.100109421746211, 4.8706265791777525 50.08871036871416, 4.879621551507 50.090213403208296, 4.8710275526614737 50.106609311050008, 4.8713185136661536 50.124809423548569, 4.8940264975073546 50.1371112829889, 4.8746195921183073 50.151001370587196, 4.8199215635411861 50.159309336987107, 4.79548752790825 50.148723320180451, 4.774921531039638 50.139804388476719, 4.7459354430524172 50.112308309506133, 4.7136345470556478 50.097808312723842, 4.6913335213770324 50.081417333441195, 4.6864405183476094 50.067810285949079, 4.702229509344761 50.058612362598424, 4.7054314885557744 50.048607387701239, 4.6923315545872128 50.028614335823661, 4.6906304976307354 50.000515388467747, 4.6837305149430222 49.990718293151033, 4.6723335741505707 49.985515318960566, 4.6227355480835115 49.984920371473706, 4.5881375915236049 49.978416433710677, 4.50824142463884 49.9436153501094, 4.4631525020541858 49.935722438790535, 4.4403565082297121 49.93622638395469, 4.4305925046666914 49.937759341843147, 4.4141575203924219 49.9400173259737, 4.3900484176176917 49.949524340385594, 4.3535584224376294 49.951324320563273, 4.3251554885995063 49.965820444906271, 4.2207274189804025 49.961185311127835, 4.2340035489354477 49.948055277744984, 4.2555205816831858 49.940517398698589, 4.2732105883187614 49.927440347325685, 4.2708814921217311 49.900150387735906, 4.2256105648916957 49.828048384968795, 4.2191504561003228 49.800617433385824, 4.2595294364207632 49.760986361903164, 4.2369605083530928 49.724914414143583, 4.2212165784673914 49.710834401001435, 4.1810535746458868 49.687873300448345, 4.1197294504489435 49.669674420089549, 4.1248495192351982 49.656204316131394, 4.12162448140856 49.642498345418076, 4.101418445371479 49.633705444010374, 4.05862359101053 49.648716426755485, 4.0377895157328965 49.648067441138906, 4.0387815642642408 49.634475355343952, 4.0956275644928439 49.598121423598016, 4.0977834570428229 49.568229360843119, 4.072985588139062 49.507518314189596, 4.0731415418293864 49.447601293605075, 4.0595144280611066 49.406322323195795, 4.0764625105377945 49.401390419753781, 4.0969945355528523 49.404743424096083, 4.1388325453757773 49.400596393684808, 4.15995458931863 49.395786296059626, 4.17744252503266 49.382698331448793, 4.1987395328222306 49.375156403943166, 4.2610865090446168 49.374298306606377, 4.3135385228489156 49.334961364487768, 4.3347795562891349 49.327404299265012, 4.3974264705344694 49.321052442753071, 4.4188364831425417 49.310764427749731, 4.4586914520226344 49.271011374430245, 4.5208955000321964 49.270023374358161, 4.5617435735634047 49.279312300031521, 4.6219774300876963 49.242782348319068, 4.6626595167904554 49.25477634883795, 4.7456904232590205 49.251491288202729, 4.8075295818779864 49.255798320763589, 4.8285305240838738 49.250877330559504, 4.8711034172670509 49.230152387661107, 4.8911575480730107 49.241542287654894, 4.9027834908418981 49.255462298647487, 4.9230164579338407 49.2641062871635, 4.9436775055843611 49.264625370044783, 4.9822385516905285 49.241024436913378, 5.0063135065917947 49.25521833497389, 5.026832506129324 49.258426298863768, 5.0426625097786655 49.27241530968324, 5.0517294742742251 49.335262358630516, 5.059285483377181 49.349067428584974, 5.0952875512100491 49.374412367544679, 5.0846955497245006 49.417736337925007, 5.0957105271895955 49.445217279178465, 5.0735045522928885 49.471935349897038, 5.0678984923791006 49.499038376282371, 5.0913755074540745 49.52679830918278, 5.1064554900260362 49.5570793760637, 5.138318448346098 49.585041379885681, 5.1589754475373866 49.588215371922033, 5.1801914861423768 49.580532276403247, 5.2065464276699913 49.553875284613085, 5.2474585724690144 49.568374401295543, 5.2686654580357413 49.560665430841695, 5.28597350134396 49.547432425778439, 5.3067484339128441 49.547874411914378, 5.3337534171768084 49.591983431345383, 5.3544535412599146 49.595142285664608, 5.3723334734393688 49.623970307721876))'),
('Arige', '09', 'POLYGON ((2.1341254808659471 42.647358383705992, 2.10945346623825 42.673462320761345, 2.071107516531157 42.687835407147773, 2.0424634353389024 42.716449388925739, 2.0227314210716827 42.729076357244267, 2.0046365685130922 42.725364272170239, 1.9739415026709253 42.699054391754075, 1.9358324758387653 42.71067839830333, 1.9129924770226694 42.791626284488061, 1.9002954527574616 42.807369334273929, 1.880528586536883 42.820007391850325, 1.8425904750922371 42.828853275267946, 1.841214527013932 42.842476340576994, 1.8509014338316092 42.856716355868727, 1.8866384155948595 42.869651359128667, 1.9232445839528225 42.874389288567571, 1.9408564377232835 42.883560280863364, 1.9418095858420088 42.911018339521164, 1.9612585600030457 42.939460349791872, 1.9484545155982289 42.9935604385427, 1.9568105354490228 43.021423343123516, 1.9427424916645748 43.050792274537926, 1.9231694234271401 43.060703430792941, 1.9180995203313671 43.074138330757805, 1.9278274398012343 43.088363384352377, 1.926207528049332 43.104702437744876, 1.9134404478374734 43.120441439071541, 1.8938244307281877 43.130355411646022, 1.8750635186162583 43.132076358858725, 1.8568065516685124 43.128326429491906, 1.8175674766513055 43.148090303373053, 1.7990654899101344 43.147060410548946, 1.7611965543123347 43.153175344185954, 1.7486855831517687 43.166187268171242, 1.7090814427239707 43.188648295999442, 1.6731844588111358 43.175647285252083, 1.6860314520878035 43.302463334413247, 1.6391944752156178 43.286121288681287, 1.6138454877966524 43.2435533240572, 1.5558924979985989 43.262169371736647, 1.5182305618814382 43.265476434867693, 1.4985124531915517 43.275306269898167, 1.4858985103505802 43.288273308792, 1.479186516987113 43.246769384865544, 1.4618304202280115 43.234794394503027, 1.4432814361558144 43.233703422750509, 1.4165904725120981 43.273262326046918, 1.4002815185338591 43.286029406258777, 1.3422204524763401 43.304512382843555, 1.323354456444406 43.306144263953186, 1.3054025320986398 43.299602305877372, 1.2898684180130431 43.271240384691467, 1.3096354602535882 43.261451386293217, 1.3467284998389744 43.263649347615186, 1.365865566619334 43.259311335540204, 1.3784795094603339 43.24634535276617, 1.3478134869126279 43.219864380942525, 1.3128705312183229 43.198585327189548, 1.2560995154954639 43.206154361770004, 1.237575526258496 43.20502836204416, 1.212831519464487 43.159664320251821, 1.2291695167372154 43.14695339040928, 1.2667914963219857 43.143730288802274, 1.2830995702003918 43.131000348803369, 1.2735124667037496 43.116710343841149, 1.2392684862965098 43.089969390526917, 1.2213885541170555 43.083404373835506, 1.2022895076494535 43.087730416552759, 1.1881304615423289 43.114299398359677, 1.1520644984616126 43.136753385389213, 1.1304825143462551 43.162853273985334, 1.111357416923596 43.16718336516179, 1.0940974270662309 43.15515134433015, 1.0567514467889794 43.155571327970264, 1.024487514985168 43.112430418355117, 1.0131444363024684 43.081550355528137, 0.97429154909181648 43.0955692897419, 0.95707450810627392 43.08350734551594, 0.95496649298718239 43.069656334350228, 0.96763553007770042 43.056747382045344, 0.97448446697512736 43.029750319679849, 0.96288052670203683 43.001590293395523, 0.9285295261551596 42.977481366640731, 0.87415555033641112 42.965786424044964, 0.85538354896661417 42.967327302831919, 0.83726458167262763 42.963428284553473, 0.81838256782373264 42.934772410023456, 0.79962957661032874 42.936321385728846, 0.79018258500701677 42.921993360453868, 0.80433758265490951 42.865307362374821, 0.80209843266078451 42.835544322255387, 0.86474851526551788 42.819946312921942, 0.94083948251397942 42.789352282540548, 0.94903550021518868 42.79044730275227, 0.95673654977053957 42.800949358034913, 0.96683446321006272 42.801540433082508, 0.988340582719843 42.784851275976578, 1.0906294816857951 42.7801473183912, 1.1247284216406115 42.752853310342189, 1.151222418941785 42.716247318004193, 1.1679235454054151 42.706455327266482, 1.1857205721806565 42.705650387959579, 1.2268245787431908 42.718948344390483, 1.2664225584721578 42.7141493360232, 1.3521185832538265 42.717151356552236, 1.3623104913554585 42.711647388219021, 1.367712544128068 42.696548395490666, 1.3878064554464515 42.685650295283367, 1.4252075299732496 42.639957272173589, 1.4441085539785092 42.603752429339309, 1.4441425258320351 42.602264356542307, 1.434810475266886 42.586860321211972, 1.4351804692365135 42.584396393720581, 1.4421524440905387 42.589038392277715, 1.447605542653406 42.592617406257048, 1.4492974465716486 42.597580289213155, 1.4482054186993309 42.600219356571259, 1.4586935684046125 42.600780332204565, 1.4694725030946074 42.604587292040506, 1.471914428090173 42.606121306048763, 1.479482582570796 42.610874373204794, 1.4799395304038967 42.619465379710888, 1.477211572962716 42.627273273385939, 1.478919494697891 42.634739336285989, 1.4842085426519986 42.641056340844571, 1.4850045049406049 42.645904282762544, 1.485327501579178 42.647873418128043, 1.4890355381939457 42.65171839827677, 1.4980805001937085 42.649276297261238, 1.499873439572724 42.647541268451207, 1.501956459856558 42.645523375554987, 1.5075315402562524 42.643524316795194, 1.5184954719310326 42.644031430318748, 1.532882463894822 42.64530528681648, 1.5424535495745033 42.648861418200127, 1.5510575815581262 42.652317394222862, 1.5630195464431154 42.650871390197878, 1.5677405779652531 42.650299325306676, 1.5784065078367178 42.6461642642531, 1.5807824253448359 42.643135312669173, 1.5822984853164996 42.641201381296966, 1.5858134280280183 42.636772366899308, 1.5941074888505966 42.632656316002155, 1.6002224224876045 42.628193329750943, 1.6050464256901478 42.623146309250828, 1.6106825850181963 42.623565412791109, 1.6172504180291014 42.624061437056767, 1.6333365307297072 42.625534372136642, 1.6430635700997414 42.625782384269471, 1.6479944174219554 42.625469420768994, 1.653343488184646 42.625126357854256, 1.6554925159559275 42.622802366236229, 1.6583514322522035 42.619712335723918, 1.6645054423217687 42.616970296685437, 1.6745755446065687 42.617881376032145, 1.6825814607439327 42.620514282691417, 1.6936464278795142 42.623066396186019, 1.7062424166839207 42.619281262825908, 1.7144125594500679 42.614479438139156, 1.7229185483123501 42.611717332824483, 1.732999563835051 42.612625419831758, 1.7381854640887582 42.612823266274134, 1.7401355892978643 42.612899306899678, 1.7370404542065216 42.606914275997966, 1.7369635334811449 42.606765363106277, 1.7309204159904823 42.598980352026885, 1.7314264733942366 42.592193374157674, 1.7360684719513984 42.587501385930054, 1.7498694934465959 42.585334404122179, 1.7623605743509643 42.583793349315258, 1.7636284461698324 42.583797397774489, 1.7746444797547269 42.583828377288611, 1.784752426332318 42.583515413788135, 1.79514358903603 42.58213840959, 1.7898784797974088 42.578666415750334, 1.8984095748361369 42.604534310030587, 1.9866765472488623 42.644954303003217, 2.0422995607500809 42.642486327052595, 2.1170694981497604 42.632763336141792, 2.1351515012507889 42.636459403398831, 2.1341254808659471 42.647358383705992))'),
('Aube', '10', 'POLYGON ((4.2578104254276923 47.953109400478681, 4.2616425561188578 47.967075352682528, 4.281102443517824 47.978565408037255, 4.3214715667201347 47.9797892748645, 4.3827154258123358 47.970676369157658, 4.4227504631181489 47.97732534737311, 4.4836505552157178 47.973617310758343, 4.5440484623487976 47.978050373615233, 4.5634155872254212 47.992237406897019, 4.5568614837719394 48.032997294425016, 4.5966245702294941 48.045021394358159, 4.6579094419738851 48.035793371593215, 4.7433164419705349 48.007290282394152, 4.7553834907755288 48.030201393276755, 4.7581934735211178 48.05211235870955, 4.7440094325787356 48.087215316553412, 4.7270185772501918 48.100395339606749, 4.7262345843192861 48.114021397255229, 4.7667385388159289 48.115093358851354, 4.8074915615652287 48.110687403069321, 4.8487575064969519 48.098114296860572, 4.8685254288373585 48.106807394947239, 4.8742064732568906 48.1506002825184, 4.8889194541986569 48.178241401941406, 4.8752314375219612 48.205196395534884, 4.879431449943155 48.276214291328174, 4.852634522279601 48.3191913263545, 4.7755985038308779 48.385406341341209, 4.7338004505403433 48.403404382918225, 4.6924544165238444 48.413219432271532, 4.6453954784738585 48.450149301347935, 4.6387174569639456 48.493614439741393, 4.6448915333097034 48.526500426106892, 4.5832245222180177 48.533020381686882, 4.5560084910141541 48.510433323562651, 4.505896486644815 48.528122274078456, 4.4658114596684868 48.516086380807522, 4.2999395722752638 48.614895365035281, 4.2858405489767222 48.641769389444178, 4.2943044690669865 48.699287433904985, 4.2852095173967371 48.712642420805011, 4.2641915012540892 48.720188396769871, 4.2435464714205011 48.722297291988795, 4.2029944634730043 48.715618390379021, 4.1830815006802027 48.706840274648513, 4.1522625167815761 48.678627442374236, 4.1320094834134409 48.67525437175577, 4.1113514281023527 48.677349361397333, 4.0765024670701848 48.648967373935207, 4.0566414301675024 48.640159334810406, 4.0159875066593713 48.6361464316136, 3.8494955009240641 48.507923278840039, 3.6794364505671524 48.540310424620415, 3.6584254752231971 48.547756421244273, 3.6371645515267517 48.55792632685008, 3.6320094547671715 48.571396430808235, 3.5920474657474415 48.610920306131291, 3.5496954776222651 48.628494315608933, 3.5322814702942082 48.641521377311349, 3.497730511065356 48.612980443819495, 3.4917835004764015 48.585487357188313, 3.4713755695377415 48.584739272330594, 3.4613665461813241 48.557075270311955, 3.4214925671448668 48.544696314126256, 3.404484461859596 48.503132367391217, 3.3698914338587542 48.477264297091, 3.3590475478011115 48.460476392783832, 3.3572415829445958 48.433132395064334, 3.3728575463146342 48.392757287183159, 3.3825664556281083 48.374008344428987, 3.4241145605661814 48.364639329670851, 3.4649825243536156 48.363418279163071, 3.4859704410819745 48.356010302851971, 3.5379825809899046 48.316940383022583, 3.5564065908858993 48.290317363085947, 3.5773374771451074 48.282863269543626, 3.59059354082396 48.269691343408752, 3.57674446587788 48.239166312854238, 3.5818794963612675 48.22571134661321, 3.55271157974866 48.183693268364507, 3.5578474903318522 48.170231437344782, 3.5981254351914913 48.174423352847541, 3.6153965143067524 48.161384321787395, 3.6126474344696078 48.1449053325215, 3.6333035535610634 48.140178316320529, 3.6531255140311885 48.146331270270295, 3.6831965890920344 48.177421324917376, 3.7036344434250168 48.175411352919625, 3.7310745480462515 48.1354183843858, 3.7946615849327827 48.099380408479774, 3.825003554722116 48.073124390173334, 3.8391545039108053 48.046295426875858, 3.8694535248282875 48.020015293834021, 3.87549241783978 47.992916315907891, 3.8958845069814458 47.990871315936843, 3.915664574699548 47.997001387290979, 3.9360575439410468 47.994938433283309, 3.911764500301274 47.939537380959919, 3.9167775489478629 47.926029432708944, 3.9576965585255834 47.919216403884704, 4.0176215000086017 47.929359378435649, 4.0381325786476623 47.924560370068335, 4.0780984401066576 47.931308271504989, 4.1015455317873091 47.942970298367, 4.1413225238222253 47.952423274649178, 4.1620434182613621 47.944877298684318, 4.1772524234688149 47.958992339799821, 4.1976165254358193 47.956916360314651, 4.2106435871382359 47.943664345095, 4.23100047228661 47.941555273856139, 4.2578104254276923 47.953109400478681))'),
('Aude', '11', 'POLYGON ((3.2273034676371992 43.202217323178772, 3.2028365162705086 43.232284349780414, 3.1259814463473674 43.261852359776938, 3.0464315107367668 43.277523417396495, 3.0278765419856768 43.276710381171128, 2.9895805819490988 43.28869241233231, 2.9799005399101191 43.315658319163717, 2.967618570725989 43.328785360207135, 2.9123034161462442 43.3208123598035, 2.8937234525599251 43.319984361880969, 2.8746814365614739 43.324607350281738, 2.8365864913266705 43.377620339719314, 2.8175194804929617 43.382225374083518, 2.7995944872020857 43.373176363624523, 2.8105624673360978 43.33261133019947, 2.8005675255770086 43.318451403992512, 2.7817485268761573 43.3203244324563, 2.7632115121616607 43.275657429731396, 2.7453555186976359 43.266601378473737, 2.7067925363718359 43.281227405552059, 2.6689375063513978 43.287655302689544, 2.6551584873519971 43.317123333345094, 2.6390894485881233 43.3300553442656, 2.5845415650424286 43.313736357149267, 2.565968466234807 43.312847280298357, 2.5466604840669618 43.320125353874161, 2.5342695585235617 43.333213318484994, 2.5417435423220809 43.3746644364215, 2.5690525120682537 43.403362379723504, 2.5678124514041087 43.417007271508439, 2.5551865392054083 43.43283428281832, 2.5410345338969478 43.423931368931548, 2.5226664983503042 43.420303421401528, 2.4477284618825763 43.422111322477704, 2.3738004279827578 43.41295229953964, 2.2399305546831272 43.444557388608743, 2.2213174993431153 43.443603360390185, 2.21646251662645 43.415943406830749, 2.2029144358231463 43.40154233326966, 2.1845634742132631 43.397869324628218, 2.1452385014523827 43.41774743546766, 2.1099095339715177 43.396721322406549, 2.0918335155493253 43.390281279891369, 2.0732524958432066 43.389320386894113, 2.05437048199434 43.391071433521105, 2.038158515017642 43.403907337539877, 2.0328874211001562 43.416851317818086, 2.002799448122488 43.421207283929633, 1.9103275347295039 43.410751345878211, 1.8723184872383456 43.4169233099844, 1.8325944772133482 43.43941126886746, 1.8142704466583552 43.435661339500669, 1.7967874395033903 43.423748308166367, 1.7763675392070013 43.367801417926771, 1.7589185039055906 43.355865327976844, 1.7220424969389398 43.351074416528022, 1.704053432380249 43.344577343543691, 1.6860314520878035 43.302463334413247, 1.6731844588111358 43.175647285252083, 1.7090814427239707 43.188648295999442, 1.7486855831517687 43.166187268171242, 1.7611965543123347 43.153175344185954, 1.7990654899101344 43.147060410548946, 1.8175674766513055 43.148090303373053, 1.8568065516685124 43.128326429491906, 1.8750635186162583 43.132076358858725, 1.8938244307281877 43.130355411646022, 1.9134404478374734 43.120441439071541, 1.926207528049332 43.104702437744876, 1.9278274398012343 43.088363384352377, 1.9180995203313671 43.074138330757805, 1.9231694234271401 43.060703430792941, 1.9427424916645748 43.050792274537926, 1.9568105354490228 43.021423343123516, 1.9484545155982289 42.9935604385427, 1.9612585600030457 42.939460349791872, 1.9418095858420088 42.911018339521164, 1.9408564377232835 42.883560280863364, 1.9232445839528225 42.874389288567571, 1.8866384155948595 42.869651359128667, 1.8509014338316092 42.856716355868727, 1.841214527013932 42.842476340576994, 1.8425904750922371 42.828853275267946, 1.880528586536883 42.820007391850325, 1.9002954527574616 42.807369334273929, 1.9129924770226694 42.791626284488061, 1.9358324758387653 42.71067839830333, 1.9739415026709253 42.699054391754075, 2.0046365685130922 42.725364272170239, 2.0227314210716827 42.729076357244267, 2.0424634353389024 42.716449388925739, 2.071107516531157 42.687835407147773, 2.10945346623825 42.673462320761345, 2.1341254808659471 42.647358383705992, 2.1787074659470136 42.644222411982426, 2.1981824910631076 42.672634322838817, 2.2869884366133135 42.710098412513631, 2.3178035480726749 42.736335420663679, 2.3299885302552354 42.764320307081292, 2.3287375563531612 42.777961326426961, 2.3049764450522332 42.83427433819692, 2.3184425005511571 42.848659393941077, 2.3373994989057678 42.844135328761482, 2.3744974670501904 42.843265438086931, 2.4482355754061302 42.846973298681732, 2.5047455535186316 42.836078366833831, 2.65412454606863 42.821422416361187, 2.7079614849695304 42.840419371248217, 2.7277665475228332 42.868732358883435, 2.7452555393566627 42.880520416041506, 2.7985035154495677 42.907653365821162, 2.8347245521207753 42.91753741500132, 2.8889094824954782 42.889915305734704, 2.9265165003830873 42.883411367971675, 2.935009463767841 42.870109363081539, 2.9524454735917232 42.861774289606771, 2.9795354744995564 42.88478837216978, 3.0025294907863724 42.916328333851268, 3.0167945009133632 42.921409326204937, 3.0228735264772126 42.900901415925276, 3.0401835060050644 42.891727431290079, 3.0506054722029319 42.8885303806381, 3.055306437448877 42.889736293428754, 3.0619084183332461 42.916633376453277, 3.0179125797407096 42.938129286805022, 3.0070264488911107 42.952228310103564, 3.0012404965715405 42.9552303306326, 2.9978144439431276 42.96043436094287, 2.9947115639732544 42.963428284553473, 3.0011054892572133 42.968532335522738, 3.0084154224469444 42.971626414494281, 3.0102064256063272 42.957431284294, 3.0260114344204112 42.948032346141574, 3.0307085272270911 42.93843028094777, 3.0383034367426376 42.938629359529912, 3.0519134765741569 42.993530339128441, 3.07030545083623 43.035926332245239, 3.0788114396985122 43.043926263703767, 3.0805054558563256 43.0564273777462, 3.0849024346200906 43.059829315639192, 3.1022074855888775 43.0863263052798, 3.1175995515615114 43.099723360951842, 3.1174694728062491 43.117527428525747, 3.1329014953112733 43.126522400854995, 3.1448085419666825 43.1427232785738, 3.16520045508841 43.150516386571653, 3.2026025857349794 43.1823152736239, 3.2273034676371992 43.202217323178772))'),
('Aveyron', '12', 'POLYGON ((3.3659554513873218 44.172550271233618, 3.3487264410440503 44.1992414108973, 3.3099175588250205 44.211330286178153, 3.2721755336230842 44.209774269674071, 3.235088478716591 44.200012378350678, 3.2162034725282638 44.199226273180173, 3.1966735291826183 44.206627384712576, 3.1820804178380513 44.247085397997964, 3.1627544816335842 44.251735317453623, 3.1140754558117294 44.290741342035162, 3.09563243575937 44.284458309330105, 3.0762815047196739 44.289127414962124, 3.07515656111363 44.3027613935091, 3.1056134719410977 44.347881295607849, 3.1098145404821196 44.389122421724309, 3.1162584554365651 44.403080277009693, 3.134090510185132 44.417522363223, 3.1329754236971894 44.4311862651643, 3.1079985424874792 44.457489280801795, 3.0856915321299994 44.497608279631677, 3.0758305415654377 44.524566265564587, 3.07511044388238 44.5792843604179, 3.0552224759248361 44.58938931465606, 3.0359915905023058 44.591289274174713, 2.9798285477438071 44.62445442820713, 2.9634535862781206 44.637420410981164, 2.9596084301094265 44.653297411961532, 2.925514418713675 44.6795733205242, 2.9167245096454053 44.6928712769551, 2.9158484582720234 44.74759342026762, 2.9058894245861211 44.77453626848343, 2.9085165225864671 44.788360348594253, 2.9035404381328647 44.801815314835309, 2.8637514767402195 44.819210312007, 2.8258705717846908 44.858600412155496, 2.8058264741168273 44.868652384383736, 2.7865184919489536 44.8705254128475, 2.7488345533359677 44.8633383415944, 2.7292614850985331 44.867942319838775, 2.7204025762033837 44.881221266113286, 2.7179634675272837 44.908500312465165, 2.7269925877300523 44.936294393239066, 2.7219425748905053 44.949745311020862, 2.7054364785497569 44.962688411199267, 2.6860894199493259 44.964542429506636, 2.6679625317568139 44.952758420807825, 2.6263434907722285 44.90425840729192, 2.5506244537130556 44.769252325108383, 2.5089635199764473 44.723453337978768, 2.490962486059999 44.711631308967171, 2.4858985676430905 44.684013424179753, 2.4719544419151021 44.669647378591989, 2.45346442453166 44.663261374206527, 2.3969505739798933 44.655048282568558, 2.3185834925443203 44.675869332368634, 2.2037334567273774 44.67835631847565, 2.1941164298364129 44.628441280448882, 2.17759554781847 44.633194347604885, 2.190877486432413 44.614692360863742, 2.170778470534998 44.586280273987356, 2.1298385145812517 44.575958287130462, 2.0916085620321212 44.576740343841735, 2.0539504983541974 44.572048355614086, 2.0344124580900882 44.576530352021663, 2.0154595081947093 44.575538303490347, 1.9973095613866008 44.56636027039589, 1.9422015823074616 44.508678351346262, 1.9243554459615666 44.49674243741633, 1.9048724999469755 44.501201375208311, 1.8681045692397618 44.4882693642878, 1.8519855408054013 44.4600183356808, 1.8769925214294005 44.36543242248986, 1.8589385055030334 44.356243300137507, 1.8523974275270803 44.309295430686419, 1.936604499411942 44.30284130657391, 1.9431594829652852 44.275772428062069, 1.8939465885849529 44.237533322474647, 1.9028964998027789 44.224308414329883, 1.9225785243995119 44.217132432334651, 1.9390575136654036 44.204303393094577, 1.9447674253594585 44.185432292483611, 1.9386255606675604 44.171413358269845, 1.9585724953139163 44.1614912887769, 1.9956935220739638 44.168926372162829, 2.0311794993649812 44.192726383876376, 2.0503024845480127 44.190982378048076, 2.0866625769927793 44.206569298123625, 2.1055185398866172 44.207557298195738, 2.1448324233896017 44.193142319057259, 2.2016595894818067 44.193302321206843, 2.206749558853744 44.179863372782748, 2.1752164619509529 44.153587288200143, 2.176550517277235 44.139953309653166, 2.2508545298255456 44.154693397669789, 2.2699435431550512 44.152904330730038, 2.2913905199560816 44.126602371212343, 2.3107375785565409 44.12208129837218, 2.3504744380390719 44.102157422341449, 2.4082804511650977 44.050209353701334, 2.4281265263706189 44.04021828438151, 2.4667405544867052 44.031154312225354, 2.479274584262896 44.018070396073753, 2.4968375044826416 43.991527289201926, 2.4980705243481509 43.977890318315517, 2.4793154208951478 43.935886321664142, 2.5175995875939634 43.929519327435074, 2.5363485303481639 43.889324287979647, 2.5353295507619578 43.859150417258334, 2.5203245526957119 43.8173523639678, 2.5328075366816165 43.804260350897735, 2.5712555779692821 43.795139348272457, 2.591456509427303 43.779682330932175, 2.6258154308726773 43.732025277035959, 2.6454895345709133 43.721988266504852, 2.6644444206859248 43.720138296656714, 2.7420695779625817 43.734729295761682, 2.8185835211905896 43.719093266115451, 2.8562255670515526 43.718067421750547, 2.86861455637532 43.704925419009996, 2.8697824488532149 43.69128827210362, 2.922595479608816 43.688190320692811, 2.9992194353159221 43.669693438530672, 3.01701153353207 43.681453332494115, 3.0323444567959541 43.723190306856239, 3.0338385142717925 43.750625306898471, 3.0143515197979696 43.804523324727725, 3.0169555591827191 43.818351277277841, 3.0345864231095447 43.832801284389618, 3.05310847612688 43.8363384056169, 3.0914984308255953 43.827068314079966, 3.1309904465347245 43.804126399703236, 3.1499564219076319 43.802200389229526, 3.2050874596023959 43.818233343900246, 3.2231865366401848 43.827198392835228, 3.2406434928400927 43.844356291111993, 3.2298914892049879 43.884975362666765, 3.2480174972976386 43.893936363142487, 3.3049694615460794 43.888103413491834, 3.326867577521341 43.897216319198677, 3.3817044858520546 43.967880414859266, 3.3971755847896361 44.012302397790748, 3.3923575662659573 44.025806297582491, 3.353459441923917 44.040641436381023, 3.3050815862647767 44.079727374027371, 3.2678605801637275 44.072723363539453, 3.2592465150420082 44.086036281667489, 3.2657034554739823 44.099998361432071, 3.293701543389119 44.128547391842417, 3.348347470056126 44.155410326993419, 3.3659554513873218 44.172550271233618))'),
('Bas-Rhin', '67', 'POLYGON ((7.6411035794877478 49.059669305204849, 7.6353904994343225 49.044674340276728, 7.5903494542805561 48.987381425353121, 7.5617004445292366 48.960052389330755, 7.5205675706921795 48.957187312335648, 7.4793984367420308 48.962490441887056, 7.4382384558301453 48.962318294359804, 7.30253357437951 48.953506382795709, 7.2612375300335259 48.966900270108383, 7.1787904817938966 48.977302346050024, 7.1662464188796378 48.990841273815093, 7.1248134309996658 49.009636333800515, 7.1081325468321666 49.023128440254467, 7.0869254852454731 49.063831297313314, 7.0662725345134163 49.06641738266147, 7.0457845144899807 49.058086357645905, 7.0418735268538057 49.044441289841032, 7.0503515285413982 49.03091028297446, 7.0302095637721322 49.000785345803862, 7.0263754968613341 48.98441742513684, 7.0307094604770555 48.970832380140521, 7.0144445114904386 48.957111271710104, 6.9939844786416927 48.951496410797986, 6.9615385421925 48.9240114210853, 6.9617675441689357 48.910392404235452, 6.9786885195707953 48.883289377850119, 7.0200305051280623 48.8672442778017, 7.0818094649184786 48.856819319264375, 7.0779424822739259 48.840446294018321, 7.09927557415665 48.786106290053127, 7.1197995022532439 48.78624728204629, 7.1315264804829326 48.827190406359435, 7.1519305389823273 48.835487283501479, 7.1725555025397227 48.827457428648657, 7.189163514441077 48.81393029422135, 7.2508115153763981 48.806141410702693, 7.2919984273431737 48.792747347370081, 7.300333500817942 48.779163358493562, 7.2806995296720913 48.702778437901017, 7.2849634373411334 48.68917033428913, 7.3055405234676414 48.678383302680672, 7.2855874281224544 48.6319583885501, 7.2453554244740985 48.577240293696818, 7.2050014389889157 48.536132414695018, 7.1806154568068337 48.52780931057795, 7.1398145566266464 48.527538415849492, 7.1111614984160951 48.532791379710446, 7.0869844519342564 48.510833416946568, 7.0994394487454713 48.4972913208221, 7.107811486413226 48.480991343862158, 7.0998504553673172 48.467308431764465, 7.1167624537508516 48.426551360555962, 7.0973875839957259 48.35826828698255, 7.1016595885832317 48.34467338486813, 7.1425685650228559 48.328598361425392, 7.2035885267176241 48.326255359651, 7.26876255962236 48.318462427673111, 7.2891754191200846 48.310394376487565, 7.3220034949166006 48.283298390900868, 7.3508364455329342 48.242557337509325, 7.4525685933447505 48.215763402185175, 7.4729474809889211 48.204940286483591, 7.5057894623627988 48.150554341307142, 7.542440515812217 48.12339428445263, 7.577571460830768 48.104736344021134, 7.5812854821244 48.1204873147055, 7.5832625383883965 48.124267343486579, 7.59910855985467 48.1374052977679, 7.6055885589022694 48.158821295054864, 7.6430274777218585 48.205082334596582, 7.6718185355861408 48.226864277393943, 7.6776995386876479 48.257682381192708, 7.6989954903574471 48.306594281430293, 7.7344615773922385 48.32315441590076, 7.747771503180843 48.334491333884628, 7.7335645796428309 48.401813338440817, 7.7594794712541386 48.444469313048174, 7.7699105904902694 48.476150442742821, 7.8073565501085227 48.519706407439045, 7.8059075537441061 48.585228431817555, 7.8170725002206609 48.61186236499212, 7.8440734350254218 48.645340306505048, 7.9072445367310706 48.676292361498341, 7.9581074422775941 48.718502301510554, 7.9621455163295991 48.720752364742609, 7.9815855134723677 48.759452290602368, 8.0136195631998817 48.760349288351776, 8.03827749623025 48.789142282435719, 8.070317530636629 48.793644345119461, 8.0951474351743116 48.808052283459276, 8.1270054649353085 48.875900411695412, 8.1469854913353572 48.903267292010568, 8.1948625701897413 48.952575413192775, 8.2367915823353712 48.973549424343773, 8.2272655577670832 48.9828144113017, 8.2009915854240774 48.976513424560082, 8.1588754640540344 48.979938421068667, 8.1007385333909383 48.994335270150586, 8.0714574359398341 49.010131301946373, 8.0339614866510942 49.030338394103225, 8.01325344166952 49.033756349813174, 7.9880554793818419 49.028537357805774, 7.9765434215312894 49.041855380512843, 7.9351405330656064 49.066513313543211, 7.92704449470537 49.04977029432753, 7.8884665506824092 49.046814391029713, 7.8543334628541 49.044185356809706, 7.7911525040303218 49.07461128812308, 7.7618224730285306 49.051937276135405, 7.7357125512943128 49.051029365148068, 7.7245655588543229 49.064533440959778, 7.7089055904926624 49.053730391534359, 7.6966554809224874 49.066330428798, 7.6786674724835677 49.0530094137515, 7.6504055306386363 49.055706391678555, 7.6411035794877478 49.059669305204849))'),
('Bouches-Du-Rhne', '13', 'POLYGON ((5.7380864179977493 43.732521301301617, 5.7016205375531115 43.70446037425846, 5.6831775175007522 43.6958843294495, 5.5492794810064652 43.66849527061855, 5.51195655934481 43.664947412173333, 5.47430342422598 43.669601380088196, 5.4175554671187172 43.682003394889492, 5.2456124750601134 43.754547383792541, 5.1708905911112879 43.747249419960511, 5.1143915262367159 43.751308264368575, 5.0723674633091491 43.766651396790493, 5.056706438827689 43.779915381367843, 5.0083704759205716 43.84702633798419, 4.9700095645163458 43.862430373314524, 4.9156304841185658 43.896526320929908, 4.8392094794328671 43.919063389383652, 4.7371085697911894 43.927127392109966, 4.6849205859366805 43.917431332254054, 4.6443314377762306 43.9025683823008, 4.6078365140371034 43.882347384566586, 4.5935704477903414 43.868240264349581, 4.5913224967978863 43.840812305106013, 4.608632476325738 43.800296381251641, 4.5719814228762914 43.717151413844775, 4.5577824202367765 43.703045349747569, 4.5393524256619173 43.697006280716138, 4.464306488954719 43.697437353614148, 4.4275234205304059 43.685360271671058, 4.3991664279035376 43.657100266045759, 4.3820875625917211 43.629211310509888, 4.3828875733395876 43.615551281007853, 4.4069415818648 43.58896240894471, 4.3927964413350367 43.574833286231907, 4.3168105580066083 43.531353362161227, 4.22498058943151 43.503708370298952, 4.1929535805026319 43.478016319965278, 4.1945284311431408 43.4619483373212, 4.2908444445850193 43.452701304399866, 4.3155324770296772 43.456302320875, 4.3222404219339126 43.4520033852326, 4.3511265305801317 43.452999306203182, 4.4067205007868608 43.445995295715264, 4.5023245134641741 43.451503312507711, 4.543023498083727 43.447303300086489, 4.5746164417751629 43.437801390253654, 4.6017615369324858 43.411636374269918, 4.5994875349849735 43.402218425961067, 4.58923648417462 43.397903296481772, 4.5771104686808144 43.393482379002577, 4.5713114908837156 43.387104295515584, 4.5648205785982157 43.375602270803128, 4.567210577703662 43.364307421591278, 4.5941104770476215 43.353607343846292, 4.6863085033727145 43.342308270155243, 4.7125094274296373 43.346714401957243, 4.7804054330966608 43.3465044101372, 4.8019045118078054 43.342807286760333, 4.8380614772112267 43.327976372441, 4.8533935203752492 43.332107385035314, 4.9040925513329228 43.355701277368055, 4.91578749392869 43.376205315208452, 4.9122915613735927 43.382400337930235, 4.9103984666336373 43.373996264628587, 4.89439754759681 43.359207419081244, 4.8779975912958662 43.354007437230209, 4.8674985283526553 43.372902300536637, 4.85839143130471 43.373207343138617, 4.8520974853617531 43.381908362123809, 4.845997513421878 43.380401279170414, 4.84709658209286 43.375602270803128, 4.8342925376880146 43.381103422816878, 4.8534934997162225 43.38880535247209, 4.8740505195665378 43.408256438872726, 4.8993915860870061 43.424705328724357, 4.9349914482963584 43.434600291142445, 4.9444864933504959 43.427696436015495, 4.9719904932196073 43.424602357043923, 4.9787924327859514 43.410205331942066, 4.9742845614432838 43.402702304849058, 4.9957815279148292 43.389209318295244, 5.0086834394210484 43.369304276400939, 5.0267885011377018 43.356407293453785, 5.0187114729338589 43.342025406069027, 5.03197950597044 43.330803429123321, 5.05367748724376 43.329609309670431, 5.0697834902005923 43.334407437937884, 5.0852804640732643 43.328704391022526, 5.09228148222175 43.332710429440638, 5.0932814516515634 43.32970436045234, 5.1190835144643358 43.328102402737031, 5.1250775223843732 43.33230628759749, 5.145778526567284 43.325008323765459, 5.1820694431652043 43.332908275883014, 5.1956784268769525 43.329208336186682, 5.2023754585432584 43.333404300148672, 5.2373675238082171 43.32970436045234, 5.2513695601051893 43.332107385035314, 5.2937724180007137 43.356811435296933, 5.3235625651950045 43.357902407049423, 5.3492604241875767 43.343704284509741, 5.3458614786340206 43.338306280196363, 5.3666575335988682 43.311504423973744, 5.36516347612303 43.296600285348333, 5.3767575592779622 43.295810307738563, 5.3576685459484565 43.291912345579917, 5.3482625669973629 43.282406387287821, 5.3491674856452676 43.277607378920536, 5.3759605408695563 43.261604347644109, 5.3772664330011821 43.252807397777175, 5.3721615019320836 43.243511431305151, 5.3451695441456195 43.227413349246817, 5.3426605555428068 43.216007431436068, 5.3639644281110748 43.2072143540084, 5.39955742554173 43.211509417211531, 5.4260524789627027 43.203914331676017, 5.4300615097202183 43.20761532749215, 5.4521525435787908 43.202514268862316, 5.4554935785633631 43.204929438822958, 5.447117492436405 43.209743408887405, 5.4636635453095437 43.21101040060644, 5.472563466856883 43.205707271055033, 5.4851624480007217 43.20780930149526, 5.5127544578530774 43.199215302649733, 5.5176615424798 43.206310315460357, 5.5360545728616728 43.213508299951386, 5.5494665902308782 43.206905438967155, 5.5490605121681256 43.195011417789246, 5.5676624782502415 43.183616413216427, 5.5939565168694685 43.163219395515696, 5.6026554236150332 43.162014362824877, 5.6091574251584291 43.164318288166712, 5.6101515859293443 43.177520313715846, 5.6292784435516694 43.1837123440982, 5.6308235468177941 43.2026973296275, 5.6519774503746021 43.233215319383348, 5.6701594328166038 43.244522313972894, 5.7069375726818805 43.256210391789963, 5.71387047110332 43.270015285724455, 5.713381487636326 43.28366440198856, 5.6979985747019555 43.297031358246343, 5.660878428041741 43.293541410370082, 5.6418524298602506 43.304096271642678, 5.6557145302838592 43.331703419212161, 5.6578184969437189 43.375488385884793, 5.6721824302918549 43.389461378887304, 5.7283005879588984 43.385120374472919, 5.7466404603108856 43.393699411621284, 5.7535895525692524 43.407497264757112, 5.7191514221389639 43.431419434327424, 5.7111754293958938 43.4449314310376, 5.7064595024527875 43.472164360158231, 5.7126075278435167 43.507843431352526, 5.7083795282476331 43.521423371769785, 5.6812045096959878 43.548198296937542, 5.680691587513536 43.561870295797306, 5.7043425103154277 43.630699383306862, 5.72264946693366 43.642006377896408, 5.7781175828643256 43.66222737563065, 5.78136356706699 43.675968374317264, 5.7622375895444975 43.686527284049092, 5.7434215831830784 43.688888415880044, 5.7380864179977493 43.732521301301617))'),
('Calvados', '14', 'POLYGON ((0.47600947531881843 49.002086309376423, 0.49685551995415267 49.03069342637572, 0.49460756896166913 49.046959431482108, 0.45388341348692052 49.071842318029709, 0.4478765561093212 49.085151363718481, 0.45420148156640039 49.099208318245033, 0.44820553742675884 49.112518420053632, 0.4563624786954108 49.1430893918194, 0.45446955997542204 49.156643281281632, 0.43612247080480415 49.169212339031148, 0.43675948706365375 49.223915296167334, 0.43074242052801992 49.237228390315337, 0.36808652926438867 49.2689704229184, 0.35792753689651136 49.282013326417811, 0.3683604163323082 49.296314420637927, 0.38823254249288652 49.302990329908241, 0.40280048298222937 49.317546301039883, 0.39676141395079867 49.330856402848482, 0.3753624906005939 49.335014346497687, 0.33526250192710449 49.324360385983951, 0.31051743901332429 49.322834292874191, 0.31282541281436238 49.394069397306154, 0.32302946629368989 49.427333298539779, 0.28234350715163714 49.423633358843475, 0.22525442334926993 49.41599638055591, 0.1819505192451345 49.413067408312983, 0.13445153127884168 49.4060672702643, 0.1121564902790908 49.396167379287149, 0.0832624607343746 49.369671269746377, 0.029157443424452367 49.337173407407064, -0.012028412422495194 49.319778410235372, -0.0637305811694091 49.307876292139, -0.082332547251553478 49.296276400325169, -0.21411658394788446 49.281780275982143, -0.22792447022177953 49.269180414738472, -0.2429125703712316 49.263981312987269, -0.24362245889622614 49.270881295674982, -0.22791355698385019 49.275077435656939, -0.241312548875527 49.277275396978908, -0.24592145567899593 49.282676393631718, -0.24882050452762883 49.287174407856256, -0.30511256992156177 49.298576277207744, -0.34900948529292464 49.318073304819663, -0.40881156483933978 49.335476398909819, -0.45140153195924881 49.337272330628238, -0.46019848182618261 49.334377330238837, -0.54879144321691342 49.344974436303417, -0.60939758197037008 49.337776275792393, -0.66239156125158161 49.346782337379565, -0.73358846935082056 49.34717943842405, -0.78157855302370649 49.352176293233711, -0.84607050855817079 49.361683307645578, -0.89726450766170274 49.37927227882038, -0.91457043873032262 49.390873402774005, -0.95306741356867519 49.396579442028766, -1.0058614341679402 49.395374409337947, -1.0672654714296357 49.387279427097539, -1.1118485126305018 49.36257537683592, -1.1041564400934476 49.339679403670445, -1.1156505439074067 49.33638730223656, -1.129551544743606 49.33638730223656, -1.0709015158781199 49.265773372266452, -1.029336513023253 49.2413903824238, -0.98458150031510172 49.222713431835913, -0.95903255421418976 49.219078443507257, -0.93892755363791025 49.223274407469219, -0.910530428458685 49.252685407655619, -0.8908415390832829 49.259563387847507, -0.87216458849539436 49.247192352560333, -0.87180744398332877 49.219844306381574, -0.89608957438517223 49.190727435559253, -0.91484344569840914 49.178417303180495, -0.92083446127898583 49.16430243808496, -0.89991043979847518 49.138427326986076, -0.92417356004392559 49.10928739754813, -0.92191944835263939 49.095768360039287, -0.902324553639346 49.102646340231175, -0.86984957389569217 49.132339324403929, -0.84887855508409871 49.131103312199016, -0.846211500551334 49.114872335065925, -0.86595354795665 49.083343286622366, -0.86969045184594052 49.055679284603727, -0.92123244242330316 49.01635730418225, -0.95995841923809166 48.999889404174255, -0.999989584104668 48.991504341028971, -1.0622705528396068 48.992466290146027, -1.0868225218501379 48.941333369970877, -1.0663714660196888 48.942829363666348, -1.0445615360476666 48.936195347148058, -1.0300414729891827 48.923576299728055, -1.0686364909489043 48.907047320791648, -1.1099445046526455 48.882087337498731, -1.138024441852167 48.852611385944684, -1.1316574476230983 48.839363419184266, -1.0904015358294714 48.814994334918978, -1.0260514523880317 48.800529366110041, -0.98796953263075693 48.819767292331207, -0.96755244865380519 48.821235298852017, -0.85756654859176251 48.7798383950652, -0.81724547884030585 48.78546135289578, -0.7809725162789789 48.79079440584151, -0.75927347888585928 48.784114272091969, -0.71234549969096861 48.825779430307776, -0.65239257103326054 48.838192358347, -0.62811853754988078 48.867286346573692, -0.5442754749557821 48.85941737397026, -0.50341050350780847 48.862209402679255, -0.40335142547777991 48.882743363913946, -0.38209349412076676 48.878692440404379, -0.33745148623111731 48.857082293094365, -0.29039149206133175 48.819164423945878, -0.26023451925681229 48.864982421231858, -0.23978152720673052 48.866348336172095, -0.15557357522200732 48.855484383838288, -0.11186042469572044 48.839206409374142, -0.048174464587987131 48.826934297308142, -0.031744584892749117 48.855377363698622, -0.010111554987076943 48.848579296571543, 0.006324485406992153 48.876987334988669, 0.024784579396111894 48.891857325740588, 0.04486053667793044 48.895893287552994, 0.063707522553471563 48.908039369322964, 0.0695304390660283 48.924831322089361, 0.083900533113023812 48.939430418112792, 0.1425894623911006 48.962318294359804, 0.16305547991873937 48.963600423795967, 0.18470857610057578 48.9567643363561, 0.22529244366205603 48.962051272070582, 0.25830657256315703 48.991451359019052, 0.34145946086852064 48.988422407435124, 0.38396951492364906 48.980068323803962, 0.47600947531881843 49.002086309376423))'),
('Cantal', '15', 'POLYGON ((3.3602164963988059 44.979824306980234, 3.3629655762359505 44.993606318319067, 3.3542224884787686 45.006950391981192, 3.3178544751355332 45.030113387435861, 3.3260765437917996 45.071521380480576, 3.3121915607725327 45.101081293558664, 3.3188065671344589 45.11502031470765, 3.3773745706955367 45.103672307465885, 3.3839825362587987 45.117618369413506, 3.3675524805435941 45.130661272912917, 3.3080925838121118 45.152900339563345, 3.2954964189877387 45.16607226569819, 3.2796005838709448 45.22017640290828, 3.2430354281651717 45.243320388206584, 3.2446914240102274 45.27077140606572, 3.2281904322485104 45.283786322390469, 3.2078594220351988 45.29663842024614, 3.168735464076093 45.303218398634712, 3.1637525148437931 45.31670029593063, 3.1262134406632356 45.304199357908161, 3.087280464367808 45.308040289597656, 3.1003825105759688 45.335956352208385, 3.09426141624013 45.363060434713518, 3.0815585833160242 45.376224439949894, 3.0559994280570777 45.35872629507783, 3.0248294603452166 45.316326429521737, 3.00675150570342 45.301864277032266, 2.9877545508163905 45.298309377788357, 2.9281885140451038 45.317638306332228, 2.8618684151383604 45.369491324190435, 2.8209684157170329 45.395065441146571, 2.7817184274618683 45.401523437698344, 2.7237045347553988 45.401649291974408, 2.7036954650608607 45.408970314422035, 2.6780984655090947 45.435173350718557, 2.6375584269192984 45.455227305504522, 2.5214074275297662 45.455295425231569, 2.5196305059677115 45.474399400258235, 2.4805905095326182 45.395874428912705, 2.4626375290670524 45.381328314899193, 2.4233644821962912 45.387664329614168, 2.3924884678285423 45.4272614292433, 2.3726925583134744 45.431808377018527, 2.3753384904502468 45.404537427585112, 2.3561764288346296 45.362514420777373, 2.2339884726532375 45.268879367445564, 2.223795508431806 45.254669275548153, 2.2056974875138451 45.242817323142262, 2.1752224466298173 45.200195320388431, 2.1652894638989437 45.144912377462546, 2.1034365757225828 45.070541301306989, 2.1061694617228284 45.043277392672238, 2.1217614863774088 45.002994343233567, 2.0843595317508061 44.992839399324922, 2.0649524503417638 44.994594318391151, 2.0545975477511433 44.983112359954887, 2.06499047065455 44.956234287086758, 2.1206534406881588 44.860450382003634, 2.1514064170993095 44.820903272045015, 2.14837957775498 44.774185284670196, 2.1247154534555932 44.704483314146628, 2.127431441539045 44.677227326410375, 2.1325874183984581 44.663787321866508, 2.1580844386092508 44.637676344012462, 2.17759554781847 44.633194347604885, 2.1941164298364129 44.628441280448882, 2.2037334567273774 44.67835631847565, 2.3185834925443203 44.675869332368634, 2.3969505739798933 44.655048282568558, 2.45346442453166 44.663261374206527, 2.4719544419151021 44.669647378591989, 2.4858985676430905 44.684013424179753, 2.490962486059999 44.711631308967171, 2.5089635199764473 44.723453337978768, 2.5506244537130556 44.769252325108383, 2.6263434907722285 44.90425840729192, 2.6679625317568139 44.952758420807825, 2.6860894199493259 44.964542429506636, 2.7054364785497569 44.962688411199267, 2.7219425748905053 44.949745311020862, 2.7269925877300523 44.936294393239066, 2.7179634675272837 44.908500312465165, 2.7204025762033837 44.881221266113286, 2.7292614850985331 44.867942319838775, 2.7488345533359677 44.8633383415944, 2.7865184919489536 44.8705254128475, 2.8058264741168273 44.868652384383736, 2.8258705717846908 44.858600412155496, 2.8637514767402195 44.819210312007, 2.9035404381328647 44.801815314835309, 2.9085165225864671 44.788360348594253, 2.9058894245861211 44.77453626848343, 2.9158484582720234 44.74759342026762, 2.9167245096454053 44.6928712769551, 2.925514418713675 44.6795733205242, 2.9596084301094265 44.653297411961532, 2.9881085269690573 44.706962379355147, 3.0200804416484175 44.73571031232764, 3.0410245294051208 44.805069395956409, 3.0833634920527686 44.8479424031825, 3.1105295335861172 44.890167304891847, 3.1286965543309861 44.901882313763807, 3.1684594647685742 44.884380296452477, 3.20618952061281 44.891437288950314, 3.2246545431609945 44.9003944169868, 3.2328065558705816 44.94179536923285, 3.2516885697194482 44.945320345082436, 3.2710074651252228 44.943367403553864, 3.3262115511060983 44.972976426202607, 3.3602164963988059 44.979824306980234))'),
('Charente', '16', 'POLYGON ((0.61320049334679538 45.685100404765549, 0.6267315002133671 45.729252373068405, 0.63658756221886392 45.743602400839208, 0.66755352278951818 45.775711435072466, 0.68588846658244051 45.78507640137137, 0.69790658183674736 45.813259310251325, 0.71169052939521293 45.827850309356322, 0.7528205869128044 45.811191427684619, 0.77115658682552635 45.820545304725627, 0.78107249561963954 45.834873330000633, 0.81743346816423923 45.856311329783395, 0.83123941821853009 45.870868357034809, 0.847243505614756 45.899276395451963, 0.84435642612382367 45.953945380734623, 0.86274945650572477 45.963283415978637, 0.92401056555462446 45.942306412488207, 0.94242454231252282 45.951648320171486, 0.95241349939274755 45.965965432208534, 0.95462642241187723 45.979793384758651, 0.918519446678971 46.018745371210471, 0.89773043251275908 46.028469418241073, 0.83740258132635859 46.041271350406291, 0.82402541591054046 46.054161292554809, 0.808958458816079 46.080665322994079, 0.80555352858365836 46.107872377179618, 0.80773247974926221 46.121715291426867, 0.82549958313018124 46.136509417573208, 0.78024256147747906 46.152923279451514, 0.760422537227015 46.154453421020506, 0.74128951890585881 46.15053944104487, 0.66084346564571206 46.104404431799182, 0.58335842026238538 46.096832404879294, 0.5635665592065493 46.098327342454965, 0.48111141404848468 46.128727398833249, 0.47122050008960059 46.114387404200542, 0.47868057831078659 46.087417272889937, 0.46879758525042803 46.073078334377, 0.45079355899454754 46.060939293405696, 0.43169345640714596 46.05697233142017, 0.41082153683672118 46.066600271549063, 0.39736551447589363 46.079452369404763, 0.27996653352371936 46.077285387596888, 0.23813855683886231 46.096489341964528, 0.19776256885788257 46.104786395126538, 0.180357538548094 46.117347355957591, 0.15924042316430587 46.099491362493595, 0.13904142792591756 46.103618326628705, 0.11772347376032144 46.115909272831104, 0.098653470587180436 46.111892321175091, 0.044091505444185941 46.080776391592948, 0.023902543343865545 46.084880297112434, -0.034414455744951056 46.080921432045344, -0.059760450824484224 46.038005299927462, -0.044291464126473556 46.011627299784223, -0.050158561650619049 45.997497296971588, -0.083172514531781871 45.981506411072857, -0.072771494709940043 45.935539324875222, -0.0917844674139019 45.931488401365655, -0.10535754305246314 45.916835267212477, -0.10854244832674453 45.8562013173043, -0.13567258178693464 45.799415339884277, -0.15425641781251898 45.792629418134894, -0.17474954241498608 45.799442270939167, -0.23116957432461049 45.784485326323775, -0.25169350242120458 45.791275296532419, -0.26370052841761549 45.820652324865264, -0.30200652159231822 45.815174407487106, -0.31938444482725004 45.800205317494047, -0.33791952332211395 45.793392288669807, -0.39590243651448986 45.789249306717736, -0.43178146639073134 45.767433392066849, -0.44522551939385835 45.752739421281447, -0.424728522352126 45.745975326007894, -0.40541349938558824 45.747360427124491, -0.39569649315365041 45.734329316962842, -0.41875158836884907 45.705215438479925, -0.39935348397813186 45.6791343840202, -0.40122246398269112 45.665268411157356, -0.41891845529713123 45.653019357706953, -0.43035852098137184 45.624717283309664, -0.41070853201856039 45.623394317241278, -0.3918485206654907 45.62749839878073, -0.37176446646520844 45.623436386013267, -0.32348148556803835 45.585716363307156, -0.30029842383717664 45.559906379595887, -0.25986646150681736 45.549049292040777, -0.24638456421089927 45.536289428647521, -0.25019152404686906 45.508545337544106, -0.29052051469679441 45.464481379224523, -0.29241044107735092 45.450618398701081, -0.27274654653717789 45.421806394460774, -0.30998955513402393 45.410907414153613, -0.32762552363988107 45.39863230974818, -0.32950541688236967 45.384781298582467, -0.30875653526854308 45.3752864295483, -0.29529153588941881 45.362507379978709, -0.31291852737697923 45.350265367326969, -0.31864656912756573 45.336113362018509, -0.29829549263808985 45.329342401966258, -0.24193354731744421 45.341602368654563, -0.22235854286034851 45.340248423072083, -0.18169652243375367 45.3266522888179, -0.13915548886453166 45.2994343213944, -0.13303052208942745 45.283386405026519, -0.14072453084611425 45.255386380891778, -0.12730952113747662 45.242607331322191, -0.042665567695706841 45.245765305541582, 0.0358044854202717 45.23745329068241, 0.056067551926503256 45.230621427721744, 0.14838756008839482 45.234180375424884, 0.16644456835416577 45.243644440964928, 0.19726249613299274 45.273162285271027, 0.24108847545784329 45.292587320716606, 0.26395452522899632 45.324302422264807, 0.26728447095567276 45.357448390120865, 0.26183753309163649 45.398265308117985, 0.273222504526359 45.429218419231105, 0.326191488972313 45.468403280098627, 0.46042942002193854 45.540294410945833, 0.50485844375208444 45.587062387991168, 0.53185057755851517 45.649158359741293, 0.58765154724588342 45.6691742942145, 0.61320049334679538 45.685100404765549))'),
('Charente-Maritime', '17', 'MULTIPOLYGON (((-1.236996412907297 45.758888317927088 0 0, -1.2331915729725722 45.693889433733986 0 0, -1.2170915460176646 45.674995309101682 0 0, -1.2258985197315038 45.69649135871375 0 0, -1.197788501085796 45.696895326702318 0 0, -1.103798415481549 45.64059428429006 0 0, -1.0650984896217892 45.632000285444533 0 0, -1.0454944418702325 45.621555436651008 0 0, -1.0404954748209718 45.620552298861796 0 0, -0.82212352017256762 45.502098430250228 0 0, -0.73402042234869214 45.366398301338691 0 0, -0.73165242573904266 45.350761391592627 0 0, -0.70711647454547233 45.336792271029381 0 0, -0.70562646552886577 45.325130420187335 0 0, -0.69112558864674156 45.330902290909606 0 0, -0.65195744967601854 45.328331343278549 0 0, -0.6332245247388073 45.332470276771389 0 0, -0.61525042187724921 45.342056324148231 0 0, -0.60576558598114616 45.356506331260036 0 0, -0.5882054820808662 45.368793405023169 0 0, -0.56741453169502165 45.359340428741021 0 0, -0.55572856611755128 45.33272128124365 0 0, -0.54221656940737262 45.319996269803781 0 0, -0.45998954612591092 45.287555437933619 0 0, -0.40427852264144803 45.250415401017179 0 0, -0.39809052469342737 45.234386323892366 0 0, -0.40090650446507131 45.173759426063604 0 0, -0.38141458510989423 45.1724133849922 0 0, -0.36385448120958586 45.1846844409384 0 0, -0.34511557159351014 45.188789402577683 0 0, -0.25206349639083214 45.132286289243879 0 0, -0.21077748518291628 45.113250433944259 0 0, -0.19130457230642151 45.111896312341784 0 0, -0.15383643417240478 45.120044276592139 0 0, -0.11713644717227112 45.1336133037715 0 0, -0.097646460359015919 45.132244396491828 0 0, -0.080473424365123947 45.119697341238137 0 0, -0.06023957717334838 45.1128804399746 0 0, -0.0364064737061085 45.144607334860567 0 0, -0.00042852060866493957 45.1635852795912 0 0, 0.0035004210641034206 45.191303319739561 0 0, 0.020762523161067747 45.206222420062133 0 0, 0.057187580078026157 45.22245426360557 0 0, 0.056067551926503256 45.230621427721744 0 0, 0.0358044854202717 45.23745329068241 0 0, -0.042665567695706841 45.245765305541582 0 0, -0.12730952113747662 45.242607331322191 0 0, -0.14072450734721734 45.255386359483126 0 0, -0.13303052561632869 45.283386419250967 0 0, -0.13915548886453166 45.2994343213944 0 0, -0.18169652243375367 45.3266522888179 0 0, -0.22235854286034851 45.340248423072083 0 0, -0.24193354731744421 45.341602368654563 0 0, -0.29829549263808985 45.329342401966258 0 0, -0.318646550424216 45.336113380397684 0 0, -0.31291852737697923 45.350265367326969 0 0, -0.29529151403999371 45.362507374638234 0 0, -0.30875653526854308 45.3752864295483 0 0, -0.32950545253076752 45.384781296726864 0 0, -0.32762552363988107 45.39863230974818 0 0, -0.30998955513402393 45.410907414153613 0 0, -0.2727465641395147 45.421806387463647 0 0, -0.29241039253826728 45.450618409148127 0 0, -0.29052051469679441 45.464481379224523 0 0, -0.25019152404686906 45.508545337544106 0 0, -0.24638454153812589 45.536289412354719 0 0, -0.25986646150681736 45.549049292040777 0 0, -0.30029842383717664 45.559906379595887 0 0, -0.32348148556803835 45.585716363307156 0 0, -0.37176446646520844 45.623436386013267 0 0, -0.3918485206654907 45.62749839878073 0 0, -0.41070853201856039 45.623394317241278 0 0, -0.43035847687560047 45.624717293659771 0 0, -0.41891845529713123 45.653019357706953 0 0, -0.40122246398269112 45.665268411157356 0 0, -0.39935346867984389 45.679134368485975 0 0, -0.41875163199892995 45.70521544942433 0 0, -0.3956964614702792 45.734329313096666 0 0, -0.40541349938558824 45.747360427124491 0 0, -0.424728522352126 45.745975326007894 0 0, -0.44522552942391291 45.752739435353647 0 0, -0.43178146639073134 45.767433392066849 0 0, -0.39590243651448986 45.789249306717736 0 0, -0.33791952332211395 45.793392288669807 0 0, -0.31938444482725004 45.800205317494047 0 0, -0.30200652159231822 45.815174407487106 0 0, -0.26370052841761549 45.820652324865264 0 0, -0.25169350242120458 45.791275296532419 0 0, -0.23116957432461049 45.784485326323775 0 0, -0.17474954241498608 45.799442270939167 0 0, -0.15425641781251898 45.792629418134894 0 0, -0.13567258178693464 45.799415339884277 0 0, -0.10854244832674453 45.8562013173043 0 0, -0.10535754305246314 45.916835267212477 0 0, -0.0917844674139019 45.931488401365655 0 0, -0.072771496667894 45.935539333091668 0 0, -0.083172514531781871 45.981506411072857 0 0, -0.16463842747799617 46.003322325723744 0 0, -0.19570243117001951 46.056049282715733 0 0, -0.20929451696497381 46.06881337058816 0 0, -0.2493084318748231 46.074245346755063 0 0, -0.29797443221914932 46.11201430301189 0 0, -0.33566946009003118 46.101101417127367 0 0, -0.3792215523469622 46.103496344791878 0 0, -0.4156835603523632 46.084427397738565 0 0, -0.43511050617655311 46.083023297994181 0 0, -0.43522759036799452 46.110485406330994 0 0, -0.45546741716597694 46.114505337578109 0 0, -0.49352645432762188 46.106277284242978 0 0, -0.51378441625479354 46.110302332817483 0 0, -0.537274456807296 46.136074296215966 0 0, -0.557941489136681 46.142791394158465 0 0, -0.59642755073713261 46.13724535705326 0 0, -0.61502141990078485 46.130371425320575 0 0, -0.63529047108588088 46.134403338673778 0 0, -0.64901648871583728 46.147117449771713 0 0, -0.64617256531579215 46.180278376849692 0 0, -0.6990864436726838 46.217575413155473 0 0, -0.77181054202896537 46.280853329580879 0 0, -0.7482845230673274 46.3073234369433 0 0, -0.7631605278066047 46.333694376911112 0 0, -0.79623151115691826 46.336734417752936 0 0, -0.81392644635155875 46.3491403049935 0 0, -0.83385841930075344 46.350399375814035 0 0, -0.93400955577325817 46.33460633635768 0 0, -0.94004247321897738 46.3478813765914 0 0, -0.92657044936947308 46.362644367618451 0 0, -0.92870343388241849 46.376213407984537 0 0, -0.98811351696335237 46.377205280495886 0 0, -1.0258375881287236 46.366081346671521 0 0, -1.0436175409671762 46.353733369999944 0 0, -1.0531414532958649 46.339244286455582 0 0, -1.1101124277006988 46.320030298949845 0 0, -1.1122364457763236 46.287777301523704 0 0, -1.1101935783971126 46.279163356957142 0 0, -1.1241954331822797 46.25486031450437 0 0, -1.133996576958225 46.25116336714747 0 0, -1.1568904378841012 46.227970272278512 0 0, -1.1908834138190798 46.213066309673067 0 0, -1.1972864928294775 46.204769420782711 0 0, -1.188585435644866 46.203670337550946 0 0, -1.204685491434077 46.181362297382762 0 0, -1.2319874042657473 46.163669305237349 0 0, -1.2178834685240076 46.161464296287122 0 0, -1.2013925099003586 46.14637040813777 0 0, -1.1686874720604692 46.152370400736672 0 0, -1.1543965859398981 46.149772325604175 0 0, -1.1678955253871128 46.13766831943196 0 0, -1.1472994619481938 46.13327029814927 0 0, -1.1430994495269715 46.126873380525879 0 0, -1.1258934977993249 46.124870273306826 0 0, -1.1185903998954563 46.110473425721437 0 0, -1.1359954469829077 46.106266364468588 0 0, -1.0970994475956104 46.09096935581438 0 0, -1.0852024340782691 46.058269422553494 0 0, -1.05619856807445 46.04337742930575 0 0, -1.0470985159685868 45.998775401803854 0 0, -1.0551975425248088 45.994182312942044 0 0, -1.0878934273264633 45.990974349052166 0 0, -1.1038904487593619 45.996776328625792 0 0, -1.1035775104235483 45.983307271350341 0 0, -1.0730915563015913 45.975486352197791 0 0, -1.0719954608804794 45.969280426197635 0 0, -1.0736944420110086 45.958080440409205 0 0, -1.0616995440682331 45.955478338623053 0 0, -1.0461525246037529 45.956039304231815 0 0, -1.066602580235724 45.906177434259476 0 0, -1.0912985335788505 45.878685403748122 0 0, -1.1149955736119921 45.857986335784815 0 0, -1.144594563122638 45.859485321819719 0 0, -1.1453984463097413 45.854381270850453 0 0, -1.1538984504931307 45.853984345825936 0 0, -1.1544954895587076 45.842888391356361 0 0, -1.1283916018836571 45.817985293330061 0 0, -1.1349525413964159 45.7977063620293 0 0, -1.1523915435597303 45.800388378259228 0 0, -1.1732935625444441 45.790592339062314 0 0, -1.2000885539883654 45.792492298580967 0 0, -1.2266974923276734 45.78418732452046 0 0, -1.236996412907297 45.758888317927088 0 0)), ((-1.4012725381606654 46.0457723798217 0 0, -1.4005754718782555 46.032581420679023 0 0, -1.3810745898239389 45.993877253498383 0 0, -1.3853745259893753 45.974685279581152 0 0, -1.3772804614486915 45.947979359989276 0 0, -1.3445775358483729 45.92148237034867 0 0, -1.3130884439372039 45.911476339331685 0 0, -1.2584845860421581 45.875381332956508 0 0, -1.2447944571258631 45.847789323104152 0 0, -1.2410934613097595 45.807190317825572 0 0, -1.2280875220033067 45.798290396278233 0 0, -1.2240925728430909 45.805988277474185 0 0, -1.1921925077923001 45.824192462476724 0 0, -1.1925964217974687 45.835285393351619 0 0, -1.1866964339249944 45.838588413603219 0 0, -1.1920935489835478 45.859092282034958 0 0, -1.1852004361879847 45.8746913273257 0 0, -1.1895884349253549 45.894291333980064 0 0, -1.22308942138834 45.917385339967652 0 0, -1.2198964235574212 45.939983301563885 0 0, -1.2335944860444481 45.9541784444754 0 0, -1.2262934959375091 45.967678287280592 0 0, -1.2339884153610399 45.986786305988673 0 0, -1.2714845406697464 45.986473342488196 0 0, -1.3059814617688517 45.992683326907141 0 0, -1.3290874267543984 46.012275405300969 0 0, -1.3545784622863266 46.024582369320328 0 0, -1.3696725264556164 46.0415763930083 0 0, -1.3836824836511141 46.040474331997885 0 0, -1.4012725381606654 46.0457723798217 0 0)), ((-1.5582684234922515 46.24116540669602 0 0, -1.5277724282470047 46.201667432660983 0 0, -1.4899735485958843 46.191070326596432 0 0, -1.4717714998776614 46.19907342641433 0 0, -1.4489725137137555 46.196468330909781 0 0, -1.3792814564281173 46.173362365924262 0 0, -1.3277834708424052 46.146774373960952 0 0, -1.2737875859117196 46.145965386194817 0 0, -1.2522914995400072 46.156265370555886 0 0, -1.2491815500357746 46.161670445703848 0 0, -1.2559884468969074 46.164875387218373 0 0, -1.2680804905371588 46.162075437610881 0 0, -1.2877875099691209 46.186672291712867 0 0, -1.3150855664773644 46.189270346418752 0 0, -1.3349775828941688 46.201461313280177 0 0, -1.4061804756722722 46.20346442049923 0 0, -1.4348715286229456 46.2110633566324 0 0, -1.4342755505889215 46.214862417411453 0 0, -1.4148735737589391 46.216964271831714 0 0, -1.4022684063047119 46.2260623857216 0 0, -1.4105744620965766 46.229869351697332 0 0, -1.4487755473712127 46.225967341079453 0 0, -1.46206452678382 46.212566412968144 0 0, -1.4834674985932566 46.208164329625347 0 0, -1.5092625239581052 46.221969381545037 0 0, -1.4990635717070688 46.228069371519652 0 0, -1.4785655185455369 46.227863428158841 0 0, -1.4723734496032366 46.231460395102623 0 0, -1.4759745046383159 46.249862403574909 0 0, -1.4835734626130943 46.254966278524208 0 0, -1.5092714976256332 46.256466320678911 0 0, -1.5210704680216338 46.246360310320952 0 0, -1.5582684234922515 46.24116540669602 0 0)))'),
('Cher', '18', 'POLYGON ((2.1568994721945955 46.4262583487466, 2.2223644661039827 46.40209538386209, 2.286140548434588 46.389557305626695, 2.2774914553395149 46.402019343236546, 2.29300743936858 46.443851368380635, 2.3115365331845794 46.455692407548625, 2.3321044662728241 46.486774365277213, 2.3608145549525261 46.51551842581047, 2.3990325381439277 46.528263327506536, 2.5210564437165033 46.531204269107221, 2.5797404444355436 46.536640293733356, 2.5941504950149579 46.55097940826623, 2.5967914985926654 46.564781309861289, 2.5926794961547159 46.608387440247938, 2.5770065023155269 46.648704285520168, 2.5959034778615546 46.657787267832717, 2.6230614224764395 46.705532331712206, 2.7003445729581586 46.725391432395256, 2.7381094807557531 46.7024463496591, 2.7580495506234115 46.7005882828925, 2.777500461004081 46.704162368312737, 2.834654496174096 46.72855028671448, 2.9101235848808358 46.770076389156728, 2.94863446529655 46.782653367804741, 3.0073505016494835 46.790584299436389, 3.0377584789262642 46.805523290015159, 3.0606884239452938 46.86116443357291, 3.0522354170929304 46.912796370353178, 3.0589824384297515 46.926746304740064, 3.0593895726123037 46.967788352274383, 3.0432284754059538 47.016342403920007, 3.0249945670738043 47.042930395883317, 3.0094984733009653 47.083313424662961, 3.0028864592785 47.113121349873879, 3.0054255472955731 47.129635367113124, 2.9724184591931078 47.232158372634515, 2.9540805230607532 47.258743372258394, 2.8934164737383128 47.310875381763552, 2.8710135324990631 47.337276440522388, 2.8853654964894986 47.48823943675113, 2.8798884592111733 47.504402294157146, 2.8583754749226671 47.519901380269417, 2.8188855714531371 47.512748280869843, 2.7996434207527727 47.503715288227809, 2.717396507215085 47.524791390959408, 2.6979174336397875 47.5184513277852, 2.6807524945643308 47.487636392345806, 2.6282695012459385 47.490795422685, 2.6096645428243619 47.517311422481995, 2.5673005853414566 47.540027327221722, 2.5619985119098487 47.553451313948628, 2.5446614253071402 47.566341432117085, 2.50332841676817 47.578151315751015, 2.4474964675667081 47.613891289853726, 2.3893354221682159 47.59208628844074, 2.3693184315751807 47.591144405599877, 2.3282075602339489 47.600174405902479, 2.2896695727434064 47.622978320625478, 2.2690615071028049 47.627487424107912, 2.24934744687215 47.623809310887438, 2.1952355647835589 47.602092319457725, 2.1552105606158136 47.600177398241911, 2.1605884986529986 47.548462380037464, 2.2294434610976452 47.543560399989772, 2.223111494841902 47.526832342471224, 2.2458904147296437 47.500587413422679, 2.247298574461837 47.48697631747136, 2.2421005288304343 47.459354384224682, 2.218328504291577 47.417205347120913, 2.19782552257098 47.42170336134545, 2.1964194750783861 47.435310408837566, 2.1411175219961365 47.427154347668747, 2.1140335057671678 47.379341340082178, 2.1447884183979795 47.353481366700422, 2.14504153510984 47.312446359964767, 2.1319465297003433 47.284454432748461, 2.112607568018376 47.2780453697474, 2.0921415504907372 47.282512404457819, 1.9941005413769233 47.263996336119348, 1.9522655238934306 47.281047390276441, 1.9127765005237336 47.276329351093764, 1.8958275379472127 47.248100324982559, 1.9027604363686521 47.2210993901778, 1.8965664697666682 47.204361299521182, 1.8354845490436844 47.214920385272976, 1.8330054838351941 47.201126404576414, 1.7592724800582857 47.145305368612881, 1.764737547978882 47.131908312940837, 1.8062145408504762 47.117637318134982, 1.9122894532763723 47.0956763630317, 1.9513834878411558 47.103115318856894, 2.0091555291136558 47.122448295859996, 2.0607874658938954 47.086681390702424, 2.0517525370322289 47.058887309928522, 2.0571445566667421 47.045452409963659, 2.0744145796622036 47.032631291622081, 2.0931265582234175 47.006191332450626, 2.1001914716197518 46.976413330634031, 2.0872115832683562 46.948410314159858, 2.0965374731347026 46.935192270793763, 2.1572724585036553 46.924492369068744, 2.1665775780139427 46.911251267087025, 2.1654125018555419 46.883834397101381, 2.1510144206338566 46.869449341357225, 2.1321165649879958 46.860309328575553, 2.1112245791414068 46.8319012901584, 2.0920524843876933 46.825485362378643, 2.1242095720718055 46.783279294805695, 2.1298314737825876 46.767124358298176, 2.1236295862821351 46.75041531093602, 2.1500695454535617 46.724331440156831, 2.1438745227317781 46.669265353829715, 2.1544564910792303 46.527458388199634, 2.1785164842833353 46.484825296187907, 2.1801934265043883 46.468471281098246, 2.1594255347341687 46.440075388058787, 2.1568994721945955 46.4262583487466))'),
('Corrze', '19', 'POLYGON ((1.4222884148484241 45.036571383987635, 1.4458265088517805 45.032406399539767, 1.5198645552306687 45.05850928047532, 1.5389984536516295 45.059585290530677, 1.5822694420220387 45.05103336045714, 1.6028695867641432 45.038478384304952, 1.6470014887908064 45.021705265674981, 1.7383884151101654 44.958183356176065, 1.7982494613453355 44.936737435494805, 1.8208865091400526 44.940693308222436, 1.8388144947703893 44.952625349713131, 1.8765565199723255 44.995727358915659, 1.9164704555412015 44.981403382099913, 1.9355835836061033 44.982406343869158, 1.9729505102593805 44.99258839485266, 2.0649524503417638 44.994594318391151, 2.0843595317508061 44.992839399324922, 2.1217614863774088 45.002994343233567, 2.1061694617228284 45.043277392672238, 2.1034365757225828 45.070541301306989, 2.1652894638989437 45.144912377462546, 2.1752224466298173 45.200195320388431, 2.2056974875138451 45.242817323142262, 2.223795508431806 45.254669275548153, 2.2339884726532375 45.268879367445564, 2.3561764288346296 45.362514420777373, 2.3753384904502468 45.404537427585112, 2.3726925583134744 45.431808377018527, 2.3924884678285423 45.4272614292433, 2.4233644821962912 45.387664329614168, 2.4626375290670524 45.381328314899193, 2.4805905095326182 45.395874428912705, 2.5196305059677115 45.474399400258235, 2.519400447871476 45.559257393979308, 2.5103924500646713 45.572536340253819, 2.4769025391940431 45.598343331625657, 2.466588473235646 45.625232317731715, 2.4730274596310267 45.639232417809055, 2.5096394366478876 45.662857289655918, 2.5186794700885855 45.690673372925644, 2.5044915567069381 45.717395316083454, 2.4613654327689858 45.761909357457441, 2.4280545342043069 45.743900402642524, 2.3487045572756813 45.759285427816494, 2.3436225088022127 45.73165539765138, 2.33334241469737 45.717464315910334, 2.2580634275545037 45.691890374974193, 2.197581558897383 45.713546287475495, 2.1782144340207594 45.712585394478239, 2.1577845005862741 45.72252629810761, 2.1447764490402506 45.735576418425651, 2.105503578189456 45.739078335659613, 2.0548415114247405 45.77761033847132, 2.03631558596814 45.768459412451719, 1.9860384748702131 45.727535298294967, 1.9288404347085759 45.716358382460683, 1.8687315523605434 45.72193539908001, 1.8639064930382006 45.704746345269129, 1.8808364454583284 45.691959374801073, 1.8864205028763195 45.6757893005764, 1.8486175747659672 45.665596336354994, 1.7900465788654287 45.66798739158024, 1.7350065434933413 45.637649294230172, 1.6042634888790417 45.589443410078317, 1.5460705838665945 45.588993327023914, 1.4893895143466409 45.574890431286107, 1.469484472452308 45.579258366755383, 1.4594275716650031 45.564979275031092, 1.46097144279139 45.551372403558943, 1.4236434165507035 45.538303273084537, 1.4012915211017685 45.495918369225606, 1.3633785805123182 45.488289311836567, 1.3453564241999061 45.47630340823612, 1.3071634358437336 45.471374321113572, 1.2708644223273495 45.450077313324, 1.24069442404533 45.442855390117515, 1.254767572408781 45.421734402294462, 1.2524995551401332 45.40789835282591, 1.2579315313070367 45.394493376255369, 1.2979625201536464 45.383110341040279, 1.3033795346233887 45.369701316010506, 1.3011134535743736 45.355869315001186, 1.2693395613573841 45.329353315204187, 1.2456134780297816 45.300552400221747, 1.2510215154812272 45.2871664338076, 1.2916055590626456 45.270313402112848, 1.3046745135171136 45.257370301934444, 1.249966451801896 45.229530279949287, 1.2515585523991035 45.215908270760011, 1.271039562194062 45.214294343686973, 1.2802784981969353 45.201133330790029, 1.2505064810591762 45.1582684204824, 1.2635594176966833 45.1453173994055, 1.282696484477043 45.146419284395947, 1.3194385402491662 45.162273402780684, 1.358066473942614 45.161739358202269, 1.3985405050449629 45.144859395452627, 1.3862865230355226 45.116752351178221, 1.3878384910803732 45.103126293529741, 1.4100395374179868 45.076988384620833, 1.4222884148484241 45.036571383987635))'),
('Corse-Du-Sud', '2A', 'POLYGON ((9.399103523198221 41.861396317446136, 9.34098859503095 41.849155360914196, 9.28532157653811 41.816784408970747, 9.270410573134 41.803257274543441, 9.252047466146422 41.803337363628216, 9.2672214433805209 41.830410290599289, 9.2564675035257835 41.844047437505665, 9.2017075159204467 41.86050442427576, 9.2095025601379348 41.887630333256752, 9.2061224487207767 41.903942279574423, 9.21027159137168 41.931083326272542, 9.1860244889431613 42.018062360590207, 9.1677835398123761 42.028984399512964, 9.1128345067629937 42.045406358309734, 9.0878965259658742 42.099762380091889, 9.0695434521163918 42.105228328112347, 9.0513174646827679 42.118843296502931, 9.0515095024662457 42.132431333838653, 9.0406635041690038 42.146019371174376, 9.0223334889351463 42.154190394040356, 9.0044635898937884 42.194961370826221, 8.9310634398735544 42.227588431820962, 8.9125434990958183 42.224891277873937, 8.87591057570296 42.2493364027648, 8.8574425608153433 42.249340275204034, 8.8390595635715385 42.257476270096689, 8.8137725351808172 42.311809409283214, 8.757761573673406 42.306152303579111, 8.72673242193477 42.315544376952843, 8.6759165137193 42.347313340610796, 8.6092894359909451 42.371788388895951, 8.57383549433385 42.379284375190295, 8.5682435160173611 42.371856332603031, 8.5447494270056552 42.374054293925, 8.55584748589493 42.3587572787343, 8.5521484262984586 42.3477634236652, 8.55954548937163 42.333652431008929, 8.5750535525021689 42.338459360274712, 8.5845484215363683 42.3507573472758, 8.5932434558426962 42.354057369608157, 8.6111464466377754 42.348453421933968, 8.6199474449639126 42.350059428108537, 8.619449484478622 42.341461380803779, 8.6264475102877043 42.340160417231189, 8.6271385646762724 42.335659410667219, 8.60054546813393 42.32175840983102, 8.60324543840045 42.308162275576834, 8.6219484399433668 42.312160393096448, 8.6331485904132421 42.309662317731565, 8.6457405307583883 42.299862406095357, 8.66073848802597 42.303363267209548, 8.6773405152484884 42.293262361430621, 8.6778354833943467 42.284156320502476, 8.6885355611393322 42.27895739477124, 8.69283643300136 42.269863323200823, 8.6429474459296216 42.259662438080895, 8.637537472258515 42.254959360595379, 8.6218435320433 42.26006728400391, 8.6078474804251925 42.258361298488367, 8.6001415023107768 42.248760289414363, 8.5830464431620328 42.246963301576116, 8.5741454654948939 42.240467284711585, 8.5420485766393028 42.2377703067845, 8.55305052862687 42.227565373205366, 8.5644534540981851 42.230564401394972, 8.5706424921411042 42.226162318052204, 8.5689424913044263 42.217868433249592, 8.5738465835917168 42.212562311358752, 8.56494648602441 42.206268365415795, 8.5762415112562564 42.204868302602065, 8.575448541307054 42.187961408797534, 8.58184158649118 42.178463371403936, 8.5687495734211154 42.170868285868423, 8.5871494685816856 42.171566381055655, 8.5904524832535 42.168064287801727, 8.5789435937623466 42.15736737841614, 8.5623464950988932 42.158134297410285, 8.5558564629132263 42.153507436570251, 8.562750460922075 42.151069384013951, 8.55975354497204 42.147365395858387, 8.5810424558431748 42.15236629912728, 8.5943455168530818 42.143669328601348, 8.5874414857061367 42.13106929133771, 8.6095455450422378 42.131073339796941, 8.62514056203625 42.121471274603138, 8.63084554517124 42.123768335166247, 8.6438484921382326 42.119468343404051, 8.660646429583494 42.101169307684316, 8.6976354413686465 42.113765296488722, 8.7010394915012341 42.086471288439682, 8.71223752973151 42.077575415351575, 8.7190415815374536 42.06457528470402, 8.7387385678313478 42.062477302723053, 8.741937554702929 42.042175335804231, 8.7296415039215 42.041671390640076, 8.71654350617257 42.029773321002935, 8.6913414954256609 42.027378393338424, 8.6619394722575578 42.010376272732017, 8.6568415819871234 42.000679332776244, 8.6614474964511317 41.992382279614233, 8.6707455751627549 41.99067735021849, 8.6713394665298154 41.985176374224707, 8.6497455130567 41.965976292296332, 8.62354546909961 41.970478354980074, 8.5974485728429215 41.9644773062614, 8.5956454243058715 41.960678267323928, 8.6123484869891627 41.940677294547882, 8.62454244619002 41.934982344550988, 8.61644042315092 41.917884293062812, 8.6175465326205369 41.905082360897595, 8.6103425634506436 41.897586374603222, 8.614846562354046 41.896278370232, 8.6357385482006634 41.904583344292504, 8.7272384793385243 41.908382383229977, 8.742732460871764 41.916786280511658, 8.7436375555396069 41.9286764292503, 8.7499355499418243 41.930278386965611, 8.7885384888000146 41.918178422426891, 8.8019274475536236 41.90118439873892, 8.8000375211730386 41.890777394238214, 8.7810354617070061 41.884182278132513, 8.7865355576009563 41.852989427825023, 8.7532394447134436 41.844391380520236, 8.7654325238144963 41.84158738245354, 8.7669394307478967 41.835685432976007, 8.7816365698926688 41.8332862808323, 8.7661374837803976 41.811382356198138, 8.75363953809736 41.812584396549525, 8.73443347149012 41.796684336953533, 8.7178365488466341 41.802185312947316, 8.7190385891980213 41.792892338814724, 8.7353394462578251 41.780086358190246, 8.7331404288160286 41.775890394228284, 8.7135414856435034 41.759693388948747, 8.6863435844962 41.747791270852375, 8.6818404656926589 41.752494348337919, 8.6684465783799851 41.750789418942176, 8.6627424753448565 41.743393411988805, 8.7000365297319888 41.741592375691326, 8.7115355621050128 41.723087396610751, 8.7384375736886 41.727794346535532, 8.77643359570223 41.741386432330486, 8.787029469627015 41.735092310367563, 8.7729304463284734 41.7160913070213, 8.7877374219323769 41.710090434322595, 8.7843294993605241 41.701194385214521, 8.7964365046979083 41.705089355033735, 8.8002285028367169 41.71118932697361, 8.82503658089854 41.713489379876179, 8.8257285153869418 41.707595351297144, 8.8431314334571312 41.69868838895114, 8.9162314694344218 41.689193343896974, 8.915022564304337 41.681793288484371, 8.8844274778031433 41.671798346725282, 8.8754314493540676 41.648197413593877, 8.85443050714818 41.647792391650924, 8.8222274782527847 41.631294392228611, 8.8085345330170242 41.640892408963211, 8.7950385541237779 41.627800395893146, 8.7884365732394087 41.619194427689891, 8.7925364302996627 41.614696413465353, 8.7853305249101368 41.603096345631528, 8.7869345948650732 41.594997314931859, 8.7798355335952181 41.589801381540084, 8.8041375542532876 41.575599386561109, 8.7910284672464627 41.56340032278122, 8.793138594605125 41.558895267758018, 8.8100345751717271 41.555599293884896, 8.8227345917763387 41.544906432958541, 8.8340354256670821 41.547905285128181, 8.8457254397037843 41.54350232168558, 8.85423442090547 41.548797354318523, 8.85473554975016 41.533298268206252, 8.84483548275304 41.521701368731854, 8.8682315286434061 41.5189973500061, 8.8805344442035334 41.523704299930912, 8.8836894260834924 41.520347423149346, 8.8889295404869131 41.515800299354154, 8.885628462034731 41.505703266014493, 8.9231215950040053 41.512302430579396, 8.9189275672616475 41.507206300508628, 8.92153248674623 41.487610349675535, 8.9292264955029168 41.486904333589806, 8.935321538883727 41.492401437144323, 8.956722574473531 41.492405309583589, 8.9634185500200374 41.490204355922188, 8.96342048623967 41.483707282937829, 8.9720255743430926 41.48570634169765, 8.9833255281339746 41.475109411653037, 8.9909274784481852 41.482307396144094, 9.00482355072532 41.4744072680066, 9.01732448874779 41.480606339187617, 9.015226506766794 41.47301142967207, 9.0239145002744579 41.46990942980203, 9.0241255482143288 41.463806289502756, 9.0371195181630242 41.468708269550476, 9.04121356656438 41.459205303597813, 9.0520134476304 41.460308420728026, 9.06031947781068 41.469104314475132, 9.0812214967953935 41.477611359457214, 9.0668225354738752 41.452308313249532, 9.0710204356554982 41.44321036923985, 9.0878115083220337 41.441906413327857, 9.09772143243731 41.455207362098164, 9.1004175302645365 41.443710265944773, 9.1090175137889275 41.445308351220845, 9.11831048792152 41.438606390995474, 9.12531749074887 41.4450114055373, 9.1281184964761621 41.440609322194533, 9.11071258606654 41.428409378314811, 9.11172047639485 41.419407365186871, 9.0996145271772662 41.414516298377109, 9.09642258110432 41.4004134026393, 9.1008105828497889 41.390407371622317, 9.1111195442291546 41.397411382110235, 9.12781257377435 41.399414313309322, 9.1502065379953024 41.386612381144076, 9.1714114873423682 41.382110318460306, 9.1824065745512371 41.367115353532157, 9.2248085523469285 41.366012412421938, 9.2417015405740983 41.393703345495467, 9.261106509743513 41.413608387389772, 9.2632055478443078 41.425007264401856, 9.2567024901811124 41.426010402191068, 9.219012566889262 41.405204314088124, 9.2163414638972654 41.413475316295077, 9.22580447331751 41.415706369370767, 9.2267035833065165 41.429405299285392, 9.2137075011181935 41.437507322324493, 9.21531157107313 41.441604363065281, 9.2482054783371268 41.447605411783954, 9.2626065518982159 41.454708345493074, 9.2645084476365014 41.463306392797833, 9.2787085063958443 41.46090741667409, 9.2713075708834083 41.4685093669883, 9.2880025366482357 41.480301296585608, 9.2887064404943374 41.494007267298926, 9.274204507492442 41.497001366929467, 9.2721005408325823 41.500904433667174, 9.28530344648155 41.5116993861741, 9.282706447895464 41.518505374199677, 9.26920659656298 41.520500384500266, 9.2715075295653548 41.524707437720124, 9.2740075411499 41.528297364937359, 9.2910024449376749 41.528198265696219, 9.32919842563328 41.557106376838263, 9.3497994504752171 41.5601083973673, 9.3519014809154442 41.573799406383458, 9.3725945641998862 41.597496270396604, 9.3663025544765333 41.600502339384875, 9.3567955400646667 41.596195306824043, 9.3445014255028411 41.598297337264242, 9.3376975497168644 41.6053963985341, 9.3198065282795142 41.605301347752189, 9.3091064505345287 41.599601293176264, 9.2969005219759424 41.579399305598415, 9.29360155576336 41.588401318726355, 9.2843055892913355 41.592899332950893, 9.28470057809622 41.60570126511611, 9.3066984973924889 41.6164934013036, 9.3089064918525537 41.62699932902548, 9.31690448709142 41.622200320658195, 9.3574024569092273 41.618202379158575, 9.3453054847099111 41.631302313127108, 9.35579944307409 41.638591299940842, 9.37280349990013 41.63709636236517, 9.3845005547354958 41.650394318796046, 9.39249344539536 41.646904370919813, 9.3917914777688623 41.660595379935941, 9.3787975078201669 41.664600362234253, 9.3851924892239253 41.671096379098785, 9.377393572567172 41.674492332312909, 9.37349754662813 41.683197399757333, 9.3999945362687356 41.69359243490031, 9.3991934694010979 41.704998352711058, 9.40929050274076 41.709793312619112, 9.4053935967019129 41.717891287198981, 9.4101964775084639 41.748195412695523, 9.4071015184370879 41.773685392107652, 9.3978965542877688 41.775386273044163, 9.3977965749467671 41.799492383479489, 9.4072914439809665 41.81418230580563, 9.407000482976315 41.828788266607759, 9.399103523198221 41.861396317446136))'),
('Cte-d''Or', '21', 'POLYGON ((4.1208475292763183 47.135131414547843, 4.1374875768115942 47.124733387065405, 4.1571734738475641 47.128097304645635, 4.1956635839072476 47.14843341943795, 4.2155554243040569 47.149063394898135, 4.2361485282474973 47.1387523212792, 4.2617865404514816 47.1122363214822, 4.2823674990172265 47.101936337121131, 4.3227834435306249 47.092250310403287, 4.3397255413284483 47.076370317083459, 4.34940857570686 47.049347379782873, 4.4094644760450024 47.042946413700278, 4.4142914715869495 47.029438289429336, 4.5434165506689794 46.997680415029279, 4.5601095802141742 46.984493351177306, 4.5863275782078574 46.944255362850058, 4.6270635270203684 46.926281436008495, 4.6437095592345088 46.913089267577462, 4.6484605141509405 46.899562309170122, 4.6688865751461606 46.889194381101973, 4.7081694791350515 46.895740387637019, 4.7275015760383212 46.904464289217842, 4.790102549072401 46.91980742163976, 4.8288195488689212 46.937210339709949, 4.8681614195465954 46.943721318271642, 4.90793753148165 46.942001427178738, 4.946988441154673 46.953930300310006, 4.966947521178696 46.951709280372441, 4.98664556359239 46.954921292721551, 5.0452614445843835 46.972744370451821, 5.1097864918725122 46.952465286128657, 5.1249845838420356 46.966484396362389, 5.1482315408207455 46.977955441560724, 5.2390655884252624 46.988258418261253, 5.2343174498282963 47.004532344266138, 5.2561995479865971 47.046001416239235, 5.295270523935784 47.060527287956617, 5.3543535619189413 47.072765428169063, 5.3737245592348017 47.084110267051429, 5.39970052977452 47.125625280235781, 5.4064315332943522 47.153080346554177, 5.4557704579707149 47.208732403349856, 5.4886754544925793 47.277671327318544, 5.504986520710446 47.292183293458535, 5.4956965389172581 47.29965639715725, 5.4911124509291085 47.313198317261751, 5.5106084224212282 47.324531362806354, 5.4980435891508819 47.337909408322005, 5.5087234245997081 47.368175337485795, 5.46865547156014 47.370079345463679, 5.452076502953247 47.383388391152479, 5.4222905802381547 47.423710341003741, 5.3814375781478816 47.441951290134554, 5.3960664215456688 47.47228639514519, 5.4557405345763925 47.481735322968106, 5.4753794342813364 47.490341291171362, 5.4868224923050093 47.504223281851196, 5.4935325494488438 47.534366349078354, 5.4797204386957219 47.575035410303613, 5.4624644972975887 47.601989347777319, 5.4420384363023686 47.609729297745261, 5.402668578450033 47.592548340852872, 5.3848145212056409 47.606300428797411, 5.3539024227447385 47.605140281198047, 5.3130335788574712 47.620632326511654, 5.2889584479362668 47.620102330392442, 5.2694084383144286 47.60876030782957, 5.24922352467334 47.611019348079921, 5.2477815691075875 47.641025295753153, 5.1867695283113164 47.656009347443373, 5.1820935579006289 47.669563412925569, 5.1653375132074189 47.682811379685987, 5.1146414745891775 47.651600399321907, 5.0531564681428449 47.674717277545383, 5.0329335341889987 47.676944282161813, 5.013419432640319 47.665573392324418, 4.9933374906796644 47.66507736805876, 4.9728244758209712 47.672748318199851, 4.960050530830415 47.686077430164815, 4.955309433032113 47.699604388572155, 4.9584684633713039 47.716083377838046, 4.9495294653914073 47.732216311849768, 4.9295874593041162 47.729004299500659, 4.9160605008967764 47.7559622854336, 4.8955105218451251 47.763618273877526, 4.906826493452968 47.777546381788554, 4.9502045019630145 47.79501741958579, 4.9615424760666826 47.808948343816311, 4.964852531537133 47.822685294043723, 4.9511784204377989 47.852356275720652, 4.8967134422963454 47.88921327253091, 4.8878925537139537 47.902633386818579, 4.846948549301004 47.912498425842372, 4.8261864661896823 47.922889412526146, 4.825419547195537 47.93651529415466, 4.8440744952876 47.964283323973532, 4.8232914658002812 47.974659348960145, 4.8029474301094695 47.976852381723077, 4.8013834927069183 48.0041162903578, 4.7810405131358777 48.006309323120732, 4.7609974715878138 48.003063338918068, 4.7433164419705349 48.007290282394152, 4.6579094419738851 48.035793371593215, 4.5966245702294941 48.045021394358159, 4.5568614837719394 48.032997294425016, 4.5634155872254212 47.992237406897019, 4.5440484623487976 47.978050373615233, 4.4836505552157178 47.973617310758343, 4.4227504631181489 47.97732534737311, 4.3827154258123358 47.970676369157658, 4.3214715667201347 47.9797892748645, 4.281102443517824 47.978565408037255, 4.2616425561188578 47.967075352682528, 4.2578104254276923 47.953109400478681, 4.263977460974786 47.931644293621062, 4.2465395149312712 47.890159379851, 4.2443285281317742 47.862793379635647, 4.2613565236732711 47.849647328435864, 4.2818635538530714 47.844818396674285, 4.2878434801757805 47.814964354232146, 4.2384455888106345 47.769790414003651, 4.2353295073432662 47.756042374518344, 4.2411615768940862 47.728904320159685, 4.2751015708191176 47.702652350312476, 4.2719675353151843 47.688888293010208, 4.24695245777275 47.641693291526124, 4.18079042479593 47.549526420735091, 4.1656954805268072 47.535392369463224, 4.1229555443953814 47.514930400394846, 4.1419285605669529 47.471824342733058, 4.10761153187363 47.44615535101498, 4.1007365440211743 47.429538362095329, 4.0955765187025293 47.388385421982107, 4.1014154530320468 47.361274298678282, 4.1261175670740045 47.351116362430204, 4.128165559384513 47.321136289692035, 4.1222405512913838 47.290897291583107, 4.1290035904451372 47.250137404055138, 4.1483585699440653 47.25894526716, 4.205600439077358 47.178795279483509, 4.1661705584164395 47.172096311597571, 4.1468465584316334 47.163280351574272, 4.1208475292763183 47.135131414547843))'),
('Ctes-d''Armor', '22', 'MULTIPOLYGON (((-3.0157274765684909 48.836521405625177 0 0, -3.0031244382735451 48.836921318168734 0 0, -2.9978355663394325 48.85941737397026 0 0, -2.9912355216746676 48.859420366309692 0 0, -2.9904335906031987 48.864124327945056 0 0, -3.0163324485015437 48.859424414768924 0 0, -3.0157274765684909 48.836521405625177 0 0)), ((-3.64296141675414 48.662799381438425 0 0, -3.6203604533830003 48.651733351689174 0 0, -3.6134074886853682 48.638633417720612 0 0, -3.5937365533465311 48.643257286221214 0 0, -3.5717444427091607 48.637073352757326 0 0, -3.5567174421470895 48.624744386242142 0 0, -3.5538205055380558 48.611240310430432 0 0, -3.5347485661453106 48.618545315061127 0 0, -3.5139164270873096 48.617733334955531 0 0, -3.5029625202063843 48.605014297429371 0 0, -3.5041355256075235 48.591144286872449 0 0, -3.5267204714921547 48.561500412270348 0 0, -3.5625604386289185 48.536102316026913 0 0, -3.5365934314144454 48.511036367967975 0 0, -3.5337375023589845 48.497539320239419 0 0, -3.5695274712307992 48.472137363526073 0 0, -3.5730024391116855 48.430519391446644 0 0, -3.5511085659138359 48.424331396738168 0 0, -3.5401854863759334 48.411602337189159 0 0, -3.5436805368937847 48.369976436940334 0 0, -3.5109235554523197 48.331768309213935 0 0, -3.5287744403298764 48.319076383168337 0 0, -3.4874215395967449 48.29820639756975 0 0, -3.5437924720252738 48.27359740248589 0 0, -3.5570115802597377 48.258579387785332 0 0, -3.5461085427447756 48.245845390483979 0 0, -3.5248625807454914 48.242351394148486 0 0, -3.5053345736194785 48.246975438669054 0 0, -3.4846594250832843 48.246151305345343 0 0, -3.4892884174512631 48.229198302150039 0 0, -3.5071035913778559 48.216491415003965 0 0, -3.450270423511995 48.219101268810377 0 0, -3.4290295660917423 48.21559143067789 0 0, -3.4027295427936792 48.187778339747595 0 0, -3.3803855682432129 48.178856415704431 0 0, -3.258740457638595 48.184669299078891 0 0, -3.2168674198423162 48.180282353453222 0 0, -3.177793451553697 48.189380297462932 0 0, -3.1571424370412444 48.188530297044579 0 0, -3.1342934612068518 48.17687231864177 0 0, -3.11309150419919 48.173290312323033 0 0, -3.0864364486286604 48.20323940554708 0 0, -3.0798374600836951 48.231353314600184 0 0, -3.061930420829384 48.243980282918685 0 0, -3.0406955480879958 48.240402325059179 0 0, -3.0189445848047569 48.234123340813355 0 0, -3.0041645402557435 48.2216984434164 0 0, -3.0014355266947632 48.208202288503216 0 0, -2.9389294284226253 48.202835439723927 0 0, -2.8909134698146772 48.187866349730839 0 0, -2.8681164198703755 48.176159437777372 0 0, -2.846939457697971 48.172546275924546 0 0, -2.7860995644289517 48.175209281998079 0 0, -2.7643954224568006 48.168872387183271 0 0, -2.7403565516487163 48.129737339966269 0 0, -2.7197405651096176 48.128814291261804 0 0, -2.6883194169055287 48.156318291130887 0 0, -2.6491715202309649 48.165252360551747 0 0, -2.6344704990919325 48.152797376670094 0 0, -2.6573434154706503 48.123294304434978 0 0, -2.6494684659144809 48.082733320145834 0 0, -2.6388034161428493 48.069923291062153 0 0, -2.6176764436409314 48.066265420137839 0 0, -2.5785744881776225 48.075172382483842 0 0, -2.5651505014506881 48.090091306786448 0 0, -2.5275635498392717 48.10709729983212 0 0, -2.4977505200493226 48.164661285504152 0 0, -2.4963425363371243 48.178520393588329 0 0, -2.4560985633310111 48.181987282848965 0 0, -2.4003664174505559 48.211490341477869 0 0, -2.3807614895991662 48.215919355875528 0 0, -2.3620984445886677 48.203746343050668 0 0, -2.3543915863743905 48.163177437186377 0 0, -2.3438145465860316 48.150333436249142 0 0, -2.2648634309015279 48.165264329909476 0 0, -2.2447605425648476 48.166961338406722 0 0, -2.22665354462859 48.179474421806887 0 0, -2.2266994858398448 48.223426431427768 0 0, -2.2130994791463934 48.238304343078184 0 0, -2.1944825513670878 48.248111295513027 0 0, -2.1839085039181612 48.279201350160079 0 0, -2.1455854368067264 48.29338028652343 0 0, -2.1047204653587244 48.315994275702522 0 0, -2.08452446245974 48.317669281703971 0 0, -2.0401894333917028 48.299347363388549 0 0, -2.0190225043573946 48.295578423865365 0 0, -1.9988594171921648 48.297237412049853 0 0, -1.9417715655295638 48.321117336828181 0 0, -1.9418905436280165 48.411735403281178 0 0, -1.9497714997106672 48.455001279711048 0 0, -1.9290675004657203 48.475227394038384 0 0, -1.8903934544445651 48.487278418682777 0 0, -1.8979255199285205 48.532310317141921 0 0, -1.9343375382634065 48.534298286643846 0 0, -1.9511504374058006 48.558242282689989 0 0, -1.9939095597135577 48.548904423465942 0 0, -2.0091595775732003 48.526455364995471 0 0, -2.0411034857067003 48.527195353627533 0 0, -2.041722549113044 48.549095397754265 0 0, -2.074679489712139 48.558849375554544 0 0, -2.1147685651476991 48.584312423911783 0 0, -2.1325914668580026 48.604431330065424 0 0, -2.1480875606308416 48.609131415211507 0 0, -2.1577934776048835 48.617824337278236 0 0, -2.1826974951061797 48.5971333740631 0 0, -2.1678964862092487 48.5864332765866 0 0, -2.1726875830922268 48.579933399184611 0 0, -2.1902925720839903 48.577335344478726 0 0, -2.20049451332369 48.6120302880402 0 0, -2.2025914391848858 48.59092743027368 0 0, -2.2277904593830797 48.562137422448544 0 0, -2.22079452663933 48.589931340948418 0 0, -2.2331914542451443 48.593830351561579 0 0, -2.2354904510279141 48.61022942776269 0 0, -2.2513915702334506 48.616031385709249 0 0, -2.247591484755989 48.624733301954869 0 0, -2.259485504103778 48.634731408889273 0 0, -2.2515915142659875 48.643329275237846 0 0, -2.2785894678910097 48.642330365077484 0 0, -2.28018244858805 48.636222296219174 0 0, -2.3188864229070418 48.612629283986266 0 0, -2.3261805142998071 48.618934319187119 0 0, -2.3436325399586808 48.622162360774446 0 0, -2.3237774897168322 48.629135380327014 0 0, -2.3124784100598434 48.639633387130395 0 0, -2.3148775854891288 48.644031427508075 0 0, -2.2890795538159239 48.665329309923393 0 0, -2.2891765240689304 48.66822834949776 0 0, -2.3135804597660106 48.670627333755469 0 0, -2.3131754669094446 48.680427425194445 0 0, -2.3222744552226686 48.689628338242 0 0, -2.330975474207861 48.674732296535055 0 0, -2.362373563796325 48.658130269312565 0 0, -2.3752765314223439 48.65892834384077 0 0, -2.4028785744127958 48.644428347058479 0 0, -2.4172724195984983 48.644535364733933 0 0, -2.4154764882282875 48.638527274344767 0 0, -2.4255724918118382 48.63633337581966 0 0, -2.423168590019678 48.648929348310389 0 0, -2.4396725560750383 48.652931343581329 0 0, -2.4931685386216422 48.6484333194637 0 0, -2.4716645518585367 48.636734329651091 0 0, -2.4797674522424407 48.633937391466333 0 0, -2.4781754973804984 48.627830372591809 0 0, -2.5213664148778889 48.604435378524656 0 0, -2.5652634892151389 48.6020312869131 0 0, -2.5614625209054007 48.596336358555114 0 0, -2.5783574621444267 48.58883243496873 0 0, -2.5759695608173518 48.581737432318732 0 0, -2.6395604780188648 48.545139356381995 0 0, -2.6401665147635924 48.526142401494994 0 0, -2.6450635662522473 48.523140380965927 0 0, -2.6622554363825657 48.525840351232446 0 0, -2.6668555421876761 48.533634339330106 0 0, -2.6870504942284845 48.534542432519615 0 0, -2.6853534744285743 48.514835397236077 0 0, -2.6944584652779326 48.496746363005755 0 0, -2.7066515443789854 48.515640346212351 0 0, -2.7198574596394645 48.520137301315266 0 0, -2.7200545893710357 48.530334318330283 0 0, -2.7350504278543024 48.530239453945683 0 0, -2.7241494939137 48.537143309164271 0 0, -2.7324564062240189 48.547943347358611 0 0, -2.72074952241813 48.553039317990333 0 0, -2.7791444874917204 48.570633384253355 0 0, -2.7839494805378706 48.582733348792104 0 0, -2.8230514360011796 48.5929333538122 0 0, -2.8328404343994293 48.646835420100686 0 0, -2.857137526498434 48.664932384898876 0 0, -2.8915434452748627 48.673324312822828 0 0, -2.894937462269354 48.694435443527752 0 0, -2.9298325405327432 48.702728272210564 0 0, -2.9383385293950255 48.715625431177685 0 0, -2.9521295224428008 48.720829289427051 0 0, -2.9404315886810677 48.728325270205012 0 0, -2.9433385325226604 48.7422333028504 0 0, -2.9333314579644627 48.751823417215633 0 0, -2.9553325588561656 48.760227296902329 0 0, -2.9542285717937453 48.768028331132513 0 0, -2.9673304260411157 48.7593343572248 0 0, -2.9884364521670079 48.7599254322724 0 0, -3.0142295379615121 48.765522339147921 0 0, -3.0284244785526466 48.774429309604372 0 0, -3.0161324904970965 48.78172638821308 0 0, -3.0493284504137415 48.785431441513907 0 0, -3.0071326033857741 48.801921320751568 0 0, -3.0160275832798003 48.80922740462389 0 0, -3.0138225977918842 48.818424448693357 0 0, -3.0294255176914078 48.82042331874645 0 0, -3.050423467557863 48.815925304521912 0 0, -3.0637205438889339 48.822227347383333 0 0, -3.0844984560993707 48.81806130329214 0 0, -3.0826215790466058 48.825821331028045 0 0, -3.0997275375326749 48.8322222834569 0 0, -3.0871255618764724 48.843929366338259 0 0, -3.0957214926018977 48.8584173997361 0 0, -3.0786234334205451 48.858925401991506 0 0, -3.0966184955811773 48.866222314119717 0 0, -3.0760234594490612 48.873619368949235 0 0, -3.0705284484957369 48.883617291032927 0 0, -3.10491942521341 48.8648224190823 0 0, -3.1299135563798473 48.863716309612656 0 0, -3.1363234994807669 48.856926339404041 0 0, -3.1671125599850711 48.851219420049418 0 0, -3.175419470265183 48.842521393403686 0 0, -3.1899175308278416 48.838424352662869 0 0, -3.2028685519047144 48.832504273128805 0 0, -3.2089114933754388 48.837223368431282 0 0, -3.2238184358386461 48.835621421611009 0 0, -3.2156185430942776 48.848625415828295 0 0, -3.2279095043822394 48.868019293714283 0 0, -3.2431125249108277 48.867622368689794 0 0, -3.2719104475538074 48.836727344165624 0 0, -3.2883065314154862 48.842922366887407 0 0, -3.2982134631913027 48.83262643098557 0 0, -3.3304124436274662 48.838424352662869 0 0, -3.3597014619770675 48.822124375702927 0 0, -3.3996014784927571 48.817627408809486 0 0, -3.3980035826256487 48.8053202722402 0 0, -3.4122974601139617 48.80272627131221 0 0, -3.4509025152886812 48.800930326263746 0 0, -3.4374044376976243 48.820526281473974 0 0, -3.4630934780732048 48.8200223452627 0 0, -3.4857914287763379 48.839927387157033 0 0, -3.4914904272324634 48.84012628971918 0 0, -3.499399532388253 48.83162734165559 0 0, -3.5079905350339144 48.834526379052129 0 0, -3.5073885530331186 48.829425330581017 0 0, -3.5180974293521388 48.839920346358369 0 0, -3.5267975682374981 48.837822364377374 0 0, -3.5305964176001683 48.831726428923886 0 0, -3.5258894709511015 48.824428313215058 0 0, -3.546990578797022 48.829525311215363 0 0, -3.5545895367718003 48.821228434073319 0 0, -3.5547905432070181 48.817230326631517 0 0, -3.5446915918503241 48.815223334169765 0 0, -3.5445984674519764 48.807029431433804 0 0, -3.563094469514283 48.797722375703884 0 0, -3.5761875387041187 48.8010253903757 0 0, -3.5773885229357347 48.797329323118632 0 0, -3.59369344865996 48.794532366471195 0 0, -3.5895854813221648 48.78922642472007 0 0, -3.594791443571018 48.785125333311925 0 0, -3.5904905603444517 48.770027401885848 0 0, -3.5948835052467252 48.764930379172505 0 0, -3.5775844331584494 48.765430280705445 0 0, -3.5616915980232458 48.752533294083612 0 0, -3.5624914077082694 48.739330384374242 0 0, -3.5485895441729269 48.739433363789729 0 0, -3.5406964497475628 48.733230418314868 0 0, -3.5441985500880264 48.728630314364338 0 0, -3.5678855569830716 48.731136310627718 0 0, -3.5779875188817982 48.724731296085864 0 0, -3.5877914789772092 48.727031348988433 0 0, -3.5871905647348585 48.691940349230464 0 0, -3.57599057631938 48.682438285698922 0 0, -3.5833874594148085 48.6735343046429 0 0, -3.6020904609577258 48.669437439922078 0 0, -3.6131835912879353 48.67313333115915 0 0, -3.62088851328258 48.682937291254561 0 0, -3.6412834187437113 48.685138420935928 0 0, -3.6405895480356776 48.670135359089343 0 0, -3.64296141675414 48.662799381438425 0 0)))'),
('Creuse', '23', 'POLYGON ((2.5476775274335068 46.127346346175912, 2.5534335563587831 46.149505323741565, 2.5349704700302311 46.17875632177838, 2.5089615837568147 46.204940347918509, 2.4506104367944772 46.240535281568796, 2.4245274461151212 46.2666853358554, 2.3840865067664936 46.278453326737278, 2.3798375607945843 46.322063329563193, 2.3597434734562341 46.326580353944124, 2.3211305014599191 46.319259331496468, 2.3007514377957534 46.326492343960851, 2.2993994284329062 46.34012931484726, 2.3162765748630818 46.368316272186448, 2.286140548434588 46.389557305626695, 2.2223644661039827 46.40209538386209, 2.1568994721945955 46.4262583487466, 2.145974440932406 46.417514380889585, 2.0477185114394558 46.415378378595832, 1.9878074755337707 46.423298396989551, 1.9264324815665361 46.444816309837123, 1.906525503452599 46.446529336151329, 1.8648694982750555 46.430679442245761, 1.8248004891156597 46.436844365553284, 1.7838255051885881 46.451118352698543, 1.7654205054489864 46.439209369823473, 1.7409704519990896 46.41053043667786, 1.7210705146838166 46.412208435018712, 1.7002934698753336 46.422054287866175, 1.6807015675014725 46.421009433344878, 1.6623305396154251 46.409092353551372, 1.643048432382642 46.4053153171097, 1.6020584867584091 46.419536322245037, 1.5830685726700437 46.413040305380505, 1.5650224776422021 46.398361296292265, 1.5457495234476539 46.394584435870584, 1.5056734734896224 46.400608367184915, 1.4870304947552881 46.391349364905849, 1.4549274452008945 46.362194297750776, 1.4359655182871904 46.355671349831354, 1.402804588734 46.370254428037853, 1.4228235155466393 46.333019340339504, 1.4206544214991936 46.283588357220637, 1.4143974397491945 46.26953932359261, 1.3823904970965089 46.24033743512642, 1.3761495331634421 46.226284353039162, 1.3855324534989393 46.213112426904289, 1.4066015154318734 46.200588430266194, 1.4648234637387816 46.206566420369242, 1.4855605520148458 46.1967432740975, 1.5127744709791102 46.129753419218119, 1.5134935125423397 46.088691305407636, 1.5321174811203093 46.062320346063061, 1.5492144764886859 46.049553441871169, 1.541602493036379 45.977901346138495, 1.5230955777361714 45.968666282574887, 1.5090914291995716 45.954193392867452, 1.5067415626464822 45.940357343398873, 1.5121494240779896 45.926944269909896, 1.5330965041740967 45.914394398336711, 1.5904195185119931 45.925766344293905, 1.5958155866057382 45.912357319264132, 1.5755664256768682 45.883838388268074, 1.5848324687545698 45.870659421334565, 1.6454144927726304 45.852020315039468, 1.6651125351863243 45.850341436598782, 1.7035975406669479 45.855167376020958, 1.7579604272278004 45.89367632021704, 1.7856365746241636 45.854057394112047, 1.824931447970755 45.815025318575451, 1.8648474957792303 45.8061753866986, 1.8817874813374544 45.793365357614917, 1.887118422043585 45.779937322428751, 1.8828214226208217 45.746833423344711, 1.8687315523605434 45.72193539908001, 1.9288404347085759 45.716358382460683, 1.9860384748702131 45.727535298294967, 2.03631558596814 45.768459412451719, 2.0548415114247405 45.77761033847132, 2.105503578189456 45.739078335659613, 2.1447764490402506 45.735576418425651, 2.1577845005862741 45.72252629810761, 2.1782144340207594 45.712585394478239, 2.197581558897383 45.713546287475495, 2.2580634275545037 45.691890374974193, 2.33334241469737 45.717464315910334, 2.3436225088022127 45.73165539765138, 2.3487045572756813 45.759285427816494, 2.4280545342043069 45.743900402642524, 2.4613654327689858 45.761909357457441, 2.4017724649428374 45.854934325585262, 2.4121014925983957 45.869102348710683, 2.4346075815380175 45.878387401944778, 2.511243506602824 45.892933339938324, 2.5086484442363712 45.92019232001401, 2.5254995397114897 45.948360267196833, 2.5815305674950935 45.97559742079666, 2.5916684374670069 45.992496393702694, 2.5969015110717351 46.020099316792951, 2.5697224440608579 46.059909400581589, 2.5476775274335068 46.127346346175912))'),
('Deux-Svres', '79', 'POLYGON ((0.180357538548094 46.117347355957591, 0.19552957956256023 46.178745408540451, 0.18200649359448562 46.191543292246465, 0.14453254680157102 46.178070371968843, 0.12355554331111307 46.187652370886482, 0.11388553441022964 46.200733294698651, 0.0738054359929663 46.206264370106695, 0.098965553987824251 46.2518693832332, 0.097061546009939548 46.26545337210969, 0.11506944470508529 46.277641346631682, 0.12100448593631086 46.291763428545849, 0.12707154214243133 46.333313293683588, 0.08852950619262856 46.355434426956421, 0.05212752099583895 46.333774289975921, 0.03109243091645908 46.34334132719637, 0.033095538135484048 46.357196386821315, 0.0058444789582949852 46.382801307271578, -0.021373488465201262 46.435833306865575, -0.021667441809285037 46.465999432708358, -0.039237578847661325 46.478511283968757, -0.041162533201571705 46.492103369763711, -0.021899436125153215 46.523601438693177, -0.002316510769588831 46.524929333320628, 0.016142527099731296 46.534408360557833, 0.023687446944791191 46.565082304004036, 0.010012455745595616 46.577884412189221, -0.02690350775344541 46.55893727095274, -0.032732584964833222 46.572250365100743, -0.015435454894543454 46.589897422864496, 0.0030334400929064032 46.5993732817423, 0.02302754809028329 46.597973394948568, 0.042262481972045407 46.602001435862476, 0.052112559298677752 46.616398284944367, 0.042370558231482391 46.6294674154188, -0.020821489850163744 46.627941322309042, -0.030527582844200651 46.668445276805684, -0.020578582296366221 46.710266388711844, -0.006774568461707986 46.7249073774873, 0.031018502530514525 46.738422366536909, 0.040906424149937948 46.752811294720331, 0.023252501607515796 46.76533141891916, -0.01765154627304355 46.773574433951453, -0.017965565893348412 46.803711340479779, -0.00019547017299714753 46.818615303085224, 0.0018164380443863593 46.832489372866561, -0.0009724223052103298 46.936523333780613, -0.036288540328541785 47.016441327141209, -0.056065439687216667 47.015113432513758, -0.0773914907712765 47.024635408622785, -0.086700482720829086 47.117279293523083, -0.13266950513809661 47.075767272678164, -0.15323743822631286 47.079845303262559, -0.18726544213461693 47.121399392879496, -0.22804750817837771 47.126850379202793, -0.33137650912649974 47.122444423420731, -0.36974446132938965 47.1115343538557, -0.40687745744716608 47.092468399141794, -0.42665048436657571 47.091087346484457, -0.44805345617601233 47.1005362743074, -0.45014052491907819 47.11413540090102, -0.55215553681711071 47.101390323184958, -0.55386750701151755 47.060100439537777, -0.60420851335726411 47.0235553501082, -0.64598650037163452 47.00954838525216, -0.74596548931688744 47.010509278249415, -0.78374553483158138 46.996757366324843, -0.797717471714293 47.009452278350423, -0.81788742365822031 47.010708356831529, -0.85650849257297068 47.002361313999032, -0.87795758161362869 47.011741418015063, -0.920381561905117 47.052524364158657, -0.97261143851164888 47.054103439278336, -0.95686258006688263 47.030567281494612, -0.9209564431157844 47.005806376783838, -0.89477945777431955 46.9665563885287, -0.85542156927971291 46.944774269711374, -0.79203044261589639 46.9220013345025, -0.78594455227334947 46.90872942902665, -0.78705541428209358 46.864719332816819, -0.77707455412033255 46.851719378189259, -0.73558541587104287 46.84104535139933, -0.7138135062117783 46.82891440734646, -0.70777144484091536 46.815628420273313, -0.71931342608576188 46.787326345876, -0.70683044209988566 46.758037327526395, -0.67908951935584128 46.732608427042649, -0.668900427573675 46.692176288692352, -0.61556444149752565 46.654873433306889, -0.60318354909222194 46.625545338524731, -0.6223524754865366 46.569252393030936, -0.62933747581806188 46.511093283852077, -0.62520646322371931 46.483925306099067, -0.6147065201806754 46.44075429706966, -0.57190849746032768 46.419151366578276, -0.55959854110153628 46.389831368714553, -0.56927048622205234 46.375400371759142, -0.58713756894394464 46.36311734645524, -0.66498257515880255 46.329963281680719, -0.68448945988885157 46.328537343931927, -0.72557058385572759 46.339222283959785, -0.7631605278066047 46.333694376911112, -0.74828455237582148 46.307323417566536, -0.77181050100148241 46.280853358980821, -0.6990864436726838 46.217575413155473, -0.64617255347624791 46.180278366428908, -0.64901650807536271 46.147117436875718, -0.63529047108588088 46.134403338673778, -0.61502141990078485 46.130371425320575, -0.59642755073713261 46.13724535705326, -0.557941489136681 46.142791394158465, -0.537274456807296 46.136074296215966, -0.51378441625479354 46.110302332817483, -0.49352645432762188 46.106277284242978, -0.45546741716597694 46.114505337578109, -0.43522758529533689 46.110485393582664, -0.43511053201760319 46.083023286465604, -0.4156835603523632 46.084427397738565, -0.3792215523469622 46.103496344791878, -0.33566946009003118 46.101101417127367, -0.29797443221914932 46.11201430301189, -0.2493084318748231 46.074245346755063, -0.20929451696497381 46.06881337058816, -0.19570243117001951 46.056049282715733, -0.16463842747799617 46.003322325723744, -0.083172514531781871 45.981506411072857, -0.050158561650619049 45.997497296971588, -0.044291464126473556 46.011627299784223, -0.059760450824484224 46.038005299927462, -0.034414455744951056 46.080921432045344, 0.023902543343865545 46.084880297112434, 0.044091505444185941 46.080776391592948, 0.098653470587180436 46.111892321175091, 0.11772347376032144 46.115909272831104, 0.13904142792591756 46.103618326628705, 0.15924042316430587 46.099491362493595, 0.180357538548094 46.117347355957591))'),
('Dordogne', '24', 'POLYGON ((0.29143652260225394 44.796367320851445, 0.34417157651273556 44.744999414020967, 0.30773949190165695 44.701389411195052, 0.32067643138120161 44.661075382242259, 0.34141457577706547 44.648758385084804, 0.39865855714998588 44.649807288065333, 0.42070646611674078 44.656753387984267, 0.473799544639121 44.6904483621159, 0.49208045030229641 44.697132368304679, 0.51071850047759426 44.701107427208669, 0.56837155225269953 44.699367293819634, 0.58598041368369991 44.711475355276818, 0.60600444507539919 44.704525382918618, 0.64329550712309924 44.712410373339011, 0.6694885102815249 44.686660412436325, 0.68983553831176891 44.676979314277546, 0.78172447357565034 44.707485334675667, 0.84070858833760553 44.694721422823207, 0.85161056098419863 44.667968324131309, 0.85063241803021583 44.613052382835647, 0.87025054737910068 44.608768408890413, 0.92321249102639058 44.644973427744659, 0.96018953345384261 44.655475307007336, 0.97950754875978419 44.653915418064017, 1.036847461014446 44.621742312562915, 1.0915474258112 44.599861270524414, 1.1956134223591732 44.702587403087207, 1.291011491675647 44.738350435805515, 1.3399485627684271 44.779594378241441, 1.3547634592708278 44.851741266100007, 1.3684724223235492 44.86624531134153, 1.4053625108874996 44.879333275952362, 1.4232135757924596 44.891304393875586, 1.4163405241596365 44.918316417938243, 1.4270245840876612 44.960060433099059, 1.4086994974128686 44.986431392443635, 1.4018044432842203 45.013458378203453, 1.4079005427848017 45.02752342964844, 1.4222884148484241 45.036571383987635, 1.4100395374179868 45.076988384620833, 1.3878384910803732 45.103126293529741, 1.3862865230355226 45.116752351178221, 1.3985405050449629 45.144859395452627, 1.358066473942614 45.161739358202269, 1.3194385402491662 45.162273402780684, 1.282696484477043 45.146419284395947, 1.2635594176966833 45.1453173994055, 1.2505064810591762 45.1582684204824, 1.2802784981969353 45.201133330790029, 1.271039562194062 45.214294343686973, 1.2515585523991035 45.215908270760011, 1.249966451801896 45.229530279949287, 1.3046745135171136 45.257370301934444, 1.2916055590626456 45.270313402112848, 1.2510215154812272 45.2871664338076, 1.2456134780297816 45.300552400221747, 1.2693395613573841 45.329353315204187, 1.3011134535743736 45.355869315001186, 1.3033795346233887 45.369701316010506, 1.2979625201536464 45.383110341040279, 1.2579315313070367 45.394493376255369, 1.2524995551401332 45.40789835282591, 1.254767572408781 45.421734402294462, 1.24069442404533 45.442855390117515, 1.1813795677662711 45.453098344009433, 1.1406304174562365 45.46989029677583, 1.121687500698954 45.466045316627074, 1.1046765790942175 45.478740404672649, 1.0953535055473367 45.491901417569565, 1.1274215271284049 45.548633356859867, 1.1254884758560308 45.564960440894666, 1.1161405834938876 45.578140287928036, 1.0962274446811193 45.5824393995904, 1.0579645763982342 45.577434271842307, 1.0392554141564858 45.603733415040537, 1.0089574493587747 45.629345376289464, 0.93141449340649274 45.62739929953959, 0.87418952218996537 45.618450268421569, 0.86429244753225021 45.604118370707326, 0.84633348238781991 45.592052378022132, 0.805742574027704 45.606014281766747, 0.78644251275832744 45.604828435252287, 0.76613051270143728 45.611801290206117, 0.7468434769095893 45.6105883366168, 0.73742957705997014 45.623722418458883, 0.75113554777328773 45.638301272186155, 0.753289504103634 45.652153339471667, 0.7322734241806188 45.664543384915234, 0.71229058146110447 45.668792330887143, 0.68567143396373353 45.694557429506958, 0.66564757859202928 45.698795286220971, 0.61320049334679538 45.685100404765549, 0.58765154724588342 45.6691742942145, 0.53185057755851517 45.649158359741293, 0.50485844375208444 45.587062387991168, 0.46042942002193854 45.540294410945833, 0.326191488972313 45.468403280098627, 0.273222504526359 45.429218419231105, 0.26183753309163649 45.398265308117985, 0.26728447095567276 45.357448390120865, 0.26395452522899632 45.324302422264807, 0.24108847545784329 45.292587320716606, 0.19726249613299274 45.273162285271027, 0.16644456835416577 45.243644440964928, 0.14838756008839482 45.234180375424884, 0.056067551926503256 45.230621427721744, 0.057187566973482262 45.222454277295057, 0.020762523161067747 45.206222420062133, 0.0035004210641034206 45.191303319739561, -0.00042852060866493957 45.1635852795912, -0.0364064737061085 45.144607334860567, 0.041933500654607769 45.136295320001395, 0.060934504000869083 45.110157411092487, 0.0384224303823828 45.020740324218522, 0.029585523983058692 45.000904282151069, 0.011625502718828784 44.991428423273263, 0.0058624329948884224 44.977295428121195, 0.0039105475861163086 44.963443360835683, 0.022883563757659431 44.937297355008312, 0.024740574404489735 44.923687315176764, 0.0094055389010350154 44.895168384180707, 0.011250580190107939 44.881576298385752, 0.024521429546183526 44.868759404523374, 0.045050462221809084 44.859188318843664, 0.083463475536120768 44.85910030886042, 0.12299157533837501 44.8508374035719, 0.17934947219981723 44.860176318915777, 0.2152434637732199 44.8790854398395, 0.25223652401760432 44.889801359381451, 0.29103854145796504 44.886921320689211, 0.3111555113919735 44.880046332836756, 0.28785856474274851 44.823589336734145, 0.28585352130409092 44.809719315412067, 0.29143652260225394 44.796367320851445))'),
('Doubs', '25', 'POLYGON ((6.9479615941146733 47.436142279199359, 6.9382854245149588 47.451568317025519, 6.9616225037165407 47.492698374543082, 6.9411284990142406 47.519798408589011, 6.9209034528207951 47.53054037908602, 6.8363244507466447 47.551612433358358, 6.8206055156962009 47.535095423779708, 6.7805755829693908 47.531986383111004, 6.7402795080531916 47.542507272530045, 6.6996565640591825 47.566639433920429, 6.6794885483348878 47.571888349322151, 6.6596674679645957 47.560756318579323, 6.676317548637968 47.533661389112424, 6.664600427526409 47.519882370113024, 6.6242895669330153 47.530361366780042, 6.60443645092883 47.521949372579925, 6.6048324958535147 47.505577403453643, 6.5891035276649745 47.491764412600716, 6.4690394283996682 47.487610341390777, 6.4402874469679148 47.514537347809593, 6.4203415684413869 47.51157035525388, 6.4006035694953027 47.500385342501133, 6.3209545346435618 47.482952325016655, 6.28212453002854 47.441497334640886, 6.26236452858663 47.433033414550621, 6.2547675068314845 47.419265308789122, 6.2111824988407989 47.404995370103094, 6.1759825539953965 47.379921325871877, 6.1165495883188044 47.362644438097718, 6.0536294910854167 47.33164239343391, 6.01388154234499 47.325538373034831, 5.993846421695423 47.327953366975507, 5.973963558316882 47.324894315977318, 5.8912165720543328 47.29346841523413, 5.8317774456789095 47.281509442688574, 5.7530634288893054 47.252796361669439, 5.7634464946745823 47.190181307038031, 5.8038724723260771 47.174537356493332, 5.8163265890374589 47.1611133697664, 5.8143835046270169 47.106472371658427, 5.8188725418332581 47.092907392938329, 5.81145048392483 47.0791243254797, 5.7918775917073617 47.070568346946928, 5.7764865818545275 47.056644287495104, 5.7656425197769181 47.029144336085253, 5.7701125468267946 47.015564395667994, 5.8094255502299461 47.02720230779461, 5.8257885423379037 47.013843272435324, 5.8661925174935732 46.995433344136657, 5.9062544858543049 46.985210280500965, 5.9500894421974522 46.980487312759195, 5.9702175013893282 46.972644391110819, 5.9786215746909761 46.959133274500473, 5.9676474338581329 46.931640363889287, 5.9879545053559866 46.918335366659718, 5.9923805274142126 46.904750321663428, 5.985373524586862 46.877323418539689, 6.005453530327884 46.869457438275688, 6.0305705234309528 46.828903318088592, 6.090191478431791 46.821674354083441, 6.1505404520141553 46.789821428901476, 6.1598274414679111 46.746261415746048, 6.1523235342750411 46.732505279342277, 6.1132634715637835 46.718250302353411, 6.0550265615597141 46.687278357103864, 6.0805594898436652 46.630336425993519, 6.0770644373883727 46.616623414481566, 6.0617345064639494 46.602722413645367, 6.1232034950933212 46.56901934259524, 6.1240235721173519 46.581218406375157, 6.2663145926553909 46.671714319623945, 6.2932125557797178 46.695915304821241, 6.3328075431692525 46.706817277467806, 6.3756995605517375 46.727508424532616, 6.4061004970298541 46.753708292469739, 6.4457025252180529 46.763206329863337, 6.4656925847561979 46.779407383602077, 6.4651004535888035 46.7859072729059, 6.4424014467658708 46.8063012982672, 6.4508044639477191 46.832103361079973, 6.4731035534067018 46.856506417198815, 6.4773935120308295 46.883796376788624, 6.4735935929935238 46.8980024202268, 6.4459024839000278 46.915695419201811, 6.4538004997979215 46.933200428852572, 6.5025015281155731 46.9725993299994, 6.5180965451096142 46.97139728964801, 6.6008885924836136 46.993591295186988, 6.6352834220021464 46.996597364175287, 6.6429865837970965 46.999393441343486, 6.620628527649302 47.001217360236623, 6.6491465785455262 47.033352269404944, 6.7200555179795458 47.061248441759446, 6.71934052487552 47.067009399243787, 6.7051165274007474 47.074211432194048, 6.7076394215809216 47.078354414146119, 6.74562558647645 47.090408437473585, 6.759844479372191 47.116687338375655, 6.7805405549960369 47.12064338712328, 6.812037567805703 47.130546270439865, 6.8269784946041341 47.147648370387273, 6.85307451076099 47.160247351531112, 6.8545074893084745 47.178241344648868, 6.8788114461861483 47.1899454402829, 6.90922452804196 47.214958405585733, 6.9484664193786614 47.231701424801443, 6.96016646655346 47.245559300745825, 6.9578245208988676 47.288402384577623, 6.99472745892038 47.294155421163467, 7.0082084761164651 47.296135293746929, 7.00875449005261 47.326370419416563, 7.0427634838045492 47.335014407932604, 7.0483535259013763 47.340416284685219, 7.0532014678193491 47.355533407470134, 7.0433124900801261 47.373356309180437, 7.0352025461425285 47.377136337961545, 7.0123445932898392 47.377132289502313, 6.9387425483680261 47.360935284222776, 6.8858314744910274 47.359489280197792, 6.8872665652781109 47.379112338105713, 6.9272285542978409 47.411510397124019, 6.9407305178699232 47.4318503843556, 6.9479615941146733 47.436142279199359))'),
('Drme', '26', 'POLYGON ((5.8037575312879426 44.717132284960954, 5.7553615455722422 44.70617328184521, 5.736211453314354 44.708538286115427, 5.6973765201402671 44.726913362460706, 5.6781924560288246 44.729267277473028, 5.6592345775743809 44.72615841282429, 5.553449570033365 44.795070405738088, 5.5393755415700809 44.764690415636, 5.4774374597299129 44.785236346228416, 5.4839394612733088 44.8127403460975, 5.47077756827656 44.853447427635516, 5.5142844234020743 45.097732337675595, 5.4949794335736613 45.100036439037396, 5.4615965428426705 45.071987305331973, 5.4426594347442574 45.0661013736714, 5.38536757594045 45.059364385472705, 5.3469225269922163 45.0612483271744, 5.2900085830565331 45.046268323943409, 5.2512945755994451 45.053577377033307, 5.2121855793375005 45.069034394373588, 5.1928765410498272 45.071315437119765, 5.1738355811711756 45.068126307366285, 5.1542795868705014 45.075847423197828, 5.1498014629021895 45.089409409578522, 5.1561804264889872 45.116924322685506, 5.1772804679360149 45.158424374172725, 5.1790565093982366 45.20222835100175, 5.1899324310897725 45.21615628289284, 5.2089214650783049 45.2220842833254, 5.21212749274855 45.235832322810708, 5.19994145444619 45.249214416785591, 5.1413215249949644 45.266941387614153, 5.1515695834659141 45.294532341346709, 5.1393675273465931 45.307888384366535, 5.1202545753016295 45.304695382173819, 5.1054884363299493 45.290668351041589, 5.0862564947876194 45.290176375235163, 5.0695194602508025 45.317104437773779, 5.049710525258206 45.327552278906737, 5.0112075657409889 45.326584345110817, 4.9915285334837165 45.334266384509775, 4.9754304514253533 45.347549379243517, 4.861851455786649 45.306270408834266, 4.8042645875189578 45.301960383933974, 4.7694534707796095 45.303764412570885, 4.7898964296915949 45.282451386964354, 4.7944854462388378 45.268898377601957, 4.7965184768521567 45.159572376394394, 4.7902884261570478 45.13205341482815, 4.7917775550738213 45.104736348163513, 4.8239195050408341 45.078270338037029, 4.8330304745280444 45.0511623830926, 4.8244435164811819 44.996238344878478, 4.8648964251875384 44.956310327712274, 4.8701395319303629 44.929119291343667, 4.8385904172106109 44.873558412890659, 4.7482574984508119 44.775344376149732, 4.7488755045532685 44.693306398312345, 4.7389485065012593 44.665676368147231, 4.6484835727665654 44.578315370502182, 4.6416585745845964 44.564441300720873, 4.6424154604406453 44.550781271218838, 4.659142461839366 44.523918336067808, 4.6454535650628088 44.49617442098436, 4.6583714943859889 44.469185279517362, 4.6598864982378529 44.441883350569853, 4.6363755113093532 44.386493387504331, 4.6310945602737377 44.345306299517588, 4.6466754956704222 44.337555436311717, 4.6657604605406959 44.335376309126147, 4.7036255236992588 44.336467280878665, 4.7410375114639578 44.3457373724156, 4.7790525436339806 44.344074335771907, 4.7987085172756565 44.330940429949791, 4.8070055704376671 44.317482295349365, 4.8295255649546505 44.249740307153033, 4.8667604766330328 44.261703328157822, 4.8857975640724192 44.259483364340028, 4.9233315336739167 44.265960371048195, 4.9976255130841309 44.295265407214728, 5.0165404426667521 44.295761431480415, 5.0357095450810334 44.290802420963544, 5.0515295155922786 44.2775194262298, 5.0704384604960353 44.277996264319128, 5.1070905700652531 44.303543274200408, 5.1257515028361809 44.3094753230922, 5.14493943938686 44.304496422319104, 5.1455755755458767 44.290821431119937, 5.1279644258553105 44.263050408961632, 5.1399524416953284 44.24965634562902, 5.1487805470963508 44.222538357546526, 5.167803552938409 44.220268404058217, 5.2241174448082006 44.22983931371796, 5.3005854468249538 44.212520357171812, 5.3415364920365676 44.227146384250133, 5.3604545899785876 44.227581329587409, 5.3761335684966411 44.214283373156505, 5.3805175217828776 44.200687414922285, 5.3773174787914968 44.186943423896238, 5.38239055024664 44.156982361314434, 5.4015124793099005 44.151943437732783, 5.4209635657105366 44.138713425008959, 5.4447514320463881 44.111896431069212, 5.4832994526750269 44.110111412588722, 5.5198665446004327 44.121742283916674, 5.53439945711645 44.13573428707555, 5.5252025898855948 44.1765554295519, 5.5435364775587175 44.190601294820553, 5.5624174352877844 44.191005436663673, 5.5817435475122181 44.180484371224665, 5.57851850968558 44.166729290940694, 5.5828185014477754 44.15317135301926, 5.6201544485869306 44.164867351734827, 5.61154355182461 44.192024416249879, 5.6487934252001537 44.206470374902452, 5.640706539878181 44.219974274694167, 5.6391424264556633 44.260948378521405, 5.623466440277042 44.274307413880692, 5.6043464474334144 44.279377316976465, 5.58488955237388 44.292640421453982, 5.5800194319401157 44.319889368391571, 5.5611034462376949 44.319496315806319, 5.5010845100925394 44.304538315071156, 5.4239875887354 44.335651428333833, 5.4049344834790816 44.337963274574136, 5.3967895115681586 44.351448340229453, 5.4032064954677139 44.378952340098536, 5.3982464288310723 44.406173299861464, 5.4014515764014845 44.419922395466543, 5.4398295617424708 44.409839267704243, 5.45834052550191 44.421203292762939, 5.4262524376446777 44.46148634220161, 5.4359194542061289 44.502716379060175, 5.4549125366538647 44.503139355039721, 5.532430497770946 44.466545332059454, 5.5899064734597346 44.454063404193349, 5.6086624570125707 44.459942295055257, 5.6265714324865144 44.487644317386682, 5.6454515101157483 44.490768319752547, 5.6411275796381233 44.504329426033379, 5.5637435697155695 44.538276284737108, 5.6034114293712491 44.593780308740961, 5.6137594671831721 44.621345387538426, 5.61267852856875 44.6486554134044, 5.6314945349301979 44.654495403853687, 5.6700955375687556 44.641628344300855, 5.7461525329636913 44.645855287776939, 5.7834485235704562 44.668438297441938, 5.7943735548326458 44.682315359562708, 5.8037575312879426 44.717132284960954), (5.0172355455145521 44.358677304234604, 4.97383659062848 44.31653636404927, 4.9550464592021228 44.3133083338832, 4.9169145497743614 44.317749317638587, 4.8800475198260074 44.297611401328552, 4.8489264856648333 44.313175438808472, 4.8595654844814078 44.327140334892519, 4.8779335200280514 44.338581280676593, 4.8810105250628339 44.352344281859061, 4.87204547612788 44.379448364364194, 4.878202478536906 44.406959405031941, 4.8964555730453867 44.421131300596628, 4.9336825638252719 44.435802388786371, 4.9717444173063825 44.43406630385654, 5.0107574826865857 44.413223427580604, 5.0310464241279078 44.386398336722394, 5.0172355455145521 44.358677304234604))'),
('Essonne', '91', 'POLYGON ((2.431447495079027 48.3019413696352, 2.4443895391376032 48.335323380266388, 2.5329085721423894 48.3884433898436, 2.52749243777248 48.401847310294343, 2.4673085709186751 48.43196133422704, 2.461895428888198 48.445373351596245, 2.4963254624000513 48.509727307476922, 2.4906164308058294 48.525867282287308, 2.4933405158077449 48.539646301286709, 2.5128864769703512 48.548717314241529, 2.5142574964895914 48.576088419035884, 2.5251404589797914 48.590225286627216, 2.578745579584762 48.628074331968818, 2.5896475522313551 48.642200286322222, 2.5867124192895687 48.672115407692743, 2.6063444542158152 48.681160369692506, 2.6011925258156339 48.691848302059796, 2.5559724683559182 48.692608356275244, 2.5134775520179176 48.707122434654863, 2.4998625836273334 48.720157417255777, 2.4788584730620471 48.724708413490234, 2.4393845874094779 48.709285368003506, 2.4257344150255733 48.722324399063623, 2.4047524829760789 48.726833326526091, 2.3848504334211782 48.720485342453387, 2.3736224717966081 48.750011283677949, 2.3370235202572758 48.746154334171464, 2.3008565217157866 48.7384913049289, 2.28013457115685 48.74027632340939, 2.2828114828077162 48.754051293949587, 2.269105512094427 48.767070434753506, 2.2480874959517791 48.771568272958078, 2.226188499876713 48.784191368837313, 2.2022304222332423 48.7776263521459, 2.1913995616531281 48.763450408121983, 2.1715374686306461 48.757068276175787, 2.1607064320305653 48.742893388271668, 2.1408434589082503 48.736499286967742, 2.0582084213444034 48.740764426776579, 2.0597005426006376 48.727192407257789, 2.1031964844882509 48.70467734129987, 2.1128404424340772 48.6914823565494, 2.092993487128723 48.685066428769645, 2.0302664837986129 48.695724437742612, 2.0224554217641924 48.654365378248585, 2.0691434857446893 48.6019744433727, 2.0505364150835135 48.584697379578571, 2.047921462460863 48.570915368239739, 1.986817539242054 48.567951368023458, 1.9842224768756012 48.554168300564825, 1.9900774290220795 48.5380443435714, 1.9460044936841996 48.492183397413569, 1.9333495381910097 48.458767414928857, 1.9708305257825884 48.452404293139054, 1.9613015088748966 48.427349435084167, 1.982519483699491 48.420196335684594, 2.0017315349855949 48.393791404486493, 2.0133865210489716 48.361560388416436, 2.0270345811932771 48.348552336870384, 2.0484984559111297 48.338680433067893, 2.0085264337533033 48.331268408297589, 1.9981185491527356 48.314365386932323, 1.9995914842326101 48.300762387899439, 2.0180345042849694 48.29453233720433, 2.0722914268259842 48.307037323686032, 2.1337005686667396 48.304504396367761, 2.2122385654897982 48.332813335543747, 2.2325324354901568 48.33377440456097, 2.2461275136245433 48.320747342858553, 2.2475305687777052 48.307144343825669, 2.2683875266509688 48.302650378060363, 2.3278204923275609 48.319072336857133, 2.3480985205309537 48.3200073549193, 2.3657154788804178 48.307144343825669, 2.4071044617687676 48.300842300964248, 2.431447495079027 48.3019413696352))'),
('Eure', '27', 'POLYGON ((1.6241065717451306 49.1152953110455, 1.6437234689542493 49.124504323654051, 1.6798135467703617 49.170021326797283, 1.6931345618168905 49.19799037141793, 1.6937814351938414 49.228065318918041, 1.706264419179746 49.238201428690289, 1.7268184466906291 49.265232286889372, 1.7902835017403618 49.254718438268966, 1.8096655883141466 49.266616331886141, 1.8081125641494964 49.2801894075247, 1.7783414271115987 49.322384385839754, 1.7733505569808017 49.365806399341423, 1.7453975301771152 49.391712313934434, 1.7502055155626977 49.421978419118219, 1.7323954633099561 49.431999411832336, 1.6645714498092161 49.442253278962184, 1.6234855733032418 49.4374542705949, 1.5480075075782338 49.441787354110815, 1.4552875820523923 49.450641334446871, 1.4125705285166248 49.45932439939547, 1.3718454929420432 49.451725441420692, 1.3521284403719562 49.442493370196516, 1.3372605618596367 49.428054276322669, 1.2836735713112262 49.356922319591078, 1.2640114369707192 49.347683383588205, 1.2216684258638111 49.3536032871023, 1.2013715635240203 49.349769396211471, 1.1624574213650192 49.328533291330317, 1.079885574969154 49.324005353711456, 1.0562334200274961 49.281723421532959, 1.0370014784851662 49.269729421014048, 1.01601549797644 49.27129740687586, 0.9723044596897239 49.287964385466, 0.95168143235196112 49.2868044138866, 0.95226353038125922 49.314151403945559, 0.9102744954270463 49.31724143445787, 0.88607051789034585 49.34320437952006, 0.90529541863401164 49.355217390195335, 0.90762257861140938 49.3690143632313, 0.88930242049568164 49.381641331549829, 0.82588049033773814 49.388942287721264, 0.78542441327195434 49.411213390005585, 0.76439654001120516 49.41272733773765, 0.72342542852339875 49.407631383686848, 0.70128352489450663 49.417278333972106, 0.68022255988003621 49.418773271547778, 0.61446642894603087 49.412197341618437, 0.571629505813064 49.420597366460882, 0.54946753590800768 49.430198375534886, 0.51674049557226454 49.455593304165077, 0.49492141256200739 49.462497335312023, 0.43391958092377081 49.453144338370848, 0.39438954490188394 49.4380263354861, 0.33311945883468752 49.429996304613312, 0.32302946629368989 49.427333298539779, 0.31282541281436238 49.394069397306154, 0.31051743901332429 49.322834292874191, 0.33526250192710449 49.324360385983951, 0.3753624906005939 49.335014346497687, 0.39676141395079867 49.330856402848482, 0.40280048298222937 49.317546301039883, 0.38823254249288652 49.302990329908241, 0.3683604163323082 49.296314420637927, 0.35792753689651136 49.282013326417811, 0.36808652926438867 49.2689704229184, 0.43074242052801992 49.237228390315337, 0.43675948706365375 49.223915296167334, 0.43612247080480415 49.169212339031148, 0.45446955997542204 49.156643281281632, 0.4563624786954108 49.1430893918194, 0.44820553742675884 49.112518420053632, 0.45420148156640039 49.099208318245033, 0.4478765561093212 49.085151363718481, 0.45388341348692052 49.071842318029709, 0.49460756896166913 49.046959431482108, 0.49685551995415267 49.03069342637572, 0.47600947531881843 49.002086309376423, 0.44507150192282552 48.986549378971361, 0.44065744922232852 48.958912308007584, 0.4526394803834819 48.932304425788075, 0.46680345504967136 48.91948330744647, 0.50740650878748284 48.8945882755212, 0.54982855285933852 48.886196347597249, 0.60936941877542949 48.903434334958789, 0.62348146755147127 48.890609344177946, 0.64432751218683393 48.889110358143043, 0.66252744866542912 48.876499407641475, 0.65618157683232425 48.862465335710581, 0.66211943438301546 48.84912830284712, 0.72780955782960177 48.820205406027881, 0.77410351310504666 48.781879346577043, 0.78585742238962553 48.755233444044748, 0.77312449005125927 48.727123407430909, 0.78309654921469019 48.714042307598774, 0.79713642980448185 48.701175424065909, 0.84043346912991979 48.684551394347594, 0.90286247065671432 48.710022363603329, 0.94366548307650078 48.712375398515817, 0.98274349982435183 48.728263312734114, 1.0722084641292327 48.736030369776941, 1.0909125217919495 48.750736309920043, 1.1317584830835585 48.753013304206988, 1.1464084488773381 48.767490418393621, 1.1487915832040869 48.781276302171719, 1.1903234943052325 48.77811040705383, 1.2543335071713386 48.759754340864916, 1.3146324910832163 48.771225386063279, 1.3561594736253255 48.767986442659279, 1.3762634180818054 48.771785305576785, 1.3909924168405325 48.786243409607053, 1.3852525817521553 48.79961441432404, 1.3876904582885174 48.813396425662873, 1.4024215692868438 48.827850305213943, 1.440387491886213 48.854450442554921, 1.4803565217045787 48.864757291694687, 1.4907035033967304 48.881679323216318, 1.4849675407476468 48.895050327933333, 1.4413784842977293 48.914615299252304, 1.4479714881638301 48.928623320228169, 1.4756694620360236 48.938266398074163, 1.4955285627190733 48.944767343497787, 1.5020995640893489 48.958782405272288, 1.4810294460366151 49.031440279093673, 1.4815395518996013 49.06151540261375, 1.50079754439696 49.07343635484655, 1.5848745375265878 49.096920410720159, 1.6241065717451306 49.1152953110455))'),
('Eure-Et-Loir', '28', 'POLYGON ((0.79563145909071409 48.21412236803728, 0.80181556857456826 48.198051393053774, 0.8865014147683894 48.172901308197012, 0.90037249221029469 48.160015414507754, 0.89405548765168419 48.145977294117628, 0.8749075076333952 48.136650348131482, 0.85823841680365831 48.1083104294414, 0.86333049841519482 48.100395339606749, 0.92616047342573893 48.117721336951561, 0.9682484316011255 48.106472428950966, 1.0452145701231359 48.140987304086664, 1.0630865814040931 48.128303305298985, 1.0607504444083986 48.114486442006793, 1.0745715321798173 48.101589283039672, 1.1202904302246566 48.093235375428478, 1.1418294654681915 48.083496366700714, 1.1751134329780086 48.044330339969591, 1.220432413658898 48.005802385617145, 1.2321254200350324 47.976352308998159, 1.2526155522980673 47.974743310484186, 1.2757855885514289 47.984226386180623, 1.3157324398540311 47.9891743074396, 1.4183964373686138 47.978321268343691, 1.4378945211003327 47.984855305521009, 1.4564544184104591 47.999538363068481, 1.4628884762468033 48.013538287125854, 1.5463604887514748 47.987026335788116, 1.5546754959500504 48.026649310352312, 1.6036824469695432 48.02373934826575, 1.6418324864538931 48.044864384548035, 1.6809175440004083 48.057850433598261, 1.7144475874233933 48.084179324170819, 1.7756365282860429 48.081833330056995, 1.8592465404444738 48.096992345593961, 1.9382184264850082 48.117340429744004, 1.9331585565273315 48.16355130359527, 1.9848464676569222 48.1743163327079, 1.9778394648295716 48.2013133950734, 1.9829875207904877 48.228897308007291, 2.0180345042849694 48.29453233720433, 1.9995914842326101 48.300762387899439, 1.9981185491527356 48.314365386932323, 2.0085264337533033 48.331268408297589, 2.0484984559111297 48.338680433067893, 2.0270345811932771 48.348552336870384, 2.0133865210489716 48.361560388416436, 2.0017315349855949 48.393791404486493, 1.982519483699491 48.420196335684594, 1.9613015088748966 48.427349435084167, 1.9708305257825884 48.452404293139054, 1.9333495381910097 48.458767414928857, 1.9017044925894879 48.448997426687, 1.8607545034976738 48.449707315211995, 1.7967205519161098 48.473827331224655, 1.7733084882088122 48.499977385511258, 1.76209055972231 48.526756359138218, 1.7304844145334073 48.552471292067551, 1.7095084671627774 48.556881296308845, 1.6957315604029475 48.56983530972515, 1.6828854472261412 48.610183310531468, 1.6317514709311638 48.66220829989696, 1.6106685034208965 48.702114314567339, 1.6128335490091104 48.718612313989624, 1.6341844189084611 48.747036370223739, 1.6005014141345271 48.789020300598921, 1.6120875763909908 48.830597272811488, 1.5843415490679433 48.8564984348654, 1.5770555545936418 48.883438290741779, 1.5552744918961423 48.893249291635854, 1.5397544594078454 48.919757370534356, 1.5183025540477217 48.926849391005547, 1.4769915480045768 48.927425328336014, 1.4756694620360236 48.938266398074163, 1.4479714881638301 48.928623320228169, 1.4413784842977293 48.914615299252304, 1.4849675407476468 48.895050327933333, 1.4907035033967304 48.881679323216318, 1.4803565217045787 48.864757291694687, 1.440387491886213 48.854450442554921, 1.4024215692868438 48.827850305213943, 1.3876904582885174 48.813396425662873, 1.3852525817521553 48.79961441432404, 1.3909924168405325 48.786243409607053, 1.3762634180818054 48.771785305576785, 1.3561594736253255 48.767986442659279, 1.3146324910832163 48.771225386063279, 1.2543335071713386 48.759754340864916, 1.1903234943052325 48.77811040705383, 1.1487915832040869 48.781276302171719, 1.1464084488773381 48.767490418393621, 1.1317584830835585 48.753013304206988, 1.0909125217919495 48.750736309920043, 1.0722084641292327 48.736030369776941, 0.98274349982435183 48.728263312734114, 0.94366548307650078 48.712375398515817, 0.90286247065671432 48.710022363603329, 0.84043346912991979 48.684551394347594, 0.84168250681238987 48.643592428237454, 0.8813575832866718 48.591186355644439, 0.90312350826707188 48.581520395202787, 0.91710741450751243 48.568626404595065, 0.91479046368817762 48.554828375439271, 0.95827144387862973 48.535431327168354, 0.96582551676192452 48.508518402346866, 0.93680158448191264 48.47949939862589, 0.9487654855865344 48.450084349980287, 0.93601653543123575 48.422020430597669, 0.90474447613877373 48.379181395225132, 0.86666554872093116 48.357807290690218, 0.80585857118563808 48.354274393942134, 0.78736943390205738 48.339504382531189, 0.80713154758353767 48.313301346234695, 0.78640554856536937 48.284717287851024, 0.7885225407027292 48.268436321047446, 0.804223521716608 48.241989321077355, 0.79563145909071409 48.21412236803728))'),
('Finistre', '29', 'MULTIPOLYGON (((-4.0409575110300784 48.745834330884335 0 0, -4.0389605765705028 48.741832339913472 0 0, -3.9908594429515549 48.737339428581024 0 0, -3.9926664452750629 48.746437374277647 0 0, -4.0248645456113934 48.752334395196115 0 0, -4.0409575110300784 48.745834330884335 0 0)), ((-4.8000175513854053 48.415863404607009 0 0, -4.7925164868936179 48.408661395238411 0 0, -4.7841175163769858 48.407863324963479 0 0, -4.7840135220087348 48.395366424197732 0 0, -4.7660184134881636 48.374164306295654 0 0, -4.7693094864472982 48.369865362476915 0 0, -4.79221654887067 48.368560350445122 0 0, -4.7929174891344157 48.362568272718079 0 0, -4.7614125466982955 48.364963396385349 0 0, -4.7825074914838428 48.357566318776904 0 0, -4.7755094377281466 48.330864442474407 0 0, -4.7379124529786338 48.334262331908164 0 0, -4.7174145758370685 48.331264359838357 0 0, -4.7053225321968171 48.337162436876596 0 0, -4.7028184721530693 48.350868407589914 0 0, -4.6865144467338666 48.35496139987147 0 0, -4.6389244564448973 48.344467441507291 0 0, -4.6295274545121 48.338363421108184 0 0, -4.6104264718248658 48.336868307512546 0 0, -4.55773049434697 48.352859369431243 0 0, -4.5516324586267274 48.359462406435441 0 0, -4.5365255449998756 48.356361286665233 0 0, -4.5286305214414142 48.362262356042933 0 0, -4.5015364720743776 48.36365537805797 0 0, -4.4770355488541327 48.381961278556432 0 0, -4.4594404169804989 48.38446428248038 0 0, -4.4461304911918944 48.380760294324844 0 0, -4.4315364997474944 48.393455382370391 0 0, -4.4108395384088093 48.387859354491688 0 0, -4.4127264780649114 48.383449351353406 0 0, -4.4476384542450944 48.354263304684238 0 0, -4.4496334835837636 48.34865936550586 0 0, -4.4408235228533126 48.341522280695749 0 0, -4.4540404825336 48.337665326368018 0 0, -4.4524705543661014 48.325351321102929 0 0, -4.4101905584072085 48.335708335933148 0 0, -4.3983915880112363 48.32599238582101 0 0, -4.378162493358559 48.329498351514232 0 0, -4.3566415881715557 48.346420383035863 0 0, -4.3258724179234775 48.3556674159572 0 0, -4.3237015636763374 48.342399382920618 0 0, -4.2829175553956169 48.351127334697381 0 0, -4.317035511524125 48.333385400434949 0 0, -4.3310595545648081 48.317428309271421 0 0, -4.2973475022485559 48.312400300026056 0 0, -4.2610134607588179 48.309063313500715 0 0, -4.2373995021499127 48.310020334058706 0 0, -4.23379549333535 48.301067430501419 0 0, -4.20127352445905 48.293831424513087 0 0, -4.241497422990534 48.288017310183406 0 0, -4.2653414396957032 48.281971376373249 0 0, -4.2760165226054312 48.290786280276777 0 0, -4.3117915246814675 48.2941743125924 0 0, -4.339745431584987 48.282570372319341 0 0, -4.3576434938210014 48.283062348125767 0 0, -4.3687454251495694 48.274864394204926 0 0, -4.39324353205032 48.272163367818607 0 0, -4.4202455380714039 48.274967356435361 0 0, -4.4199434873310883 48.290462396922258 0 0, -4.4305425149965174 48.29136239362721 0 0, -4.4543435828298641 48.291767415570163 0 0, -4.5143394603593947 48.281868404692844 0 0, -4.5211274840550555 48.2917712982627 0 0, -4.5042295800496879 48.305763309758063 0 0, -4.507832530256934 48.3101653745111 0 0, -4.53993751603096 48.286068417114038 0 0, -4.5583294927888831 48.299469329725625 0 0, -4.5481284511546844 48.3132633437899 0 0, -4.55032952857338 48.320659311711161 0 0, -4.536632551839566 48.33646029509196 0 0, -4.5404294918374148 48.341362273277852 0 0, -4.5494274565060948 48.341663443440567 0 0, -4.560524459275598 48.332763345873261 0 0, -4.5746305105673786 48.332462345097433 0 0, -4.5737224303192638 48.327163276946528 0 0, -4.5851304882311217 48.321563356688671 0 0, -4.5730315588180961 48.285366258609876 0 0, -4.58852958798937 48.277771363952056 0 0, -4.6060224522624367 48.288467393237809 0 0, -4.614723471247629 48.280971406943436 0 0, -4.6368264719045174 48.283065345079613 0 0, -4.6239205005500645 48.277668397241165 0 0, -4.6316275449263173 48.261169314542066 0 0, -4.6264324954407243 48.256370328362252 0 0, -4.6176285047751264 48.262970373027017 0 0, -4.6000284443424277 48.253669301975961 0 0, -4.5843295755681481 48.252971382808695 0 0, -4.5598235477689 48.257866322057723 0 0, -4.5483324647300707 48.2412642929714 0 0, -4.5748305015215216 48.236366370324809 0 0, -4.5687375509135677 48.2310713306138 0 0, -4.557830488779314 48.205375412898881 0 0, -4.5625314309512524 48.187873377501717 0 0, -4.5574254812412942 48.180370358588753 0 0, -4.5660365255430966 48.179577381189517 0 0, -4.5645294415738817 48.170574324239581 0 0, -4.5519285242104388 48.169178309885083 0 0, -4.54863554267672 48.181778347148722 0 0, -4.5343344484566046 48.186473327715774 0 0, -4.520034586376255 48.209571371802824 0 0, -4.5021365009249026 48.219772440405045 0 0, -4.5093355580546461 48.22557035445665 0 0, -4.4971354448513807 48.236969407652069 0 0, -4.470232553167989 48.237266353335585 0 0, -4.4451384426605784 48.2317732982403 0 0, -4.4367415861775328 48.235164322895358 0 0, -4.4348365220798769 48.228462362669987 0 0, -4.4230435363627407 48.222473283309043 0 0, -4.3826414974267038 48.213974335245453 0 0, -4.376236482884849 48.203563282285486 0 0, -4.327542495365833 48.199772340266477 0 0, -4.3131454702639758 48.192669406557386 0 0, -4.2992515044577395 48.168670298539162 0 0, -4.3052485258704678 48.163868315065024 0 0, -4.3043515127364742 48.155166416469982 0 0, -4.288246565899442 48.150974324947256 0 0, -4.2814484987723347 48.154678313102792 0 0, -4.2756495209752359 48.142074403399917 0 0, -4.2741576099769141 48.130275444363143 0 0, -4.2899465712811367 48.126075424552795 0 0, -4.2874504310435571 48.116272331387236 0 0, -4.3087534200592756 48.090480310912469 0 0, -4.3235454339660464 48.091579379583422 0 0, -4.3839514380175615 48.111374408998657 0 0, -4.4251415183437359 48.106575400631371 0 0, -4.4389425398389619 48.10057840037193 0 0, -4.467343537457424 48.1006773235931 0 0, -4.4958425781972835 48.090576417814177 0 0, -4.5445374458161325 48.09197630460794 0 0, -4.5593375566413386 48.081882439627677 0 0, -4.5862314713064336 48.084880411697483 0 0, -4.627930425355828 48.075077331701905 0 0, -4.6671304239404776 48.073578345667 0 0, -4.6759235013681462 48.077381433063707 0 0, -4.6847244996943118 48.068584307176806 0 0, -4.7248155113358763 48.070377409665767 0 0, -4.7175245799180345 48.053081353420382 0 0, -4.747918497767186 48.049083403478058 0 0, -4.7399224249763563 48.040985432545753 0 0, -4.7181205919227978 48.040378339681226 0 0, -4.6663305892126061 48.028179275901337 0 0, -4.6430334665434145 48.033382426111771 0 0, -4.6091355413903727 48.021175441433385 0 0, -4.6010324622314727 48.011482373916877 0 0, -4.5763335165489138 48.00587842624266 0 0, -4.5645275053542775 48.014782396249259 0 0, -4.552439510173258 48.017181372373 0 0, -4.550217434115865 48.025188344630166 0 0, -4.538717521643008 48.010299343721883 0 0, -4.5169274819271834 48.004341419895 0 0, -4.5035395792934025 47.998085318244833 0 0, -4.47463551661059 47.980487370051733 0 0, -4.4539475379051794 47.976684282655029 0 0, -4.4268464477394787 47.961586346046474 0 0, -4.3974454806911751 47.932788423403466 0 0, -4.3596545219385234 47.882686276152285 0 0, -4.3461504652719531 47.832191429974074 0 0, -4.3513495476757162 47.827697277675895 0 0, -4.3474554529551472 47.821491334579868 0 0, -4.3650465415730366 47.821388378930365 0 0, -4.3768555494294095 47.81200037300102 0 0, -4.3657564300980312 47.7913892960358 0 0, -4.350251535326862 47.789398334194473 0 0, -4.337455587840509 47.794792290048619 0 0, -4.3254534904031345 47.794399413483333 0 0, -4.2815634398104692 47.786792358590091 0 0, -4.2156684291229 47.789795435238958 0 0, -4.2092625354924955 47.798092323159743 0 0, -4.21946852463551 47.806892411602306 0 0, -4.20936744238125 47.802986371530196 0 0, -4.2025625104754738 47.7921944113627 0 0, -4.1852595717462577 47.79329629635312 0 0, -4.1764694866580214 47.795295355112941 0 0, -4.16396450017632 47.811596388192683 0 0, -4.1647604682570369 47.826793416454727 0 0, -4.182458584647418 47.829292385325424 0 0, -4.1787654919675976 47.836692420366361 0 0, -4.1961564423889426 47.850189298372371 0 0, -4.1860585263743246 47.875789285804004 0 0, -4.1715625780512653 47.87149439862084 0 0, -4.16056450026133 47.847286361292568 0 0, -4.1664715552701921 47.83358745231498 0 0, -4.1315664411580428 47.857391326863066 0 0, -4.1027294420824774 47.859336347493141 0 0, -4.0772655136253775 47.860393347392105 0 0, -4.0700754500328458 47.873081394639016 0 0, -4.0554825196621422 47.853183403149195 0 0, -4.07397044223904 47.852993287479229 0 0, -4.0368715716078043 47.840786307301116 0 0, -4.0322744848149927 47.8422852977526 0 0, -4.0347695491170938 47.854091324200624 0 0, -4.0229795477899017 47.848182314254487 0 0, -4.0110804220329612 47.851589356726507 0 0, -4.00348058395835 47.847591415226887 0 0, -3.9959805492047735 47.852485298356115 0 0, -3.9744844728734416 47.84969325980596 0 0, -3.9820744322076376 47.887481411695454 0 0, -3.9737765105276992 47.897190321393779 0 0, -3.9584784392172025 47.888778327193634 0 0, -3.9467805042820032 47.894390371786315 0 0, -3.9306764626437567 47.8736874197845 0 0, -3.9299855717084675 47.86348743390505 0 0, -3.8972786079329449 47.857387277337 0 0, -3.8970854912133746 47.853584367027096 0 0, -3.9125754100733574 47.850582348892232 0 0, -3.8978825096217804 47.847091342502 0 0, -3.8775845997304956 47.853984295106422 0 0, -3.8885824837707395 47.846592331058332 0 0, -3.8855894540837412 47.841186412050277 0 0, -3.8949845282688753 47.831894301221183 0 0, -3.8739885032461245 47.814792382724832 0 0, -3.855681551775048 47.816188378040444 0 0, -3.8696895545291605 47.807392318218582 0 0, -3.8570835456612258 47.799289424173324 0 0, -3.8512824556245278 47.787193332073841 0 0, -3.8100895589788877 47.790191304143647 0 0, -3.7928855434709021 47.782791424751011 0 0, -3.7816885613604256 47.785690297579706 0 0, -3.7687905222934717 47.782196301244213 0 0, -3.7268954820013676 47.794937330501014 0 0, -3.67170653373762 47.773590333040957 0 0, -3.6648994895922442 47.776992270933945 0 0, -3.6495005588409128 47.774494371589029 0 0, -3.6301045666897949 47.765586353123226 0 0, -3.57880442754643 47.761184269780429 0 0, -3.5621034771027382 47.76348837114223 0 0, -3.5357055867033012 47.758484299513938 0 0, -3.5314835717862536 47.767585411883019 0 0, -3.5264064518718783 47.769310407554954 0 0, -3.5151915157248084 47.8274043893462 0 0, -3.497455567877978 47.859398306521356 0 0, -3.4563904617280343 47.857792300346787 0 0, -3.4381104361646635 47.867775272748176 0 0, -3.4369325105487007 47.881683314383039 0 0, -3.4192064198199716 47.89436731317069 0 0, -3.3809065873441284 47.906223314035813 0 0, -3.371713437311743 47.920856375688231 0 0, -3.3785185372060682 47.933990281537788 0 0, -3.3561145452533063 47.963623438205552 0 0, -3.3645075111430174 48.004154310670586 0 0, -3.3753225299261373 48.016903436845851 0 0, -3.4337085288418621 48.003151348901341 0 0, -3.4548434222422486 48.0066643553932 0 0, -3.4994354404614114 48.024463318388072 0 0, -3.520014462807552 48.025276354613439 0 0, -3.5795215328900554 48.0168453502569 0 0, -3.6012515497972686 48.023029283720788 0 0, -3.6275795602700214 48.050808402797557 0 0, -3.6952074875280232 48.099403291075404 0 0, -3.7049774757699083 48.126011349314908 0 0, -3.7199194610023327 48.138340324260582 0 0, -3.7016274637670392 48.16765239279529 0 0, -3.6832955123135491 48.177681306407933 0 0, -3.5260514195993835 48.209209298731693 0 0, -3.5071035742830361 48.216491420766729 0 0, -3.4892884174512631 48.229198302150039 0 0, -3.4846594245581635 48.24615130473881 0 0, -3.5053345736194785 48.246975438669054 0 0, -3.5248625807454914 48.242351394148486 0 0, -3.5461085427447756 48.245845390483979 0 0, -3.5570115418863133 48.258579363715093 0 0, -3.5437924720252738 48.27359740248589 0 0, -3.48742155886433 48.298206405219872 0 0, -3.5287744482361982 48.319076383383674 0 0, -3.5109235613561069 48.331768301228742 0 0, -3.5436805252520318 48.369976412831356 0 0, -3.5401854528216221 48.411602329858873 0 0, -3.5511085659138359 48.424331396738168 0 0, -3.57300245536573 48.430519376271981 0 0, -3.5695274712307992 48.472137363526073 0 0, -3.5337374873756158 48.497539346900169 0 0, -3.5365934314144454 48.511036367967975 0 0, -3.5625604333133682 48.53610231640674 0 0, -3.5267204714921547 48.561500412270348 0 0, -3.5041355256075235 48.591144286872449 0 0, -3.5029625163935441 48.605014326010433 0 0, -3.5139164270873096 48.617733334955531 0 0, -3.5347485661453106 48.618545315061127 0 0, -3.5538205055380558 48.611240310430432 0 0, -3.5567174421470895 48.624744386242142 0 0, -3.5717444427091607 48.637073352757326 0 0, -3.5937365533465311 48.643257286221214 0 0, -3.6134074886853682 48.638633417720612 0 0, -3.6203604533830003 48.651733351689174 0 0, -3.6429614170845923 48.662799374944555 0 0, -3.6472895720414158 48.672931436257542 0 0, -3.6573864475847189 48.680938419713613 0 0, -3.6478924659667471 48.697437272447807 0 0, -3.6843854279462391 48.68683243709377 0 0, -3.722377577520632 48.699539318477079 0 0, -3.7253855827285349 48.705238316933205 0 0, -3.7700745879492388 48.710437418684378 0 0, -3.790377434967894 48.703430415857028 0 0, -3.8026715495297196 48.713836364237963 0 0, -3.8229775649077737 48.718727431047725 0 0, -3.8257764583954383 48.7036404076771 0 0, -3.8358704993956962 48.716537390624254 0 0, -3.8463655138796753 48.709232385993559 0 0, -3.8459694689549906 48.700538407807059 0 0, -3.8552754685651109 48.699142393452561 0 0, -3.8611694769705838 48.689438408746419 0 0, -3.85757657758748 48.68033642022921 0 0, -3.8512694418530158 48.679336280827847 0 0, -3.8535795161876649 48.665039405038513 0 0, -3.8585784832369256 48.67713532111803 0 0, -3.8691734925262877 48.67623534304893 0 0, -3.8552784609045432 48.634346275415979 0 0, -3.8199695523636068 48.632145301770741 0 0, -3.8536705185103415 48.6303442854571 0 0, -3.8654925425970452 48.617149312529349 0 0, -3.8640775358516652 48.631439305112629 0 0, -3.8966655075732319 48.64274242781913 0 0, -3.9051764043009194 48.655040411910313 0 0, -3.9043665571286112 48.665138328259715 0 0, -3.893876492463618 48.670040323130522 0 0, -3.9208705412297604 48.675933280766642 0 0, -3.9274674175350981 48.673938270466081 0 0, -3.9356725882745707 48.656845323556936 0 0, -3.9424734717211436 48.65934339892182 0 0, -3.9443704389003642 48.654144297170646 0 0, -3.9556265564733466 48.652557318703309 0 0, -3.9539684430107771 48.670940282515069 0 0, -3.9755694672106379 48.672138303277094 0 0, -3.9700605530144344 48.686634414631428 0 0, -3.9617695092498009 48.687233408054588 0 0, -3.9680585019151806 48.694538415208186 0 0, -3.9767684768848843 48.69563342745996 0 0, -3.9717624868775219 48.726734399144036 0 0, -3.9788675360194361 48.722438283981987 0 0, -3.9900595895708477 48.725036338687843 0 0, -3.9920605845503019 48.714935432908916 0 0, -4.0012655486996209 48.7124333090848 0 0, -4.0062645157488816 48.725540283852 0 0, -4.0165585154310861 48.711734333797736 0 0, -4.0350605021722572 48.710834343708896 0 0, -4.0428525540502847 48.702236296404138 0 0, -4.05155445313531 48.70333430895532 0 0, -4.0605594443148574 48.691040385472427 0 0, -4.0573604550642912 48.686237314416992 0 0, -4.0684604801295556 48.688038354120508 0 0, -4.0673545608988366 48.680839299830524 0 0, -4.0825505131202533 48.691242441335035 0 0, -4.0979515610439181 48.687835395348692 0 0, -4.0977595424846136 48.69273740401033 0 0, -4.11454654253501 48.695236334375451 0 0, -4.1541464584835808 48.69264637658803 0 0, -4.1799515136357854 48.685642366100083 0 0, -4.190144477857217 48.687641424859905 0 0, -4.2150514791402145 48.673038280377241 0 0, -4.224448476754123 48.661548396275506 0 0, -4.2015514520163073 48.653946293950909 0 0, -4.2739414232200943 48.653339357863715 0 0, -4.3046364968467987 48.642540353648933 0 0, -4.2994395016685516 48.633739369858262 0 0, -4.3161385137747459 48.635643366549274 0 0, -4.3188414376530622 48.6400452849106 0 0, -4.3111395458940489 48.644149352201744 0 0, -4.3220415289177669 48.645141392573237 0 0, -4.3032394185879923 48.651546418484727 0 0, -4.2981374916430246 48.665439318921806 0 0, -4.3101404573954767 48.66694640535583 0 0, -4.3150424374431964 48.6727413346937 0 0, -4.3294345111341865 48.669143320157936 0 0, -4.32764349437056 48.67624237477974 0 0, -4.3494335705424305 48.678341409928649 0 0, -4.3977364416958267 48.658947353997164 0 0, -4.4370345124065267 48.65644030929392 0 0, -4.4362374649934111 48.652137317512327 0 0, -4.4070355711136768 48.639347356348594 0 0, -4.4219305621144258 48.638538366938675 0 0, -4.4327374839790821 48.6435433186668 0 0, -4.4389284582416337 48.637344423505752 0 0, -4.4469285657201 48.643745389588375 0 0, -4.4662275708696768 48.632049390872808 0 0, -4.5061235524019594 48.625843278893129 0 0, -4.5210315634666358 48.639049352901495 0 0, -4.5319215667555 48.634449423116351 0 0, -4.5491194215646829 48.641750379287814 0 0, -4.5481275490533335 48.62884142698293 0 0, -4.5680165731306772 48.631141303865505 0 0, -4.5676175358665887 48.62655228731829 0 0, -4.5756244998076454 48.62395140061227 0 0, -4.5728284309555249 48.615245292728744 0 0, -4.56202343606596 48.61614228185401 0 0, -4.5625295027142556 48.608642431744514 0 0, -4.567318477943445 48.598549270844117 0 0, -4.59662545032964 48.593841440819475 0 0, -4.5987255734770773 48.598541337767223 0 0, -4.589321497617993 48.603843398334291 0 0, -4.6063155255067159 48.609848344535166 0 0, -4.6112194496142953 48.591846454578217 0 0, -4.6044164629928108 48.5883524388606 0 0, -4.6129204987305172 48.575409334005045 0 0, -4.6277144488568922 48.576847417131532 0 0, -4.6643135764161912 48.572750376390744 0 0, -4.6738165423688542 48.576553287767481 0 0, -4.68192243784722 48.569755396660341 0 0, -4.688518434052753 48.575252324194892 0 0, -4.70601957126425 48.569854319881543 0 0, -4.7080274310223729 48.553970278102483 0 0, -4.72771544029797 48.561950319304785 0 0, -4.7529185071646509 48.548854433795455 0 0, -4.7546174518815292 48.531555367505504 0 0, -4.7666045844197109 48.533249372031804 0 0, -4.7646126033495877 48.522358318892664 0 0, -4.7837135412161569 48.50235735568554 0 0, -4.7700144464132279 48.475559367695254 0 0, -4.7260164955810922 48.479953354119559 0 0, -4.7201204928476272 48.475158383337579 0 0, -4.7532105242891305 48.472355276244613 0 0, -4.7594125878095781 48.463153304434726 0 0, -4.7658084493131412 48.467956361261244 0 0, -4.7740085154736107 48.46406139144203 0 0, -4.8000175513854053 48.415863404607009 0 0)), ((-5.1420875791808012 48.452861429256615 0 0, -5.1008865703254855 48.456161439324504 0 0, -5.0974865532395528 48.449863279820683 0 0, -5.1208945967165489 48.439365430799583 0 0, -5.1088935425826776 48.4376643811424 0 0, -5.0946954200429673 48.441467292519135 0 0, -5.0872855075122345 48.449165349735054 0 0, -5.0694884807370215 48.450164439065034 0 0, -5.0439925166460284 48.46025443160606 0 0, -5.0386914968395349 48.466358272457242 0 0, -5.055097440314 48.465953430062186 0 0, -5.0592974467296266 48.473056376512261 0 0, -5.05399644872913 48.477363401429365 0 0, -5.073193525012357 48.484161287439278 0 0, -5.0774945728943521 48.476059440420144 0 0, -5.1058955705128426 48.474464347483504 0 0, -5.1123864827983425 48.467460336995586 0 0, -5.1334935650440627 48.462463306165958 0 0, -5.1420875791808012 48.452861429256615 0 0)))'),
('Gard', '30', 'POLYGON ((4.0781795853112328 43.557953323482266, 4.0853495826275719 43.557895412913282, 4.1389464302941406 43.539402403190408, 4.1470435247741761 43.516197338963721, 4.1332444394985828 43.512893268172107, 4.1279434221867746 43.50460431192856, 4.1352445543781755 43.48819731482898, 4.14693650463451 43.479095322360067, 4.1945284311431408 43.4619483373212, 4.1929535805026319 43.478016319965278, 4.22498058943151 43.503708370298952, 4.3168105580066083 43.531353362161227, 4.3927964413350367 43.574833286231907, 4.4069415818648 43.58896240894471, 4.3828875733395876 43.615551281007853, 4.3820875625917211 43.629211310509888, 4.3991664279035376 43.657100266045759, 4.4275234205304059 43.685360271671058, 4.464306488954719 43.697437353614148, 4.5393524256619173 43.697006280716138, 4.5577824202367765 43.703045349747569, 4.5719814228762914 43.717151413844775, 4.608632476325738 43.800296381251641, 4.5913224967978863 43.840812305106013, 4.5935704477903414 43.868240264349581, 4.6078365140371034 43.882347384566586, 4.6443314377762306 43.9025683823008, 4.6849205859366805 43.917431332254054, 4.7371085697911894 43.927127392109966, 4.7800674747609548 43.969383273333435, 4.78613945952614 43.996902410919645, 4.7734035348483417 44.023887327907445, 4.7493484702033015 44.050571426772464, 4.6946564263050448 44.084560354248211, 4.6826045152171787 44.097896330991873, 4.6817525785791929 44.182659273931009, 4.6689034730629544 44.209648415398007, 4.6409645278565677 44.2361712799737, 4.6231014935939072 44.284885333768912, 4.5463534438104318 44.301757375620056, 4.52588549006316 44.328498328934259, 4.4488714741102626 44.348037425318168, 4.4299435190501413 44.347442301811341, 4.41345942520519 44.305893316773435, 4.4029184695099559 44.2918852957976, 4.384334457464405 44.28583936198747, 4.3647784631637023 44.296161348844336, 4.3547384602931913 44.336879343620282, 4.34255453423043 44.350174307711754, 4.2490775468285733 44.328010401587065, 4.2310214186626069 44.313736414441777, 4.2206974955861085 44.296989346766864, 4.2021335498167218 44.290893423286249, 4.1637925286687221 44.297840403305017, 4.0856475844308875 44.333492367424455, 4.0286994926217119 44.334278296574993, 4.0090544322179653 44.344551349881172, 4.008159546708157 44.35818427230835, 4.0319424844849436 44.400055373884996, 4.0254455875205792 44.440876340341376, 3.9731685375629979 44.494896340007429, 3.9534055437816846 44.438377384876631, 3.9363064361737088 44.41040429179678, 3.9179324159482292 44.401558408379159, 3.8804155202834636 44.394733410197162, 3.8709315644871936 44.367027339406533, 3.8794354411098766 44.353645421451589, 3.9178554952228524 44.346813382470955, 3.9066395029559828 44.288944354196914, 3.9459065651478795 44.268451405614442, 3.9354985045273736 44.254398323527155, 3.917341516920601 44.242817265849723, 3.9144894654030225 44.229011315795432, 3.927667552236727 44.20213341894727, 3.9469075906975206 44.197338283019249, 3.9629614917442666 44.184219338894323, 3.96008655763103 44.170448416813358, 3.9417685117549013 44.161594436477273, 3.9042215166758751 44.15750126817575, 3.8572474202497347 44.125709421922167, 3.8380135424878006 44.130497341031557, 3.7530564495255589 44.209488413248451, 3.7139294992270209 44.227172435205162, 3.6948445343567471 44.229187335761949, 3.6578644995898912 44.21685027232833, 3.6550814478991924 44.2030524191925, 3.6608304360258046 44.175899403136654, 3.65149046456213 44.148178370648864, 3.6147545694888379 44.133106308975371, 3.5774684360002027 44.126178339112968, 3.5167434837693179 44.129303397598633, 3.4401065025847117 44.142681267094318, 3.3820744798216822 44.159515288632704, 3.3659554513873218 44.172550271233618, 3.348347470056126 44.155410326993419, 3.293701543389119 44.128547391842417, 3.2657034554739823 44.099998361432071, 3.2592465150420082 44.086036281667489, 3.2678605801637275 44.072723363539453, 3.3050815862647767 44.079727374027371, 3.353459441923917 44.040641436381023, 3.3923575662659573 44.025806297582491, 3.3971755847896361 44.012302397790748, 3.3817044858520546 43.967880414859266, 3.326867577521341 43.897216319198677, 3.3767144958210906 43.885555348456464, 3.3815214250868735 43.872078379719611, 3.3761144437551991 43.844471408170094, 3.4492984412565306 43.872066410361882, 3.4682654727492377 43.870083369419021, 3.4628125502063085 43.842491359566694, 3.501133505078144 43.833061265880175, 3.5400775706314676 43.815437266732047, 3.5588045108898427 43.816173382232037, 3.5690745718566177 43.830253395374186, 3.5520474564149538 43.85696829773336, 3.5573454813873298 43.8872724232299, 3.5755144383518314 43.896202268171535, 3.5950885627090656 43.886024265647265, 3.6134655752740059 43.892192357314187, 3.6357965243469437 43.947788439760515, 3.6541974756273135 43.953987334921564, 3.7141375548274596 43.958973276493296, 3.7323575575822474 43.967865277142138, 3.7517345395769723 43.960380380105661, 3.7910595123378528 43.937202422953831, 3.7995385701452449 43.923839339135313, 3.8004695397481782 43.91019427133044, 3.7901725477265416 43.896125347446187, 3.7780055195805744 43.854633392877432, 3.79676255925321 43.855312301888304, 3.8517515488349829 43.87649542475954, 3.8705274226440451 43.877189295467574, 3.8898774735839083 43.869674299016836, 3.9179774770596509 43.843326398287886, 3.9169945815665983 43.802223271825184, 3.9366635806858028 43.789245319693421, 3.9737935844641186 43.796051307719, 3.992723475743901 43.793987297591556, 4.0314494525587179 43.776176365238982, 4.10601749505679 43.726787274872166, 4.1339835473380049 43.700370374316307, 4.1638194597235838 43.643932388370118, 4.1611184333372933 43.627422419590104, 4.14413849124665 43.599487346823011, 4.1120674773261783 43.57377241389365, 4.0935714752638717 43.570388430037255, 4.0747244893883305 43.572479371219586, 4.0781795853112328 43.557953323482266))'),
('Gers', '32', 'POLYGON ((-0.15376954658512432 43.58458743267677, -0.12582144834050268 43.600326434003406, -0.11649855081358851 43.614738420802453, -0.025261417485751281 43.607551349549325, -0.008560467042059372 43.595008342754866, 0.015500582281816833 43.5555233678444, 0.041474440581907857 43.52990330967701, 0.081175568011275345 43.513500361036662, 0.090420488692984691 43.500427358122963, 0.092202514834070826 43.486824359090079, 0.11187855475193942 43.479972429853248, 0.12480352487378354 43.467147439072406, 0.10982545786242781 43.438617418818453, 0.11902549345268199 43.425544415904781, 0.13761443405729779 43.426864389633735, 0.15759358035751347 43.417274293797632, 0.15779248291968884 43.387092326157884, 0.26718942017376435 43.380958382364483, 0.2855484787021112 43.354782277122851, 0.30408250107717549 43.356052437201285, 0.32159842396586669 43.365482354867808, 0.35939554341732105 43.362575385120678, 0.375975568144014 43.349987317214769, 0.39521155814554731 43.345810363409171, 0.43197649651332881 43.351040268654529, 0.53318850532406259 43.319400327632039, 0.55172745625819175 43.320633347497548, 0.5898324346311199 43.314922379683694, 0.63027847855877894 43.3203244324563, 0.65292151103236051 43.34925841853341, 0.68772752319267738 43.37073127026953, 0.70695752851537463 43.36651242371191, 0.725183515949027 43.370418306769054, 0.72931646476300216 43.398140395376672, 0.74722948869614925 43.404789373592124, 0.7860265775774451 43.393558419628093, 0.82285857955244524 43.398681304733785, 0.84174851429983732 43.397133385148194, 0.89971452957541942 43.381607367981033, 0.91861942601994429 43.380062264714908, 0.97402646302222706 43.386280346052288, 1.0027115568666716 43.429226401564492, 1.0050575509804958 43.473251283451518, 1.0338035477333563 43.516178328807328, 1.034376492724391 43.543632339005924, 1.0725615601820664 43.537761369042514, 1.0908685168003274 43.541637328705363, 1.1436454634628035 43.572281348757244, 1.145813501390478 43.586113349766563, 1.1405304381152632 43.5995373364935, 1.1187595845757983 43.625618390953221, 1.1022835876493104 43.638328264675962, 1.0444194879343627 43.651226303742916, 1.0244825864261031 43.660961264011448, 1.0266455197747462 43.67481227517716, 1.0213135229488159 43.688213379308436, 1.0047845440124092 43.700901426555319, 0.994118438120978 43.727657341566683, 0.95420855101133384 43.747120397325048, 0.94138356023049141 43.760044311327093, 0.93976452857842219 43.77365135881918, 0.92319946554889043 43.786335357606859, 0.88515943854361012 43.78942538811917, 0.895271433580433 43.831203375133512, 0.89363550401157 43.84484140213975, 0.90700351638915322 43.859390332472728, 0.90163649158989756 43.872772426447611, 0.914976516792791 43.887321356780589, 0.91337051061822194 43.900951286868334, 0.90425250033234761 43.914074279452521, 0.88764642465062593 43.926757398140339, 0.84884951178929668 43.935295422636514, 0.81136341961868652 43.932926369907094, 0.77486444742032745 43.922374324953964, 0.75513542549254 43.929344363588328, 0.74972545182146177 43.942703398947614, 0.7689155006117403 43.971370362735527, 0.799385436916765 44.000740350269709, 0.81486551287264319 44.029171271282522, 0.86792655576110178 44.059951354768529, 0.87005358103655794 44.073795325135578, 0.860905471336423 44.086937327876129, 0.82233351199232629 44.09273929801266, 0.80485648951622579 44.080661335969737, 0.78561645105543221 44.052013382338217, 0.76649047353296851 44.053535426988745, 0.74650358235422232 44.093410286125064, 0.71843350227280212 44.075164408435185, 0.69580455139654873 44.0434992965575, 0.67735941910456177 44.039570354884731, 0.67026845475319874 44.066555271872531, 0.66105856204478641 44.079685305255381, 0.6412795504465123 44.086635277613581, 0.62453054655196638 44.099285304547706, 0.60506256223453647 44.103492357767564, 0.56883254854503207 44.090149340225238, 0.53127041574887812 44.087696325971777, 0.49507050147363429 44.074325321254761, 0.44324951924934908 44.035198370956223, 0.35011453864245823 44.023471392726563, 0.31467555868249519 44.0046002921156, 0.27612454571442413 44.010227298405411, 0.23823343160083255 44.01038342811573, 0.21842555272803565 44.017250319049722, 0.2128795156228307 44.030590344252616, 0.19305843525253863 44.0374794137024, 0.17572046854999712 44.025295311619672, 0.16233855059508073 43.983188343287893, 0.14433646055886129 43.9764554035484, 0.12523054931256183 43.977863387260626, 0.10626756627908662 44.006744391327814, 0.086023509929248121 44.0108373836094, 0.068016491333963813 44.0095712719902, 0.050728514301908945 43.997371328110447, 0.047222548608715442 43.96693043509994, 0.054634573379019 43.939983362404931, 0.052691488968577005 43.926101371725125, 0.016345478121138513 43.91532138091533, -0.02220852718636479 43.920829397707777, -0.031530544613445954 43.933902400621449, -0.027636454894064855 43.98910930292179, -0.0332284332105246 44.002437358766954, -0.053084541554142106 44.009269397747588, -0.070723502399431482 43.999767311894786, -0.11423141364477374 43.958202309039919, -0.1899205273096527 43.95824842627114, -0.22625157645995841 43.94737637701887, -0.23746158404793505 43.919094368897746, -0.21123443301601696 43.89352430040087, -0.22882146797118708 43.884014293649543, -0.22132847401624645 43.857090279570158, -0.20823047626734592 43.844295388203577, -0.2250085234563528 43.801883377269817, -0.22125454563033031 43.774692340901211, -0.21192355118495243 43.76161933798754, -0.21377844959218351 43.747753365124666, -0.24360151252020046 43.718124276199759, -0.24541557429520822 43.676784402882063, -0.28044653997275759 43.657722320607448, -0.28973352942648489 43.643310333808429, -0.28034849685138852 43.602790361494826, -0.26357942668064993 43.590309313728554, -0.24756143370709083 43.583233311074324, -0.2092165401197974 43.577804327246852, -0.15376954658512432 43.58458743267677))'),
('Gironde', '33', 'POLYGON ((-0.15724541286405724 44.216056422279294, -0.13838557753095415 44.244873355078667, -0.10037054536093137 44.244838327105342, -0.058834585800553896 44.302707355379383, -0.08327548621221581 44.342174376253254, -0.0775954979124549 44.35630437906589, 0.01562555645804764 44.371112410789593, -0.020505534010254678 44.412513363035643, -0.024566490657917939 44.442443270083359, -0.016923527691517393 44.470432380980171, -0.028185461169641712 44.497116303825223, 0.015434574794369382 44.541347305093055, 0.030664526377819357 44.569873276887776, 0.078190445399002328 44.614364435666104, 0.11608754419145839 44.616977276049184, 0.15470650086660953 44.614151275486634, 0.16046745835095066 44.628280398199465, 0.15487055147539763 44.64160528568523, 0.16064752677669958 44.655735288497894, 0.17850457636049555 44.665195305578706, 0.18248544392338317 44.692917394186324, 0.16928957907308018 44.705730415609438, 0.14884151558206327 44.71534339404117, 0.11088457000099083 44.712734426097356, 0.09263446783191398 44.705989340980196, 0.08702541557869381 44.719310356026696, 0.088972548448367661 44.7331814334686, 0.10721754603841305 44.739940424163123, 0.12438354123364093 44.754840338309364, 0.133589561502788 44.771942438256744, 0.15188155642385937 44.778679426455469, 0.17085844503469616 44.77997933390823, 0.19131143708480636 44.770397334990619, 0.19692753013669062 44.75704534043, 0.21700841597757403 44.750171408697312, 0.23530445935787725 44.756885338280412, 0.23549843336098775 44.784362407094633, 0.29143652260225394 44.796367320851445, 0.28585352130409092 44.809719315412067, 0.28785856474274851 44.823589336734145, 0.3111555113919735 44.880046332836756, 0.29103854145796504 44.886921320689211, 0.25223652401760432 44.889801359381451, 0.2152434637732199 44.8790854398395, 0.17934947219981723 44.860176318915777, 0.12299157533837501 44.8508374035719, 0.083463475536120768 44.85910030886042, 0.045050462221809084 44.859188318843664, 0.024521429546183526 44.868759404523374, 0.011250580190107939 44.881576298385752, 0.0094055389010350154 44.895168384180707, 0.024740574404489735 44.923687315176764, 0.022883563757659431 44.937297355008312, 0.0039105475861163086 44.963443360835683, 0.0058624329948884224 44.977295428121195, 0.011625502718828784 44.991428423273263, 0.029585523983058692 45.000904282151069, 0.0384224303823828 45.020740324218522, 0.060934504000869083 45.110157411092487, 0.041933500654607769 45.136295320001395, -0.0364064737061085 45.144607334860567, -0.06023957717334838 45.1128804399746, -0.080473424365123947 45.119697341238137, -0.097646460359015919 45.132244396491828, -0.11713644717227112 45.1336133037715, -0.15383643417240478 45.120044276592139, -0.19130457230642151 45.111896312341784, -0.21077748518291628 45.113250433944259, -0.25206349639083214 45.132286289243879, -0.34511557159351014 45.188789402577683, -0.36385448120958586 45.1846844409384, -0.38141458510989423 45.1724133849922, -0.40090650814278206 45.173759409676208, -0.39809054071832861 45.234386318785724, -0.40427852264144803 45.250415401017179, -0.45998954612591092 45.287555437933619, -0.54221656940737262 45.319996269803781, -0.55572856611755128 45.33272128124365, -0.56741453169502165 45.359340428741021, -0.5882054820808662 45.368793405023169, -0.60576558598114616 45.356506331260036, -0.61525042187724921 45.342056324148231, -0.6332245247388073 45.332470276771389, -0.65195744967601854 45.328331343278549, -0.69112558864674156 45.330902290909606, -0.70562646552886577 45.325130420187335, -0.70505158431819837 45.321319411892134, -0.70033847369455771 45.2900462964799, -0.69092756618439921 45.227504290134604, -0.65476848854140712 45.135364350398461, -0.59669351690652661 45.044864388690414, -0.5502974700504808 45.03250532276094, -0.59438149464625667 45.029235399842847, -0.59207052850575792 45.013607291095113, -0.59230357894145413 45.013740362189807, -0.59812455923437824 45.00792730279538, -0.608441441512241 45.016548408715764, -0.62316357549227064 45.026710393423073, -0.635485501208791 45.038536294873936, -0.6407865185205992 45.04157633571576, -0.66750142087977338 45.0711864144843, -0.69893753078099508 45.132049366368918, -0.76440657314961413 45.269401266646312, -0.80085555567748656 45.36152642070526, -0.89922941854800342 45.41728637774041, -0.92143046488564551 45.415577399885436, -0.92385954042364915 45.431213429531667, -0.9978215461770219 45.472953396233251, -1.0002775527699157 45.488590305979315, -1.0249664653143782 45.502494299154947, -1.0570945097040294 45.563293355791714, -1.056939436113538 45.563919282792696, -1.056303475974488 45.56790138249535, -1.0839004143858801 45.559101440288984, -1.095610494698775 45.542606433206132, -1.1272004460507787 45.516807362732791, -1.1486034178601869 45.478202311634973, -1.1465005073201269 45.43680928028742, -1.1556005635694362 45.375614354745906, -1.1520065878929415 45.298118396124678, -1.1595085588661789 45.269123331119189, -1.1642964779755687 45.197326370954059, -1.1850995737390804 45.116024332596695, -1.2152975591957897 44.867141428991104, -1.2558074983713254 44.652256429879529, -1.2564974966400939 44.621959345181651, -1.2545044225591369 44.61595143168428, -1.2473015095090432 44.614055344604893, -1.2403985344819262 44.633003365941207, -1.2343015548814833 44.6486554134044, -1.233008512207391 44.675251326266178, -1.2223985566852775 44.696659402654646, -1.1711065144603765 44.746849383869133, -1.1719114537673079 44.75814440910095, -1.1601015701333779 44.771194353399025, -1.1237145466337495 44.748249270662896, -1.1011074222333264 44.739647350918872, -1.0816144430806673 44.719452404139687, -1.0397695684790165 44.692306428882532, -1.0415185028664098 44.68434927027586, -1.0413125595055703 44.680355377235472, -1.0165164508014755 44.664657388561025, -1.0143195455993066 44.654155333278382, -1.0297184763506095 44.65815327477803, -1.0360224554316915 44.647655267954619, -1.0405134288575653 44.654258304958788, -1.0741165205666618 44.643955328258286, -1.1132124913511063 44.648506324492743, -1.1433104974668424 44.645958435477311, -1.1485085430982451 44.648155340679509, -1.1396054531914785 44.651859328835044, -1.14280848852232 44.656753387984267, -1.161309419143663 44.66315435406689, -1.182503455252828 44.663055430845688, -1.1898014190848585 44.658050303097596, -1.2103024645857943 44.59825544036984, -1.2462985477397979 44.549362374268682, -1.2554095172270081 44.526767395245955, -1.2497015417525859 44.495685437517366, -1.1905384146846814 44.502884302108228, -1.1364094586593296 44.523735275302627, -1.101575459324323 44.545772271031481, -1.0826835883573267 44.547256295369223, -1.0692425276936319 44.534591306737966, -1.0113104842715757 44.530922346555755, -1.0092204231890776 44.517334309220033, -1.0554205598224087 44.444950322466539, -1.0361324679107611 44.443718358720858, -0.94221243825316492 44.4538843918874, -0.85762357906091324 44.424747278768919, -0.83833548714926565 44.423477294710452, -0.69020253994230529 44.454132404020228, -0.67254157660119063 44.463710354478636, -0.65285849588465794 44.459713293078821, -0.63196457381843629 44.447548377172424, -0.62799145113405075 44.42036033314325, -0.61843743939110141 44.407356330056459, -0.55868042095613646 44.389873322901494, -0.51782653876605877 44.37094131938214, -0.50077654072873656 44.358467312414533, -0.48179243529926907 44.3324163573691, -0.4417554617738233 44.318920378475852, -0.40397453615926793 44.294227417472158, -0.37750746991298456 44.268715435564204, -0.36382244557569265 44.2257653315928, -0.34493955162699308 44.199672307775344, -0.28737556595493174 44.195640394422171, -0.25091056561012692 44.206539374729331, -0.23323358445205145 44.21607631253552, -0.22008242867323702 44.230758313963193, -0.22386650591354851 44.257957271230268, -0.21443852446662959 44.272373306488518, -0.19601557069046294 44.27644728861371, -0.15724541286405724 44.216056422279294))'),
('Haut-Rhin', '68', 'POLYGON ((7.1369054746399172 47.502224399111341, 7.1675044335803761 47.486389290883, 7.18531747817255 47.493946356105724, 7.1914424449476542 47.492328380573454, 7.1896315515320737 47.479370318697917, 7.16875646360225 47.450027438238564, 7.1979104746375242 47.437427400974926, 7.2270775111503269 47.442466324556577, 7.2299545575031345 47.418354405462381, 7.2378754559966865 47.41276929192459, 7.2994275260502661 47.432567313679257, 7.37484046438766 47.430950394266787, 7.4369334437983525 47.465686350480425, 7.4464835831020366 47.475044275980665, 7.4259605351052755 47.493225378322862, 7.4398205232892565 47.498447362669694, 7.4734815255673652 47.484947335317244, 7.486080506711204 47.486927383920644, 7.514699593068201 47.512485307039853, 7.5254915532357245 47.529220405357066, 7.496872466878699 47.532821421832196, 7.4828315301691077 47.540558379460705, 7.5013794581215336 47.556221340161827, 7.5617335362829294 47.578483289407856, 7.5632874405474126 47.583221394866754, 7.5733765529885773 47.610939435015112, 7.5548374260344815 47.631637270838652, 7.52783754734952 47.650360338657762, 7.5107414320810051 47.689056392078257, 7.5418654585816114 47.723610343646513, 7.54385853266254 47.737651280356104, 7.5389544403752495 47.746673359760237, 7.5292795029153012 47.764473378874882, 7.5346685302103538 47.7945252677594, 7.5573465906572892 47.843486277567635, 7.55500552510253 47.876957354301837, 7.5733725045293454 47.900901350348008, 7.5818304399407737 47.931499429188634, 7.6063014397666961 47.95111439017812, 7.6237645566654066 47.982799392312, 7.6182355934969621 48.002529294339624, 7.5796754274906277 48.03031527819509, 7.5715744605713269 48.042915315458728, 7.572284525116288 48.082874312139026, 7.577571460830768 48.104736344021134, 7.542440515812217 48.12339428445263, 7.5057894623627988 48.150554341307142, 7.4729474809889211 48.204940286483591, 7.4525685933447505 48.215763402185175, 7.3508364455329342 48.242557337509325, 7.3220034949166006 48.283298390900868, 7.2891754191200846 48.310394376487565, 7.26876255962236 48.318462427673111, 7.2035885267176241 48.326255359651, 7.17555646694899 48.2933693732855, 7.1522144591883432 48.216884297332015, 7.1402574228624189 48.200454417636749, 7.0760145355806117 48.156376377719837, 7.080645444879849 48.1155122863717, 7.0689364206867822 48.08816934477197, 7.0530164708345353 48.068958349605666, 7.0130345915586076 48.03865440012909, 6.9932444907024376 48.011245275021977, 6.9532904225812047 47.983646400390924, 6.8946085341017636 47.876777285876088, 6.89533655268329 47.835876406354927, 6.8875524217037309 47.82215529792451, 6.8757205355740041 47.808414299237867, 6.8476624248503128 47.799984351001157, 6.8721325445764023 47.783832406833042, 6.8764175746414367 47.770233280239424, 6.892748531115501 47.756729380447709, 6.9575615470688774 47.732746307968981, 7.0220524464835137 47.72508627106582, 7.06252454136623 47.709015296082313, 7.07497355349858 47.681831300512371, 7.0593195698157842 47.654422351425225, 7.0276264707634084 47.626907438318213, 7.0197985108121941 47.613201291584929, 7.0240784362981969 47.596862414212396, 7.0442205770874295 47.591568437699252, 7.0842545582734431 47.597316369706064, 7.1246604696487452 47.578514268921978, 7.1491085868790378 47.551399273178916, 7.1614834946054771 47.52418130575542, 7.1369054746399172 47.502224399111341))'),
('Haute-Corse', '2B', 'POLYGON ((9.399103523198221 41.861396317446136, 9.397401586141882 41.873485368746927, 9.407296548559998 41.891788276905956, 9.4046944453948811 41.900978279358142, 9.41369857076242 41.908985427635272, 9.4170975163159767 41.935878286180596, 9.3992925686422666 41.941581333095925, 9.38173651320119 41.933223377025527, 9.3858794951532616 41.947574284896163, 9.4039924777683837 41.948780373706782, 9.4031894746811133 41.958877407046444, 9.4118915497860769 41.9550824165682, 9.4138904325259318 41.9440843370199, 9.4207884789940124 41.962078330137658, 9.4362905574456875 41.978977303043692, 9.4362954860047523 41.982277325376074, 9.42549454881896 41.978874331363286, 9.441742423868817 41.989208287577881, 9.4536874908370123 41.99567842950735, 9.4805965432192636 42.029579346999824, 9.5001895017129243 42.044376289465632, 9.5031855375631267 42.055778334837115, 9.5360924703046237 42.086979282063069, 9.5419824504244275 42.104377271574194, 9.5282884490688673 42.109775275887571, 9.5485884797680569 42.111274437942441, 9.5545835438078655 42.136566394892228, 9.548086470823506 42.136871437494207, 9.5330915058953849 42.11797340582838, 9.5236895754034947 42.119968416128941, 9.5206854426348571 42.125469392122724, 9.537482499980257 42.133171321777937, 9.5365895506900813 42.148265385947226, 9.55008957804256 42.153270337675352, 9.544586489809177 42.155174345653236, 9.5435925050582284 42.163765352159331, 9.5540845272027752 42.160671273187788, 9.56148757495481 42.185466325772083, 9.5558825711607938 42.196163411177608, 9.56098450989046 42.208168324934448, 9.5513884293755211 42.22636843743301, 9.554389569804755 42.264263423985838, 9.5626815183877341 42.276462311745789, 9.5326905324116353 42.37325639541676, 9.54398150918422 42.420749398704189, 9.54418956478466 42.433551330869406, 9.5384914464283668 42.438549417818834, 9.54478451227152 42.438251416015518, 9.5431814984363825 42.456447304034882, 9.531191546376732 42.470848377595971, 9.53798450892478 42.525650433973325, 9.534684486592397 42.550846284021375, 9.5184844889734563 42.58485034921425, 9.47518956188759 42.630340421302591, 9.46548558113318 42.649547368009664, 9.4584914277633629 42.654842400642636, 9.4593954663114346 42.646137333198212, 9.469889424675614 42.626537333905887, 9.4805935508798314 42.619449361893928, 9.4776904535719666 42.609844304360692, 9.48229143947691 42.599346297537281, 9.483393500487324 42.604946372772233, 9.4944825823583017 42.598247404886294, 9.5144844352342091 42.56734428344366, 9.48608748607495 42.577243294321008, 9.45878150866821 42.628532344206477, 9.4498854595601074 42.635440423812653, 9.4475894551167983 42.650146363955756, 9.4534855959354331 42.6606373299805, 9.453696467855309 42.682644402315034, 9.4602954564002744 42.689441413322342, 9.4596915318951176 42.717838362481572, 9.4680915567375621 42.731331349035386, 9.47509451110568 42.764740290721434, 9.48508945286477 42.774337427356173, 9.4941944376731158 42.797729424787306, 9.4876904999100873 42.811336296259455, 9.48329158492669 42.865631415133194, 9.474394479698816 42.875129276506826, 9.47518744964799 42.91472637613596, 9.4595915525541443 42.95193136442002, 9.46318658435041 42.984623376782409, 9.4583905683225566 42.991424436248948, 9.4360935911031731 43.001022276963553, 9.4337945943204033 43.011020387082041, 9.4189944834951973 43.012420273875804, 9.408792542255469 43.006725323878911, 9.3870964972017816 43.008926277540311, 9.36899847628382 43.003318281406891, 9.3596975812527319 43.004921295242, 9.3414015378724 42.9919283814131, 9.3593974672097886 42.9213253646809, 9.3250964563334264 42.898033346590765, 9.3385934913464439 42.864532346462241, 9.3142974553672673 42.832237435144307, 9.3217045515785344 42.81694041995361, 9.3453984232522487 42.791137301021038, 9.3402984207422151 42.75303637110737, 9.3442034236995255 42.734035367761109, 9.33410251792057 42.718738352570412, 9.3250985685730257 42.717739263240432, 9.3242985578251876 42.699844369363817, 9.2979015475255551 42.682743325536208, 9.2964034415904848 42.676242380112612, 9.2890084907569133 42.678241262852467, 9.2690055817612063 42.699440403540635, 9.2547064237607231 42.704441306809528, 9.25540944750702 42.714836341952534, 9.2484985515813776 42.721939275661654, 9.24240949287946 42.717838362481572, 9.2343065897405268 42.720142287823407, 9.2221055897410054 42.735439303014104, 9.20420858362479 42.727337279975, 9.1895024674616934 42.728939413710307, 9.1842114832879815 42.734237438682683, 9.1786064794939932 42.730934424010869, 9.1700124806484382 42.7367443150459, 9.1440134514931515 42.734836434628775, 9.1399054975144338 42.725433271997119, 9.1176115126344541 42.726333438105925, 9.097517425296104 42.714939313632939, 9.0901105051048035 42.7154353378986, 9.0851125941753423 42.700538416091817, 9.07221754744782 42.694542295932209, 9.0565144541943425 42.695140411778439, 9.06171954062441 42.686439392793275, 9.05371749692631 42.683242342141327, 9.0587164639755713 42.6635434196278, 9.0315194429281 42.657245425225611, 9.0158195180340215 42.6451373637684, 8.9471284301781964 42.637539285893453, 8.923923541971476 42.644344393819225, 8.9034244326901444 42.632049399157566, 8.8805325079839 42.62893631002963, 8.8657304609390621 42.61124031871519, 8.8468245083747377 42.612648302427417, 8.83102742045915 42.6027413706516, 8.8236264849467148 42.605842314401841, 8.8026375120985563 42.603641360740411, 8.8078285169312949 42.596843293613333, 8.7966274863615865 42.582843369555931, 8.7963335330175028 42.567550402824466, 8.7856285267134524 42.561348339304018, 8.7675294496756635 42.560447293095407, 8.7425384868686535 42.570442410874435, 8.7270425691157811 42.567047337760144, 8.7319345160253761 42.574649288074355, 8.7267364703940018 42.57514232000058, 8.7243385503900583 42.583347314720086, 8.7175355547038862 42.580742395235532, 8.7122324251524788 42.573047330359017, 8.7178354927268344 42.568641374576984, 8.71934046344063 42.543449396968171, 8.7145425111931161 42.535648368071847, 8.7186365595945 42.529350373669629, 8.7074385213642245 42.530948282925735, 8.69123359518619 42.518345429342631, 8.6819344603547677 42.519848287816828, 8.6657455519936946 42.511753305576391, 8.6661364923393478 42.491752332800317, 8.651744571816522 42.479950370064913, 8.6793404541081145 42.474552365751535, 8.6666404375035029 42.4459533456707, 8.6520385251606058 42.442951325141664, 8.65954542469288 42.439853373730855, 8.6601364997404744 42.423553396770885, 8.65083947714865 42.419147264968885, 8.6499424793992432 42.413753309114739, 8.6455414521762748 42.421756408932666, 8.6244405306293856 42.422756378362479, 8.6037495595845712 42.410953359507275, 8.6089474291959789 42.407356391491376, 8.6044455425322042 42.397651354617139, 8.60834456081065 42.389957345860452, 8.5783525187147518 42.385257436734307, 8.57383549433385 42.379284375190295, 8.6092894359909451 42.371788388895951, 8.6759165137193 42.347313340610796, 8.72673242193477 42.315544376952843, 8.757761573673406 42.306152303579111, 8.8137725351808172 42.311809409283214, 8.8390595635715385 42.257476270096689, 8.8574425608153433 42.249340275204034, 8.87591057570296 42.2493364027648, 8.9125434990958183 42.224891277873937, 8.9310634398735544 42.227588431820962, 9.0044635898937884 42.194961370826221, 9.0223334889351463 42.154190394040356, 9.0406635041690038 42.146019371174376, 9.0515095024662457 42.132431333838653, 9.0513174646827679 42.118843296502931, 9.0695434521163918 42.105228328112347, 9.0878965259658742 42.099762380091889, 9.1128345067629937 42.045406358309734, 9.1677835398123761 42.028984399512964, 9.1860244889431613 42.018062360590207, 9.21027159137168 41.931083326272542, 9.2061224487207767 41.903942279574423, 9.2095025601379348 41.887630333256752, 9.2017075159204467 41.86050442427576, 9.2564675035257835 41.844047437505665, 9.2672214433805209 41.830410290599289, 9.252047466146422 41.803337363628216, 9.270410573134 41.803257274543441, 9.28532157653811 41.816784408970747, 9.34098859503095 41.849155360914196, 9.399103523198221 41.861396317446136))'),
('Haute-Garonne', '31', 'POLYGON ((1.6860314520878035 43.302463334413247, 1.704053432380249 43.344577343543691, 1.7220424969389398 43.351074416528022, 1.7589185039055906 43.355865327976844, 1.7763675392070013 43.367801417926771, 1.7967874395033903 43.423748308166367, 1.8142704466583552 43.435661339500669, 1.8325944772133482 43.43941126886746, 1.8723184872383456 43.4169233099844, 1.9103275347295039 43.410751345878211, 2.002799448122488 43.421207283929633, 2.0328874211001562 43.416851317818086, 2.0351985632605931 43.433891282717312, 2.0301355249435176 43.44731931790345, 2.0013574925567355 43.4731903805431, 2.0146244694735174 43.490333317122733, 2.0170024992212632 43.504173415050516, 2.0119155221887297 43.517589304858987, 1.9927384988759513 43.522064436487867, 1.9379394348380572 43.508159387192435, 1.8809445217177654 43.516040329153569, 1.7994025681460357 43.580120397966354, 1.6800545181045266 43.644741376136253, 1.6935835887514656 43.659214265843687, 1.7116794974298557 43.665710282708218, 1.7047955325591033 43.695469274368449, 1.6455584771052543 43.722313375383024, 1.6613735190574346 43.75059943196338, 1.6435294949511388 43.777019324858642, 1.6420804985867221 43.790638341708487, 1.6167084525521602 43.816612376028544, 1.5973684347503934 43.856655334232883, 1.5554874760556174 43.8953932804054, 1.5459484260098293 43.914051396856863, 1.479622518444188 43.899292298683875, 1.4445454355354173 43.875339325619407, 1.4254805369413077 43.876964341950369, 1.3999965422080436 43.902908276856138, 1.380955582329392 43.904544382444968, 1.362511506157233 43.90072633335113, 1.3355635533623911 43.871719298987912, 1.2984015139501537 43.866779298627435, 1.2808935119599596 43.854763295612727, 1.2899194638033293 43.841598410276518, 1.3092485683671669 43.837249308943669, 1.3457934817768091 43.847633430848717, 1.3648265207569636 43.846000317599319, 1.3738195568665788 43.83282135066581, 1.3640895251571123 43.818546307400723, 1.2723514390045523 43.796688323977847, 1.2364794499269465 43.780830333153844, 1.217791586101157 43.779697292629336, 1.1781914941325908 43.79651230401133, 1.141726493787786 43.819000438914358, 1.1242535197709174 43.820449435278775, 1.1226975032668634 43.82057933801407, 1.0313385641221657 43.795795374687671, 0.97492944545047067 43.795059435207648, 0.92319946554889043 43.786335357606859, 0.93976452857842219 43.77365135881918, 0.94138356023049141 43.760044311327093, 0.95420855101133384 43.747120397325048, 0.994118438120978 43.727657341566683, 1.0047845440124092 43.700901426555319, 1.0213135229488159 43.688213379308436, 1.0266455197747462 43.67481227517716, 1.0244825864261031 43.660961264011448, 1.0444194879343627 43.651226303742916, 1.1022835876493104 43.638328264675962, 1.1187595845757983 43.625618390953221, 1.1405304381152632 43.5995373364935, 1.145813501390478 43.586113349766563, 1.1436454634628035 43.572281348757244, 1.0908685168003274 43.541637328705363, 1.0725615601820664 43.537761369042514, 1.034376492724391 43.543632339005924, 1.0338035477333563 43.516178328807328, 1.0050575509804958 43.473251283451518, 1.0027115568666716 43.429226401564492, 0.97402646302222706 43.386280346052288, 0.91861942601994429 43.380062264714908, 0.89971452957541942 43.381607367981033, 0.84174851429983732 43.397133385148194, 0.82285857955244524 43.398681304733785, 0.7860265775774451 43.393558419628093, 0.74722948869614925 43.404789373592124, 0.72931646476300216 43.398140395376672, 0.725183515949027 43.370418306769054, 0.70695752851537463 43.36651242371191, 0.68772752319267738 43.37073127026953, 0.65292151103236051 43.34925841853341, 0.63027847855877894 43.3203244324563, 0.592503537623088 43.2792353875909, 0.557774446188148 43.241459390535439, 0.5557644741903971 43.227596410012, 0.5648555534214097 43.214481338326308, 0.54667251485957991 43.210537434956407, 0.47603851861327939 43.1783602809961, 0.44786546685145368 43.135296292106332, 0.4532374202097742 43.121936376647213, 0.49055858167176325 43.121700333872113, 0.51004856848499 43.114788381826671, 0.52283641905290779 43.101913401375342, 0.53358349412894768 43.075195330656769, 0.53325345669171043 43.047741320458172, 0.49936257233733272 43.020771365167533, 0.508432529172353 43.007660341941076, 0.52789347269111886 43.00072832361947, 0.54568345866769619 43.007412329808247, 0.5587564615813676 43.021999280453983, 0.57721655557048734 43.023235292658924, 0.58995353636808545 43.0103643606668, 0.60633043405340459 42.967563345607019, 0.55371348954048472 42.881729321171591, 0.51722243824062275 42.876556270375417, 0.46065648577874185 42.88369740041729, 0.44326342482668224 42.874282268427905, 0.44665656172136892 42.8470723979229, 0.43337057464819395 42.805008378462944, 0.43846054402013124 42.764206422162957, 0.46900951329010354 42.69223027367191, 0.496865553092249 42.691753435582612, 0.60885544047317808 42.697055332994253, 0.668254434296216 42.685356341939254, 0.67966052812693079 42.693752318322439, 0.67875455335922652 42.719558429594443, 0.6625575480796897 42.752449344519007, 0.66555851248895692 42.772854283118235, 0.65015641337825514 42.783447340723583, 0.65525553578845575 42.795150380237814, 0.67252045420488571 42.804073360400778, 0.67115858772388037 42.823642380178981, 0.67105350380387563 42.838043277720132, 0.68235451371455724 42.844844337186643, 0.68875653591697983 42.857345275209113, 0.70175244208533627 42.860447275079153, 0.80209843266078451 42.835544322255387, 0.80433758265490951 42.865307362374821, 0.79018258500701677 42.921993360453868, 0.79962957661032874 42.936321385728846, 0.81838256782373264 42.934772410023456, 0.83726458167262763 42.963428284553473, 0.85538354896661417 42.967327302831919, 0.87415555033641112 42.965786424044964, 0.9285295261551596 42.977481366640731, 0.96288052670203683 43.001590293395523, 0.97448446697512736 43.029750319679849, 0.96763553007770042 43.056747382045344, 0.95496649298718239 43.069656334350228, 0.95707450810627392 43.08350734551594, 0.97429154909181648 43.0955692897419, 1.0131444363024684 43.081550355528137, 1.024487514985168 43.112430418355117, 1.0567514467889794 43.155571327970264, 1.0940974270662309 43.15515134433015, 1.111357416923596 43.16718336516179, 1.1304825143462551 43.162853273985334, 1.1520644984616126 43.136753385389213, 1.1881304615423289 43.114299398359677, 1.2022895076494535 43.087730416552759, 1.2213885541170555 43.083404373835506, 1.2392684862965098 43.089969390526917, 1.2735124667037496 43.116710343841149, 1.2830995702003918 43.131000348803369, 1.2667914963219857 43.143730288802274, 1.2291695167372154 43.14695339040928, 1.212831519464487 43.159664320251821, 1.237575526258496 43.20502836204416, 1.2560995154954639 43.206154361770004, 1.3128705312183229 43.198585327189548, 1.3478134869126279 43.219864380942525, 1.3784795094603339 43.24634535276617, 1.365865566619334 43.259311335540204, 1.3467284998389744 43.263649347615186, 1.3096354602535882 43.261451386293217, 1.2898684180130431 43.271240384691467, 1.3054025320986398 43.299602305877372, 1.323354456444406 43.306144263953186, 1.3422204524763401 43.304512382843555, 1.4002815185338591 43.286029406258777, 1.4165904725120981 43.273262326046918, 1.4432814361558144 43.233703422750509, 1.4618304202280115 43.234794394503027, 1.479186516987113 43.246769384865544, 1.4858985103505802 43.288273308792, 1.4985124531915517 43.275306269898167, 1.5182305618814382 43.265476434867693, 1.5558924979985989 43.262169371736647, 1.6138454877966524 43.2435533240572, 1.6391944752156178 43.286121288681287, 1.6860314520878035 43.302463334413247))'),
('Haute-Loire', '43', 'POLYGON ((4.4604544680073275 45.248329388393913, 4.44342858470543 45.275150430792891, 4.4243585815323172 45.271839319202641, 4.3868964280771365 45.254284319881364, 4.367329520538533 45.259132437819332, 4.35325654819502 45.299724402299248, 4.3408814644486142 45.313026407189355, 4.3391855120711682 45.340320415238395, 4.3306395666764956 45.353725391808936, 4.3107044253679021 45.364051427125034, 4.2537855528731541 45.348556389471995, 4.233995452016984 45.356128416391911, 4.2254204633278505 45.369529344503221, 4.1854744921250813 45.390121392326861, 4.12874149671498 45.371841366763491, 4.0903795291909546 45.367839376804611, 4.0529495873896622 45.350151306388668, 4.0335104703467266 45.352226405774005, 3.9953685277808404 45.345462310500452, 3.9828765667766675 45.35872629507783, 3.9436204178227 45.368293332298279, 3.8867805782928997 45.352646389414147, 3.8675255781349733 45.351963431944014, 3.8629145590919336 45.362739374294577, 3.804160502426214 45.374344370687467, 3.7527994603744332 45.336910380426943, 3.7337264648618884 45.3334734145606, 3.7138914789142632 45.340957431497245, 3.6877884219587145 45.381034361555109, 3.668525500902291 45.38031743223145, 3.6474235232356307 45.352172367644286, 3.628582522038954 45.345985265821, 3.5892695186357741 45.355453379820275, 3.5363035265292524 45.391769291253453, 3.5172625666506008 45.388298353533585, 3.4977995108922357 45.390281394476418, 3.4599395523127328 45.429866348727856, 3.4228845330401327 45.409259339207054, 3.384985498028044 45.399566271690574, 3.3265375400841037 45.40544938703168, 3.2898755733967562 45.428600413128621, 3.2333944625587492 45.409893363126471, 3.0815585833160242 45.376224439949894, 3.09426141624013 45.363060434713518, 3.1003825105759688 45.335956352208385, 3.087280464367808 45.308040289597656, 3.1262134406632356 45.304199357908161, 3.1637525148437931 45.31670029593063, 3.168735464076093 45.303218398634712, 3.2078594220351988 45.29663842024614, 3.2281904322485104 45.283786322390469, 3.2446914240102274 45.27077140606572, 3.2430354281651717 45.243320388206584, 3.2796005838709448 45.22017640290828, 3.2954964189877387 45.16607226569819, 3.3080925838121118 45.152900339563345, 3.3675524805435941 45.130661272912917, 3.3839825362587987 45.117618369413506, 3.3773745706955367 45.103672307465885, 3.3188065671344589 45.11502031470765, 3.3121915607725327 45.101081293558664, 3.3260765437917996 45.071521380480576, 3.3178544751355332 45.030113387435861, 3.3542224884787686 45.006950391981192, 3.3629655762359505 44.993606318319067, 3.3602164963988059 44.979824306980234, 3.372328430295255 44.972099318709425, 3.383150489877039 44.931472326256156, 3.4092535468325593 44.891452426667442, 3.4342865784115872 44.865062281146507, 3.4825324190958327 44.784862303799557, 3.5022135635927327 44.777412434736434, 3.5961075422952717 44.800190298504347, 3.6286265270305762 44.826034430089138, 3.6456844459663671 44.854046423581607, 3.6643735419319512 44.86022542848643, 3.6842694307879924 44.850025423466334, 3.68907248761451 44.836525396113885, 3.6834335119669674 44.808956268857187, 3.6958694986218177 44.795730304592595, 3.7151264349993767 44.793712411696376, 3.7524954738922531 44.80604137821156, 3.7715705816443972 44.806736305039394, 3.7839704842060939 44.79350629231557, 3.8230775442484344 44.781246325627265, 3.8278385323029624 44.76774242583555, 3.8221344292678054 44.740146367523963, 3.8269045703605684 44.726650388630716, 3.859279570763249 44.700447352334223, 3.89029956946365 44.693348291064368, 3.892228572276764 44.720783291106571, 3.8674875578222156 44.747261270590784, 3.8703454179986636 44.761036417150947, 3.9263924635992282 44.779445289329786, 3.9321574695428012 44.80701036812728, 3.9505045587134191 44.818592305904517, 3.9888394191625878 44.817215301706412, 4.0257435893238949 44.837627281104304, 4.0399045716506521 44.85453030246957, 4.0582794719759647 44.866092349990609, 4.1375984693904968 44.88245041353953, 4.1749305440904152 44.897365289382904, 4.2260115383754453 44.9373242860632, 4.2630554683901494 44.957687331910407, 4.2949295159681071 44.9997363896732, 4.3132204547694073 45.013992422781868, 4.3518575415011185 45.009742420690159, 4.3708384785711587 45.013069374077432, 4.3893304321742335 45.024597273724979, 4.3923315726034389 45.038356402468153, 4.3761715315168885 45.051548394879191, 4.356502532397684 45.059131335037009, 4.3480085128931307 45.07253631160755, 4.3548234779370318 45.086422350746616, 4.3923535750992642 45.101276323681574, 4.3915225848373041 45.114914350687783, 4.3791895698628878 45.128212307118687, 4.3595034968069513 45.135810384993633, 4.3586645856464941 45.149448411999842, 4.4165695219936936 45.1457822681371, 4.4354295333467633 45.151844395784153, 4.4491564504360781 45.179603272564762, 4.4604544680073275 45.248329388393913))'),
('Haute-Marne', '52', 'POLYGON ((5.4328364644924818 48.43248728188702, 5.4408955386597313 48.447235290802141, 5.42334846023698 48.474140294725132, 5.3819665181472942 48.486900334138326, 5.3401874750131526 48.507835268856766, 5.2552955094385254 48.574150439204473, 5.2133855074492885 48.59503943271163, 5.130985456540742 48.606815344492006, 5.1101344833463429 48.614521322606421, 5.0971625158934444 48.627853426910818, 5.0765954629050327 48.630092400885005, 5.0358714834502223 48.6264033744266, 5.0148585718866343 48.636795417230175, 5.0100264717656273 48.650325367976947, 5.0133965500446891 48.664035387149468, 4.9853525209182976 48.652465418729932, 4.9446174522055912 48.648735379619339, 4.8831305095396544 48.649944284749424, 4.86300245034775 48.643970343105579, 4.9013065073027917 48.617687393744276, 4.9068914448206158 48.59056430108275, 4.8245885569336053 48.599388358024541, 4.8048035606564383 48.587982440213793, 4.8096585433731036 48.574466395044382, 4.8307045466904128 48.56409037005777, 4.8356994652804417 48.547855344465447, 4.7806094402378676 48.510990426756692, 4.719124433791535 48.514831358446216, 4.6777065836286909 48.524658377157223, 4.6448915333097034 48.526500426106892, 4.6387174569639456 48.493614439741393, 4.6453954784738585 48.450149301347935, 4.6924544165238444 48.413219432271532, 4.7338004505403433 48.403404382918225, 4.7755985038308779 48.385406341341209, 4.852634522279601 48.3191913263545, 4.879431449943155 48.276214291328174, 4.8752314375219612 48.205196395534884, 4.8889194541986569 48.178241401941406, 4.8742064732568906 48.1506002825184, 4.8685254288373585 48.106807394947239, 4.8487575064969519 48.098114296860572, 4.8074915615652287 48.110687403069321, 4.7667385388159289 48.115093358851354, 4.7262345843192861 48.114021397255229, 4.7270185772501918 48.100395339606749, 4.7440094325787356 48.087215316553412, 4.7581934735211178 48.05211235870955, 4.7553834907755288 48.030201393276755, 4.7433164419705349 48.007290282394152, 4.7609974715878138 48.003063338918068, 4.7810405131358777 48.006309323120732, 4.8013834927069183 48.0041162903578, 4.8029474301094695 47.976852381723077, 4.8232914658002812 47.974659348960145, 4.8440744952876 47.964283323973532, 4.825419547195537 47.93651529415466, 4.8261864661896823 47.922889412526146, 4.846948549301004 47.912498425842372, 4.8878925537139537 47.902633386818579, 4.8967134422963454 47.88921327253091, 4.9511784204377989 47.852356275720652, 4.964852531537133 47.822685294043723, 4.9615424760666826 47.808948343816311, 4.9502045019630145 47.79501741958579, 4.906826493452968 47.777546381788554, 4.8955105218451251 47.763618273877526, 4.9160605008967764 47.7559622854336, 4.9295874593041162 47.729004299500659, 4.9495294653914073 47.732216311849768, 4.9584684633713039 47.716083377838046, 4.955309433032113 47.699604388572155, 4.960050530830415 47.686077430164815, 4.9728244758209712 47.672748318199851, 4.9933374906796644 47.66507736805876, 5.013419432640319 47.665573392324418, 5.0329335341889987 47.676944282161813, 5.0531564681428449 47.674717277545383, 5.1146414745891775 47.651600399321907, 5.1653375132074189 47.682811379685987, 5.1820935579006289 47.669563412925569, 5.1867695283113164 47.656009347443373, 5.2477815691075875 47.641025295753153, 5.24922352467334 47.611019348079921, 5.2694084383144286 47.60876030782957, 5.2889584479362668 47.620102330392442, 5.3130335788574712 47.620632326511654, 5.3539024227447385 47.605140281198047, 5.3848145212056409 47.606300428797411, 5.4235554597175906 47.663944327534253, 5.4431494743310509 47.675254314463231, 5.48342847531049 47.673370372761539, 5.5273924542890995 47.679718356834243, 5.5683625096571063 47.661434282811641, 5.588553583997026 47.659095329496481, 5.6484785254800443 47.668449382557455, 5.675471539386308 47.696254376569286, 5.6891574438234329 47.756542271223296, 5.7047035272667586 47.770469323014524, 5.7110115548070439 47.814247424908487, 5.7660364524620036 47.850734427749117, 5.8066474270983122 47.843269420968866, 5.8467365025338722 47.849434344276389, 5.86627049433875 47.866130366161016, 5.8737374373386331 47.882644383400233, 5.9131894965153435 47.907863292063936, 5.9167334825213231 47.921558349539296, 5.9076554287678675 47.948681442200822, 5.8867734760593464 47.967422288036559, 5.8701205790665085 47.980777274936585, 5.8500185708296613 47.977718399958363, 5.8104635399725453 47.955185379963851, 5.790470488094968 47.949386402166752, 5.7699784196123005 47.95720327286007, 5.7446845264428816 47.98401234590132, 5.7349984997250374 48.024761320191388, 5.6735555620507228 48.042728382254282, 5.6321125410326545 48.066494422114275, 5.5912885822368708 48.073894301506911, 5.5947804663327361 48.087585310523039, 5.6640705501346531 48.176189361171666, 5.7039644194273365 48.19329427743854, 5.703413476932127 48.206916286627788, 5.6779785917695165 48.233734336687334, 5.657553586894096 48.236072409902661, 5.6233814226332015 48.276321311467839, 5.5821945106664543 48.289169360864278, 5.5520014537687814 48.329498351514232, 5.5310925700053986 48.3427044255226, 5.4900475301316476 48.35007138918148, 5.4495015068629868 48.3465154338178, 5.4360664308781566 48.3735082717041, 5.42323545541845 48.386875403981819, 5.4024094770593081 48.3973463037304, 5.4328364644924818 48.43248728188702))'),
('Haute-Sane', '70', 'POLYGON ((5.3848145212056409 47.606300428797411, 5.402668578450033 47.592548340852872, 5.4420384363023686 47.609729297745261, 5.4624644972975887 47.601989347777319, 5.4797204386957219 47.575035410303613, 5.4935325494488438 47.534366349078354, 5.4868224923050093 47.504223281851196, 5.4753794342813364 47.490341291171362, 5.4557405345763925 47.481735322968106, 5.3960664215456688 47.47228639514519, 5.3814375781478816 47.441951290134554, 5.4222905802381547 47.423710341003741, 5.452076502953247 47.383388391152479, 5.46865547156014 47.370079345463679, 5.5087234245997081 47.368175337485795, 5.4980435891508819 47.337909408322005, 5.5106084224212282 47.324531362806354, 5.4911124509291085 47.313198317261751, 5.4956965389172581 47.29965639715725, 5.504986520710446 47.292183293458535, 5.5242175821529145 47.286598355940711, 5.58163459115292 47.249496339337057, 5.6018124639953442 47.244449318836942, 5.6217435568447058 47.244846419881426, 5.6809744515997238 47.259632273089338, 5.7208614561137381 47.260376309487825, 5.7530634288893054 47.252796361669439, 5.8317774456789095 47.281509442688574, 5.8912165720543328 47.29346841523413, 5.973963558316882 47.324894315977318, 5.993846421695423 47.327953366975507, 6.01388154234499 47.325538373034831, 6.0536294910854167 47.33164239343391, 6.1165495883188044 47.362644438097718, 6.1759825539953965 47.379921325871877, 6.2111824988407989 47.404995370103094, 6.2547675068314845 47.419265308789122, 6.26236452858663 47.433033414550621, 6.28212453002854 47.441497334640886, 6.3209545346435618 47.482952325016655, 6.4006035694953027 47.500385342501133, 6.4203415684413869 47.51157035525388, 6.4402874469679148 47.514537347809593, 6.4690394283996682 47.487610341390777, 6.5891035276649745 47.491764412600716, 6.6048324958535147 47.505577403453643, 6.60443645092883 47.521949372579925, 6.6242895669330153 47.530361366780042, 6.664600427526409 47.519882370113024, 6.676317548637968 47.533661389112424, 6.6596674679645957 47.560756318579323, 6.6794885483348878 47.571888349322151, 6.6996565640591825 47.566639433920429, 6.7402795080531916 47.542507272530045, 6.7805755829693908 47.531986383111004, 6.8206055156962009 47.535095423779708, 6.8363244507466447 47.551612433358358, 6.8074585843965849 47.592266356866489, 6.8228795176437131 47.625148294772757, 6.8225424394078118 47.641517271559607, 6.77728946621437 47.695640418926061, 6.7683995778050985 47.736484267978071, 6.7721565479705816 47.7501673560957, 6.79974943792277 47.777706383938138, 6.8476624248503128 47.799984351001157, 6.7666664852147278 47.821037395117131, 6.7259215593838917 47.842449343944836, 6.6356914362845316 47.909687386977012, 6.6153255741178612 47.917652290462186, 6.5750984990285417 47.911747348645221, 6.51127647548671 47.880989443675006, 6.4911214852399155 47.880752344780078, 6.4505015335853386 47.891166390079476, 6.4295975783809922 47.918190383499834, 6.4089764872628621 47.934280368639733, 6.3885764772226992 47.942215348730585, 6.3481904561036231 47.941673383253672, 6.3079894319693608 47.935691344691364, 6.2238635052890459 47.912696272284748, 6.1831745538075609 47.923019315261442, 6.1536385794449586 47.963489297904559, 6.1446854998677054 47.990631400722478, 6.1321224267970535 48.00409340776217, 6.1116495444907457 48.011959388026142, 6.0714985100269416 48.003158389700005, 5.9719794612542216 47.95794343681932, 5.9517954277129945 47.957607414703219, 5.9432535307775538 47.9710963527978, 5.9229374822614034 47.973491280462312, 5.8867734760593464 47.967422288036559, 5.9076554287678675 47.948681442200822, 5.9167334825213231 47.921558349539296, 5.9131894965153435 47.907863292063936, 5.8737374373386331 47.882644383400233, 5.86627049433875 47.866130366161016, 5.8467365025338722 47.849434344276389, 5.8066474270983122 47.843269420968866, 5.7660364524620036 47.850734427749117, 5.7110115548070439 47.814247424908487, 5.7047035272667586 47.770469323014524, 5.6891574438234329 47.756542271223296, 5.675471539386308 47.696254376569286, 5.6484785254800443 47.668449382557455, 5.588553583997026 47.659095329496481, 5.5683625096571063 47.661434282811641, 5.5273924542890995 47.679718356834243, 5.48342847531049 47.673370372761539, 5.4431494743310509 47.675254314463231, 5.4235554597175906 47.663944327534253, 5.3848145212056409 47.606300428797411))'),
('Haute-Savoie', '74', 'POLYGON ((6.8141605446219558 45.775673414759709, 6.8208774665444878 45.826866357743441, 6.8473735760852605 45.829666307350934, 6.8766735076727628 45.823963436455543, 6.8905695799498972 45.837062314304305, 6.9220695850989955 45.849865302589322, 7.00624743766943 45.875454381242619, 7.0012984602906556 45.876316351018673, 7.0111474814975168 45.882263361607627, 7.0131414356782784 45.905361405694677, 7.0425835913987385 45.93272740591, 7.0446465454064082 45.956955322162159, 7.0065424471333131 45.968250347393976, 7.0212445148371785 45.983253409240589, 7.0029475913570138 46.0061534308653, 7.01163857720411 46.007164313533039, 6.9680664186709862 46.053352304788646, 6.9480594612160473 46.063648416710478, 6.9421675448766109 46.072452407376048, 6.930766555624956 46.069946411112667, 6.9045684478874989 46.05135342204882, 6.8892645679181044 46.059452276728521, 6.887770510442266 46.071449269586836, 6.9047645341302086 46.09074739463658, 6.9032664281951384 46.126548271647707, 6.8796674312833659 46.133648389037361, 6.8224734395809321 46.132740302030058, 6.7948694603708759 46.145046385949584, 6.7959755698404933 46.16164436471287, 6.8200714711177568 46.18114139232479, 6.81697756816618 46.212543354352519, 6.8341694382964988 46.240837331831344, 6.8591704342416335 46.260242301000787, 6.865970437588345 46.288139353455094, 6.8639754272877838 46.294536271078485, 6.8076735047756927 46.327133408678932, 6.8057784738161047 46.335331362599774, 6.7929735493114549 46.34043541356904, 6.7784795372080282 46.355034333572533, 6.7813775299368615 46.36142737875663, 6.8105685051651221 46.372528429985366, 6.8145754236830385 46.381633414793711, 6.8126745840645526 46.398231393556969, 6.8274685341909276 46.417530398706546, 6.8220754584366432 46.428920298700334, 6.73887645290003 46.448326323989548, 6.6695784481996441 46.457023294515508, 6.5163954881531367 46.456321326889011, 6.4387004509497388 46.418922364601812, 6.3358055152390875 46.403629397870347, 6.2559095243742888 46.350933420392451, 6.2373154791906416 46.324035281248158, 6.2228154824083788 46.312931413699957, 6.2499074195358162 46.292534395999226, 6.2505125761807392 46.285736328872119, 6.2412125612494833 46.278335393359683, 6.2434154511305167 46.271038309627514, 6.2714144191454579 46.256332369484383, 6.30250447379251 46.264438440982715, 6.3115015583613854 46.256637412086391, 6.3085104510702479 46.244842314129656, 6.2842135349912382 46.222141371087091, 6.243709580494567 46.209247380479368, 6.1904105586113758 46.172340393998624, 6.1488224971409124 46.1541483784185, 6.1356155430327135 46.150547361943367, 6.0733245411596783 46.152843366386705, 6.0432214304649108 46.1410403475315, 5.9853525782108363 46.144939365809947, 5.9950185386524879 46.12630430797411, 5.9607015099591649 46.10112042728376, 5.9222154483587133 46.084064268547635, 5.90288458359521 46.07827039532954, 5.882977429461306 46.08884831521776, 5.8785934761750696 46.102432304094251, 5.8587595463472439 46.110271353303361, 5.8397294997065217 46.096271429245988, 5.814487532427222 46.03844429372397, 5.8177894909792371 45.948314325985578, 5.8735865882273117 45.913799274829884, 5.8818544220748947 45.900287278119706, 5.8798794780504977 45.84560033880048, 5.8842664236761379 45.832004380566261, 5.9002905773485566 45.818622286591378, 5.9392494285790747 45.816581335079533, 5.978645513406434 45.800865392368493, 6.0391405835610215 45.733547436271536, 6.0748715806454356 45.709533384278714, 6.0860745474347766 45.723377354645763, 6.0891015627990726 45.750744410980886, 6.1279864856436461 45.748642380540659, 6.1476514363036188 45.740757390120294, 6.1635905723321969 45.7273173855764, 6.1721645049015592 45.700138318565521, 6.2113565825877117 45.687057394753353, 6.2307715848952228 45.687355396556669, 6.2388945543103205 45.673805379533732, 6.2586684613295915 45.660442295715214, 6.2975035705236166 45.658271441468074, 6.3206274895457568 45.664047360649576, 6.3397004850583016 45.675266345255878, 6.3621585205470694 45.705616411963675, 6.3647864986472484 45.752117366719759, 6.3722015157570127 45.765892337259928, 6.414486440274942 45.782848340635113, 6.4448655502772283 45.810562332324267, 6.4858514474422293 45.882122369614436, 6.51632842454589 45.909828440405093, 6.5553295205683639 45.907581369512471, 6.5712125062276243 45.894096303857154, 6.5524075891240727 45.866546362776816, 6.6045114354345742 45.798854364250971, 6.64332154979337 45.802028356287323, 6.6628694471756091 45.796795282682595, 6.6748115218043722 45.783256354917526, 6.6912125342251159 45.742443309359643, 6.710732444432665 45.737209355655082, 6.7300775668134634 45.740142376357269, 6.7877285063489978 45.77078639640915, 6.8141605446219558 45.775673414759709))'),
('Haute-Vienne', '87', 'POLYGON ((0.61320049334679538 45.685100404765549, 0.66564757859202928 45.698795286220971, 0.68567143396373353 45.694557429506958, 0.71229058146110447 45.668792330887143, 0.7322734241806188 45.664543384915234, 0.753289504103634 45.652153339471667, 0.75113554777328773 45.638301272186155, 0.73742957705997014 45.623722418458883, 0.7468434769095893 45.6105883366168, 0.76613051270143728 45.611801290206117, 0.78644251275832744 45.604828435252287, 0.805742574027704 45.606014281766747, 0.84633348238781991 45.592052378022132, 0.86429244753225021 45.604118370707326, 0.87418952218996537 45.618450268421569, 0.93141449340649274 45.62739929953959, 1.0089574493587747 45.629345376289464, 1.0392554141564858 45.603733415040537, 1.0579645763982342 45.577434271842307, 1.0962274446811193 45.5824393995904, 1.1161405834938876 45.578140287928036, 1.1254884758560308 45.564960440894666, 1.1274215271284049 45.548633356859867, 1.0953535055473367 45.491901417569565, 1.1046765790942175 45.478740404672649, 1.121687500698954 45.466045316627074, 1.1406304174562365 45.46989029677583, 1.1813795677662711 45.453098344009433, 1.24069442404533 45.442855390117515, 1.2708644223273495 45.450077313324, 1.3071634358437336 45.471374321113572, 1.3453564241999061 45.47630340823612, 1.3633785805123182 45.488289311836567, 1.4012915211017685 45.495918369225606, 1.4236434165507035 45.538303273084537, 1.46097144279139 45.551372403558943, 1.4594275716650031 45.564979275031092, 1.469484472452308 45.579258366755383, 1.4893895143466409 45.574890431286107, 1.5460705838665945 45.588993327023914, 1.6042634888790417 45.589443410078317, 1.7350065434933413 45.637649294230172, 1.7900465788654287 45.66798739158024, 1.8486175747659672 45.665596336354994, 1.8864205028763195 45.6757893005764, 1.8808364454583284 45.691959374801073, 1.8639064930382006 45.704746345269129, 1.8687315523605434 45.72193539908001, 1.8828214226208217 45.746833423344711, 1.887118422043585 45.779937322428751, 1.8817874813374544 45.793365357614917, 1.8648474957792303 45.8061753866986, 1.824931447970755 45.815025318575451, 1.7856365746241636 45.854057394112047, 1.7579604272278004 45.89367632021704, 1.7035975406669479 45.855167376020958, 1.6651125351863243 45.850341436598782, 1.6454144927726304 45.852020315039468, 1.5848324687545698 45.870659421334565, 1.5755664256768682 45.883838388268074, 1.5958155866057382 45.912357319264132, 1.5904195185119931 45.925766344293905, 1.5330965041740967 45.914394398336711, 1.5121494240779896 45.926944269909896, 1.5067415626464822 45.940357343398873, 1.5090914291995716 45.954193392867452, 1.5230955777361714 45.968666282574887, 1.541602493036379 45.977901346138495, 1.5492144764886859 46.049553441871169, 1.5321174811203093 46.062320346063061, 1.5134935125423397 46.088691305407636, 1.5127744709791102 46.129753419218119, 1.4855605520148458 46.1967432740975, 1.4648234637387816 46.206566420369242, 1.4066015154318734 46.200588430266194, 1.3855324534989393 46.213112426904289, 1.3761495331634421 46.226284353039162, 1.3823904970965089 46.24033743512642, 1.4143974397491945 46.26953932359261, 1.4206544214991936 46.283588357220637, 1.4228235155466393 46.333019340339504, 1.402804588734 46.370254428037853, 1.360815553779787 46.392574287852895, 1.3406144463017711 46.396915292267281, 1.3216805065627852 46.390373334191494, 1.3076154551177694 46.375869288949971, 1.2890034558975572 46.366603421892236, 1.1895835063659774 46.374626411966361, 1.1687165153546175 46.384384430850488, 1.1471924418082153 46.366710442031874, 1.1282965223819872 46.360111277466942, 1.0683025810720892 46.367588429624888, 1.0490935221254176 46.363708421502807, 1.0227864580286905 46.321048398436218, 1.0049084620688404 46.306293348722434, 0.98570045924196847 46.302414396720181, 0.92576654074065345 46.309799314415656, 0.8880495103739463 46.296573350151064, 0.87412351470251792 46.282016322899622, 0.81930244816879849 46.248562320102153, 0.80149943671469259 46.233753408278645, 0.82598046967871142 46.163948290054677, 0.82549958313018124 46.136509417573208, 0.80773247974926221 46.121715291426867, 0.80555352858365836 46.107872377179618, 0.808958458816079 46.080665322994079, 0.82402541591054046 46.054161292554809, 0.83740258132635859 46.041271350406291, 0.89773043251275908 46.028469418241073, 0.918519446678971 46.018745371210471, 0.95462642241187723 45.979793384758651, 0.95241349939274755 45.965965432208534, 0.94242454231252282 45.951648320171486, 0.92401056555462446 45.942306412488207, 0.86274945650572477 45.963283415978637, 0.84435642612382367 45.953945380734623, 0.847243505614756 45.899276395451963, 0.83123941821853009 45.870868357034809, 0.81743346816423923 45.856311329783395, 0.78107249561963954 45.834873330000633, 0.77115658682552635 45.820545304725627, 0.7528205869128044 45.811191427684619, 0.71169052939521293 45.827850309356322, 0.69790658183674736 45.813259310251325, 0.68588846658244051 45.78507640137137, 0.66755352278951818 45.775711435072466, 0.63658756221886392 45.743602400839208, 0.6267315002133671 45.729252373068405, 0.61320049334679538 45.685100404765549))'),
('Hautes-Alpes', '05', 'POLYGON ((5.8037575312879426 44.717132284960954, 5.7943735548326458 44.682315359562708, 5.7834485235704562 44.668438297441938, 5.7461525329636913 44.645855287776939, 5.6700955375687556 44.641628344300855, 5.6314945349301979 44.654495403853687, 5.61267852856875 44.6486554134044, 5.6137594671831721 44.621345387538426, 5.6034114293712491 44.593780308740961, 5.5637435697155695 44.538276284737108, 5.6411275796381233 44.504329426033379, 5.6454515101157483 44.490768319752547, 5.6265714324865144 44.487644317386682, 5.6086624570125707 44.459942295055257, 5.5899064734597346 44.454063404193349, 5.532430497770946 44.466545332059454, 5.4549125366538647 44.503139355039721, 5.4359194542061289 44.502716379060175, 5.4262524376446777 44.46148634220161, 5.45834052550191 44.421203292762939, 5.4398295617424708 44.409839267704243, 5.4014515764014845 44.419922395466543, 5.3982464288310723 44.406173299861464, 5.4032064954677139 44.378952340098536, 5.3967895115681586 44.351448340229453, 5.4049344834790816 44.337963274574136, 5.4239875887354 44.335651428333833, 5.5010845100925394 44.304538315071156, 5.5611034462376949 44.319496315806319, 5.5800194319401157 44.319889368391571, 5.58488955237388 44.292640421453982, 5.6043464474334144 44.279377316976465, 5.623466440277042 44.274307413880692, 5.6391424264556633 44.260948378521405, 5.640706539878181 44.219974274694167, 5.6487934252001537 44.206470374902452, 5.6755574371299815 44.198814386458523, 5.7510325105155573 44.203045378393838, 5.8079175871767461 44.1986693460061, 5.8269995597075877 44.193561422597568, 5.8647924546798436 44.194259341764834, 5.8756405652166848 44.208126370747507, 5.8176984886565322 44.242607274029652, 5.8053885322977408 44.269687417819355, 5.8086915469695555 44.283435281284696, 5.8233355280844421 44.297371310094221, 5.8420615882429843 44.303196338846377, 5.8610814257256436 44.300815316759227, 5.8767054860141457 44.28742935034505, 5.88095055954679 44.273838320669896, 5.9002305545399736 44.263260400781704, 5.9188835664124042 44.271793320698848, 5.9221934458629164 44.285522350027762, 5.9099135889183856 44.312652307467985, 5.9132354377265983 44.326381336796871, 5.98678150829906 44.39601941207259, 6.0801065904697964 44.444061421635595, 6.1185614965361594 44.428287392335633, 6.1303685638506238 44.41481042359878, 6.1685305726926742 44.407222378861931, 6.1840944341526267 44.3937873028771, 6.2080114991439075 44.3531453487267, 6.2270575636015622 44.35071134462963, 6.2414464917849841 44.378276423427096, 6.2435254636095863 44.438434415345782, 6.31913343206989 44.450496359571773, 6.33788448706369 44.458965384241068, 6.352706424364726 44.472820267846046, 6.3671955079090878 44.500377425745015, 6.38597243783795 44.508838353495847, 6.4015225697405072 44.495376346456155, 6.4136125011411593 44.468197279445278, 6.4328014938116667 44.4602622993544, 6.45176042838591 44.460510311487226, 6.5057695148140624 44.425678424391819, 6.56292654232351 44.415451312296895, 6.6008625415285564 44.415912308589228, 6.6385614418387036 44.42731136162125, 6.6720925413814882 44.457737292934624, 6.6860775037417284 44.515300398506852, 6.84776944498995 44.612655281791163, 6.9271674753694583 44.646202399150937, 6.9560585125747423 44.650421421728524, 6.9534634502082895 44.65362533715917, 6.9667554219603289 44.661132412711439, 6.972259566313511 44.671928421338166, 6.99960250791321 44.686771305015228, 7.0348494500896948 44.6910283479056, 7.07694057662448 44.684730353503383, 7.0657314491363081 44.707538316685614, 7.063343562270461 44.712429383495376, 7.0417425679987105 44.724624398816033, 7.0242505838254488 44.747226418637425, 7.0255425703797414 44.77362430903689, 7.00914349417863 44.793018364968376, 7.0220494541440814 44.823017271842943, 7.0012725853555935 44.837719339546808, 7.010950515154974 44.846515409313909, 6.97125854076387 44.851520361042034, 6.9486605694017385 44.863617333241322, 6.9391574274291088 44.862217270427593, 6.9129624880510505 44.845317417421754, 6.8694704186027025 44.853916344826345, 6.8253775930085965 44.872314303767283, 6.8123744700216378 44.8866153979874, 6.7622804196888922 44.913612284332928, 6.7627734516151179 44.970710345153591, 6.7494744390644428 44.99051241536749, 6.7541715318710942 44.996616435766569, 6.7497784255466229 45.016109414919256, 6.7395784205265272 45.0236054012136, 6.6869855907490319 45.020313299779716, 6.6763854923450481 45.033603335312122, 6.6706875500087222 45.060707417817255, 6.6536854294023158 45.0837093550026, 6.6352825419023134 45.097206390015614, 6.6308795784596839 45.108898340271949, 6.6085604227245085 45.102062428852051, 6.570022435233966 45.107059283661712, 6.5509114194086351 45.104107428823127, 6.4939305878856715 45.078788364798513, 6.4748095389222442 45.075809402885071, 6.4639605482855984 45.048339374869514, 6.4489685756968811 45.034477274445905, 6.410338529763834 45.044906281442437, 6.3719455827256866 45.047119380481533, 6.352397509323481 45.060512387694374, 6.3443495244141275 45.074066277156575, 6.3474624375220685 45.1014322773719, 6.3317274846546638 45.11488337117369, 6.2938055670469453 45.0979463779549, 6.2746125259172061 45.097679355665676, 6.2664744187849806 45.113937439873595, 6.2439825874626536 45.094478432574434, 6.2367104985657136 45.0807032860143, 6.2378845517424111 45.03971826894913, 6.2234044452163459 45.009430337289515, 6.3003445327832992 44.9996453873505, 6.3160655800733707 44.9862023904672, 6.3248304943063829 44.945320345082436, 6.3603634689284547 44.904823431384457, 6.3649135850630785 44.877552305931076, 6.3579854391807373 44.850113433449607, 6.3391884429756828 44.838916275319164, 6.2814685036132971 44.8517613323762, 6.2624435615516063 44.8487432940302, 6.2287565083184688 44.82363932640466, 6.1904695253001591 44.825782369497077, 6.1325024539047774 44.84674828372961, 6.1135005704586831 44.843723380604914, 6.094902476815804 44.827022430161222, 6.0571324644392064 44.812721335941106, 6.0379455840082983 44.81513632988181, 6.0185004822865267 44.825752270082788, 5.999500535060065 44.822689346645333, 5.9428374195766764 44.80258927462809, 5.959030552416948 44.775524268555515, 5.9594804594513846 44.761867407412879, 5.9028034383906345 44.744457272524087, 5.84550154644873 44.746139319324172, 5.8265404996348877 44.743061434189556, 5.8037575312879426 44.717132284960954))'),
('Hautes-Pyrnes', '65', 'MULTIPOLYGON (((-0.14165358360619965 43.330040384270667 0 0, -0.12866751517921671 43.317253412100357 0 0, -0.10942642059862351 43.3131604198188 0 0, -0.091632562182809352 43.319934372210483 0 0, -0.0749134816825574 43.334873362789253 0 0, -0.073051538736189331 43.348743365375171 0 0, -0.080421498475004682 43.375648388034378 0 0, -0.10634448700477606 43.401249436045376 0 0, -0.12343144923505633 43.389038402907758 0 0, -0.13272247914094712 43.374622388867934 0 0, -0.12346048056034122 43.361564330483283 0 0, -0.14165358360619965 43.330040384270667 0 0)), ((-0.17575356295833658 43.305584347855017 0 0, -0.15833742740285528 43.260158348104717 0 0, -0.15836245101551485 43.23270027998629 0 0, -0.14022252190159179 43.236759305389327 0 0, -0.10542143830031137 43.255771397993456 0 0, -0.10355756076336477 43.269642293982315 0 0, -0.11831648502786152 43.296020299558634 0 0, -0.17575356295833658 43.305584347855017 0 0)), ((-0.38507051097350548 42.87530530287026 0 0, -0.36772850465280271 42.821354296634141 0 0, -0.35398345750695626 42.829654342135584 0 0, -0.28707950037124874 42.842857423804517 0 0, -0.25868448743162276 42.826755293286951 0 0, -0.2298805801097501 42.822647339308233 0 0, -0.20748555976899752 42.797756355842196 0 0, -0.17978652977700449 42.788353369230506 0 0, -0.14439155480869204 42.804355344387133 0 0, -0.13618849630881869 42.782356368971065 0 0, -0.11199648812981877 42.753349334607847 0 0, -0.098899546500717861 42.727859355195719 0 0, -0.06179752989703502 42.722557281764111 0 0, -0.0563014824623167 42.702163432422751 0 0, -0.044801569989459722 42.693454316519123 0 0, 0.0023024291719480061 42.69065436691163 0 0, 0.026799479952927641 42.700756328810385 0 0, 0.051595412637027493 42.699855282601746 0 0, 0.078991512266640029 42.708255307444162 0 0, 0.12569541804415962 42.7002603045447 0 0, 0.17008941380098008 42.726051278099604 0 0, 0.19388854541466571 42.732254397739823 0 0, 0.26398550474311833 42.70735126889609 0 0, 0.27697648235238148 42.6835553056418 0 0, 0.2940815746392218 42.674663304992933 0 0, 0.30737653873066506 42.67556030274234 0 0, 0.32818051459400976 42.686653433072578 0 0, 0.343680480806114 42.706356404045309 0 0, 0.36527953885826037 42.71685441086872 0 0, 0.38027855224564178 42.714058333700493 0 0, 0.41367253223450007 42.693157370835607 0 0, 0.46900950170826089 42.69223026194436 0 0, 0.43846054402013124 42.764206422162957 0 0, 0.43337056271087304 42.805008389552157 0 0, 0.44665655484001632 42.8470724126696 0 0, 0.44326342168566862 42.874282288682409 0 0, 0.46065648577874185 42.88369740041729 0 0, 0.51722243824062275 42.876556270375417 0 0, 0.55371348954048472 42.881729321171591 0 0, 0.60633043095074779 42.967563352295805 0 0, 0.58995353636808545 43.0103643606668 0 0, 0.57721655557048734 43.023235292658924 0 0, 0.5587564615813676 43.021999280453983 0 0, 0.54568345866769619 43.007412329808247 0 0, 0.52789347269111886 43.00072832361947 0 0, 0.508432529172353 43.007660341941076 0 0, 0.49936259203916883 43.020771356480985 0 0, 0.53325345669171043 43.047741320458172 0 0, 0.53358350846995273 43.075195324400013 0 0, 0.52283641905290779 43.101913401375342 0 0, 0.51004856848499 43.114788381826671 0 0, 0.49055858167176325 43.121700333872113 0 0, 0.4532374202097742 43.121936376647213 0 0, 0.44786545797604838 43.135296294010253 0 0, 0.47603851861327939 43.1783602809961 0 0, 0.54667251485957991 43.210537434956407 0 0, 0.56485553711016967 43.214481343822733 0 0, 0.555764484923206 43.227596406415252 0 0, 0.557774446188148 43.241459390535439 0 0, 0.592503537623088 43.2792353875909 0 0, 0.63027850528404594 43.320324431322533 0 0, 0.5898324346311199 43.314922379683694 0 0, 0.55172745625819175 43.320633347497548 0 0, 0.53318850532406259 43.319400327632039 0 0, 0.43197649651332881 43.351040268654529 0 0, 0.39521155814554731 43.345810363409171 0 0, 0.375975568144014 43.349987317214769 0 0, 0.35939554341732105 43.362575385120678 0 0, 0.32159842396586669 43.365482354867808 0 0, 0.30408250107717549 43.356052437201285 0 0, 0.2855484787021112 43.354782277122851 0 0, 0.26718942017376435 43.380958382364483 0 0, 0.15779248291968884 43.387092326157884 0 0, 0.15759358035751347 43.417274293797632 0 0, 0.13761443405729779 43.426864389633735 0 0, 0.11902549345268199 43.425544415904781 0 0, 0.10982545528627956 43.438617422369269 0 0, 0.12480353397412018 43.467147437032217 0 0, 0.11187855475193942 43.479972429853248 0 0, 0.092202514834070826 43.486824359090079 0 0, 0.090420488692984691 43.500427358122963 0 0, 0.081175568011275345 43.513500361036662 0 0, 0.041474440581907857 43.52990330967701 0 0, 0.015500582281816833 43.5555233678444 0 0, -0.008560467042059372 43.595008342754866 0 0, -0.025261417485751281 43.607551349549325 0 0, -0.11649855081358851 43.614738420802453 0 0, -0.12582144834050268 43.600326434003406 0 0, -0.15376953410754543 43.584587422881462 0 0, -0.12511754449437262 43.56742830226024 0 0, -0.0712725340205583 43.502655410598848 0 0, -0.073153458037296559 43.488784341417315 0 0, -0.10329546914465482 43.461895355311285 0 0, -0.1088814594167038 43.447765344922324 0 0, -0.095897525971651021 43.434959371874172 0 0, -0.077334460302125763 43.43630926899742 0 0, -0.042026439197258014 43.452564360865907 0 0, -0.016099580525967949 43.426963328268435 0 0, -0.017630439866511145 43.410377308220774 0 0, 0.0045655178815309228 43.384510289268931 0 0, 0.0063774433860724136 43.370910274184475 0 0, -0.010722520290869397 43.358696433118425 0 0, -0.029263583464597787 43.357380331828736 0 0, -0.047075571936971983 43.350597402418757 0 0, -0.0564475713980242 43.308742335983254 0 0, -0.054300469202031174 43.264957338965914 0 0, -0.063600502414146831 43.25054131672816 0 0, -0.097676559773304916 43.226135268269886 0 0, -0.12509642209838034 43.180214299303472 0 0, -0.2226535523242319 43.101654299984617 0 0, -0.23185358791451449 43.059776333629273 0 0, -0.24918345769859229 43.050262278418714 0 0, -0.30452043875419577 43.046142355082296 0 0, -0.32145848809278732 43.033893301631892 0 0, -0.32695156041029111 43.019745334734239 0 0, -0.3046975353388045 42.966480289977639 0 0, -0.31022348566955316 42.952324417005272 0 0, -0.32711858613629374 42.940078355894329 0 0, -0.37970050267588817 42.9169123681002 0 0, -0.38517753995421344 42.902763355131171 0 0, -0.38507051097350548 42.87530530287026 0 0)))'),
('Hauts-De-Seine', '92', 'POLYGON ((2.1792645691410542 48.877586330934761, 2.170458466235857 48.844402342765946, 2.1774325533294814 48.817424290556815, 2.226188499876713 48.784191368837313, 2.2480874959517791 48.771568272958078, 2.269105512094427 48.767070434753506, 2.2828114828077162 48.754051293949587, 2.28013457115685 48.74027632340939, 2.3008565217157866 48.7384913049289, 2.3370235202572758 48.746154334171464, 2.3383665526018547 48.772987345928172, 2.3557395472777216 48.803802281367567, 2.3458764444735607 48.819732440377848, 2.3038045041151065 48.828750295302754, 2.2819085003794441 48.841377439641249, 2.2722795041307791 48.854599355446609, 2.2515075639013276 48.856380325467867, 2.283275471439481 48.890281418980308, 2.28442241754135 48.896103279373065, 2.3425565318849522 48.931526417536034, 2.3329145101587585 48.944736363983665, 2.3121325367912107 48.946521382464184, 2.287786511141519 48.942680274754721, 2.243786448069784 48.929729429697787, 2.2050754329521567 48.906078330875928, 2.1792645691410542 48.877586330934761))'),
('Hrault', '34', 'POLYGON ((4.0781795853112328 43.557953323482266, 4.0747244893883305 43.572479371219586, 4.0935714752638717 43.570388430037255, 4.1120674773261783 43.57377241389365, 4.14413849124665 43.599487346823011, 4.1611184333372933 43.627422419590104, 4.1638194597235838 43.643932388370118, 4.1339835473380049 43.700370374316307, 4.10601749505679 43.726787274872166, 4.0314494525587179 43.776176365238982, 3.992723475743901 43.793987297591556, 3.9737935844641186 43.796051307719, 3.9366635806858028 43.789245319693421, 3.9169945815665983 43.802223271825184, 3.9179774770596509 43.843326398287886, 3.8898774735839083 43.869674299016836, 3.8705274226440451 43.877189295467574, 3.8517515488349829 43.87649542475954, 3.79676255925321 43.855312301888304, 3.7780055195805744 43.854633392877432, 3.7901725477265416 43.896125347446187, 3.8004695397481782 43.91019427133044, 3.7995385701452449 43.923839339135313, 3.7910595123378528 43.937202422953831, 3.7517345395769723 43.960380380105661, 3.7323575575822474 43.967865277142138, 3.7141375548274596 43.958973276493296, 3.6541974756273135 43.953987334921564, 3.6357965243469437 43.947788439760515, 3.6134655752740059 43.892192357314187, 3.5950885627090656 43.886024265647265, 3.5755144383518314 43.896202268171535, 3.5573454813873298 43.8872724232299, 3.5520474564149538 43.85696829773336, 3.5690745718566177 43.830253395374186, 3.5588045108898427 43.816173382232037, 3.5400775706314676 43.815437266732047, 3.501133505078144 43.833061265880175, 3.4628125502063085 43.842491359566694, 3.4682654727492377 43.870083369419021, 3.4492984412565306 43.872066410361882, 3.3761144437551991 43.844471408170094, 3.3815214250868735 43.872078379719611, 3.3767144958210906 43.885555348456464, 3.326867577521341 43.897216319198677, 3.3049694615460794 43.888103413491834, 3.2480174972976386 43.893936363142487, 3.2298914892049879 43.884975362666765, 3.2406434928400927 43.844356291111993, 3.2231865366401848 43.827198392835228, 3.2050874596023959 43.818233343900246, 3.1499564219076319 43.802200389229526, 3.1309904465347245 43.804126399703236, 3.0914984308255953 43.827068314079966, 3.05310847612688 43.8363384056169, 3.0345864231095447 43.832801284389618, 3.0169555591827191 43.818351277277841, 3.0143515197979696 43.804523324727725, 3.0338385142717925 43.750625306898471, 3.0323444567959541 43.723190306856239, 3.01701153353207 43.681453332494115, 2.9992194353159221 43.669693438530672, 2.922595479608816 43.688190320692811, 2.8697824488532149 43.69128827210362, 2.859966519400075 43.674408309353979, 2.8585275561737546 43.646972429211942, 2.822560516314212 43.628906267907908, 2.7674745397308982 43.615413281354094, 2.7487824514258818 43.614536349880879, 2.6724105563108651 43.63012731841566, 2.6537355419426092 43.629264292519807, 2.6171084272086205 43.61931229963254, 2.5996644964862412 43.604774282537491, 2.5946324376832877 43.577144428392344, 2.6132115211697737 43.536949388936947, 2.6429444618749471 43.497295434858628, 2.6416484268614226 43.469852337897962, 2.6279595300848939 43.455505302466591, 2.5911815662395838 43.448269297662776, 2.5551865392054083 43.43283428281832, 2.5678124514041087 43.417007271508439, 2.5690525120682537 43.403362379723504, 2.5417435423220809 43.3746644364215, 2.5342695585235617 43.333213318484994, 2.5466604840669618 43.320125353874161, 2.565968466234807 43.312847280298357, 2.5845415650424286 43.313736357149267, 2.6390894485881233 43.3300553442656, 2.6551584873519971 43.317123333345094, 2.6689375063513978 43.287655302689544, 2.7067925363718359 43.281227405552059, 2.7453555186976359 43.266601378473737, 2.7632115121616607 43.275657429731396, 2.7817485268761573 43.3203244324563, 2.8005675255770086 43.318451403992512, 2.8105624673360978 43.33261133019947, 2.7995944872020857 43.373176363624523, 2.8175194804929617 43.382225374083518, 2.8365864913266705 43.377620339719314, 2.8746814365614739 43.324607350281738, 2.8937234525599251 43.319984361880969, 2.9123034161462442 43.3208123598035, 2.967618570725989 43.328785360207135, 2.9799005399101191 43.315658319163717, 2.9895805819490988 43.28869241233231, 3.0278765419856768 43.276710381171128, 3.0464315107367668 43.277523417396495, 3.1259814463473674 43.261852359776938, 3.2028365162705086 43.232284349780414, 3.2273034676371992 43.202217323178772, 3.2430005762117844 43.209114313527053, 3.2885885154015284 43.238514400475523, 3.3402864596692439 43.264316287268329, 3.3418854250451488 43.272834421508307, 3.3630954789712462 43.272312346287592, 3.3709875101902753 43.279213385095105, 3.3810915843286296 43.276107336765833, 3.4090875600041386 43.288814394169108, 3.4392804408818165 43.283008375573345, 3.453087447055907 43.279613302459026, 3.477583441717087 43.274116374924475, 3.5082834361183188 43.273315308056837, 3.5361875293713183 43.302807277427846, 3.6574934495004356 43.388511399127978, 3.6929014499462767 43.393215356713355, 3.6982975180400217 43.404613353625606, 3.7034955636714244 43.396011433881583, 3.7289915277624175 43.414318390499815, 3.7872984937131662 43.434017313013342, 3.8196694456566149 43.458542350968983, 3.8519925201691763 43.485607357041559, 3.9076405285056239 43.513610373515732, 3.9236754193959769 43.523800345397731, 3.9885644759748971 43.546001391735373, 4.0474505476155116 43.558200279495296, 4.0781795853112328 43.557953323482266))'),
('Ille-Et-Vilaine', '35', 'POLYGON ((-1.1711024660011446 47.851772417491716, -1.1226654676332544 47.951465373991354, -1.0968035580318656 47.99182129569617, -1.0593125373021905 48.011066438735966, -0.9990184819493777 48.015545442804139, -0.97980449444364126 48.022453346390321, -0.97887757329991132 48.0417292929243, -0.99938442745977341 48.067646296775209, -1.001607559636966 48.081211275495306, -0.99038241433183316 48.112205399260617, -0.99261645974695512 48.125755416283582, -1.0234414283244462 48.164623441211361, -1.0633015017835419 48.23298237939035, -1.0807864451581395 48.289287294241873, -1.0794395403742953 48.30584742871234, -1.0309034427652648 48.383484379326759, -1.028180413883149 48.416595319209463, -1.0461135040924887 48.549625401248804, -1.0880625825143113 48.554756383272959, -1.1534974770094095 48.577327423580229, -1.195468557927029 48.582420385291627, -1.2347035844850325 48.571254382695244, -1.2585004278391523 48.542022394814822, -1.2769524249098083 48.529670369684013, -1.3206425168205271 48.520897358532537, -1.3395234745495941 48.511222421072588, -1.3534285238450252 48.496444312743208, -1.3732224971404605 48.492183397413569, -1.4399435695309535 48.498058415836212, -1.4770804380879952 48.522640308241037, -1.494433542507636 48.551468330298306, -1.5380514662320479 48.589237286555132, -1.5468774593934711 48.61597436743007, -1.5099384372788052 48.627529374152445, -1.5809364428158688 48.633724396874257, -1.5841305011284135 48.63723036256745, -1.6282314236409547 48.618320361543894, -1.6616204750707766 48.610923298470723, -1.7485234687629259 48.607029384771309, -1.7685244415390002 48.6133273791735, -1.7810225632420043 48.607322281995593, -1.824209414068406 48.612728383227434, -1.8462075093846408 48.618522432465468, -1.8730104217270593 48.644928419783369, -1.8612095151114545 48.65632641669562, -1.8601174872391368 48.6654243607053, -1.8347125254708487 48.67752432524405, -1.845906515241893 48.697422326339691, -1.8386124238491277 48.70791628470387, -1.8562175888608579 48.698524387350105, -1.9010085096421676 48.689823368364912, -1.9254075173018066 48.69121938271941, -1.9259135747055609 48.700023373385008, -1.9333004286206688 48.701927381362893, -1.9374055662799208 48.694828320093038, -1.9606095743868082 48.684623386513906, -1.9889054880852655 48.684623386513906, -1.982401550322237 48.673721413867312, -1.9945064434200503 48.660926346480764, -2.0387045289541277 48.6567303825188, -2.0446034860922282 48.651127314944418, -2.0423004408502266 48.646526329039474, -2.0327964187777638 48.651931374151516, -2.037000479658218 48.634731407102734, -2.0324155115702069 48.627296323716777, -2.05870250939077 48.625930408776568, -2.0615945174407386 48.636531387280385, -2.0814995593350432 48.638527277680808, -2.1037905518755906 48.632927378465823, -2.1095995628107858 48.638828271823556, -2.1225884281804497 48.641227423967266, -2.1297985580491741 48.635524377051908, -2.1542945527103541 48.63312927336743, -2.1575975673821688 48.62702542898829, -2.1325914668580026 48.604431330065424, -2.1147685651476991 48.584312423911783, -2.074679489712139 48.558849375554544, -2.0417225673001269 48.54909540512962, -2.0411035050778708 48.527195352934726, -2.0091595775732003 48.526455364995471, -1.9939095597135577 48.548904423465942, -1.9511504374058006 48.558242282689989, -1.9343375382634065 48.534298286643846, -1.8979255199285205 48.532310317141921, -1.8903934495410226 48.487278425026417, -1.9290675004657203 48.475227394038384, -1.9497714969880633 48.455001291725139, -1.94189055502693 48.411735407933762, -1.9417715655295638 48.321117336828181, -1.9988594171921648 48.297237412049853, -2.0190225043573946 48.295578423865365, -2.0401894333917028 48.299347363388549, -2.08452446245974 48.317669281703971, -2.1047204653587244 48.315994275702522, -2.1455854368067264 48.29338028652343, -2.1839085039181612 48.279201350160079, -2.1944825513670878 48.248111295513027, -2.2130994791463934 48.238304343078184, -2.2266994858398448 48.223426431427768, -2.22665354462859 48.179474421806887, -2.2447605425648476 48.166961338406722, -2.2648634309015279 48.165264329909476, -2.2728915255546838 48.1426043995191, -2.2371564800110377 48.104404370364264, -2.1959554864469624 48.102363418852448, -2.17435044371598 48.095924432457039, -2.1798774706647919 48.081730358376589, -2.2431464394718432 48.070911291134237, -2.2622025370675942 48.063808357425117, -2.2812285352490846 48.03470627227999, -2.2666745003371034 48.022205334257492, -2.1643174816441046 48.019832409088806, -2.1427374337483798 48.0133703640778, -2.0986435520344742 47.9950794252765, -2.0696155712952304 47.970001332586051, -2.0686495737189432 47.942604352856605, -2.0932735348957863 47.899341285384693, -2.08982952823078 47.858390416193046, -2.0708315172239793 47.865478388205005, -2.0462105483865685 47.908760289813316, -2.0261625782794397 47.91040026784141, -2.0192115498014402 47.894485422568223, -2.0222924272754881 47.866771430879069, -2.0934194554480428 47.811393437171276, -2.0829545403783243 47.798507367462051, -2.0634615612256368 47.802887272289055, -2.0489925439574677 47.790363275650961, -2.0669965702133197 47.777855296829827, -2.1259604426791441 47.767444419889827, -2.1314475130955657 47.753238376451648, -2.092071494544399 47.715294280328138, -2.0786624695146259 47.68618040184522, -2.0337955081077439 47.684417385860527, -1.9733645092209713 47.708671353067743, -1.932000521167879 47.7038383728469, -1.9125034935559881 47.708187298159785, -1.8754965277342421 47.7277033359281, -1.6803914203207739 47.724262321602524, -1.6613874246351088 47.731277421348338, -1.6346334458433773 47.763618273877526, -1.6165095499903259 47.776046339633851, -1.5021185742460545 47.818042415386728, -1.4648674687307448 47.837429430519549, -1.4471695411966721 47.85253528802663, -1.4280824640867706 47.859512367459658, -1.4080404786585063 47.861072432422972, -1.3656784573952336 47.850628287709313, -1.3410634732367157 47.825069308470304, -1.3192095382730429 47.81577334199828, -1.2533395224207027 47.809837420667222, -1.2137684737466259 47.815597322031763, -1.1950765614615761 47.82524127997759, -1.1711024660011446 47.851772417491716))'),
('Indre', '36', 'POLYGON ((1.1687165153546175 46.384384430850488, 1.1895835063659774 46.374626411966361, 1.2890034558975572 46.366603421892236, 1.3076154551177694 46.375869288949971, 1.3216805065627852 46.390373334191494, 1.3406144463017711 46.396915292267281, 1.360815553779787 46.392574287852895, 1.402804588734 46.370254428037853, 1.4359655182871904 46.355671349831354, 1.4549274452008945 46.362194297750776, 1.4870304947552881 46.391349364905849, 1.5056734734896224 46.400608367184915, 1.5457495234476539 46.394584435870584, 1.5650224776422021 46.398361296292265, 1.5830685726700437 46.413040305380505, 1.6020584867584091 46.419536322245037, 1.643048432382642 46.4053153171097, 1.6623305396154251 46.409092353551372, 1.6807015675014725 46.421009433344878, 1.7002934698753336 46.422054287866175, 1.7210705146838166 46.412208435018712, 1.7409704519990896 46.41053043667786, 1.7654205054489864 46.439209369823473, 1.7838255051885881 46.451118352698543, 1.8248004891156597 46.436844365553284, 1.8648694982750555 46.430679442245761, 1.906525503452599 46.446529336151329, 1.9264324815665361 46.444816309837123, 1.9878074755337707 46.423298396989551, 2.0477185114394558 46.415378378595832, 2.145974440932406 46.417514380889585, 2.1568994721945955 46.4262583487466, 2.1594255347341687 46.440075388058787, 2.1801934265043883 46.468471281098246, 2.1785164842833353 46.484825296187907, 2.1544564910792303 46.527458388199634, 2.1438745227317781 46.669265353829715, 2.1500695454535617 46.724331440156831, 2.1236295862821351 46.75041531093602, 2.1298314737825876 46.767124358298176, 2.1242095720718055 46.783279294805695, 2.0920524843876933 46.825485362378643, 2.1112245791414068 46.8319012901584, 2.1321165649879958 46.860309328575553, 2.1510144206338566 46.869449341357225, 2.1654125018555419 46.883834397101381, 2.1665775780139427 46.911251267087025, 2.1572724585036553 46.924492369068744, 2.0965374731347026 46.935192270793763, 2.0872115832683562 46.948410314159858, 2.1001914716197518 46.976413330634031, 2.0931265582234175 47.006191332450626, 2.0744145796622036 47.032631291622081, 2.0571445566667421 47.045452409963659, 2.0517525370322289 47.058887309928522, 2.0607874658938954 47.086681390702424, 2.0091555291136558 47.122448295859996, 1.9513834878411558 47.103115318856894, 1.9122894532763723 47.0956763630317, 1.8062145408504762 47.117637318134982, 1.764737547978882 47.131908312940837, 1.7592724800582857 47.145305368612881, 1.8330054838351941 47.201126404576414, 1.8354845490436844 47.214920385272976, 1.8291224833736806 47.236488287791033, 1.815684415049418 47.249500387796289, 1.7946285546139791 47.25936137836085, 1.7527285857628385 47.276344312790926, 1.6927605193880026 47.275959357124137, 1.5557184142517144 47.249538408109075, 1.5370824763160158 47.23760636661838, 1.4777845179537508 47.231659356029425, 1.4399484980897057 47.213184300343144, 1.4153254170126957 47.184456433646844, 1.3964294975864675 47.175190390569114, 1.3722885351977823 47.176597318161541, 1.3604744270846538 47.107494343584065, 1.341589420896355 47.0982363974248, 1.3208144883274997 47.105289341463433, 1.3022894429707037 47.093311358761483, 1.2714864768890664 47.050514392160935, 1.2391084841469535 47.021286276719749, 1.1777475717770187 47.03425243551375, 1.0768504626863944 47.012016361202782, 1.0601155403891482 46.953518413588355, 1.0257085654929199 46.877544323597661, 1.0228575700951694 46.8362922842433, 1.0126985777272637 46.821975348226189, 1.0318164583312921 46.795707360562048, 1.0341504830873873 46.776653375205868, 0.99541042467527063 46.7688982875208, 0.94007854819869863 46.735485297375519, 0.93063648515445152 46.715747298429434, 0.93795645148227891 46.688785440057231, 0.91328144451514959 46.632499359342162, 0.91667352529003665 46.605289312817163, 0.93968655173324578 46.57925437558869, 0.98095953746363307 46.565250403072056, 1.0198895214196284 46.5703083368101, 1.0408385377353966 46.560566335742905, 1.1010414147455663 46.55311241822055, 1.139661427540517 46.527954412465292, 1.1664564189844668 46.502105352321465, 1.2079434449941573 46.485290340939471, 1.2252395189446474 46.472580291196763, 1.2190115804891093 46.458534425928107, 1.1817905743880885 46.439956398561421, 1.1677404846402339 46.425434399283304, 1.1687165153546175 46.384384430850488))'),
('Indre-Et-Loire', '37', 'POLYGON ((1.3722885351977823 47.176597318161541, 1.3478324970689926 47.180729386875683, 1.2701754801783807 47.228439422781818, 1.2493954430304939 47.268348429791629, 1.2278875633210191 47.2808263091985, 1.1877984878854591 47.281311420226231, 1.148690547743314 47.273616355349745, 1.0962855312700697 47.308956412088506, 1.1231134384477457 47.351558348566144, 1.113161445560479 47.36743534954654, 1.1257554981452529 47.395538345361715, 1.120089415422882 47.408897380720973, 1.1247484879167757 47.436546421042479, 1.1037654997474817 47.4764212801788, 1.10272557378525 47.517429355859562, 1.0927204228681262 47.533306356839958, 1.075046434049483 47.545986307168377, 1.0740084443069122 47.586990334389938, 1.0539374155841585 47.618694346680243, 1.0149514572788121 47.608245273407519, 1.0006774701335246 47.593719401690166, 0.97966843100920187 47.600731333076581, 0.97394144537838656 47.614067309820243, 0.98022148574401058 47.628128312806, 0.95278648570180735 47.653919286360875, 0.9334714627352696 47.647316425376673, 0.9412585860542606 47.61764931613898, 0.903337548546375 47.599002288945414, 0.88228855288963359 47.6059834168377, 0.8725734828773 47.619125419578253, 0.86110243767896577 47.6458204316812, 0.87135454460911888 47.660110436643421, 0.85760245666460833 47.672992281873448, 0.819671562038593 47.654319379744791, 0.75893956900904413 47.656192408208582, 0.69277049523358869 47.6686363157619, 0.64987742173130414 47.687969292765004, 0.64807744155362457 47.701538319944333, 0.62877949252387566 47.694904303426043, 0.6193254601218996 47.705265366715494, 0.56324743500724139 47.671726346274212, 0.52431146637238157 47.661098436715505, 0.46470054450961129 47.654670363558054, 0.42690342505815693 47.635875303572632, 0.40689241914401464 47.63462837812979, 0.39704744639638534 47.647709301941958, 0.37593244325219644 47.654590274473279, 0.35704655696406462 47.645183415422352, 0.34690956709198417 47.630832331531749, 0.36663753289997203 47.604702343521339, 0.36850246444529944 47.591118354644848, 0.34890950595163872 47.587116364685969, 0.32854945244386613 47.588581378867346, 0.28883142709773324 47.613456344516422, 0.26809750718106784 47.617626433543322, 0.25422748585896215 47.630424317249336, 0.21786457709472984 47.630825290733085, 0.23289545009603785 47.609882435116148, 0.20891149751750504 47.550785315535663, 0.21877548042149897 47.537708440182726, 0.18405254968536156 47.412128403226475, 0.17002446243333225 47.397522442424346, 0.15086152071788206 47.390785278205684, 0.14083454332487122 47.376430321875816, 0.14903144112594191 47.346809329869345, 0.14296948949882449 47.332706434131538, 0.10102058709699691 47.288822368217737, 0.070286444822244221 47.16615634180728, 0.055586489357978053 47.156959298556458, 0.071705517792338469 47.127853340972038, 0.092641508630578073 47.121013381092908, 0.13224652915820911 47.123630269935219, 0.15358842203923473 47.114055311816244, 0.19167157393630418 47.127502357158775, 0.1975314546418474 47.114177293653043, 0.18752243128543 47.099819344983743, 0.1933675263137502 47.086490409038745, 0.25424455979572258 47.079483406211395, 0.27195252046789165 47.066909419902814, 0.27604956120867996 47.037033374964849, 0.26979046721908162 46.995498295504305, 0.27560458273330823 46.98214330860425, 0.29907244477001882 46.9562534118282, 0.32105346614949326 46.941230283705394, 0.34190443934389236 46.934337341816345, 0.38212746597397995 46.931404321114186, 0.45855955991757469 46.955455337299966, 0.50201554527276926 46.958194383999043, 0.56271550266839654 46.951034419820772, 0.58604448495151473 46.9552154220856, 0.58464847059704539 46.996242331902792, 0.56740942711567754 47.036293387025594, 0.62994351256247683 47.015491347381882, 0.66874852234226978 46.993202291060967, 0.697751508246256 46.953861300483126, 0.724844501493493 46.897964399914017, 0.75202744094366381 46.872207398212694, 0.79459857392714639 46.850120412813354, 0.84745349743479892 46.809444310789431, 0.84695148849027646 46.782009310747227, 0.86613044802268746 46.755756284780219, 0.94007854819869863 46.735485297375519, 0.99541042467527063 46.7688982875208, 1.0341504830873873 46.776653375205868, 1.0318164583312921 46.795707360562048, 1.0126985777272637 46.821975348226189, 1.0228575700951694 46.8362922842433, 1.0257085654929199 46.877544323597661, 1.0601155403891482 46.953518413588355, 1.0768504626863944 47.012016361202782, 1.1777475717770187 47.03425243551375, 1.2391084841469535 47.021286276719749, 1.2714864768890664 47.050514392160935, 1.3022894429707037 47.093311358761483, 1.3208144883274997 47.105289341463433, 1.341589420896355 47.0982363974248, 1.3604744270846538 47.107494343584065, 1.3722885351977823 47.176597318161541))'),
('Isre', '38', 'POLYGON ((6.2664744187849806 45.113937439873595, 6.2733895391898216 45.141388281712793, 6.2540375520303257 45.146560276389138, 6.235141456584131 45.135345340242068, 6.15757156957693 45.158760396288827, 6.1644465574294145 45.186210358028191, 6.1366345226188912 45.215839270933131, 6.1170584620420243 45.226452394814643, 6.1538665253015949 45.28171139902507, 6.1688644825691767 45.295597438164137, 6.1879684575958436 45.30136138798791, 6.2021635877960932 45.342582271808212, 6.2210244792489959 45.356544351572794, 6.2283565909545189 45.3702923910581, 6.2237024470196616 45.397552427253586, 6.2078694510309163 45.410984334878989, 6.1693575144954025 45.407665302390242, 6.1306225606622888 45.41253630292384, 6.0134145613737928 45.454349317911507, 5.9815945519255536 45.481155398613325, 5.924118576236765 45.466491351222245, 5.929484544916221 45.422863394359737, 5.9260864794624979 45.40912626811236, 5.9111344634061993 45.395195343881866, 5.8719784698131718 45.410892276436513, 5.8333885564324817 45.410194357269248, 5.8139034981782913 45.41530632913701, 5.7745075893708986 45.436428373079863, 5.7354894194116639 45.446636298998428, 5.6942674794715629 45.514160374476191, 5.64626841878038 45.554218294377691, 5.6253324279421406 45.594806386418341, 5.6284134814361835 45.613990274509817, 5.6050785144742008 45.616268324916561, 5.5114895783736415 45.723674300329279, 5.4792884856978787 45.75032037888154, 5.4426064527343385 45.7905314361539, 5.4169265477783313 45.844635397343993, 5.3808544239988123 45.868454419213904, 5.3417195528017487 45.873050300539845, 5.3225094377352775 45.86714535872288, 5.2886375635372929 45.84177736114755, 5.2406444875249747 45.7860073709743, 5.2215054845249824 45.780090283779671, 5.1825475133942973 45.781898360875786, 5.0838675518019727 45.812305282032767, 5.06055951589488 45.811744306399461, 5.0777084371533761 45.779365433557516, 5.0976615324985346 45.768913367945387, 5.10874445367071 45.700840286192019, 5.0533115417333363 45.644802393629718, 5.04305855470335 45.617191373621, 5.0476095509378069 45.60364927749653, 5.0366894482346538 45.589695294650411, 5.0170565332086028 45.594677363782878, 4.9924695362247462 45.62139138604222, 4.9733824591148732 45.615432406095536, 4.9702035385194563 45.601665356453864, 4.9514345294890916 45.590263311082381, 4.9129965213394939 45.583797393632111, 4.8753414500010308 45.563659301302138, 4.8357795543652173 45.579006306163322, 4.796648555607419 45.586151308644432, 4.7779105260911763 45.574707370520926, 4.7863885277787688 45.561256276719163, 4.8263774478533605 45.537746345910435, 4.8510374931233287 45.511062423065383, 4.859471489819299 45.497619426182084, 4.8563305895366682 45.483852376540412, 4.8416105677962094 45.469791373554628, 4.7649804513903007 45.456771352650875, 4.7424234926803592 45.445202440351139, 4.74037655648965 45.412330359563, 4.7518504180074785 45.346496427803785, 4.7487174386233164 45.330528424500685, 4.75332247298752 45.316986328376245, 4.7694534707796095 45.303764412570885, 4.8042645875189578 45.301960383933974, 4.861851455786649 45.306270408834266, 4.9754304514253533 45.347549379243517, 4.9915285334837165 45.334266384509775, 5.0112075657409889 45.326584345110817, 5.049710525258206 45.327552278906737, 5.0695194602508025 45.317104437773779, 5.0862564947876194 45.290176375235163, 5.1054884363299493 45.290668351041589, 5.1202545753016295 45.304695382173819, 5.1393675273465931 45.307888384366535, 5.1515695834659141 45.294532341346709, 5.1413215249949644 45.266941387614153, 5.19994145444619 45.249214416785591, 5.21212749274855 45.235832322810708, 5.2089214650783049 45.2220842833254, 5.1899324310897725 45.21615628289284, 5.1790565093982366 45.20222835100175, 5.1772804679360149 45.158424374172725, 5.1561804264889872 45.116924322685506, 5.1498014629021895 45.089409409578522, 5.1542795868705014 45.075847423197828, 5.1738355811711756 45.068126307366285, 5.1928765410498272 45.071315437119765, 5.2121855793375005 45.069034394373588, 5.2512945755994451 45.053577377033307, 5.2900085830565331 45.046268323943409, 5.3469225269922163 45.0612483271744, 5.38536757594045 45.059364385472705, 5.4426594347442574 45.0661013736714, 5.4615965428426705 45.071987305331973, 5.4949794335736613 45.100036439037396, 5.5142844234020743 45.097732337675595, 5.47077756827656 44.853447427635516, 5.4839394612733088 44.8127403460975, 5.4774374597299129 44.785236346228416, 5.5393755415700809 44.764690415636, 5.553449570033365 44.795070405738088, 5.6592345775743809 44.72615841282429, 5.6781924560288246 44.729267277473028, 5.6973765201402671 44.726913362460706, 5.736211453314354 44.708538286115427, 5.7553615455722422 44.70617328184521, 5.8037575312879426 44.717132284960954, 5.8265404996348877 44.743061434189556, 5.84550154644873 44.746139319324172, 5.9028034383906345 44.744457272524087, 5.9594804594513846 44.761867407412879, 5.959030552416948 44.775524268555515, 5.9428374195766764 44.80258927462809, 5.999500535060065 44.822689346645333, 6.0185004822865267 44.825752270082788, 6.0379455840082983 44.81513632988181, 6.0571324644392064 44.812721335941106, 6.094902476815804 44.827022430161222, 6.1135005704586831 44.843723380604914, 6.1325024539047774 44.84674828372961, 6.1904695253001591 44.825782369497077, 6.2287565083184688 44.82363932640466, 6.2624435615516063 44.8487432940302, 6.2814685036132971 44.8517613323762, 6.3391884429756828 44.838916275319164, 6.3579854391807373 44.850113433449607, 6.3649135850630785 44.877552305931076, 6.3603634689284547 44.904823431384457, 6.3248304943063829 44.945320345082436, 6.3160655800733707 44.9862023904672, 6.3003445327832992 44.9996453873505, 6.2234044452163459 45.009430337289515, 6.2378845517424111 45.03971826894913, 6.2367104985657136 45.0807032860143, 6.2439825874626536 45.094478432574434, 6.2664744187849806 45.113937439873595))'),
('Jura', '39', 'POLYGON ((5.3205725140236666 46.448516425553393, 5.3206844627223688 46.424614322259274, 5.2950594759959131 46.383052311743839, 5.334699524496898 46.375736393875243, 5.3548094536322139 46.365242435511064, 5.3873914535155336 46.338646346629318, 5.4003655332080314 46.311599294593307, 5.4396875136294796 46.309719401350847, 5.4560645873347653 46.293670428863166, 5.49618552238428 46.272659277499216, 5.5388235429550434 46.284469337153084, 5.6072315907047141 46.337776279934772, 5.62651457803733 46.346340355386005, 5.6465644843640916 46.335819289946969, 5.66333056219537 46.308818355142208, 5.7029394551622659 46.298664291333395, 5.7113164213890855 46.285144373724719, 5.7079185319553005 46.2714343545522, 5.72782744628887 46.263610267040221, 5.7866925715534876 46.26197838593059, 5.8654104607823285 46.252479292417192, 5.9041894196070359 46.264095378067978, 5.9576245049243539 46.305988306120454, 6.0222674855900777 46.367180415342474, 6.0296555716449518 46.380943416524943, 6.0826734896416212 46.435440430300289, 6.0921285781633685 46.44033044099028, 6.0868245685121281 46.466728331389717, 6.1156184426959044 46.496723365825048, 6.1585234855558895 46.534023404891045, 6.140919552683954 46.559021408496747, 6.1298385677314116 46.565376433368087, 6.1232034950933212 46.56901934259524, 6.0617345064639494 46.602722413645367, 6.0770644373883727 46.616623414481566, 6.0805594898436652 46.630336425993519, 6.0550265615597141 46.687278357103864, 6.1132634715637835 46.718250302353411, 6.1523235342750411 46.732505279342277, 6.1598274414679111 46.746261415746048, 6.1505404520141553 46.789821428901476, 6.090191478431791 46.821674354083441, 6.0305705234309528 46.828903318088592, 6.005453530327884 46.869457438275688, 5.985373524586862 46.877323418539689, 5.9923805274142126 46.904750321663428, 5.9879545053559866 46.918335366659718, 5.9676474338581329 46.931640363889287, 5.9786215746909761 46.959133274500473, 5.9702175013893282 46.972644391110819, 5.9500894421974522 46.980487312759195, 5.9062544858543049 46.985210280500965, 5.8661925174935732 46.995433344136657, 5.8257885423379037 47.013843272435324, 5.8094255502299461 47.02720230779461, 5.7701125468267946 47.015564395667994, 5.7656425197769181 47.029144336085253, 5.7764865818545275 47.056644287495104, 5.7918775917073617 47.070568346946928, 5.81145048392483 47.0791243254797, 5.8188725418332581 47.092907392938329, 5.8143835046270169 47.106472371658427, 5.8163265890374589 47.1611133697664, 5.8038724723260771 47.174537356493332, 5.7634464946745823 47.190181307038031, 5.7530634288893054 47.252796361669439, 5.7208614561137381 47.260376309487825, 5.6809744515997238 47.259632273089338, 5.6217435568447058 47.244846419881426, 5.6018124639953442 47.244449318836942, 5.58163459115292 47.249496339337057, 5.5242175821529145 47.286598355940711, 5.504986520710446 47.292183293458535, 5.4886754544925793 47.277671327318544, 5.4557704579707149 47.208732403349856, 5.4064315332943522 47.153080346554177, 5.39970052977452 47.125625280235781, 5.3737245592348017 47.084110267051429, 5.3543535619189413 47.072765428169063, 5.295270523935784 47.060527287956617, 5.2561995479865971 47.046001416239235, 5.2343174498282963 47.004532344266138, 5.2390655884252624 46.988258418261253, 5.236785425778919 46.952705377362989, 5.2975195310480387 46.9267424323008, 5.3113145678644 46.886093437351732, 5.3913744333180205 46.8687134018772, 5.4521595843774548 46.837234343104129, 5.4527645650023828 46.823597372217719, 5.433352555034304 46.814994396353896, 5.37440153202607 46.805530330813824, 5.3549965628566554 46.796924362610568, 5.3595825870644376 46.783367304788968, 5.38846957581049 46.756656274869059, 5.3953225611671485 46.691253416007854, 5.4209434994343724 46.648086279417711, 5.4183255544722613 46.618000418679671, 5.4038825881591208 46.587631341815481, 5.3814845754789644 46.559822299344418, 5.3749484260620477 46.529644380163873, 5.3948585725353837 46.524593311204526, 5.4151144222229846 46.511387413216127, 5.4196715791562724 46.497825426835433, 5.393361522720113 46.469936295279595, 5.3205725140236666 46.448516425553393))'),
('Landes', '40', 'POLYGON ((-1.5113374439727352 43.534416285598709, -1.4984904506960675 43.522861278876334, -1.478204501594206 43.513569360863514, -1.4592094829268092 43.512420302522074, -1.4039504787163821 43.519828278833174, -1.3474204343276881 43.519043405802435, -1.2575344302628935 43.545761300501013, -1.2224874467683833 43.562385330219357, -1.2030594189833437 43.558487368060682, -1.1898214853610227 43.545822379429396, -1.1840205713442913 43.532550297933582, -1.1835615112715914 43.505077277578621, -1.1645914874394521 43.503891431064162, -1.129115543286531 43.517788383441129, -1.0721655152577227 43.514145298193981, -0.99828043022972679 43.522842268719941, -0.99866644201631516 43.550308424296205, -0.9425144885157124 43.552059294903231, -0.93711454798273053 43.56622326956942, -0.919340579823114 43.573139270074066, -0.861551464613882 43.563976374696736, -0.844159459781622 43.573581432229972, -0.80536747547935761 43.565643283779721, -0.78797846298652985 43.575245348973525, -0.76936646376631757 43.576690296878709, -0.7430875628642184 43.551258404055531, -0.72331154360537653 43.544544298452493, -0.70630343832010567 43.556873264967678, -0.66911446785297812 43.55974538276142, -0.65014743636027106 43.558452340087356, -0.60981351715128085 43.53956627777923, -0.59044058361575935 43.535556366921881, -0.57221758852153926 43.539699348873924, -0.53740541566239131 43.55884539267258, -0.46606452323052849 43.58621931378643, -0.44747857496534493 43.587619376600131, -0.4418344947387709 43.57429941767343, -0.45108645621917276 43.559864372258787, -0.43133648791535961 43.553119287141627, -0.41348947146966 43.559944285323596, -0.35768146098362763 43.564109269771464, -0.31859446721747986 43.553276296951779, -0.26357942668064993 43.590309313728554, -0.28034849685138852 43.602790361494826, -0.28973352942648489 43.643310333808429, -0.28044653997275759 43.657722320607448, -0.24541557429520822 43.676784402882063, -0.24360151252020046 43.718124276199759, -0.21377844959218351 43.747753365124666, -0.21192355118495243 43.76161933798754, -0.22125454563033031 43.774692340901211, -0.2250085234563528 43.801883377269817, -0.20823047626734592 43.844295388203577, -0.22132847401624645 43.857090279570158, -0.22882146797118708 43.884014293649543, -0.21123443301601696 43.89352430040087, -0.23746158404793505 43.919094368897746, -0.22625157645995841 43.94737637701887, -0.1899205273096527 43.95824842627114, -0.11423141364477374 43.958202309039919, -0.070723502399431482 43.999767311894786, -0.053084541554142106 44.009269397747588, -0.0332284332105246 44.002437358766954, -0.027636454894064855 43.98910930292179, -0.031530544613445954 43.933902400621449, -0.02220852718636479 43.920829397707777, 0.016345478121138513 43.91532138091533, 0.052691488968577005 43.926101371725125, 0.054634573379019 43.939983362404931, 0.047222548608715442 43.96693043509994, 0.050728514301908945 43.997371328110447, 0.068016491333963813 44.0095712719902, 0.086023509929248121 44.0108373836094, 0.079397414309454462 44.037819308257767, 0.083273549992242124 44.065555302442718, 0.094674539243925437 44.09380738716952, 0.10412153084723741 44.108204412271405, 0.12144946441168258 44.120376368976437, 0.12715743988607642 44.1345142926876, 0.10764650669682396 44.138641432842647, 0.070071524443108046 44.1360243679804, 0.03173648797394435 44.138839279285023, 0.011110468296777753 44.151115439810255, -0.008415426589664321 44.15522040144954, -0.04563044801182059 44.149856368989717, -0.10275244754794244 44.15128741131754, -0.12267245113940817 44.158107304920506, -0.12490244809526985 44.174430340496045, -0.15724541286405724 44.216056422279294, -0.19601557069046294 44.27644728861371, -0.21443852446662959 44.272373306488518, -0.22386650591354851 44.257957271230268, -0.22008242867323702 44.230758313963193, -0.23323358445205145 44.21607631253552, -0.25091056561012692 44.206539374729331, -0.28737556595493174 44.195640394422171, -0.34493955162699308 44.199672307775344, -0.36382244557569265 44.2257653315928, -0.37750746991298456 44.268715435564204, -0.40397453615926793 44.294227417472158, -0.4417554617738233 44.318920378475852, -0.48179243529926907 44.3324163573691, -0.50077654072873656 44.358467312414533, -0.51782653876605877 44.37094131938214, -0.55868042095613646 44.389873322901494, -0.61843743939110141 44.407356330056459, -0.62799145113405075 44.42036033314325, -0.63196457381843629 44.447548377172424, -0.65285849588465794 44.459713293078821, -0.67254157660119063 44.463710354478636, -0.69020253994230529 44.454132404020228, -0.83833548714926565 44.423477294710452, -0.85762357906091324 44.424747278768919, -0.94221243825316492 44.4538843918874, -1.0361324679107611 44.443718358720858, -1.0554205598224087 44.444950322466539, -1.0092204231890776 44.517334309220033, -1.0113104842715757 44.530922346555755, -1.0692425276936319 44.534591306737966, -1.0826835883573267 44.547256295369223, -1.101575459324323 44.545772271031481, -1.1364094586593296 44.523735275302627, -1.1905384146846814 44.502884302108228, -1.2497015417525859 44.495685437517366, -1.2504094940579478 44.470466352833725, -1.2581054390342672 44.407966415260418, -1.2789025501189428 44.285774410619823, -1.2970035633763359 44.223472319488891, -1.3032045707769839 44.207584405270566, -1.3088055261117688 44.192882337566729, -1.3208965136321922 44.120189435771991, -1.333902452938645 44.08878342528503, -1.3747894268824439 43.925995407705258, -1.4052704524453361 43.835914373517554, -1.4196444189315969 43.761528335664835, -1.4306365138010335 43.740635293698446, -1.4421425869727216 43.66073243805495, -1.468866466350164 43.607532339392961, -1.5159035779243197 43.538520367138162, -1.5113374439727352 43.534416285598709))'),
('Loir-Et-Cher', '41', 'POLYGON ((2.24934744687215 47.623809310887438, 2.2302364310468477 47.652988316757941, 2.20934550132003 47.6601903497082, 2.1438004183258954 47.6707342977429, 2.0991334156009884 47.674053330231644, 1.9794884198759632 47.662696345971611, 1.8763475842720538 47.684890351510589, 1.8574835244597523 47.672992281873448, 1.8432524861863442 47.655872403909441, 1.8189025880973873 47.657375438403577, 1.7973735859919202 47.6699334068952, 1.7561014803613659 47.678775417873553, 1.7249804462001919 47.704517281857775, 1.7015444437774363 47.733398285924991, 1.6601894327426407 47.742202276590561, 1.6157774829492269 47.742607298533542, 1.5907625814267305 47.749500416442558, 1.5851834525678328 47.762878285938243, 1.5635454941030957 47.775409323375, 1.5764634234262758 47.803470426438125, 1.5371634455006244 47.828743373231546, 1.5642794973634864 47.873958326112231, 1.5193044596971959 47.912605269962071, 1.5137135375005073 47.925983315477723, 1.5201505876762553 47.940010346609952, 1.5680864571994562 47.9808424023242, 1.5463604887514748 47.987026335788116, 1.4628884762468033 48.013538287125854, 1.4564544184104591 47.999538363068481, 1.4378945211003327 47.984855305521009, 1.4183964373686138 47.978321268343691, 1.3157324398540311 47.9891743074396, 1.2757855885514289 47.984226386180623, 1.2526155522980673 47.974743310484186, 1.2321254200350324 47.976352308998159, 1.220432413658898 48.005802385617145, 1.1751134329780086 48.044330339969591, 1.1418294654681915 48.083496366700714, 1.1202904302246566 48.093235375428478, 1.0745715321798173 48.101589283039672, 1.0607504444083986 48.114486442006793, 1.0630865814040931 48.128303305298985, 1.0452145701231359 48.140987304086664, 0.9682484316011255 48.106472428950966, 0.92616047342573893 48.117721336951561, 0.86333049841519482 48.100395339606749, 0.85823841680365831 48.1083104294414, 0.82227243306394371 48.10345843906417, 0.80564453090636334 48.075122392813327, 0.80110251169017488 48.047466311693185, 0.844245533544921 48.028110276074457, 0.85404456508126714 48.015003301307232, 0.84372257822437291 48.000705375446515, 0.85424452376324211 47.919204434526975, 0.84796043493838624 47.905147303980456, 0.82854543263087521 47.898529305279126, 0.8107244671402043 47.911163314396291, 0.77122347441280681 47.903347323802805, 0.78406149067117781 47.835670286974121, 0.7722635763950052 47.802127394093574, 0.73355555361678171 47.788849327918896, 0.67446758707455956 47.777080280917218, 0.67003857267690137 47.749439337514175, 0.63175246975845312 47.733413423642091, 0.6193254601218996 47.705265366715494, 0.62877949252387566 47.694904303426043, 0.64807744155362457 47.701538319944333, 0.64987742173130414 47.687969292765004, 0.69277049523358869 47.6686363157619, 0.75893956900904413 47.656192408208582, 0.819671562038593 47.654319379744791, 0.85760245666460833 47.672992281873448, 0.87135454460911888 47.660110436643421, 0.86110243767896577 47.6458204316812, 0.8725734828773 47.619125419578253, 0.88228855288963359 47.6059834168377, 0.903337548546375 47.599002288945414, 0.9412585860542606 47.61764931613898, 0.9334714627352696 47.647316425376673, 0.95278648570180735 47.653919286360875, 0.98022148574401058 47.628128312806, 0.97394144537838656 47.614067309820243, 0.97966843100920187 47.600731333076581, 1.0006774701335246 47.593719401690166, 1.0149514572788121 47.608245273407519, 1.0539374155841585 47.618694346680243, 1.0740084443069122 47.586990334389938, 1.075046434049483 47.545986307168377, 1.0927204228681262 47.533306356839958, 1.10272557378525 47.517429355859562, 1.1037654997474817 47.4764212801788, 1.1247484879167757 47.436546421042479, 1.120089415422882 47.408897380720973, 1.1257554981452529 47.395538345361715, 1.113161445560479 47.36743534954654, 1.1231134384477457 47.351558348566144, 1.0962855312700697 47.308956412088506, 1.148690547743314 47.273616355349745, 1.1877984878854591 47.281311420226231, 1.2278875633210191 47.2808263091985, 1.2493954430304939 47.268348429791629, 1.2701754801783807 47.228439422781818, 1.3478324970689926 47.180729386875683, 1.3722885351977823 47.176597318161541, 1.3964294975864675 47.175190390569114, 1.4153254170126957 47.184456433646844, 1.4399484980897057 47.213184300343144, 1.4777845179537508 47.231659356029425, 1.5370824763160158 47.23760636661838, 1.5557184142517144 47.249538408109075, 1.6927605193880026 47.275959357124137, 1.7527285857628385 47.276344312790926, 1.7946285546139791 47.25936137836085, 1.815684415049418 47.249500387796289, 1.8291224833736806 47.236488287791033, 1.8354845490436844 47.214920385272976, 1.8965664697666682 47.204361299521182, 1.9027604363686521 47.2210993901778, 1.8958275379472127 47.248100324982559, 1.9127765005237336 47.276329351093764, 1.9522655238934306 47.281047390276441, 1.9941005413769233 47.263996336119348, 2.0921415504907372 47.282512404457819, 2.112607568018376 47.2780453697474, 2.1319465297003433 47.284454432748461, 2.14504153510984 47.312446359964767, 2.1447884183979795 47.353481366700422, 2.1140335057671678 47.379341340082178, 2.1411175219961365 47.427154347668747, 2.1964194750783861 47.435310408837566, 2.19782552257098 47.42170336134545, 2.218328504291577 47.417205347120913, 2.2421005288304343 47.459354384224682, 2.247298574461837 47.48697631747136, 2.2458904147296437 47.500587413422679, 2.223111494841902 47.526832342471224, 2.2294434610976452 47.543560399989772, 2.1605884986529986 47.548462380037464, 2.1552105606158136 47.600177398241911, 2.1952355647835589 47.602092319457725, 2.24934744687215 47.623809310887438))'),
('Loire', '42', 'POLYGON ((4.7424234926803592 45.445202440351139, 4.7216284938353112 45.471969268600432, 4.7017125387030774 45.48236430374341, 4.6821014501528566 45.487270332250361, 4.6632384464603547 45.478534285291843, 4.6646494225120136 45.52231643564501, 4.7026864571778333 45.534328390200486, 4.7088945053771454 45.561855272665227, 4.6696075529290511 45.571689332174927, 4.6479544567471862 45.543720287554279, 4.595339448453899 45.583229377200141, 4.5755104471851382 45.590862307028445, 4.5560144756930185 45.59302928883632, 4.5174914498996088 45.589164418431366, 4.4285795403295367 45.649387361717729, 4.3957595614514844 45.678474309145756, 4.3871724273846553 45.691894423433425, 4.3854905566045375 45.719173293765309, 4.3922365218215305 45.735809292841353, 4.4108075083895528 45.750045435693821, 4.4138454369917781 45.763797347618393, 4.374371551339209 45.773533364006724, 4.3765675764415732 45.8009453054333, 4.4143914509279512 45.818508401673014, 4.4243844564674077 45.846153393535289, 4.4227295167421516 45.8734553224828, 4.4102215379210179 45.886741309555973, 4.3097334992325784 45.935611317041506, 4.3088815625945927 45.949249344047743, 4.2963385558001335 45.962524417882989, 4.2570595242505078 45.966766323056234, 4.2170464894404631 45.981895415198849, 4.2317684474005546 45.996040379708674, 4.2507124202776367 46.004852291272741, 4.2606404744494455 46.03249341069575, 4.2794415191137318 46.044048417418153, 4.2883615069372638 46.088058337608018, 4.3031075796327229 46.102192388879885, 4.3811655700070844 46.104610375160021, 4.4195495400269351 46.116699426460841, 4.4372184242665469 46.147316339437864, 4.4238345700919695 46.174251266755206, 4.4073605093851427 46.187420376570586, 4.3677744990139047 46.1944124177008, 4.3693004161036981 46.169853407891608, 4.3584054842557691 46.15585330781424, 4.2756875412876809 46.16423027404106, 4.237664588219161 46.146625285049296, 4.2175995441753 46.154197311969213, 4.19540149017709 46.194477369068451, 4.1753105711981107 46.202053268427605, 4.1557535207776368 46.201423292967419, 4.1173934894732156 46.189228277646762, 4.0779505833347685 46.1933902697552, 4.0546904248585633 46.189891344860641, 3.9973705788800942 46.168819290588274, 3.9776385646128745 46.170898438432872, 3.9206455877122153 46.201782373699118, 3.8803984463467032 46.216789307984996, 3.8872535439429612 46.230697349619859, 3.9169875407679342 46.2536014197038, 3.8784375839196343 46.244072402796078, 3.780258575152061 46.24609328803173, 3.769522589333917 46.232036333505206, 3.8173495024978195 46.003990321496687, 3.8146315781947351 45.987480352716673, 3.7955445010848621 45.981342360464041, 3.7174764775724327 45.981269312177929, 3.6984184437570207 45.975101396531, 3.6805784681099567 45.952552358719558, 3.7225085363753863 45.913067383809093, 3.7273754884497521 45.899555387098914, 3.7003074900377442 45.843864429890615, 3.6918794780206667 45.799778293055269, 3.7104105080562988 45.759426419809685, 3.7521735333734796 45.719913281704592, 3.77450641866605 45.679683390295807, 3.8316565813967998 45.640678421834068, 3.8719024906225457 45.620224373664158, 3.9211815685102636 45.580913306480639, 3.9433345613970516 45.5406343055012, 3.97704643344548 45.500778280501308, 3.9721254432413957 45.459568309918936, 3.9576425203958649 45.445392365895017, 3.9012985291117843 45.421543420630783, 3.88683444040268 45.407348290430534, 3.8629145590919336 45.362739374294577, 3.8675255781349733 45.351963431944014, 3.8867805782928997 45.352646389414147, 3.9436204178227 45.368293332298279, 3.9828765667766675 45.35872629507783, 3.9953685277808404 45.345462310500452, 4.0335104703467266 45.352226405774005, 4.0529495873896622 45.350151306388668, 4.0903795291909546 45.367839376804611, 4.12874149671498 45.371841366763491, 4.1854744921250813 45.390121392326861, 4.2254204633278505 45.369529344503221, 4.233995452016984 45.356128416391911, 4.2537855528731541 45.348556389471995, 4.3107044253679021 45.364051427125034, 4.3306395666764956 45.353725391808936, 4.3391855120711682 45.340320415238395, 4.3408814644486142 45.313026407189355, 4.35325654819502 45.299724402299248, 4.367329520538533 45.259132437819332, 4.3868964280771365 45.254284319881364, 4.4243585815323172 45.271839319202641, 4.44342858470543 45.275150430792891, 4.4604544680073275 45.248329388393913, 4.4831925512628459 45.2544934316016, 4.5017994459040267 45.2659683492392, 4.597810416743954 45.271549414317761, 4.6167265784663414 45.277565424733595, 4.6275044570365083 45.291549330974036, 4.6220835701275007 45.318748288241139, 4.6599975668367222 45.33077238817431, 4.7518504180074785 45.346496427803785, 4.74037655648965 45.412330359563, 4.7424234926803592 45.445202440351139))'),
('Loire-Atlantique', '44', 'POLYGON ((-1.9786935137074693 47.023746331771875, -1.8628574140380465 46.975570371014342, -1.8009154597586132 46.96418328734002, -1.7897304470058657 46.945869289923124, -1.7695594389421387 46.944770397272109, -1.75036058915353 46.949093271629962, -1.7257734161497069 46.9456144130116, -1.7116064491440852 46.933021416546623, -1.6946574865675643 46.904163295075065, -1.6696355442464039 46.897956302995581, -1.6413614570238053 46.872749363689607, -1.5997075640858327 46.862388300400156, -1.5388585177785785 46.856266325964484, -1.5004365274459417 46.864845363112849, -1.5128945165965888 46.891330383395726, -1.5112684441458555 46.9051974123784, -1.4938725668743302 46.920345338657469, -1.4961435764824103 46.933899404139638, -1.5306375052421117 46.972362407124464, -1.5334034829960501 46.988643373928014, -1.5266385076226641 47.019413424275953, -1.5430845811548295 47.045585305038387, -1.525202536735776 47.058002281536844, -1.4866235365930152 47.066578326345777, -1.4441944517224954 46.957267286835375, -1.3650375686971188 46.985504409865015, -1.3707504727306059 47.06747039553612, -1.3514444267823649 47.071731310865729, -1.3303345282172074 47.065139363119457, -1.3123945732291702 47.077530288662857, -1.3028085258523276 47.092003354390258, -1.2641934416164133 47.10052131261024, -1.2435345062054921 47.096618421892529, -1.1894275526759657 47.059597374473455, -1.1678985505704986 47.050270428487337, -1.1253365706252509 47.059017388683756, -1.1100015351217962 47.087635418920982, -1.1126354979008397 47.103931347421693, -1.1341775254838069 47.1132663903263, -1.1741715501374586 47.112934416669432, -1.1948204524102835 47.116867406801433, -1.212849473501393 47.129196373316617, -1.2292054248107149 47.155418419769504, -1.1703334347674286 47.187393326788268, -1.160685428362342 47.201858295597233, -1.1871824180029478 47.241035411586225, -1.2013025636974817 47.253692303299047, -1.2220084964394573 47.257595370036725, -1.2383934910432401 47.283783268616119, -1.2564985527598935 47.296135293746929, -1.2984034501700989 47.306621331212611, -1.3597425360641751 47.312843284989256, -1.3056445595529453 47.350013421319986, -1.2055754483848204 47.3769494047571, -1.1459745596601749 47.381492304073092, -1.0810705413840935 47.378162358346387, -1.0373665438960415 47.381469421477433, -0.99496456610037853 47.392891357105114, -0.92782755852900323 47.400634299412516, -0.90881951438407782 47.407543435138493, -0.930441455031854 47.416916322335894, -0.94357852921336871 47.47357538936005, -0.95589658249062381 47.500110399313414, -0.99835048617640609 47.513412404203549, -1.0802275817644329 47.521007313719068, -1.1231704689172091 47.536983413940632, -1.1555144898057961 47.561973320627871, -1.1617394359218736 47.575229384306724, -1.1520104603322068 47.589687312317, -1.0288274632800665 47.601711412250168, -1.0106305191409035 47.614067309820243, -1.0248064631648219 47.626716280634568, -1.0899884169680263 47.65477333523846, -1.1326274936586174 47.692726408380267, -1.1970754442014311 47.715294280328138, -1.2383825778053108 47.72037932114101, -1.2137684737466259 47.815597322031763, -1.2533395224207027 47.809837420667222, -1.3192095382730429 47.81577334199828, -1.3410634732367157 47.825069308470304, -1.3656784573952336 47.850628287709313, -1.4080404786585063 47.861072432422972, -1.4280824640867706 47.859512367459658, -1.4471695411966721 47.85253528802663, -1.4648674687307448 47.837429430519549, -1.5021185742460545 47.818042415386728, -1.6165095499903259 47.776046339633851, -1.6346334458433773 47.763618273877526, -1.6613874246351088 47.731277421348338, -1.6803914203207739 47.724262321602524, -1.8754965277342421 47.7277033359281, -1.9125034935559881 47.708187298159785, -1.932000521167879 47.7038383728469, -1.9733645092209713 47.708671353067743, -2.0337955081077439 47.684417385860527, -2.0786624695146259 47.68618040184522, -2.0622535361953851 47.662822376267641, -2.09285055891624 47.542049268577173, -2.1117494706819 47.53497344194291, -2.1336065740049435 47.544136337320239, -2.14210041748953 47.502174409440855, -2.1624944428508286 47.50320430226499, -2.1833684746608526 47.528934372911451, -2.2032374324620321 47.527240356753637, -2.2405184613716358 47.510345432306835, -2.2589264534506697 47.522514396672463, -2.2788184698674741 47.520813339715957, -2.3011525872997822 47.510662268246577, -2.3140344325298372 47.493057279254813, -2.3318754642966724 47.480510400021089, -2.4154034511507234 47.49531543940536, -2.4347455811920895 47.490883432668269, -2.4637804267100307 47.449398342878212, -2.4486865385606791 47.449600413799786, -2.442588502840465 47.444202409486408, -2.4512914580452616 47.426700392175078, -2.4378854253549207 47.4242053091496, -2.4291895109487882 47.416504435614215, -2.4467874591418592 47.414608348534827, -2.4702885889522577 47.418705389275615, -2.5073914856557451 47.39990628083099, -2.5233885322533069 47.384708364881433, -2.5458775472561683 47.380203309858231, -2.5464835840009243 47.373104424608343, -2.5282855837419334 47.367504349373419, -2.5083875826462929 47.3524094051043, -2.497283539078154 47.33081034705215, -2.4974884263191655 47.312309416430807, -2.4698914879077734 47.312408339651981, -2.4847935142935853 47.306110345249792, -2.4703954330719284 47.300308375113261, -2.4725914581742643 47.2916103484675, -2.5302825302621557 47.302013304509, -2.5388784653273149 47.296108362692038, -2.5369804420282946 47.288112303672804, -2.5220815840018815 47.289215420802989, -2.5131844787739794 47.2820093393935, -2.4954865512399067 47.280109379874844, -2.4891934853967825 47.273414284428171, -2.4766814581163885 47.273906436254563, -2.4201894340404806 47.258815364424706, -2.4115894505160895 47.260212434899, -2.4082964689823712 47.277607432070695, -2.3712974240591222 47.279808385732096, -2.3438985081100441 47.270107397317091, -2.3243034373767841 47.254112286939161, -2.2943944767050937 47.239010301871375, -2.2702015884262892 47.237518356635135, -2.2527104843528605 47.24191234305944, -2.2432094546198584 47.253006353489511, -2.2226015649992235 47.258609421063866, -2.21640654227744 47.266609352522394, -2.1703044487654779 47.295204324143967, -2.16260850378913 47.297172403389666, -2.1611494742866171 47.298092283734732, -2.158949576745016 47.298595348799054, -2.1565495445014733 47.299995411612784, -2.1507495105845749 47.301895371131437, -2.1459515583370887 47.30239526783636, -2.143551526093546 47.302295288495358, -2.1413514525319783 47.301895371131437, -2.1414514318729516 47.301696292549295, -2.1406514211251135 47.301796271890268, -2.1385515029244857 47.30079243002119, -2.1336514590963986 47.299297316425552, -2.128551456586365 47.29919839320435, -2.1262535159233948 47.302097442052983, -2.1217535654792243 47.3053972883654, -2.11795452654178 47.305896304970489, -2.1122555280856545 47.305797381749315, -2.1071555255755925 47.304298395714412, -2.0904565113515332 47.303802371448725, -2.0842574401705178 47.30279940967948, -2.0551604596044228 47.302501407876164, -2.0457604653321653 47.303302298723835, -2.0436614272313705 47.303806419907957, -2.0361624485975938 47.3063053753727, -2.0208654334068967 47.312603369774891, -2.0134655540142603 47.313003287138841, -2.007866534899108 47.312904363917639, -2.0050665852916438 47.311809343705917, -2.004766471248729 47.311508349563169, -2.0050665852916438 47.310905305157846, -2.0070654680314703 47.308406349693129, -2.0078654787793369 47.306507270274309, -2.007165447372472 47.304107414050733, -2.0066644945477492 47.303608397445615, -2.0058655399196823 47.303608397445615, -2.00436444164518 47.3026084280158, -1.998165546484131 47.300308375113261, -1.9967654836704014 47.300308375113261, -1.995864437461762 47.298511387275013, -1.9908644142927017 47.295108393262225, -1.9840645869659568 47.292411415335167, -1.973065451297856 47.289314344024163, -1.9469685550411668 47.288814271299273, -1.9326695730606502 47.288112303672804, -1.9260695283958853 47.286419343634762, -1.9247694449231574 47.286419343634762, -1.9197704778738967 47.285415325745717, -1.9109705356675306 47.282718347818658, -1.9074705546531732 47.282119351872566, -1.9048705637276555 47.281219361783755, -1.898071440480777 47.279621276507683, -1.8972714297329105 47.279720375748823, -1.8954714495552594 47.279022280561591, -1.8925715206067935 47.278522383856668, -1.8881715495035962 47.276920426141331, -1.8836124563506758 47.27579530651532, -1.87957649453827 47.268814354643027, -1.8806704586302203 47.269424439846986, -1.8949704967305365 47.272720413720137, -1.8985704570858672 47.2741203005139, -1.9163685399808799 47.277618345308596, -1.9350674930645937 47.280216400014481, -1.9496665890880251 47.280513345698026, -1.9524665386955178 47.280914319181747, -1.9763644175104389 47.281513315127839, -1.9837634168032423 47.282013387852729, -1.9849624648151973 47.282512404457819, -1.9921625615458254 47.284111369833724, -1.9950624904942913 47.2842102930549, -1.9973614872770611 47.282409432777413, -1.9972615079360594 47.28090639828325, -1.9959614244633315 47.278911387982689, -1.9981604419050996 47.277408353488553, -1.9989604526529376 47.2777104037511, -2.0026605683692367 47.278007349434617, -2.0053605386357276 47.279010311203862, -2.0059595345818195 47.278911387982689, -2.0061605493835657 47.279312361466438, -2.0083604469251952 47.28040738167816, -2.0087594841892837 47.281013418422916, -2.0092604370140066 47.281009369963684, -2.0102605824638147 47.2820093393935, -2.011560489916576 47.283008428723477, -2.0131605114122806 47.283008428723477, -2.0139605221601187 47.283611297108834, -2.0197605560770171 47.286010273232577, -2.0255604139739773 47.2872084411447, -2.0297595462953382 47.287307364365873, -2.0326594752438041 47.286708368419809, -2.035559580212265 47.286808347760783, -2.0389585257658212 47.286308275035893, -2.0427575647032938 47.28400839815329, -2.0450565614860352 47.282104390175434, -2.0449565821450619 47.281608365909747, -2.0479564904345011 47.279606314810522, -2.0509565747439353 47.278202379557527, -2.0538554475726016 47.277404305029322, -2.0634545204269727 47.276504314940482, -2.0696534155880215 47.27660341418165, -2.0764525388349284 47.276104397576532, -2.0779534610894643 47.275203351367921, -2.0907504646956454 47.272403401760428, -2.0968495565356591 47.272701403563744, -2.1011495482978546 47.272602304322604, -2.106248494688117 47.271701434133931, -2.108348588908683 47.270900367266293, -2.1157475882014865 47.269901277936285, -2.1245464742880529 47.269199310309816, -2.1266474486084803 47.268699413604892, -2.1294454619963403 47.268600314363724, -2.1322455876237996 47.267799423516053, -2.1354454545952137 47.267398274012336, -2.1397445662575763 47.265796316297, -2.1418444844582041 47.264598324404844, -2.1468434515074648 47.263397340173256, -2.1522425119406137 47.2614973806546, -2.1529064592543534 47.261516390810996, -2.1662084641444608 47.2521093557401, -2.1648164982491949 47.236709368868972, -2.177305466913964 47.229614356058377, -2.1751115540512274 47.223610315000272, -2.1618095491610916 47.217910436444313, -2.1493154759173194 47.195316337521419, -2.1575144859579609 47.170314285456485, -2.1718064271398134 47.153812413594935, -2.2157154878888434 47.150520312161049, -2.2376095554048732 47.127815320659252, -2.1643085046258079 47.116817417130918, -2.1393124372397665 47.108616294850677, -2.0981184844743268 47.1078222687817, -2.0917205107311361 47.10242039202906, -2.053914414261385 47.093914403166806, -2.0290204384559161 47.067321306624464, -1.9957185169095339 47.0461193496168, -1.9786935137074693 47.023746331771875))'),
('Loiret', '45', 'POLYGON ((3.0050775558217708 47.58616233646741, 2.9638135471096803 47.598133278370696, 2.9465685189494479 47.611080427008304, 2.9373174375689075 47.624370286520744, 2.9374094960113837 47.668090301825728, 2.9241395267551695 47.681202381171985, 2.9033535049284183 47.688533436757709, 2.8928305032697494 47.7154233029636, 2.8795485646558063 47.728534326190058, 2.8594675027949847 47.727680277312473, 2.8383924561831861 47.737732425560679, 2.8476905348948094 47.768177367030447, 2.8670324889162089 47.777195397975319, 2.9670234472191908 47.786827386563445, 2.9866304873101797 47.793110419268473, 3.0083235400244348 47.821327300001983, 3.0067624189413209 47.884105349122379, 3.0164155299254389 47.911811419913036, 3.035582520100121 47.923545438941389, 3.0953205283786929 47.934139376646542, 3.1292344713486955 47.962806340434454, 3.1308784978360222 47.990177269208843, 3.1216205516767559 48.003482442458349, 3.1189955659159807 48.033420270404562, 3.0883355280471392 48.059517342681218, 3.0830934774241143 48.072971428822413, 3.0830475362128595 48.119403383751646, 3.0672914609494626 48.1597364228608, 3.0487014642250472 48.186290442970559, 3.0312855206773577 48.199230374789565, 2.9659995390739198 48.202053383012654, 2.9672114365434368 48.188442287061307, 2.947726554309213 48.179458403989926, 2.8586634435878864 48.17575441583439, 2.8186924775498881 48.168625431170241, 2.7941605748155496 48.170314342749023, 2.7632544610334833 48.196323405042435, 2.7435514900607529 48.190025410640217, 2.7342245440746069 48.159561282994119, 2.7150344952843284 48.147800332910904, 2.6912865854808672 48.141315405304269, 2.6265765412079247 48.138492397081151, 2.5874515271289908 48.123123389724142, 2.5254664479577968 48.134033283269233, 2.4836875808435934 48.14582838122594, 2.4863615001550556 48.159610392564772, 2.5187375566775358 48.202049334553422, 2.5090335759231266 48.218017337856523, 2.4523014606128584 48.256439328189131, 2.4333365413597505 48.282909386774847, 2.431447495079027 48.3019413696352, 2.4071044617687676 48.300842300964248, 2.3657154788804178 48.307144343825669, 2.3480985205309537 48.3200073549193, 2.3278204923275609 48.319072336857133, 2.2683875266509688 48.302650378060363, 2.2475305687777052 48.307144343825669, 2.2461275136245433 48.320747342858553, 2.2325324354901568 48.33377440456097, 2.2122385654897982 48.332813335543747, 2.1337005686667396 48.304504396367761, 2.0722914268259842 48.307037323686032, 2.0180345042849694 48.29453233720433, 1.9829875207904877 48.228897308007291, 1.9778394648295716 48.2013133950734, 1.9848464676569222 48.1743163327079, 1.9331585565273315 48.16355130359527, 1.9382184264850082 48.117340429744004, 1.8592465404444738 48.096992345593961, 1.7756365282860429 48.081833330056995, 1.7144475874233933 48.084179324170819, 1.6809175440004083 48.057850433598261, 1.6418324864538931 48.044864384548035, 1.6036824469695432 48.02373934826575, 1.5546754959500504 48.026649310352312, 1.5463604887514748 47.987026335788116, 1.5680864571994562 47.9808424023242, 1.5201505876762553 47.940010346609952, 1.5137135375005073 47.925983315477723, 1.5193044596971959 47.912605269962071, 1.5642794973634864 47.873958326112231, 1.5371634455006244 47.828743373231546, 1.5764634234262758 47.803470426438125, 1.5635454941030957 47.775409323375, 1.5851834525678328 47.762878285938243, 1.5907625814267305 47.749500416442558, 1.6157774829492269 47.742607298533542, 1.6601894327426407 47.742202276590561, 1.7015444437774363 47.733398285924991, 1.7249804462001919 47.704517281857775, 1.7561014803613659 47.678775417873553, 1.7973735859919202 47.6699334068952, 1.8189025880973873 47.657375438403577, 1.8432524861863442 47.655872403909441, 1.8574835244597523 47.672992281873448, 1.8763475842720538 47.684890351510589, 1.9794884198759632 47.662696345971611, 2.0991334156009884 47.674053330231644, 2.1438004183258954 47.6707342977429, 2.20934550132003 47.6601903497082, 2.2302364310468477 47.652988316757941, 2.24934744687215 47.623809310887438, 2.2690615071028049 47.627487424107912, 2.2896695727434064 47.622978320625478, 2.3282075602339489 47.600174405902479, 2.3693184315751807 47.591144405599877, 2.3893354221682159 47.59208628844074, 2.4474964675667081 47.613891289853726, 2.50332841676817 47.578151315751015, 2.5446614253071402 47.566341432117085, 2.5619985119098487 47.553451313948628, 2.5673005853414566 47.540027327221722, 2.6096645428243619 47.517311422481995, 2.6282695012459385 47.490795422685, 2.6807524945643308 47.487636392345806, 2.6979174336397875 47.5184513277852, 2.717396507215085 47.524791390959408, 2.7996434207527727 47.503715288227809, 2.8188855714531371 47.512748280869843, 2.8583754749226671 47.519901380269417, 2.8719075379090384 47.547802305163017, 2.8866875824580518 47.5620993509239, 2.9276865051005814 47.552890338315322, 2.9660125645514483 47.573623378132154, 3.0050775558217708 47.58616233646741))'),
('Lot', '46', 'POLYGON ((1.0915474258112 44.599861270524414, 1.0754614891305607 44.58567828570186, 1.0388364866361712 44.572506359566987, 0.99962258247416 44.581077299796917, 0.980674561137846 44.579921376676751, 0.9866034416702405 44.498008373015566, 1.00117155817955 44.471454352905809, 1.030894465746627 44.445842391656882, 1.0324944872423316 44.432243265063263, 1.0193054871707261 44.414989435904729, 1.0262765819248898 44.387962274124973, 1.1009194329087677 44.4007342828959, 1.1138364821321147 44.38779030261766, 1.1003244854219076 44.373256333981843, 1.0638174163051133 44.3600963772047, 1.0691805686651037 44.346691400634157, 1.089331510452638 44.336956440365626, 1.1000585192525136 44.3101693698202, 1.138759501232073 44.3042683004425, 1.1591874984469257 44.2917863725764, 1.1777405309783546 44.262737269441189, 1.1969075211530367 44.261127390827355, 1.2503765783238805 44.29173638290591, 1.26955043327726 44.290119287473473, 1.2824104520314563 44.2771603454981, 1.2779685881762362 44.249477333323071, 1.2832754141469422 44.236080277651, 1.3425615791714733 44.214889409901261, 1.3561244456519717 44.229389406683524, 1.3740584159611728 44.238659322200519, 1.4288224520257131 44.258285372447872, 1.4582554547079383 44.301105397664045, 1.4960064569281712 44.303260410114191, 1.5193384315507217 44.263466344142515, 1.5385054217254037 44.261806299838256, 1.5483405373548749 44.276077294644082, 1.5363474169358255 44.316520346232309, 1.5694525481596315 44.326610338773335, 1.5822335339488518 44.313617424944411, 1.6017104952845784 44.309234351758036, 1.6560364176524729 44.334186414152455, 1.6749214238408001 44.335239365592187, 1.7141365601425491 44.323692279768309, 1.7318784926682724 44.335636290616705, 1.7504774664109846 44.33939730924142, 1.8074505530554177 44.33975938231255, 1.82689354253759 44.335331424034692, 1.8589385055030334 44.356243300137507, 1.8769925214294005 44.36543242248986, 1.8519855408054013 44.4600183356808, 1.8681045692397618 44.4882693642878, 1.9048724999469755 44.501201375208311, 1.9243554459615666 44.49674243741633, 1.9422015823074616 44.508678351346262, 1.9973095613866008 44.56636027039589, 2.0154595081947093 44.575538303490347, 2.0344124580900882 44.576530352021663, 2.0539504983541974 44.572048355614086, 2.0916085620321212 44.576740343841735, 2.1298385145812517 44.575958287130462, 2.170778470534998 44.586280273987356, 2.190877486432413 44.614692360863742, 2.17759554781847 44.633194347604885, 2.1580844386092508 44.637676344012462, 2.1325874183984581 44.663787321866508, 2.127431441539045 44.677227326410375, 2.1247154534555932 44.704483314146628, 2.14837957775498 44.774185284670196, 2.1514064170993095 44.820903272045015, 2.1206534406881588 44.860450382003634, 2.06499047065455 44.956234287086758, 2.0545975477511433 44.983112359954887, 2.0649524503417638 44.994594318391151, 1.9729505102593805 44.99258839485266, 1.9355835836061033 44.982406343869158, 1.9164704555412015 44.981403382099913, 1.8765565199723255 44.995727358915659, 1.8388144947703893 44.952625349713131, 1.8208865091400526 44.940693308222436, 1.7982494613453355 44.936737435494805, 1.7383884151101654 44.958183356176065, 1.6470014887908064 45.021705265674981, 1.6028695867641432 45.038478384304952, 1.5822694420220387 45.05103336045714, 1.5389984536516295 45.059585290530677, 1.5198645552306687 45.05850928047532, 1.4458265088517805 45.032406399539767, 1.4222884148484241 45.036571383987635, 1.4079005427848017 45.02752342964844, 1.4018044432842203 45.013458378203453, 1.4086994974128686 44.986431392443635, 1.4270245840876612 44.960060433099059, 1.4163405241596365 44.918316417938243, 1.4232135757924596 44.891304393875586, 1.4053625108874996 44.879333275952362, 1.3684724223235492 44.86624531134153, 1.3547634592708278 44.851741266100007, 1.3399485627684271 44.779594378241441, 1.291011491675647 44.738350435805515, 1.1956134223591732 44.702587403087207, 1.0915474258112 44.599861270524414))'),
('Lot-Et-Garonne', '47', 'POLYGON ((1.0262765819248898 44.387962274124973, 1.0193054871707261 44.414989435904729, 1.0324944872423316 44.432243265063263, 1.030894465746627 44.445842391656882, 1.00117155817955 44.471454352905809, 0.9866034416702405 44.498008373015566, 0.980674561137846 44.579921376676751, 0.99962258247416 44.581077299796917, 1.0388364866361712 44.572506359566987, 1.0754614891305607 44.58567828570186, 1.0915474258112 44.599861270524414, 1.036847461014446 44.621742312562915, 0.97950754875978419 44.653915418064017, 0.96018953345384261 44.655475307007336, 0.92321249102639058 44.644973427744659, 0.87025054737910068 44.608768408890413, 0.85063241803021583 44.613052382835647, 0.85161056098419863 44.667968324131309, 0.84070858833760553 44.694721422823207, 0.78172447357565034 44.707485334675667, 0.68983553831176891 44.676979314277546, 0.6694885102815249 44.686660412436325, 0.64329550712309924 44.712410373339011, 0.60600444507539919 44.704525382918618, 0.58598041368369991 44.711475355276818, 0.56837155225269953 44.699367293819634, 0.51071850047759426 44.701107427208669, 0.49208045030229641 44.697132368304679, 0.473799544639121 44.6904483621159, 0.42070646611674078 44.656753387984267, 0.39865855714998588 44.649807288065333, 0.34141457577706547 44.648758385084804, 0.32067643138120161 44.661075382242259, 0.30773949190165695 44.701389411195052, 0.34417157651273556 44.744999414020967, 0.29143652260225394 44.796367320851445, 0.23549843336098775 44.784362407094633, 0.23530445935787725 44.756885338280412, 0.21700841597757403 44.750171408697312, 0.19692753013669062 44.75704534043, 0.19131143708480636 44.770397334990619, 0.17085844503469616 44.77997933390823, 0.15188155642385937 44.778679426455469, 0.133589561502788 44.771942438256744, 0.12438354123364093 44.754840338309364, 0.10721754603841305 44.739940424163123, 0.088972548448367661 44.7331814334686, 0.08702541557869381 44.719310356026696, 0.09263446783191398 44.705989340980196, 0.11088457000099083 44.712734426097356, 0.14884151558206327 44.71534339404117, 0.16928957907308018 44.705730415609438, 0.18248544392338317 44.692917394186324, 0.17850457636049555 44.665195305578706, 0.16064752677669958 44.655735288497894, 0.15487055147539763 44.64160528568523, 0.16046745835095066 44.628280398199465, 0.15470650086660953 44.614151275486634, 0.11608754419145839 44.616977276049184, 0.078190445399002328 44.614364435666104, 0.030664526377819357 44.569873276887776, 0.015434574794369382 44.541347305093055, -0.028185461169641712 44.497116303825223, -0.016923527691517393 44.470432380980171, -0.024566490657917939 44.442443270083359, -0.020505534010254678 44.412513363035643, 0.01562555645804764 44.371112410789593, -0.0775954979124549 44.35630437906589, -0.08327548621221581 44.342174376253254, -0.058834585800553896 44.302707355379383, -0.10037054536093137 44.244838327105342, -0.13838557753095415 44.244873355078667, -0.15724541286405724 44.216056422279294, -0.12490244809526985 44.174430340496045, -0.12267245113940817 44.158107304920506, -0.10275244754794244 44.15128741131754, -0.04563044801182059 44.149856368989717, -0.008415426589664321 44.15522040144954, 0.011110468296777753 44.151115439810255, 0.03173648797394435 44.138839279285023, 0.070071524443108046 44.1360243679804, 0.10764650669682396 44.138641432842647, 0.12715743988607642 44.1345142926876, 0.12144946441168258 44.120376368976437, 0.10412153084723741 44.108204412271405, 0.094674539243925437 44.09380738716952, 0.083273549992242124 44.065555302442718, 0.079397414309454462 44.037819308257767, 0.086023509929248121 44.0108373836094, 0.10626756627908662 44.006744391327814, 0.12523054931256183 43.977863387260626, 0.14433646055886129 43.9764554035484, 0.16233855059508073 43.983188343287893, 0.17572046854999712 44.025295311619672, 0.19305843525253863 44.0374794137024, 0.2128795156228307 44.030590344252616, 0.21842555272803565 44.017250319049722, 0.23823343160083255 44.01038342811573, 0.27612454571442413 44.010227298405411, 0.31467555868249519 44.0046002921156, 0.35011453864245823 44.023471392726563, 0.44324951924934908 44.035198370956223, 0.49507050147363429 44.074325321254761, 0.53127041574887812 44.087696325971777, 0.56883254854503207 44.090149340225238, 0.60506256223453647 44.103492357767564, 0.62453054655196638 44.099285304547706, 0.6412795504465123 44.086635277613581, 0.66105856204478641 44.079685305255381, 0.67026845475319874 44.066555271872531, 0.67735941910456177 44.039570354884731, 0.69580455139654873 44.0434992965575, 0.71843350227280212 44.075164408435185, 0.74650358235422232 44.093410286125064, 0.7582055657486535 44.121593371024986, 0.7760105134223636 44.130951296525225, 0.795284523736683 44.15962230877237, 0.81344256746325527 44.166267414548528, 0.85205958791880221 44.160450306694869, 0.87086344890252576 44.161651290926457, 0.87890456903321024 44.189579322894915, 0.86973850529648189 44.202713404736969, 0.8718614821127062 44.216564415902681, 0.92642855183473216 44.236423340565764, 0.9307195665786594 44.264133283795687, 0.92206448880475023 44.304756403809662, 0.8848315133459721 44.32985737909577, 0.86497646112215421 44.336845371766756, 0.86171357900272483 44.364086397805849, 0.86974343385554675 44.392025343012207, 0.88832656580126468 44.395919432731617, 0.90785650914691018 44.391647428144083, 0.93755547799855776 44.366066270389311, 0.95643854796722394 44.367221313409644, 1.0262765819248898 44.387962274124973))'),
('Lozre', '48', 'POLYGON ((2.9596084301094265 44.653297411961532, 2.9634535862781206 44.637420410981164, 2.9798285477438071 44.62445442820713, 3.0359915905023058 44.591289274174713, 3.0552224759248361 44.58938931465606, 3.07511044388238 44.5792843604179, 3.0758305415654377 44.524566265564587, 3.0856915321299994 44.497608279631677, 3.1079985424874792 44.457489280801795, 3.1329754236971894 44.4311862651643, 3.134090510185132 44.417522363223, 3.1162584554365651 44.403080277009693, 3.1098145404821196 44.389122421724309, 3.1056134719410977 44.347881295607849, 3.07515656111363 44.3027613935091, 3.0762815047196739 44.289127414962124, 3.09563243575937 44.284458309330105, 3.1140754558117294 44.290741342035162, 3.1627544816335842 44.251735317453623, 3.1820804178380513 44.247085397997964, 3.1966735291826183 44.206627384712576, 3.2162034725282638 44.199226273180173, 3.235088478716591 44.200012378350678, 3.2721755336230842 44.209774269674071, 3.3099175588250205 44.211330286178153, 3.3487264410440503 44.1992414108973, 3.3659554513873218 44.172550271233618, 3.3820744798216822 44.159515288632704, 3.4401065025847117 44.142681267094318, 3.5167434837693179 44.129303397598633, 3.5774684360002027 44.126178339112968, 3.6147545694888379 44.133106308975371, 3.65149046456213 44.148178370648864, 3.6608304360258046 44.175899403136654, 3.6550814478991924 44.2030524191925, 3.6578644995898912 44.21685027232833, 3.6948445343567471 44.229187335761949, 3.7139294992270209 44.227172435205162, 3.7530564495255589 44.209488413248451, 3.8380135424878006 44.130497341031557, 3.8572474202497347 44.125709421922167, 3.9042215166758751 44.15750126817575, 3.9417685117549013 44.161594436477273, 3.96008655763103 44.170448416813358, 3.9629614917442666 44.184219338894323, 3.9469075906975206 44.197338283019249, 3.927667552236727 44.20213341894727, 3.9144894654030225 44.229011315795432, 3.917341516920601 44.242817265849723, 3.9354985045273736 44.254398323527155, 3.9459065651478795 44.268451405614442, 3.9066395029559828 44.288944354196914, 3.9178554952228524 44.346813382470955, 3.8794354411098766 44.353645421451589, 3.8709315644871936 44.367027339406533, 3.8804155202834636 44.394733410197162, 3.9179324159482292 44.401558408379159, 3.9363064361737088 44.41040429179678, 3.9534055437816846 44.438377384876631, 3.9731685375629979 44.494896340007429, 3.9793565194861173 44.5049513045751, 3.9737134953793714 44.532119282328111, 3.956655576443552 44.558879421818673, 3.8923234470387342 44.6085964373831, 3.8800094422206826 44.676571299995132, 3.89029956946365 44.693348291064368, 3.859279570763249 44.700447352334223, 3.8269045703605684 44.726650388630716, 3.8221344292678054 44.740146367523963, 3.8278385323029624 44.76774242583555, 3.8230775442484344 44.781246325627265, 3.7839704842060939 44.79350629231557, 3.7715705816443972 44.806736305039394, 3.7524954738922531 44.80604137821156, 3.7151264349993767 44.793712411696376, 3.6958694986218177 44.795730304592595, 3.6834335119669674 44.808956268857187, 3.68907248761451 44.836525396113885, 3.6842694307879924 44.850025423466334, 3.6643735419319512 44.86022542848643, 3.6456844459663671 44.854046423581607, 3.6286265270305762 44.826034430089138, 3.5961075422952717 44.800190298504347, 3.5022135635927327 44.777412434736434, 3.4825324190958327 44.784862303799557, 3.4342865784115872 44.865062281146507, 3.4092535468325593 44.891452426667442, 3.383150489877039 44.931472326256156, 3.372328430295255 44.972099318709425, 3.3602164963988059 44.979824306980234, 3.3262115511060983 44.972976426202607, 3.2710074651252228 44.943367403553864, 3.2516885697194482 44.945320345082436, 3.2328065558705816 44.94179536923285, 3.2246545431609945 44.9003944169868, 3.20618952061281 44.891437288950314, 3.1684594647685742 44.884380296452477, 3.1286965543309861 44.901882313763807, 3.1105295335861172 44.890167304891847, 3.0833634920527686 44.8479424031825, 3.0410245294051208 44.805069395956409, 3.0200804416484175 44.73571031232764, 2.9881085269690573 44.706962379355147, 2.9596084301094265 44.653297411961532))'),
('Maine-Et-Loire', '49', 'POLYGON ((-1.2137684737466259 47.815597322031763, -1.2383825778053108 47.72037932114101, -1.1970754442014311 47.715294280328138, -1.1326274936586174 47.692726408380267, -1.0899884169680263 47.65477333523846, -1.0248064631648219 47.626716280634568, -1.0106305191409035 47.614067309820243, -1.0288274632800665 47.601711412250168, -1.1520104603322068 47.589687312317, -1.1617394359218736 47.575229384306724, -1.1555144898057961 47.561973320627871, -1.1231704689172091 47.536983413940632, -1.0802275817644329 47.521007313719068, -0.99835048617640609 47.513412404203549, -0.95589658249062381 47.500110399313414, -0.94357852921336871 47.47357538936005, -0.930441455031854 47.416916322335894, -0.90881951438407782 47.407543435138493, -0.92782755852900323 47.400634299412516, -0.99496456610037853 47.392891357105114, -1.0373665438960415 47.381469421477433, -1.0810705413840935 47.378162358346387, -1.1459745596601749 47.381492304073092, -1.2055754483848204 47.3769494047571, -1.3056445595529453 47.350013421319986, -1.3597425360641751 47.312843284989256, -1.2984034501700989 47.306621331212611, -1.2564985527598935 47.296135293746929, -1.2383934910432401 47.283783268616119, -1.2220084964394573 47.257595370036725, -1.2013025636974817 47.253692303299047, -1.1871824180029478 47.241035411586225, -1.160685428362342 47.201858295597233, -1.1703334347674286 47.187393326788268, -1.2292054248107149 47.155418419769504, -1.212849473501393 47.129196373316617, -1.1948204524102835 47.116867406801433, -1.1741715501374586 47.112934416669432, -1.1341775254838069 47.1132663903263, -1.1126354979008397 47.103931347421693, -1.1100015351217962 47.087635418920982, -1.1253365706252509 47.059017388683756, -1.0559954410330761 47.025840441313605, -1.035410434008071 47.021900410382941, -1.0169624853966468 47.031540319869563, -1.011241484444696 47.045700422096488, -0.99321651181284665 47.058036429410336, -0.97261143851164888 47.054103439278336, -0.920381561905117 47.052524364158657, -0.87795758161362869 47.011741418015063, -0.85650849257297068 47.002361313999032, -0.81788742365822031 47.010708356831529, -0.797717471714293 47.009452278350423, -0.78374553483158138 46.996757366324843, -0.74596548931688744 47.010509278249415, -0.64598650037163452 47.00954838525216, -0.60420851335726411 47.0235553501082, -0.55386750701151755 47.060100439537777, -0.55215553681711071 47.101390323184958, -0.45014052491907819 47.11413540090102, -0.44805345617601233 47.1005362743074, -0.42665048436657571 47.091087346484457, -0.40687745744716608 47.092468399141794, -0.36974446132938965 47.1115343538557, -0.33137650912649974 47.122444423420731, -0.22804750817837771 47.126850379202793, -0.18726544213461693 47.121399392879496, -0.15323743822631286 47.079845303262559, -0.13266950513809661 47.075767272678164, -0.086700482720829086 47.117279293523083, -0.0672985058908182 47.121330393052617, -0.02614046119856539 47.11310938051615, -0.0071355854130672469 47.119884389027632, -0.0094585209112665325 47.136181373648142, -0.0034655691110572207 47.150295358643845, 0.015572574448128762 47.1570473085397, 0.055586489357978053 47.156959298556458, 0.070286444822244221 47.16615634180728, 0.10102058709699691 47.288822368217737, 0.14296948949882449 47.332706434131538, 0.14903144112594191 47.346809329869345, 0.14083454332487122 47.376430321875816, 0.15086152071788206 47.390785278205684, 0.17002446243333225 47.397522442424346, 0.18405254968536156 47.412128403226475, 0.21877548042149897 47.537708440182726, 0.20891149751750504 47.550785315535663, 0.23289545009603785 47.609882435116148, 0.21786457709472984 47.630825290733085, 0.15980544725684354 47.613376431451641, 0.11909150094012944 47.61622637072962, 0.10116457142962076 47.628746318908483, 0.059637412867544981 47.637004295637908, 0.035773505906178116 47.6628493073225, 0.014211412047018257 47.672386421148659, -0.0065554236034017777 47.676498423586608, -0.026181473850783732 47.672454364855739, -0.066560454171195715 47.672500306067022, -0.084547582510282382 47.685024302705116, -0.10455154762576058 47.683685318819769, -0.10058458564023454 47.656532302763921, -0.11897251144307575 47.644333415004, -0.16134157350501255 47.657920396219922, -0.18093646821830589 47.653869296690388, -0.20211255029087738 47.660667363817495, -0.20610644333129358 47.687793272798487, -0.21614257376253931 47.700840400777068, -0.19212957788951712 47.729873310075376, -0.20215356294309572 47.742897379438361, -0.22216844129650326 47.74155434709381, -0.23215651827689499 47.727157321991925, -0.25177447160581323 47.723091436785225, -0.31343250567923064 47.729847435140314, -0.35304456700549736 47.724369341742161, -0.37427151884841692 47.731117419198782, -0.38238251890578567 47.757980354349783, -0.37959946721508686 47.766399389348592, -0.42653642342827425 47.782337293237404, -0.46493658728505238 47.768699442251133, -0.4830295036240102 47.781135428905984, -0.5038875176170734 47.785179311616886, -0.523085487305849 47.778339351737756, -0.52902352087650684 47.764209348925093, -0.547356528449825 47.751938292978892, -0.60696745031256683 47.744976351262963, -0.6691054908346814 47.754272317734987, -0.70871051136231245 47.74867241852003, -0.72915646261373013 47.749946275017763, -0.77660053235047144 47.768474312713963, -0.79076257079702827 47.781166408420077, -0.81164258728591676 47.7851333704056, -0.85080949411687357 47.776786327573106, -0.893009577010929 47.787422334050277, -0.90320254123236055 47.800373355127149, -0.96239752791422006 47.790538415517645, -1.0460054278330517 47.80628938620201, -1.1269804210926111 47.805698311154416, -1.1478975777944243 47.80959732943289, -1.1692635854108744 47.816227297491949, -1.1794984423843573 47.829166349211093, -1.1711024660011446 47.851772417491716, -1.1950765614615761 47.82524127997759, -1.2137684737466259 47.815597322031763))'),
('Manche', '50', 'POLYGON ((-0.81665246757310683 48.527908409819119, -0.75633341738503646 48.587028411995234, -0.71917049787293763 48.61158742180443, -0.70913753580109073 48.626007329501945, -0.71565749138108 48.666656324451012, -0.71054252717388522 48.686184331577024, -0.69236248095148767 48.701156413909516, -0.81724547884030585 48.78546135289578, -0.85756654859176251 48.7798383950652, -0.96755244865380519 48.821235298852017, -0.98796953263075693 48.819767292331207, -1.0260514523880317 48.800529366110041, -1.0904015358294714 48.814994334918978, -1.1316574476230983 48.839363419184266, -1.138024441852167 48.852611385944684, -1.1099445046526455 48.882087337498731, -1.0686364909489043 48.907047320791648, -1.0300414729891827 48.923576299728055, -1.0445615360476666 48.936195347148058, -1.0663714660196888 48.942829363666348, -1.0868225218501379 48.941333369970877, -1.0622705528396068 48.992466290146027, -0.999989584104668 48.991504341028971, -0.95995841923809166 48.999889404174255, -0.92123244242330316 49.01635730418225, -0.86969045184594052 49.055679284603727, -0.86595354795665 49.083343286622366, -0.846211500551334 49.114872335065925, -0.84887855508409871 49.131103312199016, -0.86984957389569217 49.132339324403929, -0.902324553639346 49.102646340231175, -0.92191944835263939 49.095768360039287, -0.92417356004392559 49.10928739754813, -0.89991043979847518 49.138427326986076, -0.92083446127898583 49.16430243808496, -0.91484344569840914 49.178417303180495, -0.89608957438517223 49.190727435559253, -0.87180744398332877 49.219844306381574, -0.87216458849539436 49.247192352560333, -0.8908415390832829 49.259563387847507, -0.910530428458685 49.252685407655619, -0.93892755363791025 49.223274407469219, -0.95903255421418976 49.219078443507257, -0.98458150031510172 49.222713431835913, -1.029336513023253 49.2413903824238, -1.0709015158781199 49.265773372266452, -1.129551544743606 49.33638730223656, -1.1434504333402344 49.342975377543596, -1.1442604772261689 49.351783416668425, -1.1332514844399384 49.356781327597886, -1.1487604276703394 49.362384395172242, -1.1793535779519004 49.350483333195669, -1.1810484742095468 49.364284354690895, -1.173850489718518 49.365276403222211, -1.1672525572933523 49.3979763364831, -1.1612525646944789 49.394382360806631, -1.1699465428810072 49.415077380310706, -1.290742533167105 49.523471355795536, -1.3041395888391492 49.544574389581996, -1.2987405284060003 49.579368432384612, -1.2834385846562384 49.58716928526097, -1.2584414611503689 49.583561404007142, -1.2623445278880467 49.596668378774368, -1.2489485283358022 49.615165436956474, -1.2295474316056527 49.60936733925918, -1.2225414848981018 49.611667392161749, -1.2225474695769663 49.62326041919691, -1.2368505000167147 49.647167275030128, -1.2330465325201772 49.649166333789921, -1.26664152731081 49.677066378583689, -1.2589725133893808 49.695552347507871, -1.2896404721567194 49.689857397510977, -1.3748285033150296 49.703964341708016, -1.4195284217736628 49.699863428527962, -1.4459305366522983 49.691059437862364, -1.4649294277589604 49.693557337207309, -1.4810285659370948 49.668258339458859, -1.5057174784815857 49.659462269691758, -1.5347264490644363 49.654064441398347, -1.571613545288983 49.653968334496639, -1.6199114878833143 49.64026236378335, -1.632418586604615 49.655658302195221, -1.6720155102137824 49.6582642777996, -1.680010513113217 49.6625674379212, -1.6805084735985076 49.669567399949884, -1.7027054714769179 49.671566282689739, -1.7084074622724756 49.679962435092889, -1.7518984756010241 49.678360301357586, -1.8173045028216279 49.690559365137474, -1.8332964448401583 49.710456310113344, -1.8465035749683238 49.717666439982068, -1.8790945518699402 49.70566135020529, -1.8888914711666871 49.718364359149334, -1.9136905722102142 49.726860314873491, -1.93489552155728 49.727962375883905, -1.9371915260006176 49.701664288805475, -1.9294904764452667 49.689170391581641, -1.9385935250339799 49.672363301098144, -1.8971975013469944 49.666763401883188, -1.8658025801179008 49.655964400917, -1.8503005016661973 49.643463286874564, -1.8386004544913988 49.619171299354591, -1.8334965795420999 49.572666296139275, -1.8485985646098868 49.559272408826629, -1.8477974977422491 49.552570272581292, -1.8668064219869791 49.542976304305924, -1.8747935039879451 49.522579286605193, -1.8662044337014834 49.51377142350033, -1.8415054880188961 49.505676441259894, -1.8376964159433555 49.472179313570635, -1.8276995379646337 49.468372353734665, -1.8236014411040458 49.455474314667711, -1.8076075628658543 49.376175383529372, -1.8039995055920883 49.371780340985268, -1.7877025209715498 49.371181345039176, -1.7838035026931038 49.378482301210639, -1.7682074295792916 49.37988236402434, -1.7579074452181942 49.37018929650786, -1.7772075064875708 49.374786409973538, -1.777501459831683 49.370479377412678, -1.7506145859652236 49.355678386487639, -1.7205125313902556 49.325088404565477, -1.7083185721893983 49.334480301919243, -1.7162185243069246 49.345985318971159, -1.7074094290622952 49.344288310473885, -1.6928184299573275 49.329387340207873, -1.6701174869147621 49.329582370330783, -1.70891351967623 49.322288278938018, -1.6822155152338496 49.289688325018133, -1.6568135458049937 49.280986425933108, -1.657113483827942 49.277782334482495, -1.6759784237400766 49.2789232959055, -1.6615194396100037 49.263286386159436, -1.6489174661267327 49.233688276748623, -1.6262255001024641 49.209293317548244, -1.6217274858779263 49.2097893418139, -1.6275255835751921 49.222892444141863, -1.6155175014589815 49.230590325337815, -1.6171164668348865 49.235889406430019, -1.6043275601471692 49.236190400572767, -1.59862046477258 49.2317923656892, -1.5800195548102636 49.2338903476702, -1.5354215519122363 49.219692401150482, -1.5459285357539443 49.215194386925944, -1.5680234420517536 49.2222902798364, -1.603520508600667 49.21949437868814, -1.5887244462346928 49.170192418204763, -1.5880284632870598 49.1469004001146, -1.5718295217878904 49.136600415753534, -1.5757204431479011 49.126899427338529, -1.5923265188296227 49.130397296113287, -1.6035254371597318 49.099701350171259, -1.6034254578187301 49.078899310527547, -1.5864205208928581 49.078594443945533, -1.587527510462337 49.069999388980207, -1.5998295459226313 49.069004348109459, -1.5915275642015843 49.055999288902839, -1.6008235306736083 49.059501382156796, -1.6006225158718337 49.049705342959882, -1.5834334620609809 49.007503323846166, -1.5758255270679058 49.001709274608132, -1.5699295622692375 49.003498341547882, -1.571425555964737 49.01990129018823, -1.5377254772540425 49.038795273394854, -1.5257314767351602 49.038395356030904, -1.4990655079267015 49.025226422235463, -1.5273265696718 49.033702311683456, -1.5460334436539824 49.027797369866491, -1.5512295530657525 49.011905407188962, -1.5427235642034702 49.002998268822992, -1.5538284878714705 48.998806353320234, -1.5591245766242139 48.987404307948751, -1.5579355617503552 48.94100227641384, -1.5467285465017824 48.941105424114212, -1.5426325618807937 48.928905304214524, -1.5483315603369192 48.916107420508538, -1.5544355807359977 48.930301318569022, -1.5577255699302839 48.928508379190035, -1.5672304721025796 48.8756143792498, -1.5892315597582467 48.840114320361479, -1.5684244155355032 48.803016352217028, -1.5665304406957148 48.745216323769867, -1.5495314884487073 48.731723337216081, -1.5275414900509361 48.729221389411904, -1.508930546950495 48.6903234410898, -1.4958374777606309 48.681923416247386, -1.4544444464130777 48.671524332645177, -1.4486484609553827 48.655227348024638, -1.4417405573691724 48.654621311279911, -1.4389355031826767 48.665523283926504, -1.4088445378656047 48.67042139153493, -1.40984749963485 48.657920277492494, -1.3772445533755047 48.650921371583607, -1.3605525799501095 48.638820350925059, -1.3646415237724625 48.636127421457232, -1.370848515851975 48.641422278070209, -1.4259404771141533 48.6441233044565, -1.4465374534968873 48.637123342427813, -1.4530475519587469 48.6302223036203, -1.4580405343291432 48.636322275560147, -1.4726364619931758 48.634330433618985, -1.4687455406331651 48.6265264123832, -1.4810465199736882 48.631324364630686, -1.4870354233146656 48.625522394494155, -1.5052344796934278 48.634330433618985, -1.5099384372788052 48.627529374152445, -1.5468774593934711 48.61597436743007, -1.5380514662320479 48.589237286555132, -1.494433542507636 48.551468330298306, -1.4770804380879952 48.522640308241037, -1.4399435695309535 48.498058415836212, -1.3732224971404605 48.492183397413569, -1.3534285238450252 48.496444312743208, -1.3395234745495941 48.511222421072588, -1.3206425168205271 48.520897358532537, -1.2769524249098083 48.529670369684013, -1.2585004278391523 48.542022394814822, -1.2347035844850325 48.571254382695244, -1.195468557927029 48.582420385291627, -1.1534974770094095 48.577327423580229, -1.0880625825143113 48.554756383272959, -1.0461135040924887 48.549625401248804, -0.98703750690799552 48.5402452972328, -0.96497146788468058 48.530883323273329, -0.94421853781162213 48.52966737734458, -0.90453448431904349 48.538032374213671, -0.86040557463181244 48.519287303898736, -0.83967147869518044 48.51803228153743, -0.81665246757310683 48.527908409819119))'),
('Marne', '51', 'POLYGON ((3.5322814702942082 48.641521377311349, 3.5496954776222651 48.628494315608933, 3.5920474657474415 48.610920306131291, 3.6320094547671715 48.571396430808235, 3.6371645515267517 48.55792632685008, 3.6584254752231971 48.547756421244273, 3.6794364505671524 48.540310424620415, 3.8494955009240641 48.507923278840039, 4.0159875066593713 48.6361464316136, 4.0566414301675024 48.640159334810406, 4.0765024670701848 48.648967373935207, 4.1113514281023527 48.677349361397333, 4.1320094834134409 48.67525437175577, 4.1522625167815761 48.678627442374236, 4.1830815006802027 48.706840274648513, 4.2029944634730043 48.715618390379021, 4.2435464714205011 48.722297291988795, 4.2641915012540892 48.720188396769871, 4.2852095173967371 48.712642420805011, 4.2943044690669865 48.699287433904985, 4.2858405489767222 48.641769389444178, 4.2999395722752638 48.614895365035281, 4.4658114596684868 48.516086380807522, 4.505896486644815 48.528122274078456, 4.5560084910141541 48.510433323562651, 4.5832245222180177 48.533020381686882, 4.6448915333097034 48.526500426106892, 4.6777065836286909 48.524658377157223, 4.719124433791535 48.514831358446216, 4.7806094402378676 48.510990426756692, 4.8356994652804417 48.547855344465447, 4.8307045466904128 48.56409037005777, 4.8096585433731036 48.574466395044382, 4.8048035606564383 48.587982440213793, 4.8245885569336053 48.599388358024541, 4.9068914448206158 48.59056430108275, 4.9013065073027917 48.617687393744276, 4.86300245034775 48.643970343105579, 4.8831305095396544 48.649944284749424, 4.9446174522055912 48.648735379619339, 4.9853525209182976 48.652465418729932, 5.0133965500446891 48.664035387149468, 5.0062274328281546 48.721119366372804, 5.0096135289241772 48.734825337086122, 4.9965824187625287 48.748138431234125, 4.9556334857904858 48.747158352060538, 4.9345635437577187 48.757545290285051, 4.88644549356917 48.810875291682365, 4.8815885746329 48.82438640829271, 4.8808244719582206 48.837986414986162, 4.9080325822635871 48.865928352531952, 4.9261485572181414 48.909980341493835, 5.0073115398019752 48.931007334654751, 5.030514491789063 48.958824298024311, 5.0173015530019995 48.974853380255794, 5.0322975740499487 49.00246827270378, 5.0233374536740314 49.015865328375824, 5.0023044758342508 49.023544375435378, 4.9818615169222369 49.020332363086268, 4.9608345237613207 49.027996272428666, 4.9749444602977917 49.07194141727085, 4.9740325008512229 49.08826427682645, 4.9414434601692676 49.155597370640535, 4.9446575847579766 49.172008416199375, 4.9644035046025294 49.188831348479866, 4.9538905360819854 49.22945042003461, 4.9822385516905285 49.241024436913378, 4.9436775055843611 49.264625370044783, 4.9230164579338407 49.2641062871635, 4.9027834908418981 49.255462298647487, 4.8911575480730107 49.241542287654894, 4.8711034172670509 49.230152387661107, 4.8285305240838738 49.250877330559504, 4.8075295818779864 49.255798320763589, 4.7456904232590205 49.251491288202729, 4.6626595167904554 49.25477634883795, 4.6219774300876963 49.242782348319068, 4.5617435735634047 49.279312300031521, 4.5208955000321964 49.270023374358161, 4.4586914520226344 49.271011374430245, 4.4188364831425417 49.310764427749731, 4.3974264705344694 49.321052442753071, 4.3347795562891349 49.327404299265012, 4.3135385228489156 49.334961364487768, 4.2610865090446168 49.374298306606377, 4.1987395328222306 49.375156403943166, 4.17744252503266 49.382698331448793, 4.15995458931863 49.395786296059626, 4.1388325453757773 49.400596393684808, 4.0969945355528523 49.404743424096083, 4.0764625105377945 49.401390419753781, 4.0595144280611066 49.406322323195795, 4.0291034584448937 49.367218431512882, 4.0087914583879751 49.361129372810936, 3.9837594829287468 49.363056439404446, 3.9156485568825872 49.385395309375852, 3.8949325910024868 49.384719392704412, 3.8748504730218656 49.375885302624553, 3.8597175084399566 49.356319275185754, 3.8396545766356951 49.3474693433089, 3.7558085217021642 49.358322382404779, 3.7311835044055215 49.3547664270411, 3.686909554265867 49.336895295859946, 3.6673095549735422 49.32259332154, 3.6518275427980313 49.308429346873808, 3.6461674447545249 49.275524350351944, 3.6887494909759369 49.208854323751737, 3.7100185115908459 49.201416424046343, 3.7234785824109053 49.188232352533774, 3.7206164977552305 49.171768324965043, 3.6150935839443719 49.146331327562834, 3.5953724829150815 49.134727387289743, 3.596438459832342 49.121143398413253, 3.6151245634584654 49.094520378476616, 3.5800145648159685 49.068748415078133, 3.572876427113556 49.054855335140431, 3.6038624539604029 49.0286713090003, 3.6136354345416919 49.009929407044766, 3.587033537001048 48.981720271189786, 3.5658715365257763 48.937347397828958, 3.5464584704378979 48.923008283296085, 3.5064964814181678 48.907955407798951, 3.4843095166778539 48.877147337138254, 3.4688114866853823 48.865673299600459, 3.4667275863017153 48.841037369065916, 3.4428054167314315 48.831989414726721, 3.4223214451672277 48.831234289070338, 3.4450674493212148 48.804790281439651, 3.4461844720287615 48.7911834099675, 3.4065815637407297 48.7733573398978, 3.4036235482033135 48.759609300412521, 3.4304424783626928 48.733318430152693, 3.4356435163335277 48.7198643440115, 3.4256524470137037 48.692203334332291, 3.443126477150372 48.679214292942632, 3.5057654704972094 48.66511526964409, 3.527088529241837 48.654976343552377, 3.5322814702942082 48.641521377311349))'),
('Mayenne', '53', 'POLYGON ((-0.37959946721508686 47.766399389348592, -0.36409457244394616 47.797626387529604, -0.37416643492838375 47.810650280872622, -0.39460252906170012 47.811988384658136, -0.41269350918102532 47.824436340670687, -0.4187765832041066 47.837726376203094, -0.41723147993795351 47.854282286194362, -0.39966257503934344 47.871956275012977, -0.36239245936766906 47.893699317397747, -0.35240843084650919 47.908123273554466, -0.35446751241488528 47.921665369678934, -0.38709158107019448 47.9495733353712, -0.36824353907485374 47.959098303819658, -0.32445346782319007 47.9648624296634, -0.26699245383153425 47.98794533603332, -0.29806050598278944 48.032436318791682, -0.30616147290209028 48.059288340704782, -0.2872555203377658 48.068794298996878, -0.24657149741534568 48.068813309153242, -0.23293047806970435 48.113571314200826, -0.24992344563784741 48.1727062780741, -0.20313645843614836 48.214222347378282, -0.16920244918998151 48.260345387266241, -0.16352650934948088 48.304546289119784, -0.12628754921183827 48.328952337578059, -0.11815049819941237 48.356876321087285, -0.12218945235125034 48.38398339593185, -0.1079874573723032 48.398624384707304, -0.026043474197024352 48.425907303498448, -0.012603469653129196 48.44596442664384, -0.024701497972245079 48.472557347166187, -0.045387540458023068 48.473930302905089, -0.1054615708526967 48.464504433697769, -0.12695554498480988 48.471325383420506, -0.15737144316008767 48.53778031362161, -0.13784748449330664 48.544567291490793, -0.12359849218327668 48.559177300752154, -0.1520514156918864 48.584678369422178, -0.17360242029315032 48.591472388090054, -0.19433458001014969 48.592834430591, -0.23337651266487569 48.579265403411668, -0.23905245250537632 48.562461305267576, -0.25691055820900033 48.544841354578679, -0.27682844956086683 48.540748362297123, -0.29795154962351944 48.544803334265922, -0.31784057370086316 48.540714390443569, -0.35432458420206103 48.510868268899927, -0.39659243478325834 48.518955330241894, -0.45874350078290149 48.522915427448723, -0.51964658521990259 48.518703269649805, -0.56194752755479271 48.526725379624125, -0.58182352615460786 48.522609328726944, -0.61941452622528459 48.500789365616825, -0.64055153186529878 48.504783434677208, -0.64676556474344693 48.518055340153055, -0.66789658570459665 48.522037439855708, -0.68778543376200219 48.517879320186537, -0.68157544934305747 48.504627304966888, -0.69565141402597419 48.489936326520919, -0.75777854131018785 48.493744342476688, -0.77676141459988912 48.484169384357742, -0.797051588180949 48.482708418635596, -0.81665246757310683 48.527908409819119, -0.83967147869518044 48.51803228153743, -0.86040557463181244 48.519287303898736, -0.90453448431904349 48.538032374213671, -0.94421853781162213 48.52966737734458, -0.96497146788468058 48.530883323273329, -0.98703750690799552 48.5402452972328, -1.0461135040924887 48.549625401248804, -1.028180413883149 48.416595319209463, -1.0309034427652648 48.383484379326759, -1.0794395403742953 48.30584742871234, -1.0807864451581395 48.289287294241873, -1.0633015017835419 48.23298237939035, -1.0234414283244462 48.164623441211361, -0.99261645974695512 48.125755416283582, -0.99038241433183316 48.112205399260617, -1.001607559636966 48.081211275495306, -0.99938442745977341 48.067646296775209, -0.97887757329991132 48.0417292929243, -0.97980449444364126 48.022453346390321, -0.9990184819493777 48.015545442804139, -1.0593125373021905 48.011066438735966, -1.0968035580318656 47.99182129569617, -1.1226654676332544 47.951465373991354, -1.1711024660011446 47.851772417491716, -1.1794984423843573 47.829166349211093, -1.1692635854108744 47.816227297491949, -1.1478975777944243 47.80959732943289, -1.1269804210926111 47.805698311154416, -1.0460054278330517 47.80628938620201, -0.96239752791422006 47.790538415517645, -0.90320254123236055 47.800373355127149, -0.893009577010929 47.787422334050277, -0.85080949411687357 47.776786327573106, -0.81164258728591676 47.7851333704056, -0.79076257079702827 47.781166408420077, -0.77660053235047144 47.768474312713963, -0.72915646261373013 47.749946275017763, -0.70871051136231245 47.74867241852003, -0.6691054908346814 47.754272317734987, -0.60696745031256683 47.744976351262963, -0.547356528449825 47.751938292978892, -0.52902352087650684 47.764209348925093, -0.523085487305849 47.778339351737756, -0.5038875176170734 47.785179311616886, -0.4830295036240102 47.781135428905984, -0.46493658728505238 47.768699442251133, -0.42653642342827425 47.782337293237404, -0.37959946721508686 47.766399389348592))'),
('Meurthe-Et-Moselle', '54', 'POLYGON ((5.5012605300590565 49.510631403317532, 5.5007615134539662 49.491935442573251, 5.4895425288476929 49.464485304813948, 5.4985695368108622 49.448322271387937, 5.4956555262650681 49.421058362753186, 5.5087035343435105 49.407692286595264, 5.5293205770024088 49.410823329759765, 5.5698505824541087 49.433368319112006, 5.5903745105507028 49.439212358020526, 5.653200437102015 49.426761409668543, 5.6947934271315432 49.424801427341308, 5.70366747374382 49.411354381998777, 5.7055505353456795 49.365108304154191, 5.7279344664285361 49.324669301025196, 5.7582565459616433 49.292522422499118, 5.7587905905400874 49.278930336704164, 5.743453442797005 49.2486994355137, 5.7405255266738777 49.218696304159934, 5.7410644998113582 49.205089432687785, 5.762056464998949 49.197277314533537, 5.7668264300717738 49.181030319583513, 5.7515304710008763 49.150802410732481, 5.7562004567326994 49.137275276305175, 5.79428149639017 49.11341436168324, 5.8030835508361065 49.099960275542017, 5.8093285632284051 49.045581371164204, 5.826326459355613 49.032257363778271, 5.8309784910508426 49.018734277810196, 5.8279164477132213 48.991424427964191, 5.8371944601486518 48.964347276513919, 5.8294754565567075 48.950592372249915, 5.7887805203963865 48.93899529675555, 5.765509448682252 48.903156399431666, 5.778019539742985 48.794391373857408, 5.7358555409420262 48.720054269555376, 5.7615975809462157 48.690536425249306, 5.7545974428975626 48.660446340032067, 5.7680705391951506 48.630695269270333, 5.7323585522671294 48.602794344376761, 5.73807444864002 48.562023367590868, 5.7641725770365042 48.521591405260537, 5.7566565244659671 48.505085308919789, 5.7408985129829375 48.491184308083589, 5.7536685855342284 48.477787428431512, 5.8309225167014915 48.484600281235785, 5.8604804935599475 48.457851407023085, 5.8615015853857244 48.430606332524761, 5.8502984425764453 48.403137360629, 5.8589565126897867 48.389671305130079, 5.8990684707209766 48.406704405250608, 5.91177253578482 48.3932913317616, 5.9122544784531783 48.379665274113094, 5.93290250062617 48.37182640092395, 5.9461004777161008 48.344764387190807, 5.9628424408119827 48.331413272730018, 6.0038955776041973 48.321167326498667, 6.0645175581546482 48.333034416621715, 6.07625949808147 48.346843359015409, 6.133368472140063 48.342254342468195, 6.1727414983517974 48.383739432258253, 6.2336234603928347 48.3900603092561, 6.2537425425664139 48.398510323769, 6.2655415129624146 48.4123004320263, 6.2857554698979641 48.418041323234448, 6.3473895652559236 48.399776435388205, 6.3559075234759348 48.386268311117291, 6.396252531942821 48.40040641084839, 6.47782352880904 48.395965427093032, 6.5181715296153584 48.410080292188539, 6.5583734338494537 48.432361427610957, 6.5786945869446356 48.435318387028573, 6.5739455682478365 48.462513295836445, 6.5940625381818165 48.473632301101745, 6.6143894999358963 48.476593308978593, 6.6394964599008688 48.449604343531561, 6.664192589263962 48.438964288595187, 6.6846265711576791 48.436447379093849, 6.7385175481882982 48.393383390204079, 6.7794555679224118 48.3828883757201, 6.7997425731440728 48.385810307164391, 6.8601955745266707 48.419067343619318, 6.941490572085371 48.430668291552976, 7.0021375474710794 48.458419423455055, 7.0182454866475439 48.472168343040167, 7.0587485610443821 48.488804342116211, 7.0994394487454713 48.4972913208221, 7.0869844519342564 48.510833416946568, 7.1111614984160951 48.532791379710446, 7.0290284697967707 48.562172280482557, 7.0122615118656313 48.589306286382012, 6.9712414668271379 48.597145335591122, 6.9300445217222659 48.615917336960919, 6.8690694451189529 48.5962983275122, 6.8240704687372045 48.598606301313268, 6.8035245381447851 48.603866305972886, 6.7828145569435492 48.61730543041692, 6.7699045485188947 48.647152432060395, 6.7532764703413477 48.660621303878784, 6.6708815240118327 48.684299333755533, 6.6126944276582833 48.721840344155694, 6.5506825934521657 48.742939329482923, 6.4849975745846109 48.747627269251339, 6.46427949646494 48.755539366746561, 6.4348614554798758 48.782432401311851, 6.3525425497759045 48.792289343417181, 6.3480464717709992 48.805851329797846, 6.3517675338632955 48.819538290354771, 6.3677955599749794 48.833347408768461, 6.3470984282313054 48.838546334499668, 6.3060535643775211 48.837997328224091, 6.301553437913384 48.851570403862652, 6.3089635264640833 48.878894335305986, 6.3292735903013693 48.887344349818918, 6.3370844763158232 48.901062289889936, 6.3325084852461373 48.917343432713452, 6.2908945488405834 48.93313629614984, 6.2087574717620271 48.929287443561847, 6.1469945297885715 48.93112931649155, 6.10549148596192 48.941398321338525, 6.0845745052800737 48.951976417246712, 6.02873745149958 49.019226429636589, 5.9608875630637783 49.072624374740982, 5.9521485237658283 49.086116305174968, 5.9598974507520666 49.099853431422346, 6.0006735321169913 49.114112280850478, 6.0125635048356685 49.127929320162664, 5.9997064784209044 49.141327431954508, 6.0193925514768694 49.168880365374278, 6.0146975709097887 49.185138273562231, 6.0183385439173094 49.198799359184065, 6.0463204379955187 49.226486419818329, 6.0495245294461313 49.253757369251744, 6.0237414767897519 49.28058633254922, 5.981491580245148 49.304439326272686, 5.9685775233612333 49.31783638194473, 5.9883195707665493 49.3453792822264, 5.9495295226839175 49.385589283378962, 5.9434034997890137 49.462120300543731, 5.9245874934275946 49.468067311132685, 5.9166664189140761 49.477188313757992, 5.9278415745486939 49.496845343519468, 5.8839464193770254 49.499347291323616, 5.8638495157191812 49.506546331934445, 5.8359554556042781 49.535144295895478, 5.81974859320664 49.536747309730615, 5.8270484932582747 49.5521853169145, 5.8077565289073618 49.551448321314652, 5.7653575434511311 49.560638323766838, 5.7548565442882875 49.557743323377437, 5.7445505752483541 49.5444413184873, 5.7345624982679624 49.5437583610172, 5.6993585049633282 49.541343367076493, 5.6704674677580442 49.550438318746743, 5.6495635125536978 49.550537417987911, 5.6195605572198986 49.5304413944299, 5.6091625297374605 49.509048279738622, 5.5609684389233678 49.529251323436242, 5.5468715278644254 49.527141372097546, 5.5269645497504882 49.512844326336662, 5.5012605300590565 49.510631403317532))'),
('Meuse', '55', 'POLYGON ((5.5012605300590565 49.510631403317532, 5.4842735471697779 49.508846384837014, 5.4695785202645766 49.499450439024017, 5.4535765451079783 49.517543355362946, 5.4680705572113766 49.536243364566459, 5.4509795465218929 49.550441311086175, 5.4503784383362017 49.564140417020795, 5.4234794190920752 49.600742360899559, 5.3723334734393688 49.623970307721876, 5.3544535412599146 49.595142285664608, 5.3337534171768084 49.591983431345383, 5.3067484339128441 49.547874411914378, 5.28597350134396 49.547432425778439, 5.2686654580357413 49.560665430841695, 5.2474585724690144 49.568374401295543, 5.2065464276699913 49.553875284613085, 5.1801914861423768 49.580532276403247, 5.1589754475373866 49.588215371922033, 5.138318448346098 49.585041379885681, 5.1064554900260362 49.5570793760637, 5.0913755074540745 49.52679830918278, 5.0678984923791006 49.499038376282371, 5.0735045522928885 49.471935349897038, 5.0957105271895955 49.445217279178465, 5.0846955497245006 49.417736337925007, 5.0952875512100491 49.374412367544679, 5.059285483377181 49.349067428584974, 5.0517294742742251 49.335262358630516, 5.0426625097786655 49.27241530968324, 5.026832506129324 49.258426298863768, 5.0063135065917947 49.25521833497389, 4.9822385516905285 49.241024436913378, 4.9538905360819854 49.22945042003461, 4.9644035046025294 49.188831348479866, 4.9446575847579766 49.172008416199375, 4.9414434601692676 49.155597370640535, 4.9740325008512229 49.08826427682645, 4.9749444602977917 49.07194141727085, 4.9608345237613207 49.027996272428666, 4.9818615169222369 49.020332363086268, 5.0023044758342508 49.023544375435378, 5.0233374536740314 49.015865328375824, 5.0322975740499487 49.00246827270378, 5.0173015530019995 48.974853380255794, 5.030514491789063 48.958824298024311, 5.0073115398019752 48.931007334654751, 4.9261485572181414 48.909980341493835, 4.9080325822635871 48.865928352531952, 4.8808244719582206 48.837986414986162, 4.8815885746329 48.82438640829271, 4.88644549356917 48.810875291682365, 4.9345635437577187 48.757545290285051, 4.9556334857904858 48.747158352060538, 4.9965824187625287 48.748138431234125, 5.0096135289241772 48.734825337086122, 5.0062274328281546 48.721119366372804, 5.0133965500446891 48.664035387149468, 5.0100264717656273 48.650325367976947, 5.0148585718866343 48.636795417230175, 5.0358714834502223 48.6264033744266, 5.0765954629050327 48.630092400885005, 5.0971625158934444 48.627853426910818, 5.1101344833463429 48.614521322606421, 5.130985456540742 48.606815344492006, 5.2133855074492885 48.59503943271163, 5.2552955094385254 48.574150439204473, 5.3401874750131526 48.507835268856766, 5.3819665181472942 48.486900334138326, 5.42334846023698 48.474140294725132, 5.4408955386597313 48.447235290802141, 5.4328364644924818 48.43248728188702, 5.494817495204444 48.426521437161639, 5.5635855037856459 48.438778411510512, 5.5835935173603559 48.447342310941778, 5.6688285458497205 48.457149439396588, 5.71002249861516 48.447006288825676, 5.7303955776004614 48.447380331254536, 5.7461484845044595 48.461300342247128, 5.7536685855342284 48.477787428431512, 5.7408985129829375 48.491184308083589, 5.7566565244659671 48.505085308919789, 5.7641725770365042 48.521591405260537, 5.73807444864002 48.562023367590868, 5.7323585522671294 48.602794344376761, 5.7680705391951506 48.630695269270333, 5.7545974428975626 48.660446340032067, 5.7615975809462157 48.690536425249306, 5.7358555409420262 48.720054269555376, 5.778019539742985 48.794391373857408, 5.765509448682252 48.903156399431666, 5.7887805203963865 48.93899529675555, 5.8294754565567075 48.950592372249915, 5.8371944601486518 48.964347276513919, 5.8279164477132213 48.991424427964191, 5.8309784910508426 49.018734277810196, 5.826326459355613 49.032257363778271, 5.8093285632284051 49.045581371164204, 5.8030835508361065 49.099960275542017, 5.79428149639017 49.11341436168324, 5.7562004567326994 49.137275276305175, 5.7515304710008763 49.150802410732481, 5.7668264300717738 49.181030319583513, 5.762056464998949 49.197277314533537, 5.7410644998113582 49.205089432687785, 5.7405255266738777 49.218696304159934, 5.743453442797005 49.2486994355137, 5.7587905905400874 49.278930336704164, 5.7582565459616433 49.292522422499118, 5.7279344664285361 49.324669301025196, 5.7055505353456795 49.365108304154191, 5.70366747374382 49.411354381998777, 5.6947934271315432 49.424801427341308, 5.653200437102015 49.426761409668543, 5.5903745105507028 49.439212358020526, 5.5698505824541087 49.433368319112006, 5.5293205770024088 49.410823329759765, 5.5087035343435105 49.407692286595264, 5.4956555262650681 49.421058362753186, 5.4985695368108622 49.448322271387937, 5.4895425288476929 49.464485304813948, 5.5007615134539662 49.491935442573251, 5.5012605300590565 49.510631403317532))'),
('Morbihan', '56', 'MULTIPOLYGON (((-2.88255551540203 47.32750732674463 0 0, -2.8565584319033537 47.3361094213138 0 0, -2.8593615387754596 47.342109420743228 0 0, -2.8810644486078161 47.337711385859663 0 0, -2.88255551540203 47.32750732674463 0 0)), ((-2.989458417352195 47.39310839279878 0 0, -2.98015946528119 47.381305370868645 0 0, -2.9468554551723152 47.372310381295009 0 0, -2.9499584832947323 47.380512414896117 0 0, -2.939658535191783 47.387806307635636 0 0, -2.9590594238341623 47.386707423641226 0 0, -2.9800515650417196 47.39500430078327 0 0, -2.989458417352195 47.39310839279878 0 0)), ((-3.2557305239526033 47.344909364668773 0 0, -3.2456375313306012 47.329914405422542 0 0, -3.2322304102992718 47.323608319372241 0 0, -3.2424364031096444 47.309719262290905 0 0, -3.23044243170051 47.298011314550124 0 0, -3.2122324620838185 47.290012439211395 0 0, -3.1992335635760583 47.295414315964038 0 0, -3.1842334940688772 47.290210285653771 0 0, -3.1650464376180025 47.296619348654858 0 0, -3.1407465291995607 47.282215282754336 0 0, -3.1181464455978016 47.286411422736265 0 0, -3.0988474404482247 47.282512404457819 0 0, -3.0899415342220209 47.275913415912854 0 0, -3.0755534861384604 47.2828142787004 0 0, -3.0630504358763631 47.293415433224212 0 0, -3.0569444822084169 47.309715416743053 0 0, -3.0735484426997743 47.312915277155568 0 0, -3.0981435366020946 47.310516301031825 0 0, -3.1067415839068531 47.319214327677585 0 0, -3.12004042043759 47.320312340228739 0 0, -3.1233434351094047 47.326313388947412 0 0, -3.1387425418806743 47.326015387144096 0 0, -3.15003651099272 47.34331533353388 0 0, -3.15140858663176 47.3605233975011 0 0, -3.1774375391813692 47.35771535097517 0 0, -3.2026425422677107 47.369110355547988 0 0, -3.2200405317788352 47.360912401627118 0 0, -3.2242334795580372 47.365413422636585 0 0, -3.2160425957580996 47.374515407785381 0 0, -3.2405304880219035 47.3825112836593 0 0, -3.2456354190910019 47.38701229022324 0 0, -3.251735566815972 47.385608371965972 0 0, -3.2509315078437453 47.380809346602987 0 0, -3.2435355220103634 47.379711344715396 0 0, -3.2563294895844326 47.359710362629244 0 0, -3.2513375817393184 47.353313274597006 0 0, -3.2557305239526033 47.344909364668773 0 0)), ((-3.5060145648795746 47.642402320665177 0 0, -3.4965105166777164 47.631298432403085 0 0, -3.4562214825601814 47.61619943967473 0 0, -3.4415134301774515 47.621196294484392 0 0, -3.424018453664786 47.613598392629413 0 0, -3.416020505612317 47.619995282117806 0 0, -3.42021959074728 47.63029441451404 0 0, -3.4325225063074072 47.637695350026476 0 0, -3.451021500709146 47.635395297123907 0 0, -3.4627145070852805 47.64229527981162 0 0, -3.4887094877813638 47.646698419274216 0 0, -3.5060145648795746 47.642402320665177 0 0)), ((-3.7199194468790449 48.138340322279191 0 0, -3.7049774757699083 48.126011349314908 0 0, -3.6952074875280232 48.099403291075404 0 0, -3.6275795602700214 48.050808402797557 0 0, -3.6012515497972686 48.023029283720788 0 0, -3.5795215328900554 48.0168453502569 0 0, -3.520014462807552 48.025276354613439 0 0, -3.4994354404614114 48.024463318388072 0 0, -3.4548434222422486 48.0066643553932 0 0, -3.4337085288418621 48.003151348901341 0 0, -3.3753225299261373 48.016903436845851 0 0, -3.3645075111430174 48.004154310670586 0 0, -3.356114528900044 47.963623421745247 0 0, -3.3785185440968095 47.933990301921718 0 0, -3.3717134010275562 47.920856380039211 0 0, -3.3809065873441284 47.906223314035813 0 0, -3.4192064198199716 47.89436731317069 0 0, -3.4369325105487007 47.881683314383039 0 0, -3.4381104361646635 47.867775272748176 0 0, -3.4563904617280343 47.857792300346787 0 0, -3.497455567877978 47.859398306521356 0 0, -3.5151915157248084 47.8274043893462 0 0, -3.5264064181830843 47.769310427985793 0 0, -3.5218054659669349 47.757991267587713 0 0, -3.4873115372072334 47.72049338207934 0 0, -3.4446124377080594 47.6910973435901 0 0, -3.4226155745315907 47.698993423268362 0 0, -3.387515433007195 47.696087333621065 0 0, -3.3689215638435144 47.709793304334355 0 0, -3.3589005711293964 47.720749315110666 0 0, -3.3182304537843379 47.724636364031383 0 0, -3.3170044777081462 47.713325315334984 0 0, -3.3319314959385622 47.697528409086985 0 0, -3.3489274558461375 47.692093440580649 0 0, -3.3541265730499781 47.683998272764356 0 0, -3.3287275805079162 47.689891430799449 0 0, -3.2739304526896262 47.67589238684188 0 0, -3.235631500313616 47.650791411555772 0 0, -3.2118314886000974 47.642097433369244 0 0, -3.2044354816467262 47.633293442703675 0 0, -3.1864335676304449 47.612400400737258 0 0, -3.1554375076455017 47.604797394303247 0 0, -3.1426345193604845 47.579300374092483 0 0, -3.1333424351620489 47.530098398728157 0 0, -3.1530325407743907 47.517799362438353 0 0, -3.1390364952247864 47.47880529460538 0 0, -3.1089444737879148 47.466911273427471 0 0, -3.0834435569234775 47.4637983680132 0 0, -3.107044514269262 47.483604302972665 0 0, -3.1196415591934397 47.505802356970875 0 0, -3.1220405677659007 47.545204452839556 0 0, -3.1160424700763412 47.567203426740512 0 0, -3.1248404911061667 47.571399375696522 0 0, -3.1208365587461913 47.58789437293801 0 0, -3.0990384295987137 47.579998313824674 0 0, -3.106944528309922 47.573593290737968 0 0, -3.0956475734768105 47.56079433889208 0 0, -3.075046548634873 47.566097292423521 0 0, -3.0542404605319291 47.562999341012713 0 0, -3.0464225337187827 47.575710270855254 0 0, -3.0171794470563871 47.562618444480833 0 0, -3.0252034898372413 47.578891310290132 0 0, -3.0156535394906712 47.582489327825968 0 0, -3.0011924431209991 47.564842270062215 0 0, -2.9900945602516629 47.582874283492757 0 0, -2.9692604849740576 47.553630326254606 0 0, -2.9354454267643968 47.551899339540377 0 0, -2.9456715212003814 47.569805329038317 0 0, -2.9652935494181412 47.581257379520949 0 0, -2.9586855574252695 47.596809432202477 0 0, -2.956100528196913 47.6107523257907 0 0, -2.938550457434701 47.596355300688842 0 0, -2.9239994148621236 47.597530409985339 0 0, -2.89255045550334 47.577114382128215 0 0, -2.8900055588273403 47.594249397809349 0 0, -2.864362442044353 47.601322408124148 0 0, -2.8588245018575833 47.61443730378987 0 0, -2.794503461710633 47.6198923385724 0 0, -2.7896215479391344 47.634308373830649 0 0, -2.7474554479733229 47.622825373036868 0 0, -2.759571430777866 47.611908417481736 0 0, -2.7394655385781732 47.59780834551249 0 0, -2.7037215160162305 47.606632402454252 0 0, -2.6994915802007142 47.634174422636121 0 0, -2.6720495262956958 47.611190437266494 0 0, -2.7001555275144256 47.584495427384425 0 0, -2.723281558776165 47.566005410001011 0 0, -2.733438438904443 47.544082299190492 0 0, -2.7570594383120124 47.53621631892652 0 0, -2.7952024369976982 47.542125309202689 0 0, -2.8213704453208663 47.5382613188976 0 0, -2.84747843083548 47.548591402672926 0 0, -2.8833645015103855 47.556915386889827 0 0, -2.9077534760318997 47.555797308062452 0 0, -2.9089555354331087 47.539600290015315 0 0, -2.8918534164359073 47.53059740955517 0 0, -2.8735575490755423 47.527698360706538 0 0, -2.84775548626277 47.510696416120069 0 0, -2.8408544474552571 47.493198271248005 0 0, -2.8077565330500818 47.48170135111458 0 0, -2.792965575263139 47.481102355168488 0 0, -2.7754714788502781 47.492603323761173 0 0, -2.7448674153307877 47.493400342169579 0 0, -2.7143635071722656 47.502998358904151 0 0, -2.6774695461690214 47.488502410581091 0 0, -2.6639725318593763 47.510898301282786 0 0, -2.6687764372890066 47.52270134782308 0 0, -2.6490764694490281 47.514194284894828 0 0, -2.6284395392609112 47.511551341402487 0 0, -2.6296726032351505 47.500698281157341 0 0, -2.6153744545187294 47.5004964111 0 0, -2.5937815571654426 47.512500268737014 0 0, -2.5468875498240777 47.507999438193011 0 0, -2.5400745209998377 47.515895341851305 0 0, -2.5265824145458566 47.520595426997417 0 0, -2.5093805112774419 47.520393356075843 0 0, -2.4979884990440837 47.51389329075208 0 0, -2.4751924971593908 47.515693272892307 0 0, -2.4807915243347054 47.497200437226851 0 0, -2.4888824581159383 47.498001328074523 0 0, -2.4959804632659655 47.4929963763464 0 0, -2.4957794724399394 47.483898413434005 0 0, -2.4857904880276087 47.473697374496112 0 0, -2.490979587889889 47.465603265558485 0 0, -2.4877874379041884 47.44849430433014 0 0, -2.4766844504558208 47.4440084354833 0 0, -2.4637804267100307 47.449398342878212 0 0, -2.4347455811920895 47.490883432668269 0 0, -2.4154034511507234 47.49531543940536 0 0, -2.3318754642966724 47.480510400021089 0 0, -2.3140344325298372 47.493057279254813 0 0, -2.3011525872997822 47.510662268246577 0 0, -2.2788184698674741 47.520813339715957 0 0, -2.2589264534506697 47.522514396672463 0 0, -2.2405184613716358 47.510345432306835 0 0, -2.2032374324620321 47.527240356753637 0 0, -2.1833684746608526 47.528934372911451 0 0, -2.1624944428508286 47.50320430226499 0 0, -2.14210041748953 47.502174409440855 0 0, -2.1336065740049435 47.544136337320239 0 0, -2.1117494706819 47.53497344194291 0 0, -2.09285055891624 47.542049268577173 0 0, -2.0622535623952167 47.662822380625926 0 0, -2.0786624695146259 47.68618040184522 0 0, -2.092071494544399 47.715294280328138 0 0, -2.1314475313457768 47.753238378844905 0 0, -2.1259604426791441 47.767444419889827 0 0, -2.0669965702133197 47.777855296829827 0 0, -2.0489925319266367 47.790363306096388 0 0, -2.0634615612256368 47.802887272289055 0 0, -2.0829545403783243 47.798507367462051 0 0, -2.0934194595423863 47.811393433025927 0 0, -2.0222924272754881 47.866771430879069 0 0, -2.0192115307985263 47.894485416860768 0 0, -2.0261625782794397 47.91040026784141 0 0, -2.0462105483865685 47.908760289813316 0 0, -2.0708315172239793 47.865478388205005 0 0, -2.08982952823078 47.858390416193046 0 0, -2.0932735529599542 47.899341277104085 0 0, -2.0686495737189432 47.942604352856605 0 0, -2.06961560194751 47.970001357164449 0 0, -2.0986435520344742 47.9950794252765 0 0, -2.1427374337483798 48.0133703640778 0 0, -2.1643174816441046 48.019832409088806 0 0, -2.2666745003371034 48.022205334257492 0 0, -2.2812285025575449 48.034706268201006 0 0, -2.2622025370675942 48.063808357425117 0 0, -2.2431464394718432 48.070911291134237 0 0, -2.1798774706647919 48.081730358376589 0 0, -2.17435044927226 48.095924411100832 0 0, -2.1959554864469624 48.102363418852448 0 0, -2.2371564800110377 48.104404370364264 0 0, -2.2728915166238624 48.142604393028115 0 0, -2.2648634550032831 48.165264328583277 0 0, -2.3438145465860316 48.150333436249142 0 0, -2.3543915863743905 48.163177437186377 0 0, -2.3620984445886677 48.203746343050668 0 0, -2.3807614895991662 48.215919355875528 0 0, -2.4003664174505559 48.211490341477869 0 0, -2.4560985633310111 48.181987282848965 0 0, -2.4963425363371243 48.178520393588329 0 0, -2.4977505200493226 48.164661285504152 0 0, -2.5275635498392717 48.10709729983212 0 0, -2.5651505014506881 48.090091306786448 0 0, -2.5785744881776225 48.075172382483842 0 0, -2.6176764436409314 48.066265420137839 0 0, -2.6388034161428493 48.069923291062153 0 0, -2.6494684659144809 48.082733320145834 0 0, -2.65734342731278 48.123294298392643 0 0, -2.6344704937201939 48.152797359565 0 0, -2.6491715202309649 48.165252360551747 0 0, -2.6883194169055287 48.156318291130887 0 0, -2.7197405651096176 48.128814291261804 0 0, -2.7403565516487163 48.129737339966269 0 0, -2.7643954224568006 48.168872387183271 0 0, -2.7860995644289517 48.175209281998079 0 0, -2.846939457697971 48.172546275924546 0 0, -2.8681164198703755 48.176159437777372 0 0, -2.8909134698146772 48.187866349730839 0 0, -2.9389294284226253 48.202835439723927 0 0, -3.0014355266947632 48.208202288503216 0 0, -3.0041645402557435 48.2216984434164 0 0, -3.0189445848047569 48.234123340813355 0 0, -3.0406955480879958 48.240402325059179 0 0, -3.061930420829384 48.243980282918685 0 0, -3.0798374600836951 48.231353314600184 0 0, -3.0864364486286604 48.20323940554708 0 0, -3.11309150419919 48.173290312323033 0 0, -3.1342934612068518 48.17687231864177 0 0, -3.1571424370412444 48.188530297044579 0 0, -3.177793451553697 48.189380297462932 0 0, -3.2168674198423162 48.180282353453222 0 0, -3.258740457638595 48.184669299078891 0 0, -3.3803855682432129 48.178856415704431 0 0, -3.4027295427936792 48.187778339747595 0 0, -3.4290295660917423 48.21559143067789 0 0, -3.450270423511995 48.219101268810377 0 0, -3.5071035742830361 48.216491420766729 0 0, -3.5260514195993835 48.209209298731693 0 0, -3.6832955123135491 48.177681306407933 0 0, -3.7016274637670392 48.16765239279529 0 0, -3.7199194468790449 48.138340322279191 0 0)))'),
('Moselle', '57', 'POLYGON ((7.6411035794877478 49.059669305204849, 7.6369005747271217 49.061473333841761, 7.6181935247249442 49.08523127678329, 7.5618574543393606 49.08973333946706, 7.5427724894690868 49.096569426906925, 7.4959805737083229 49.137245352910881, 7.5040755559487593 49.155239346028637, 7.4952604760252939 49.164245407615809, 7.4808544739051115 49.171264379800888, 7.4511655381915887 49.1721654260095, 7.4383834962825688 49.185306372630279, 7.4265035567019879 49.188003350557338, 7.367461531371049 49.174324310898911, 7.3564824619791125 49.149303424697578, 7.3321705842029417 49.156471309774346, 7.3048225380241831 49.128784425160021, 7.2871885057379586 49.121223311478062, 7.2747695930198972 49.1338233487417, 7.2292365720597047 49.134906399595721, 7.2094385503050376 49.128429392887554, 7.1756055765196436 49.140129440062353, 7.156516563190138 49.131122322355381, 7.1370825507262339 49.13760337752278, 7.1189074330629012 49.151291394199504, 7.1147734281291548 49.149734321575622, 7.0758895614043809 49.135090340460735, 7.0649074996730121 49.148941351626448, 7.0667064237308921 49.16190328594125, 7.0582435597604274 49.179729356010952, 7.0443874440156833 49.188903340646178, 7.0170274284792242 49.196823359039868, 7.0028164564819519 49.207443347700107, 6.9232654647515517 49.222023433567145, 6.8851134890475976 49.220218348810434, 6.8633334824698693 49.229221418058174, 6.8444354508040419 49.21932627962012, 6.8453315684536165 49.176120418637325, 6.8352635784084157 49.168922434146296, 6.7350004932372087 49.174141426153696, 6.7184424710063126 49.196289314461453, 6.7253024971616355 49.21549238872926, 6.7265434379256135 49.218963326449128, 6.6955864543732559 49.220222397269666, 6.6775864765766357 49.229404302803388, 6.67255459379362 49.254417444126219, 6.6576134909752227 49.265575349804109, 6.6579755640463816 49.285915337035718, 6.608117556488736 49.312019274091071, 6.5762535420488746 49.33992037500461, 6.56762152289059 49.364566338677278, 6.5886794955656285 49.358814358211234, 6.6093745150696748 49.363140400928458, 6.549612568075645 49.403995339238364, 6.5418875798048646 49.421508269787623, 6.5361134208230283 49.43459341807899, 6.4886054558384387 49.458706393293014, 6.41967955734728 49.481983273666046, 6.4025665441619708 49.468792337374779, 6.3728714477495885 49.465904377784042, 6.3651255131027824 49.462307409768144, 6.3487505516370959 49.464290274691038, 6.2731554326343257 49.507850287846466, 6.25048353288625 49.513786385197491, 6.2130454941664937 49.5037004411157, 6.1748815491048106 49.502803443366318, 6.1615594779384821 49.494880432633167, 6.1360034910389061 49.495063317378381, 6.114952559162532 49.465370333205627, 6.0899255122623686 49.452407342771025, 6.0836324464192444 49.467525345655744, 6.0704914997984645 49.472747330002605, 6.0638375930239761 49.472927398428354, 6.0386405108361316 49.447723275441874, 6.0018574424118185 49.4699973700656, 6.00093456972732 49.450954297947376, 5.9865394808450958 49.449447391013948, 5.9766355414087116 49.455246368811075, 5.9741374660438 49.478244433557123, 5.9648414995717758 49.488048393652534, 5.9278415745486939 49.496845343519468, 5.9166664189140761 49.477188313757992, 5.9245874934275946 49.468067311132685, 5.9434034997890137 49.462120300543731, 5.9495295226839175 49.385589283378962, 5.9883195707665493 49.3453792822264, 5.9685775233612333 49.31783638194473, 5.981491580245148 49.304439326272686, 6.0237414767897519 49.28058633254922, 6.0495245294461313 49.253757369251744, 6.0463204379955187 49.226486419818329, 6.0183385439173094 49.198799359184065, 6.0146975709097887 49.185138273562231, 6.0193925514768694 49.168880365374278, 5.9997064784209044 49.141327431954508, 6.0125635048356685 49.127929320162664, 6.0006735321169913 49.114112280850478, 5.9598974507520666 49.099853431422346, 5.9521485237658283 49.086116305174968, 5.9608875630637783 49.072624374740982, 6.02873745149958 49.019226429636589, 6.0845745052800737 48.951976417246712, 6.10549148596192 48.941398321338525, 6.1469945297885715 48.93112931649155, 6.2087574717620271 48.929287443561847, 6.2908945488405834 48.93313629614984, 6.3325084852461373 48.917343432713452, 6.3370844763158232 48.901062289889936, 6.3292735903013693 48.887344349818918, 6.3089635264640833 48.878894335305986, 6.301553437913384 48.851570403862652, 6.3060535643775211 48.837997328224091, 6.3470984282313054 48.838546334499668, 6.3677955599749794 48.833347408768461, 6.3517675338632955 48.819538290354771, 6.3480464717709992 48.805851329797846, 6.3525425497759045 48.792289343417181, 6.4348614554798758 48.782432401311851, 6.46427949646494 48.755539366746561, 6.4849975745846109 48.747627269251339, 6.5506825934521657 48.742939329482923, 6.6126944276582833 48.721840344155694, 6.6708815240118327 48.684299333755533, 6.7532764703413477 48.660621303878784, 6.7699045485188947 48.647152432060395, 6.7828145569435492 48.61730543041692, 6.8035245381447851 48.603866305972886, 6.8240704687372045 48.598606301313268, 6.8690694451189529 48.5962983275122, 6.9300445217222659 48.615917336960919, 6.9712414668271379 48.597145335591122, 7.0122615118656313 48.589306286382012, 7.0290284697967707 48.562172280482557, 7.1111614984160951 48.532791379710446, 7.1398145566266464 48.527538415849492, 7.1806154568068337 48.52780931057795, 7.2050014389889157 48.536132414695018, 7.2453554244740985 48.577240293696818, 7.2855874281224544 48.6319583885501, 7.3055405234676414 48.678383302680672, 7.2849634373411334 48.68917033428913, 7.2806995296720913 48.702778437901017, 7.300333500817942 48.779163358493562, 7.2919984273431737 48.792747347370081, 7.2508115153763981 48.806141410702693, 7.189163514441077 48.81393029422135, 7.1725555025397227 48.827457428648657, 7.1519305389823273 48.835487283501479, 7.1315264804829326 48.827190406359435, 7.1197995022532439 48.78624728204629, 7.09927557415665 48.786106290053127, 7.0779424822739259 48.840446294018321, 7.0818094649184786 48.856819319264375, 7.0200305051280623 48.8672442778017, 6.9786885195707953 48.883289377850119, 6.9617675441689357 48.910392404235452, 6.9615385421925 48.9240114210853, 6.9939844786416927 48.951496410797986, 7.0144445114904386 48.957111271710104, 7.0307094604770555 48.970832380140521, 7.0263754968613341 48.98441742513684, 7.0302095637721322 49.000785345803862, 7.0503515285413982 49.03091028297446, 7.0418735268538057 49.044441289841032, 7.0457845144899807 49.058086357645905, 7.0662725345134163 49.06641738266147, 7.0869254852454731 49.063831297313314, 7.1081325468321666 49.023128440254467, 7.1248134309996658 49.009636333800515, 7.1662464188796378 48.990841273815093, 7.1787904817938966 48.977302346050024, 7.2612375300335259 48.966900270108383, 7.30253357437951 48.953506382795709, 7.4382384558301453 48.962318294359804, 7.4793984367420308 48.962490441887056, 7.5205675706921795 48.957187312335648, 7.5617004445292366 48.960052389330755, 7.5903494542805561 48.987381425353121, 7.6353904994343225 49.044674340276728, 7.6411035794877478 49.059669305204849))'),
('Nivre', '58', 'POLYGON ((2.8583754749226671 47.519901380269417, 2.8798884592111733 47.504402294157146, 2.8853654964894986 47.48823943675113, 2.8710135324990631 47.337276440522388, 2.8934164737383128 47.310875381763552, 2.9540805230607532 47.258743372258394, 2.9724184591931078 47.232158372634515, 3.0054255472955731 47.129635367113124, 3.0028864592785 47.113121349873879, 3.0094984733009653 47.083313424662961, 3.0249945670738043 47.042930395883317, 3.0432284754059538 47.016342403920007, 3.0593895726123037 46.967788352274383, 3.0589824384297515 46.926746304740064, 3.0522354170929304 46.912796370353178, 3.0606884239452938 46.86116443357291, 3.0377584789262642 46.805523290015159, 3.0315194512128585 46.78611339228668, 3.0429614531167317 46.745567369018048, 3.0599255534103804 46.732586424546852, 3.12141443229595 46.707760392448435, 3.179369534333631 46.677295384702504, 3.1986074605547969 46.683540397094774, 3.2093064821799828 46.697643292832581, 3.2478085615973669 46.710136309956582, 3.3085065827733615 46.6933864259622, 3.3282334924615498 46.694145424057851, 3.3856005117910684 46.718258399271846, 3.4193354424551217 46.69220339576718, 3.441212436034391 46.665683347510978, 3.4615735456619632 46.658252312584253, 3.5191785439862144 46.679588396806409, 3.5573294635703689 46.697414290856145, 3.59485850461283 46.723400294533931, 3.6156744498339037 46.729850370187208, 3.633069447005596 46.741214395245905, 3.7126075892784343 46.735874301501539, 3.7530675387834549 46.723652355125992, 3.778751492198694 46.6972194367532, 3.79947449887743 46.684288305932554, 3.8390795194050611 46.682922390992317, 3.9167914545252245 46.702007355862591, 3.9396745782331379 46.713722364734551, 3.9691345119702248 46.744781439867509, 4.0076564816438349 46.75974630538137, 4.04676547790578 46.76649438283799, 4.0655975020841879 46.78078438780021, 4.0686035710724582 46.794548269082483, 4.0586424251469566 46.824299339844188, 4.0616504303548595 46.838050371668928, 4.0872875624590108 46.8689573655508, 4.0903195063823716 46.882721422853066, 4.0726305558665672 46.909469416965905, 4.0428425209118757 46.938564285292429, 4.0447364957516641 46.96868535002379, 4.0358474874422541 46.982067267978707, 4.0156704946996626 46.986862403906756, 4.0067714532521563 47.000221439266014, 4.0260324380889472 47.009067322683634, 4.0477524218580925 47.039840365371006, 4.0574145098604788 47.072948312914278, 4.0581805487547911 47.119438354432461, 4.0774855385832325 47.128265403713655, 4.1208475292763183 47.135131414547843, 4.1468465584316334 47.163280351574272, 4.1661705584164395 47.172096311597571, 4.205600439077358 47.178795279483509, 4.1483585699440653 47.25894526716, 4.1290035904451372 47.250137404055138, 4.1222405512913838 47.290897291583107, 4.128165559384513 47.321136289692035, 4.1261175670740045 47.351116362430204, 4.1014154530320468 47.361274298678282, 4.1027215211836392 47.342178420570079, 4.0876975129610287 47.328045425418011, 4.06738551290411 47.332851298563995, 4.0476244553424294 47.329467314707571, 4.025611574349 47.301437367178536, 3.9879834340653986 47.324794336636316, 3.9701084304450092 47.351516279794154, 3.953174429565621 47.364616389782682, 3.9328075112791794 47.369396387993575, 3.8739404497949295 47.353733427292482, 3.8535825085267561 47.358505328584911, 3.8366275612713991 47.371597341654976, 3.8316354590008359 47.385097369007454, 3.8605925036935673 47.427051375988313, 3.8515975313642912 47.440406362888368, 3.8310135804590857 47.447902349182741, 3.811033554059037 47.447200381556243, 3.8092474794587474 47.417095334641843, 3.798286540123371 47.403061438730916, 3.758361515296599 47.40166841671585, 3.7387724292422035 47.395530424463217, 3.7179974966733482 47.405712299426753, 3.6980215187325314 47.404998362442527, 3.67723144844652 47.415207344480919, 3.6709554565401561 47.445022310490472, 3.6408484734061233 47.471271287998249, 3.5789695342747052 47.493629344146015, 3.5648344268830385 47.520435424847832, 3.5439684919914782 47.530601281994436, 3.5348835734592967 47.543914376142439, 3.528736428168429 47.571022331086837, 3.5089155238181036 47.56756635506413, 3.4892334992213705 47.51218044045784, 3.3925675580860286 47.516761360086619, 3.3747844368881488 47.488750422713949, 3.3357064201402977 47.4763144360591, 3.2943575698043333 47.4911303886813, 3.2741464291882494 47.493072416971941, 3.254375514508439 47.489570323718013, 3.2400904381052555 47.516342432566276, 3.1537274736704148 47.540264426116622, 3.1250175610106794 47.593769391360652, 3.1037874408083894 47.606578364324534, 3.0251045795528739 47.586971324233545, 3.0050775558217708 47.58616233646741, 2.9660125645514483 47.573623378132154, 2.9276865051005814 47.552890338315322, 2.8866875824580518 47.5620993509239, 2.8719075379090384 47.547802305163017, 2.8583754749226671 47.519901380269417))'),
('Nord', '59', 'MULTIPOLYGON (((3.0023985336404624 50.156761283321323 0 0, 3.0051924968599053 50.131500294516044 0 0, 3.0224945554892884 50.124157445592559 0 0, 3.0434995461543792 50.141658406784089 0 0, 3.0771184828576614 50.145397421646976 0 0, 3.0725525237047195 50.160335353720349 0 0, 3.0927425399490005 50.165874353678547 0 0, 3.0990655155411484 50.176460360576172 0 0, 3.0932424366539237 50.183006377020249 0 0, 3.0671404358182031 50.180462360444082 0 0, 3.0456344923283609 50.163940422306339 0 0, 3.0191125078524976 50.163982315058362 0 0, 3.0023985336404624 50.156761283321323 0 0)), ((2.1053205001915138 51.008621336493682 0 0, 2.1288575553078317 50.990379335988038 0 0, 2.1361535829202012 50.963512352377776 0 0, 2.2206074347981541 50.858474373574708 0 0, 2.2620895322487797 50.792301427359959 0 0, 2.3063534492503379 50.777923412414466 0 0, 2.3755034211588679 50.770065353048992 0 0, 2.3896975044411111 50.757080357369389 0 0, 2.3826364542822489 50.743164397585204 0 0, 2.3622945308310364 50.734119435585441 0 0, 2.3510044329580677 50.720012310977985 0 0, 2.3728124162037516 50.7155262824807 0 0, 2.3674955878257662 50.685363306015304 0 0, 2.3816794337242868 50.672382368547048 0 0, 2.3887154798460983 50.686287417842507 0 0, 2.4087845723492194 50.698055408724358 0 0, 2.430859588390831 50.690838414076964 0 0, 2.4450005044413956 50.677833354870344 0 0, 2.45238753437647 50.648231373020266 0 0, 2.4750075082344551 50.635574305287506 0 0, 2.5190684742146061 50.6211242981757 0 0, 2.5831955403584459 50.61839634073452 0 0, 2.6252954678915614 50.622894354959058 0 0, 2.6475984297898094 50.61291543101693 0 0, 2.6690575519685638 50.611091336103854 0 0, 2.6888714155202251 50.625503322902873 0 0, 2.7394725793764962 50.630294410371661 0 0, 2.7617535387789474 50.6203114379703 0 0, 2.782659430202898 50.623890275929639 0 0, 2.8041174962618527 50.622039425981669 0 0, 2.8110264442563215 50.638630352174232 0 0, 2.79135850933915 50.66505835284147 0 0, 2.8120575809317359 50.671322376308652 0 0, 2.8337965748572742 50.6667483214586 0 0, 2.8560734858004651 50.656753379699509 0 0, 2.8700975245932909 50.643711356299931 0 0, 2.8714224107514208 50.630161347562819 0 0, 2.8329844187317406 50.587818328170087 0 0, 2.8189844759245797 50.557327432597205 0 0, 2.8205804677108119 50.541069361281146 0 0, 2.8427864426075189 50.531078291961322 0 0, 2.8636734998950431 50.534629318765965 0 0, 2.8851025226595084 50.5327562903022 0 0, 2.9004074587487025 50.506153336641731 0 0, 3.0048805894792281 50.523849327956171 0 0, 3.0230745412789588 50.510955337348449 0 0, 3.0383085433547556 50.484325288706927 0 0, 3.0125374695625147 50.442505408006369 0 0, 3.0341495415526367 50.437900362482608 0 0, 3.054531421536268 50.446853442059833 0 0, 3.075653465479121 50.4476733430639 0 0, 3.0853625507249878 50.43444032674082 0 0, 3.0823885174581847 50.420715357130959 0 0, 3.062299534698866 50.409050337929514 0 0, 3.0044394925888738 50.393230366085305 0 0, 3.135538450429749 50.302990387200779 0 0, 3.13900146725112 50.265007390664678 0 0, 3.1600564475867259 50.265804409073084 0 0, 3.2036074837238573 50.251121351525612 0 0, 3.2090544271293839 50.237713385632084 0 0, 3.1889844668070708 50.226059280273581 0 0, 3.1872444953053414 50.198768436988004 0 0, 3.16694446091671 50.189842288440119 0 0, 3.155558433362188 50.175811384868624 0 0, 3.1508514834374068 50.13479239594993 0 0, 3.1295884475013622 50.0904163542297 0 0, 3.1236764473231458 50.062957410896885 0 0, 3.1268925256941031 50.027691287119225 0 0, 3.1586685301506918 50.001674303927317 0 0, 3.2496655722441972 50.018692442350684 0 0, 3.2920434353044641 50.014827395925764 0 0, 3.3139424313795303 50.0047303625861 0 0, 3.4175565846734344 50.022110398060633 0 0, 3.4820194969133809 50.00533639933083 0 0, 3.5234894489863393 50.012245359036839 0 0, 3.5660655105288868 50.005561352848062 0 0, 3.6282734309777425 50.015869434127595 0 0, 3.6701885375460108 50.017295371876386 0 0, 3.6907265472399331 50.023445333486748 0 0, 3.7108054968611555 50.035007381007787 0 0, 3.7380305050833158 50.063133435438559 0 0, 3.8267894533024673 50.057903354173263 0 0, 3.8446174595918023 50.044872420031581 0 0, 3.8550915276997841 50.018005436421348 0 0, 3.8762704260918213 50.015945298733172 0 0, 3.9796754676654587 50.03830740334017 0 0, 3.9974675658816352 50.025241441225162 0 0, 4.0391844739675946 49.972110342390025 0 0, 4.0812824652810775 49.970672435283504 0 0, 4.1269865776487507 49.9775203160611 0 0, 4.1521535541612877 50.000423325062087 0 0, 4.1384755824786543 50.016315296763338 0 0, 4.1546704699236159 50.041515367230048 0 0, 4.1621705046771922 50.046215276356193 0 0, 4.193864483829401 50.050518436477788 0 0, 4.2259624495894723 50.07051131565003 0 0, 4.2222695299071233 50.083713337884532 0 0, 4.1977675318445282 50.11021034092893 0 0, 4.2004715794106389 50.123016317435443 0 0, 4.1934705511443156 50.132110379720004 0 0, 4.1630764794448964 50.133613414214167 0 0, 4.1428685071882114 50.125614362855472 0 0, 4.1305685984309024 50.128914397562724 0 0, 4.1339694657406767 50.143310354169913 0 0, 4.15477645292905 50.1625063813037 0 0, 4.1583744436905095 50.2088093270465 0 0, 4.19157745640436 50.238102386741659 0 0, 4.2145674175313932 50.251003423478728 0 0, 4.2115694521621378 50.269905322253138 0 0, 4.1831765514621111 50.277008431982225 0 0, 4.1678754878121822 50.287002317621514 0 0, 4.1608714737571892 50.280895315887157 0 0, 4.1632744906383161 50.2606053052495 0 0, 4.1390775651692024 50.258808319483663 0 0, 4.1260735620823823 50.277500407788651 0 0, 4.1209705672329164 50.298904435717887 0 0, 4.1034775269398551 50.30989829078699 0 0, 4.0792735494031547 50.312996418217764 0 0, 4.0329834665669466 50.353695402837317 0 0, 4.0300324918281945 50.353119289486884 0 0, 3.999687529699429 50.347202378312218 0 0, 3.9914925681179909 50.338394339187388 0 0, 3.9667945025352651 50.337902363380962 0 0, 3.9114885009937836 50.321300336158473 0 0, 3.8880875265443535 50.3249013526336 0 0, 3.8388024639777427 50.346698433148063 0 0, 3.7480074928058116 50.341602303077295 0 0, 3.7323114403509976 50.332496438169116 0 0, 3.7249085686189289 50.306999417958323 0 0, 3.7075075867684006 50.310505383651517 0 0, 3.702001506195586 50.30030432251165 0 0, 3.6832045099905315 50.309200371619724 0 0, 3.6568044925259389 50.3591953346694 0 0, 3.6717135766956588 50.391193287316185 0 0, 3.6547165585085679 50.44549139955889 0 0, 3.6404314821054129 50.458896376129431 0 0, 3.6048284515366618 50.489063382072018 0 0, 3.572221456818113 50.485683270654889 0 0, 3.5589175157083446 50.493389424789271 0 0, 3.5090274725168058 50.48099128242724 0 0, 3.4945225471754782 50.48149135515213 0 0, 3.4913295632210928 50.4902912876795 0 0, 3.5078294733751814 50.5131872760113 0 0, 3.4973284814618069 50.52578730778761 0 0, 3.4640325445942892 50.520183360113393 0 0, 3.430426460545732 50.497989354574415 0 0, 3.3998285577250726 50.496891342023261 0 0, 3.3669265535426405 50.489891379994546 0 0, 3.2816364308037294 50.526985299679765 0 0, 3.2745414179931345 50.5364914339918 0 0, 3.2742354952912933 50.59488640992582 0 0, 3.2462384634959847 50.632084357411244 0 0, 3.2394424991605861 50.655883316806808 0 0, 3.2437495411693646 50.668781352071917 0 0, 3.255837542304127 50.675979341374713 0 0, 3.2489454745611397 50.694481323304117 0 0, 3.2371435118257352 50.707378306251272 0 0, 3.2034404407756369 50.715778331093688 0 0, 3.1916544958571649 50.736675421519337 0 0, 3.1747535867315264 50.7526782767758 0 0, 3.1479485621495087 50.778076373765387 0 0, 3.138850442119832 50.78067038001204 0 0, 3.0994855128265613 50.775001304950237 0 0, 3.0812524845942448 50.7723692783908 0 0, 3.0464624902508888 50.773471339401212 0 0, 3.0238365317140392 50.768329444139127 0 0, 3.001064476604995 50.761875320026618 0 0, 2.9739695471381253 50.749572404466491 0 0, 2.9454715625180938 50.7475773941659 0 0, 2.917368566702919 50.711177345188744 0 0, 2.9052705383838031 50.700878416947475 0 0, 2.8936745190092381 50.69918035233043 0 0, 2.8624874773606166 50.709591405290368 0 0, 2.8295715676008228 50.722282444876683 0 0, 2.7862715359359242 50.728382416816558 0 0, 2.7763834382965342 50.748272320993735 0 0, 2.7643815168791264 50.753677366105777 0 0, 2.7543784782016019 50.77127830663828 0 0, 2.73388042504007 50.784671313851121 0 0, 2.7181854287050555 50.811275323631364 0 0, 2.6893795851635787 50.813575376533933 0 0, 2.6705885736373887 50.819770399255717 0 0, 2.6536815038128907 50.818473308122392 0 0, 2.6413845729316279 50.811470353754274 0 0, 2.6278935225974465 50.814075273238856 0 0, 2.6218975784578049 50.836269278777834 0 0, 2.6010844409564062 50.852668361042376 0 0, 2.6156955150976779 50.867569318243014 0 0, 2.6092864519362706 50.90556728347822 0 0, 2.6024385711586433 50.913902356952988 0 0, 2.597699568894082 50.919670350205863 0 0, 2.6258935837378203 50.941158344689242 0 0, 2.6307844677738683 50.950763395336487 0 0, 2.6090995187318242 50.985458345783925 0 0, 2.5799944412472371 51.002964411554487 0 0, 2.557091427283126 51.097553317084888 0 0, 2.4549984385399171 51.06685631502306 0 0, 2.3877135741966526 51.05366133027259 0 0, 2.3530105337167413 51.054962293845151 0 0, 2.3487114237334668 51.058555390337887 0 0, 2.3530844428802387 51.062969436413361 0 0, 2.2794165857133919 51.040256353702048 0 0, 2.2174285142027372 51.037464324993053 0 0, 2.1678225672371809 51.022956407312265 0 0, 2.1053205001915138 51.008621336493682 0 0)))'),
('Oise', '60', 'POLYGON ((3.1083954675119969 49.114811432157509, 3.1449065850880515 49.131717269842241, 3.1560905417209995 49.145790418205721, 3.1548545295160579 49.159393417238576, 3.1412884946761608 49.1725003920058, 3.1196795795059131 49.182563277471971, 3.1007644739033253 49.209098287425334, 3.0599744869610674 49.202037422488232, 3.0388554353576467 49.2066683317875, 3.0400824705442631 49.193081350571575, 3.0297094378970826 49.170868334876204, 2.9730714932689182 49.201336334961567, 2.9718254479259087 49.21492437229729, 2.9788275221941944 49.228828365472921, 3.0002174685261025 49.221496429787365, 3.0208364474046334 49.222320379250661, 3.0404964695055412 49.234001416269095, 3.0450404249413339 49.275085356555437, 3.0239004269618874 49.279712393415437, 2.9805544540857625 49.29980841697342, 2.9917035587653231 49.313881389316904, 3.051763507562697 49.3380813183944, 3.0629564412139416 49.352150418298621, 3.0809155823783385 49.382846364240649, 3.07159550117089 49.439724400103145, 3.0786595344673913 49.453632441738009, 3.1423055380427343 49.439739361800306, 3.1493764361179331 49.453651275874435, 3.1259615560911413 49.482727310064533, 3.1235284320939058 49.509899336276746, 3.1086244694884329 49.5365644249854, 3.11396544333266 49.615825335810953, 3.1053434573124434 49.710865380515528, 3.05877244660968 49.717231318624826, 3.0384625587923608 49.710994403150991, 3.0171294669096369 49.715599437515166, 2.9965245696284342 49.712082382564077, 2.981142536793925 49.697830397914615, 2.95234549425075 49.737568313516974, 2.9317504540876769 49.734028375970226, 2.9114215561139645 49.727768401880795, 2.9306494491970625 49.701275284679454, 2.9319055276781683 49.687702385060859, 2.9121515109151517 49.676010434804496, 2.89417758407356 49.688911290190916, 2.8746555616264118 49.6744993033919, 2.8541094550139974 49.670929442450856, 2.8330565869179907 49.672805287234084, 2.8132775753197166 49.661094326821356, 2.8106754721545997 49.644630299252626, 2.7995024287595811 49.630539372872548, 2.7797774552910255 49.618824364000588, 2.695293503998812 49.628933366697979, 2.6755655381908241 49.617218357826019, 2.6616164839037708 49.589347356326741, 2.6413715474540993 49.583046369585119, 2.619803468916075 49.590309305443796, 2.6254035441509984 49.617805384414382, 2.5636025818647852 49.609703361375281, 2.5422524160453008 49.614250309150506, 2.5270145435633538 49.640857311270182, 2.5056914848187262 49.645370287191881, 2.4851814622994937 49.64176927071675, 2.4657784293497116 49.627273322393691, 2.4441624733808 49.634521296555235, 2.3760985446656946 49.686042340756572, 2.3116514742227139 49.702247442954544, 2.1811705133385715 49.709934410912595, 2.1341914883533661 49.718692284346943, 2.0836304570494519 49.721771401621353, 2.040489547434305 49.733379390353647, 2.0181404683048356 49.745990340855215, 1.9970094473436859 49.74769931871019, 1.956594558950087 49.734871335589915, 1.9425705201572896 49.747841366823152, 1.8617514805880546 49.722118336975356, 1.8409344792471813 49.721107278287647, 1.7888515793127056 49.77312434675467, 1.7446534937786282 49.792755325561089, 1.7552224366485518 49.7741894435721, 1.7167344388284675 49.745014310140832, 1.7019924145922118 49.727905345414754, 1.699747455939189 49.711418435250337, 1.7208735483412738 49.709766311844575, 1.7618495883881451 49.717235367084029, 1.7717394462272011 49.704075410306913, 1.7608325450215716 49.689914427980156, 1.7214435009928764 49.668865432323386, 1.72049352123355 49.641529355502385, 1.6990395036338271 49.6104503901132, 1.7363485197181205 49.541362377232886, 1.7394955806995824 49.514228371333431, 1.7812855370716534 49.513580441836652, 1.8029495464914476 49.5064504010527, 1.8086524173868384 49.493095414152648, 1.7719184585331789 49.450340340304123, 1.7323954633099561 49.431999411832336, 1.7502055155626977 49.421978419118219, 1.7453975301771152 49.391712313934434, 1.7733505569808017 49.365806399341423, 1.7783414271115987 49.322384385839754, 1.8081125641494964 49.2801894075247, 1.8096655883141466 49.266616331886141, 1.7902835017403618 49.254718438268966, 1.7268184466906291 49.265232286889372, 1.706264419179746 49.238201428690289, 1.751772445304681 49.192737407556976, 1.7923754990424925 49.200225296932885, 1.8139205189648919 49.1931074015266, 1.8237005403448734 49.179947444749459, 1.8661315614350258 49.171104377651304, 1.9073285065398693 49.173118398108258, 1.9885335578956926 49.187973427163016, 2.0724324188191758 49.216526330012627, 2.0930584384963709 49.217521370883375, 2.1581585430151335 49.190536277875609, 2.1793555714637307 49.186065370725927, 2.2002475573103482 49.18429531394257, 2.220562549706699 49.187976419502448, 2.2261265408484974 49.1745872847289, 2.246752560525664 49.175544305286891, 2.3101405188300816 49.202995323146055, 2.3304604397854973 49.206638408393175, 2.370115449983615 49.183872337962995, 2.4127325241783808 49.1721423673939, 2.4377535863996798 49.170528440320837, 2.4789994650552387 49.131416275699493, 2.5009484508007915 49.118747414628942, 2.5221095711762302 49.114204339292982, 2.5654395262354228 49.094280287242285, 2.6049954371923718 49.112365282682745, 2.6255885411358122 49.113254359533656, 2.6467065366194333 49.108696322500535, 2.6686305275297855 49.0959743034001, 2.6740704245951861 49.082573375288788, 2.6918494973338056 49.069687305579563, 2.7129685489372548 49.065132436905841, 2.7538495382021893 49.069576413000661, 2.7718104395662522 49.097618329887425, 2.7916394408350129 49.1066243914746, 2.8549355167168926 49.092880400448522, 2.8963734331559294 49.091850331604448, 2.9179885090250082 49.081817369532573, 2.9388055103658814 49.079929379371649, 2.9792195186596473 49.089725418568563, 3.0206525065396193 49.088661377870935, 3.0598695790610009 49.112049326842836, 3.1083954675119969 49.114811432157509))'),
('Orne', '61', 'POLYGON ((-0.012603469653129196 48.44596442664384, 0.049826587993436533 48.439056347037663, 0.051792554999536833 48.4255063300147, 0.073653530761873753 48.41596939220851, 0.093151438473597636 48.422687370250841, 0.16360747853374846 48.473755339058343, 0.20225354228375636 48.489883344511, 0.30645947470509327 48.477287355706594, 0.36626454659091223 48.489227318095786, 0.39628545596130493 48.450035416429571, 0.3940985838972324 48.436206407759684, 0.39825142296740523 48.406360286216042, 0.41010143915369213 48.379707342885112, 0.40981857506747588 48.352317403954331, 0.41978552965190374 48.33925637039836, 0.48463955825747007 48.313133423186613, 0.51450046547830652 48.273887307370742, 0.536572489180486 48.261577351011951, 0.57849446052745179 48.253162364472374, 0.61822551135111325 48.261024296277142, 0.6388004852379936 48.259533407160674, 0.69860256478438032 48.208358418213507, 0.72027555122247122 48.198707419469017, 0.74083556341221879 48.19720033651565, 0.76068146259777336 48.201110268032025, 0.79563145909071409 48.21412236803728, 0.804223521716608 48.241989321077355, 0.7885225407027292 48.268436321047446, 0.78640554856536937 48.284717287851024, 0.80713154758353767 48.313301346234695, 0.78736943390205738 48.339504382531189, 0.80585857118563808 48.354274393942134, 0.86666554872093116 48.357807290690218, 0.90474447613877373 48.379181395225132, 0.93601653543123575 48.422020430597669, 0.9487654855865344 48.450084349980287, 0.93680158448191264 48.47949939862589, 0.96582551676192452 48.508518402346866, 0.95827144387862973 48.535431327168354, 0.91479046368817762 48.554828375439271, 0.91710741450751243 48.568626404595065, 0.90312350826707188 48.581520395202787, 0.8813575832866718 48.591186355644439, 0.84168250681238987 48.643592428237454, 0.84043346912991979 48.684551394347594, 0.79713642980448185 48.701175424065909, 0.78309654921469019 48.714042307598774, 0.77312449005125927 48.727123407430909, 0.78585742238962553 48.755233444044748, 0.77410351310504666 48.781879346577043, 0.72780955782960177 48.820205406027881, 0.66211943438301546 48.84912830284712, 0.65618157683232425 48.862465335710581, 0.66252744866542912 48.876499407641475, 0.64432751218683393 48.889110358143043, 0.62348146755147127 48.890609344177946, 0.60936941877542949 48.903434334958789, 0.54982855285933852 48.886196347597249, 0.50740650878748284 48.8945882755212, 0.46680345504967136 48.91948330744647, 0.4526394803834819 48.932304425788075, 0.44065744922232852 48.958912308007584, 0.44507150192282552 48.986549378971361, 0.47600947531881843 49.002086309376423, 0.38396951492364906 48.980068323803962, 0.34145946086852064 48.988422407435124, 0.25830657256315703 48.991451359019052, 0.22529244366205603 48.962051272070582, 0.18470857610057578 48.9567643363561, 0.16305547991873937 48.963600423795967, 0.1425894623911006 48.962318294359804, 0.083900533113023812 48.939430418112792, 0.0695304390660283 48.924831322089361, 0.063707522553471563 48.908039369322964, 0.04486053667793044 48.895893287552994, 0.024784579396111894 48.891857325740588, 0.006324485406992153 48.876987334988669, -0.010111554987076943 48.848579296571543, -0.031744584892749117 48.855377363698622, -0.048174464587987131 48.826934297308142, -0.11186042469572044 48.839206409374142, -0.15557357522200732 48.855484383838288, -0.23978152720673052 48.866348336172095, -0.26023451925681229 48.864982421231858, -0.29039149206133175 48.819164423945878, -0.33745148623111731 48.857082293094365, -0.38209349412076676 48.878692440404379, -0.40335142547777991 48.882743363913946, -0.50341050350780847 48.862209402679255, -0.5442754749557821 48.85941737397026, -0.62811853754988078 48.867286346573692, -0.65239257103326054 48.838192358347, -0.71234549969096861 48.825779430307776, -0.75927347888585928 48.784114272091969, -0.7809725162789789 48.79079440584151, -0.81724547884030585 48.78546135289578, -0.69236248095148767 48.701156413909516, -0.71054252717388522 48.686184331577024, -0.71565749138108 48.666656324451012, -0.70913753580109073 48.626007329501945, -0.71917049787293763 48.61158742180443, -0.75633341738503646 48.587028411995234, -0.81665246757310683 48.527908409819119, -0.797051588180949 48.482708418635596, -0.77676141459988912 48.484169384357742, -0.75777854131018785 48.493744342476688, -0.69565141402597419 48.489936326520919, -0.68157544934305747 48.504627304966888, -0.68778543376200219 48.517879320186537, -0.66789658570459665 48.522037439855708, -0.64676556474344693 48.518055340153055, -0.64055153186529878 48.504783434677208, -0.61941452622528459 48.500789365616825, -0.58182352615460786 48.522609328726944, -0.56194752755479271 48.526725379624125, -0.51964658521990259 48.518703269649805, -0.45874350078290149 48.522915427448723, -0.39659243478325834 48.518955330241894, -0.35432458420206103 48.510868268899927, -0.31784057370086316 48.540714390443569, -0.29795154962351944 48.544803334265922, -0.27682844956086683 48.540748362297123, -0.25691055820900033 48.544841354578679, -0.23905245250537632 48.562461305267576, -0.23337651266487569 48.579265403411668, -0.19433458001014969 48.592834430591, -0.17360242029315032 48.591472388090054, -0.1520514156918864 48.584678369422178, -0.12359849218327668 48.559177300752154, -0.13784748449330664 48.544567291490793, -0.15737144316008767 48.53778031362161, -0.12695554498480988 48.471325383420506, -0.1054615708526967 48.464504433697769, -0.045387540458023068 48.473930302905089, -0.024701497972245079 48.472557347166187, -0.012603469653129196 48.44596442664384))'),
('Pas-De-Calais', '62', 'POLYGON ((2.1053205174242748 51.008621341238623, 2.0963255450949987 51.006660302791587, 2.0660325088563525 51.008060365605317, 1.9134464325163094 50.988868380595378, 1.9026405667714528 50.98286029107804, 1.8606425547989716 50.977962359489581, 1.8371514581266695 50.969368360644054, 1.763053564959165 50.956165278975121, 1.707553589414573 50.935165392889033, 1.6688605283334823 50.8977703030411, 1.6488695886955327 50.887069345196281, 1.5891604476914551 50.876873388635445, 1.5797715426770935 50.868473363793, 1.5900725831579621 50.84457442885828, 1.58976454821655 50.826381357158382, 1.6006654647433436 50.8082733031023, 1.5993625649511216 50.783981315582352, 1.6123264354855564 50.773895371500558, 1.5952674604299659 50.734787431358413, 1.5996674315331632 50.722969274786053, 1.5883715262014846 50.731781362370114, 1.5826614384874915 50.731384437345596, 1.5800625036817735 50.723880354132788, 1.5706714864278126 50.7292824069054, 1.5630714723332346 50.72298441250318, 1.5759635267213525 50.710777427824794, 1.5687614937710634 50.690887347627651, 1.5842595237635351 50.647590308302185, 1.5844665232441741 50.570289379803867, 1.6079685331543772 50.555095336293576, 1.6161224820835969 50.537487354962408, 1.5938605328375388 50.542789428394016, 1.5869665348287185 50.537590326642814, 1.5765665711266479 50.435596437140774, 1.56316141853614 50.401901286989172, 1.5856574743376655 50.382202364475646, 1.6231044900757183 50.375209443245623, 1.6802974256583525 50.337558420366364, 1.7217645614118169 50.345047365862072, 1.7619784350036412 50.363369284177466, 1.8038125723873009 50.368126399792729, 1.825179460103584 50.366424286716452, 1.9066594546471265 50.321293295359808, 1.9726204728221717 50.299881346532075, 2.0159264891659063 50.291019445297493, 2.0604524998976217 50.2712972881484, 2.0745844389298895 50.2583353538336, 2.1004394837525808 50.215931439818306, 2.1220644167397893 50.211483415264254, 2.1433475189520266 50.20973236863729, 2.1640784465292597 50.213405377278733, 2.2049374332983973 50.226162424352495, 2.2907864194309866 50.21367627200722, 2.3112015671882773 50.220039393797023, 2.3181885037394636 50.23396644558828, 2.3380465483027137 50.245731444130726, 2.3590775899228618 50.246673326971589, 2.3731195827522527 50.233665275425537, 2.4350875879867147 50.247261409679723, 2.4566794292202303 50.242756354656549, 2.4738155010211642 50.199924360082647, 2.462609541892391 50.185821288324874, 2.42143741560281 50.175850285281243, 2.4021524920505612 50.158657359031125, 2.3899305456750142 50.114555380398755, 2.3913404656068735 50.100986353219426, 2.4433784804498941 50.086914436995713, 2.4598574697157858 50.131221302869122, 2.4802734975729095 50.137546404346168, 2.5015495589864827 50.13574941650792, 2.5230984513481474 50.131225351328325, 2.5370725004704582 50.118206386544372, 2.5748954948570031 50.160667331028847, 2.5962044720043025 50.158863302391936, 2.6017464606502756 50.145462374280626, 2.5961094212223941 50.1179844253666, 2.6016864378416926 50.104602331391717, 2.689388562181847 50.070144310705174, 2.7095435524286415 50.079166390109307, 2.70550952683584 50.119854285470964, 2.7464185032754926 50.132423343220509, 2.7679404645822672 50.12786829852682, 2.7818585393552269 50.114822402687977, 2.7831975232405739 50.101242286250752, 2.7606794649432231 50.073097397683554, 2.7662064918920635 50.059692421113013, 2.7879655520937376 50.052425436795104, 2.8490295187801564 50.073978377616, 2.8699674458380287 50.074798278620065, 2.8919845513106281 50.064792423623047, 2.90169557286373 50.051563290999056, 2.8987734653994721 50.037826340771673, 2.933350475583353 50.028312285561114, 2.9845194798516559 50.065731314124477, 2.9832394626550922 50.0793114305617, 2.998764423702454 50.093528387237839, 3.0202585738545338 50.088920360534232, 3.0642174482541122 50.068843347132614, 3.1236764648857331 50.062957415472042, 3.1295884475013622 50.0904163542297, 3.1508514834374068 50.13479239594993, 3.155558433362188 50.175811384868624, 3.16694446091671 50.189842288440119, 3.1872444916158997 50.198768436962482, 3.1889844489849963 50.226059276652123, 3.209054421587922 50.237713382615638, 3.2036074837238573 50.251121351525612, 3.1600564475867259 50.265804409073084, 3.13900146725112 50.265007390664678, 3.135538450429749 50.302990387200779, 3.0044394834431216 50.393230367418269, 3.062299534698866 50.409050337929514, 3.0823885174581847 50.420715357130959, 3.0853625508125617 50.434440338000641, 3.075653465479121 50.4476733430639, 3.054531421536268 50.446853442059833, 3.0341495415526367 50.437900362482608, 3.01253745802299 50.442505396846784, 3.0383085413216406 50.484325276613149, 3.0230745412789588 50.510955337348449, 3.0048805894792281 50.523849327956171, 2.9004074587487025 50.506153336641731, 2.8851025226595084 50.5327562903022, 2.8636734998950431 50.534629318765965, 2.8427864426075189 50.531078291961322, 2.8205804677108119 50.541069361281146, 2.8189844946743392 50.557327445489065, 2.8329844187317406 50.587818328170087, 2.8714224268813098 50.630161339276967, 2.8700975245932909 50.643711356299931, 2.8560734858004651 50.656753379699509, 2.8337965748572742 50.6667483214586, 2.8120575809317359 50.671322376308652, 2.7913585129684577 50.665058353759989, 2.8110264559678626 50.638630363946262, 2.8041174962618527 50.622039425981669, 2.782659430202898 50.623890275929639, 2.7617535387789474 50.6203114379703, 2.7394725793764962 50.630294410371661, 2.6888714155202251 50.625503322902873, 2.6690575519685638 50.611091336103854, 2.6475984297898094 50.61291543101693, 2.6252954678915614 50.622894354959058, 2.5831955403584459 50.61839634073452, 2.5190684742146061 50.6211242981757, 2.4750075082344551 50.635574305287506, 2.45238753437647 50.648231373020266, 2.4450005044413956 50.677833354870344, 2.430859588390831 50.690838414076964, 2.4087845723492194 50.698055408724358, 2.3887154798460983 50.686287417842507, 2.3816794337242868 50.672382368547048, 2.3674955688018713 50.685363313018243, 2.3728124279106737 50.715526270501627, 2.3510044341582841 50.720012315368436, 2.3622945308310364 50.734119435585441, 2.3826364542822489 50.743164397585204, 2.3896974952393464 50.757080360118564, 2.3755034211588679 50.770065353048992, 2.3063534492503379 50.777923412414466, 2.2620895322487797 50.792301427359959, 2.2206074347981541 50.858474373574708, 2.1361535829202012 50.963512352377776, 2.1288575553078317 50.990379335988038, 2.1053205174242748 51.008621341238623), (3.0927425399490005 50.165874353678547, 3.0725525217288805 50.160335357371977, 3.0771184796604985 50.145397422912978, 3.0434995461543792 50.141658406784089, 3.0224945554892884 50.124157445592559, 3.0051924968599053 50.131500294516044, 3.0023985319312771 50.156761271951737, 3.0191125078524976 50.163982315058362, 3.0456344923283609 50.163940422306339, 3.0671404358182031 50.180462360444082, 3.0932424366539237 50.183006377020249, 3.0990655291864471 50.1764603704852, 3.0927425399490005 50.165874353678547))'),
('Puy-De-Dme', '63', 'POLYGON ((3.6805784681099567 45.952552358719558, 3.63982157292142 45.97569229555863, 3.6310235669346866 45.989040417679959, 3.6107094546381688 45.999229333442159, 3.5707124376451134 46.011428397222048, 3.512087579634823 46.011924421487734, 3.4547835754533196 46.045318401476592, 3.4147274157515142 46.057441424630966, 3.3400254220588863 46.062740329703175, 3.2739785061401676 46.05736133554619, 3.2152934493013561 46.057743298873547, 3.1572945182920193 46.049907418023835, 3.0979224555238432 46.058406366087453, 3.0839005289706165 46.085182347374982, 3.0905445786270036 46.099144427139564, 3.070354560406912 46.106506286219442, 3.031809532117677 46.099430283565212, 2.9677694198373104 46.115883397896042, 2.9614735376747205 46.142974278903679, 2.904451517479572 46.1679043388023, 2.8981285282421254 46.194992403490474, 2.9333635010608816 46.240284277096535, 2.9282525853129187 46.253746284136227, 2.8451824263918297 46.261112367695304, 2.8258725080043234 46.25752244047807, 2.8070434761653758 46.248504409533169, 2.809505467437134 46.221241380998251, 2.8029374584062907 46.207264339536508, 2.7841314851829395 46.198230290774674, 2.7435734925565782 46.212860366312228, 2.7240454854305369 46.211982378719213, 2.7292074469688146 46.198524420138753, 2.710173527888827 46.192207415580171, 2.6788104662736885 46.149749287415162, 2.6644525176043885 46.135418269800752, 2.6456995263909562 46.126354297644596, 2.5476775274335068 46.127346346175912, 2.5697224440608579 46.059909400581589, 2.5969015110717351 46.020099316792951, 2.5916684374670069 45.992496393702694, 2.5815305674950935 45.97559742079666, 2.5254995397114897 45.948360267196833, 2.5086484442363712 45.92019232001401, 2.511243506602824 45.892933339938324, 2.4346075815380175 45.878387401944778, 2.4121014925983957 45.869102348710683, 2.4017724649428374 45.854934325585262, 2.4613654327689858 45.761909357457441, 2.5044915567069381 45.717395316083454, 2.5186794700885855 45.690673372925644, 2.5096394366478876 45.662857289655918, 2.4730274596310267 45.639232417809055, 2.466588473235646 45.625232317731715, 2.4769025391940431 45.598343331625657, 2.5103924500646713 45.572536340253819, 2.519400447871476 45.559257393979308, 2.5196305059677115 45.474399400258235, 2.5214074275297662 45.455295425231569, 2.6375584269192984 45.455227305504522, 2.6780984655090947 45.435173350718557, 2.7036954650608607 45.408970314422035, 2.7237045347553988 45.401649291974408, 2.7817184274618683 45.401523437698344, 2.8209684157170329 45.395065441146571, 2.8618684151383604 45.369491324190435, 2.9281885140451038 45.317638306332228, 2.9877545508163905 45.298309377788357, 3.00675150570342 45.301864277032266, 3.0248294603452166 45.316326429521737, 3.0559994280570777 45.35872629507783, 3.0815585833160242 45.376224439949894, 3.2333944625587492 45.409893363126471, 3.2898755733967562 45.428600413128621, 3.3265375400841037 45.40544938703168, 3.384985498028044 45.399566271690574, 3.4228845330401327 45.409259339207054, 3.4599395523127328 45.429866348727856, 3.4977995108922357 45.390281394476418, 3.5172625666506008 45.388298353533585, 3.5363035265292524 45.391769291253453, 3.5892695186357741 45.355453379820275, 3.628582522038954 45.345985265821, 3.6474235232356307 45.352172367644286, 3.668525500902291 45.38031743223145, 3.6877884219587145 45.381034361555109, 3.7138914789142632 45.340957431497245, 3.7337264648618884 45.3334734145606, 3.7527994603744332 45.336910380426943, 3.804160502426214 45.374344370687467, 3.8629145590919336 45.362739374294577, 3.88683444040268 45.407348290430534, 3.9012985291117843 45.421543420630783, 3.9576425203958649 45.445392365895017, 3.9721254432413957 45.459568309918936, 3.97704643344548 45.500778280501308, 3.9433345613970516 45.5406343055012, 3.9211815685102636 45.580913306480639, 3.8719024906225457 45.620224373664158, 3.8316565813967998 45.640678421834068, 3.77450641866605 45.679683390295807, 3.7521735333734796 45.719913281704592, 3.7104105080562988 45.759426419809685, 3.6918794780206667 45.799778293055269, 3.7003074900377442 45.843864429890615, 3.7273754884497521 45.899555387098914, 3.7225085363753863 45.913067383809093, 3.6805784681099567 45.952552358719558))'),
('Pyrnes-Atlantiques', '64', 'POLYGON ((-0.15376954658512432 43.58458743267677, -0.2092165401197974 43.577804327246852, -0.24756143370709083 43.583233311074324, -0.26357942668064993 43.590309313728554, -0.31859446721747986 43.553276296951779, -0.35768146098362763 43.564109269771464, -0.41348947146966 43.559944285323596, -0.43133648791535961 43.553119287141627, -0.45108645621917276 43.559864372258787, -0.4418344947387709 43.57429941767343, -0.44747857496534493 43.587619376600131, -0.46606452323052849 43.58621931378643, -0.53740541566239131 43.55884539267258, -0.57221758852153926 43.539699348873924, -0.59044058361575935 43.535556366921881, -0.60981351715128085 43.53956627777923, -0.65014743636027106 43.558452340087356, -0.66911446785297812 43.55974538276142, -0.70630343832010567 43.556873264967678, -0.72331154360537653 43.544544298452493, -0.7430875628642184 43.551258404055531, -0.76936646376631757 43.576690296878709, -0.78797846298652985 43.575245348973525, -0.80536747547935761 43.565643283779721, -0.844159459781622 43.573581432229972, -0.861551464613882 43.563976374696736, -0.919340579823114 43.573139270074066, -0.93711454798273053 43.56622326956942, -0.9425144885157124 43.552059294903231, -0.99866644201631516 43.550308424296205, -0.99828043022972679 43.522842268719941, -1.0721655152577227 43.514145298193981, -1.129115543286531 43.517788383441129, -1.1645914874394521 43.503891431064162, -1.1835615112715914 43.505077277578621, -1.1840205713442913 43.532550297933582, -1.1898214853610227 43.545822379429396, -1.2030594189833437 43.558487368060682, -1.2224874467683833 43.562385330219357, -1.2575344302628935 43.545761300501013, -1.3474204343276881 43.519043405802435, -1.4039504787163821 43.519828278833174, -1.4592094829268092 43.512420302522074, -1.478204501594206 43.513569360863514, -1.4984904506960675 43.522861278876334, -1.5113374439727352 43.534416285598709, -1.5199004633041397 43.531417433429041, -1.5286905483923761 43.526722276841994, -1.5545635472516608 43.492229404202121, -1.5662484567093315 43.487041391708814, -1.5686345833755411 43.474651346265247, -1.6021924379532493 43.4381103052949, -1.6587705357927973 43.404739383921637, -1.6618325791304471 43.397361331004831, -1.657628518249993 43.392753304301223, -1.6884974918191062 43.3992123569728, -1.730587562234092 43.386142346398557, -1.7469824139560046 43.387985275448059, -1.7776244977882811 43.379093274799189, -1.7702314831743422 43.36868327795905, -1.7849875890078977 43.357151329852272, -1.7710874682715314 43.347328359600468, -1.7534794869403356 43.347530430522042, -1.7475875706009276 43.340034268207731, -1.73678856963474 43.338329338811988, -1.7341894588090838 43.315036264602028, -1.7303434225405283 43.311477316898888, -1.7197855689285007 43.301735315831721, -1.6964884462593375 43.310730288160968, -1.6519965834011145 43.310535434058025, -1.6264985070705507 43.305828308113277, -1.621893472706347 43.264434396665862, -1.6107945337172396 43.257133264474461, -1.5741985745173395 43.256031379484014, -1.5589005032068428 43.267936313899853, -1.5546934499869565 43.286632274644106, -1.5082975791508773 43.290134367898062, -1.4981984335716163 43.289432400271565, -1.4676095077692253 43.269935372659646, -1.4078024996637737 43.269539327734989, -1.3906044688346242 43.261741291178069, -1.3825075503745552 43.243335411338634, -1.3829095799781044 43.203437317566753, -1.4032085545574944 43.174743422723978, -1.4130035376346086 43.135738278242272, -1.434712432145858 43.114246416349758, -1.4670045271442973 43.101043334680796, -1.470010420112601 43.092048362351548, -1.454502533002028 43.066238378640278, -1.4162134377441191 43.04245033628446, -1.3557194237093313 43.034252382363618, -1.3403155643989351 43.048141413842089, -1.3250155568688058 43.108040304370078, -1.2831175242372979 43.121540331722528, -1.3041214587826175 43.087543307328346, -1.3008165078911702 43.072445370719791, -1.2451234384433008 43.049850391697063, -1.21802657275677 43.055149296769272, -1.1919185872421849 43.035843426841, -1.1505304844536965 43.029850299020822, -1.1294325552462396 43.008548362672187, -1.1102275447588 43.023445284478967, -1.0623295195284186 42.994045373550463, -1.0094404481472452 42.988147296512224, -0.94633852228844262 42.957748296253712, -0.92963845194458372 42.954456370839821, -0.89434345631724455 42.958549363121378, -0.81244347813358786 42.956245437779543, -0.78365242026930559 42.96764730713106, -0.76344656025219138 42.966240379538633, -0.7408484128700934 42.9486463037848, -0.7173495713192608 42.894146297670019, -0.70805254872743717 42.8886523624749, -0.678759481918604 42.886051315429583, -0.66626452857499885 42.879852420268534, -0.59616545700697543 42.812652397549144, -0.58136147374250413 42.811653308219164, -0.5690654229610459 42.792858424253708, -0.55316254704558787 42.789451381781689, -0.52997350063583326 42.797256283117306, -0.5104694322252783 42.821254317293167, -0.49997441774129925 42.826854392528091, -0.47017441342887878 42.817054304871945, -0.45156751878766954 42.802555364209482, -0.44086849716251209 42.800251438867647, -0.3888804719899781 42.808555356808355, -0.36772850465280271 42.821354296634141, -0.38507051981457607 42.875305296473343, -0.38517753995421344 42.902763355131171, -0.37970050267588817 42.9169123681002, -0.32711858613629374 42.940078355894329, -0.31022348566955316 42.952324417005272, -0.30469751484051244 42.966480294753, -0.3269515431880734 43.019745344782663, -0.32145848809278732 43.033893301631892, -0.30452043875419577 43.046142355082296, -0.24918345769859229 43.050262278418714, -0.23185358791451449 43.059776333629273, -0.2226535523242319 43.101654299984617, -0.12509642209838034 43.180214299303472, -0.097676559773304916 43.226135268269886, -0.063600502414146831 43.25054131672816, -0.054300487482890958 43.264957351986411, -0.056447579034539785 43.308742318659071, -0.047075571936971983 43.350597402418757, -0.029263583464597787 43.357380331828736, -0.010722520290869397 43.358696433118425, 0.006377467416939453 43.370910282575508, 0.0045655178815309228 43.384510289268931, -0.017630423877079693 43.410377303449351, -0.01609957822822139 43.426963312854909, -0.042026439197258014 43.452564360865907, -0.077334460302125763 43.43630926899742, -0.095897525971651021 43.434959371874172, -0.1088814627822785 43.447765352498621, -0.10329546914465482 43.461895355311285, -0.073153458037296559 43.488784341417315, -0.071272508675008339 43.50265541885922, -0.12511754449437262 43.56742830226024, -0.15376954658512432 43.58458743267677), (-0.14022252190159179 43.236759305389327, -0.158362435571604 43.2327002849613, -0.1583374407363749 43.260158343619125, -0.175753560304031 43.30558434443968, -0.11831648502786152 43.296020299558634, -0.10355756287481199 43.269642299415395, -0.10542143830031137 43.255771397993456, -0.14022252190159179 43.236759305389327), (-0.091632562182809352 43.319934372210483, -0.10942642059862351 43.3131604198188, -0.12866751517921671 43.317253412100357, -0.141653564229415 43.330040382568441, -0.1234604925295173 43.361564326432969, -0.13272248714801549 43.374622367649508, -0.12343144923505633 43.389038402907758, -0.10634448700477606 43.401249436045376, -0.080421498475004682 43.375648388034378, -0.073051542476662235 43.348743384111359, -0.0749134816825574 43.334873362789253, -0.091632562182809352 43.319934372210483))'),
('Pyrnes-Orientales', '66', 'POLYGON ((2.9524454735917232 42.861774289606771, 2.935009463767841 42.870109363081539, 2.9265165003830873 42.883411367971675, 2.8889094824954782 42.889915305734704, 2.8347245521207753 42.91753741500132, 2.7985035154495677 42.907653365821162, 2.7452555393566627 42.880520416041506, 2.7277665475228332 42.868732358883435, 2.7079614849695304 42.840419371248217, 2.65412454606863 42.821422416361187, 2.5047455535186316 42.836078366833831, 2.4482355754061302 42.846973298681732, 2.3744974670501904 42.843265438086931, 2.3373994989057678 42.844135328761482, 2.3184425005511571 42.848659393941077, 2.3049764450522332 42.83427433819692, 2.3287375563531612 42.777961326426961, 2.3299885302552354 42.764320307081292, 2.3178035480726749 42.736335420663679, 2.2869884366133135 42.710098412513631, 2.1981824910631076 42.672634322838817, 2.1787074659470136 42.644222411982426, 2.1341254808659471 42.647358383705992, 2.1351515012507889 42.636459403398831, 2.1170694981497604 42.632763336141792, 2.0422995607500809 42.642486327052595, 1.9866765472488623 42.644954303003217, 1.8984095748361369 42.604534310030587, 1.7898784797974088 42.578666415750334, 1.7858354771863389 42.576004289776634, 1.7761075577164434 42.574302352720323, 1.7690454606395747 42.57306634051541, 1.7554454539461233 42.570900414827335, 1.7453795761405217 42.568611275162695, 1.7387195086672023 42.565529341568848, 1.7353195069938181 42.550960344959705, 1.734052515274783 42.54552432033357, 1.7326925850134387 42.539608289258709, 1.7281655274944399 42.531002321055453, 1.7247174723702017 42.523166264185775, 1.7244275674853498 42.520767288062032, 1.7241174203043386 42.5182074296889, 1.7244495699811466 42.509430370078164, 1.7213785496252285 42.501598361667718, 1.7252354991316849 42.499061385890215, 1.7268934311963733 42.499759305057481, 1.7404904455503925 42.49236329810411, 1.7712884830729934 42.486457300167373, 1.8300814401513037 42.484859390911268, 1.890580558765123 42.450966394317291, 1.9278804218111532 42.4496654307447, 1.9493805566420974 42.429565358727487, 1.9728735895340321 42.376773274347883, 2.0163654829624136 42.357071359494952, 2.060571489394988 42.357769278662218, 2.0875664395208844 42.366268402745774, 2.1265615508644942 42.390865432867727, 2.1522645144361263 42.420662268820749, 2.1731565002827153 42.421363356347413, 2.2093525421186939 42.4151653412862, 2.2550575345861716 42.431656299909818, 2.3165455333719365 42.423664289349816, 2.3474474226747759 42.410164438017304, 2.4207495295736408 42.389568341734432, 2.454543426926449 42.360466432609243, 2.5017375483107287 42.342270368569913, 2.5328374600759105 42.338661431196286, 2.5784384247431831 42.353168292757246, 2.6579315059045996 42.340072407247945, 2.6733244519770381 42.339763316186705, 2.6847254412287214 42.346264437630296, 2.6650275748350225 42.367366415296956, 2.6619255749649824 42.381866412079248, 2.691830487177441 42.407264333048872, 2.7344285512158137 42.416259305378148, 2.7974155360364819 42.411461353130662, 2.8198174211559319 42.432258288195342, 2.8616214591253311 42.459564265602083, 2.9084174233453268 42.457561334403024, 2.9440114768957812 42.469562375720571, 2.9979144232841008 42.467662416201918, 3.0020655021546361 42.475422432446052, 3.0156035498198719 42.467956369546, 3.0381064704000948 42.47605540024567, 3.0568004949247154 42.450058307309988, 3.0848985621808254 42.429863360530831, 3.1021965723509481 42.429561310268255, 3.1268965741533066 42.437160268243034, 3.1734005212488512 42.434665361237549, 3.15009758992079 42.475856321663528, 3.1393975121758046 42.479255267217113, 3.1276025902390359 42.476459366068852, 3.1303034406053882 42.493255367294452, 3.1240005176441059 42.501552420456463, 3.1350994566332417 42.513755356675617, 3.1143025215685611 42.523456345090622, 3.0843015024543661 42.524456314520435, 3.0840084292101153 42.5309563798442, 3.0522005651395716 42.537956341872885, 3.0437095379744505 42.546756284079251, 3.0411084909291333 42.5756533059634, 3.0406064819846108 42.595050354234317, 3.033112431909899 42.624145398580808, 3.0360204577768286 42.715728411142877, 3.0256095808368286 42.722446389185208, 3.0358044812778928 42.731041268130568, 3.0357074942763518 42.777748342267458, 3.0503134550784807 42.881332396147073, 3.0381795186862064 42.877700400157821, 3.0330474805422512 42.860782417095422, 3.0301475515937852 42.827072305246659, 2.9775724998328883 42.811702417789817, 2.9645915553616931 42.843628391257894, 2.9480514871674188 42.842994367338477, 2.948562473130238 42.85846740249572, 2.9524454735917232 42.861774289606771), (1.9588704971172319 42.474659385891172, 1.9829134163845765 42.4931983368253, 1.9927694783900733 42.490860263609974, 1.9895694353986926 42.470661268371558, 2.0064745690035295 42.453865267145957, 1.9981755796219147 42.446262436731914, 1.9723754530287749 42.448757343737427, 1.9547764487158759 42.457466283621088, 1.9588704971172319 42.474659385891172))'),
('Rhne', '69', 'POLYGON ((5.06055951589488 45.811744306399461, 5.0208854955403694 45.827152390189056, 4.9817495682235347 45.8316303381374, 4.943028519967811 45.827896426587543, 4.9037464960787531 45.835079273361444, 4.8938154495675121 45.875816278293783, 4.8729234637208947 45.9026223589956, 4.8144244599866681 45.9037744096765, 4.7945035762953694 45.911445359817591, 4.8015535279945709 45.925308340341005, 4.7891335591566815 45.938640268625463, 4.7499164866352714 45.943042351968231, 4.7299825774664725 45.950702388871392, 4.7401144627594931 46.04938534280312, 4.7689164338617331 46.093910297415036, 4.7861674467008015 46.135402428003758, 4.7878274910050891 46.176426345481516, 4.7753534840374812 46.189758273765946, 4.7528114870247009 46.172737319023113, 4.7131105356153284 46.182590388689206, 4.6904645108023146 46.236629398511653, 4.6704445278698472 46.244285386955582, 4.6884494342255607 46.272129281380032, 4.6876814591116158 46.285759387487744, 4.6679344831472349 46.28794133099278, 4.590713467713698 46.266628305386249, 4.5506025658022793 46.281875330906431, 4.5308645668562235 46.284031399476376, 4.4920414270198989 46.27743135481164, 4.413571549923887 46.27782035893766, 4.3948175025906551 46.263580343645927, 4.3730424245719917 46.235588416429621, 4.3677744990139047 46.1944124177008, 4.4073605093851427 46.187420376570586, 4.4238345700919695 46.174251266755206, 4.4372184242665469 46.147316339437864, 4.4195495400269351 46.116699426460841, 4.3811655700070844 46.104610375160021, 4.3031075796327229 46.102192388879885, 4.2883615069372638 46.088058337608018, 4.2794415191137318 46.044048417418153, 4.2606404744494455 46.03249341069575, 4.2507124202776367 46.004852291272741, 4.2317684474005546 45.996040379708674, 4.2170464894404631 45.981895415198849, 4.2570595242505078 45.966766323056234, 4.2963385558001335 45.962524417882989, 4.3088815625945927 45.949249344047743, 4.3097334992325784 45.935611317041506, 4.4102215379210179 45.886741309555973, 4.4227295167421516 45.8734553224828, 4.4243844564674077 45.846153393535289, 4.4143914509279512 45.818508401673014, 4.3765675764415732 45.8009453054333, 4.374371551339209 45.773533364006724, 4.4138454369917781 45.763797347618393, 4.4108075083895528 45.750045435693821, 4.3922365218215305 45.735809292841353, 4.3854905566045375 45.719173293765309, 4.3871724273846553 45.691894423433425, 4.3957595614514844 45.678474309145756, 4.4285795403295367 45.649387361717729, 4.5174914498996088 45.589164418431366, 4.5560144756930185 45.59302928883632, 4.5755104471851382 45.590862307028445, 4.595339448453899 45.583229377200141, 4.6479544567471862 45.543720287554279, 4.6696075529290511 45.571689332174927, 4.7088945053771454 45.561855272665227, 4.7026864571778333 45.534328390200486, 4.6646494225120136 45.52231643564501, 4.6632384464603547 45.478534285291843, 4.6821014501528566 45.487270332250361, 4.7017125387030774 45.48236430374341, 4.7216284938353112 45.471969268600432, 4.7424234926803592 45.445202440351139, 4.7649804513903007 45.456771352650875, 4.8416105677962094 45.469791373554628, 4.8563305895366682 45.483852376540412, 4.859471489819299 45.497619426182084, 4.8510374931233287 45.511062423065383, 4.8263774478533605 45.537746345910435, 4.7863885277787688 45.561256276719163, 4.7779105260911763 45.574707370520926, 4.796648555607419 45.586151308644432, 4.8357795543652173 45.579006306163322, 4.8753414500010308 45.563659301302138, 4.9129965213394939 45.583797393632111, 4.9514345294890916 45.590263311082381, 4.9702035385194563 45.601665356453864, 4.9733824591148732 45.615432406095536, 4.9924695362247462 45.62139138604222, 5.0170565332086028 45.594677363782878, 5.0366894482346538 45.589695294650411, 5.0476095509378069 45.60364927749653, 5.04305855470335 45.617191373621, 5.0533115417333363 45.644802393629718, 5.10874445367071 45.700840286192019, 5.0976615324985346 45.768913367945387, 5.0777084371533761 45.779365433557516, 5.06055951589488 45.811744306399461))'),
('Sane-et-Loire', '71', 'POLYGON ((5.3205725140236666 46.448516425553393, 5.393361522720113 46.469936295279595, 5.4196715791562724 46.497825426835433, 5.4151144222229846 46.511387413216127, 5.3948585725353837 46.524593311204526, 5.3749484260620477 46.529644380163873, 5.3814845754789644 46.559822299344418, 5.4038825881591208 46.587631341815481, 5.4183255544722613 46.618000418679671, 5.4209434994343724 46.648086279417711, 5.3953225611671485 46.691253416007854, 5.38846957581049 46.756656274869059, 5.3595825870644376 46.783367304788968, 5.3549965628566554 46.796924362610568, 5.37440153202607 46.805530330813824, 5.433352555034304 46.814994396353896, 5.4527645650023828 46.823597372217719, 5.4521595843774548 46.837234343104129, 5.3913744333180205 46.8687134018772, 5.3113145678644 46.886093437351732, 5.2975195310480387 46.9267424323008, 5.236785425778919 46.952705377362989, 5.2390655884252624 46.988258418261253, 5.1482315408207455 46.977955441560724, 5.1249845838420356 46.966484396362389, 5.1097864918725122 46.952465286128657, 5.0452614445843835 46.972744370451821, 4.98664556359239 46.954921292721551, 4.966947521178696 46.951709280372441, 4.946988441154673 46.953930300310006, 4.90793753148165 46.942001427178738, 4.8681614195465954 46.943721318271642, 4.8288195488689212 46.937210339709949, 4.790102549072401 46.91980742163976, 4.7275015760383212 46.904464289217842, 4.7081694791350515 46.895740387637019, 4.6688865751461606 46.889194381101973, 4.6484605141509405 46.899562309170122, 4.6437095592345088 46.913089267577462, 4.6270635270203684 46.926281436008495, 4.5863275782078574 46.944255362850058, 4.5601095802141742 46.984493351177306, 4.5434165506689794 46.997680415029279, 4.4142914715869495 47.029438289429336, 4.4094644760450024 47.042946413700278, 4.34940857570686 47.049347379782873, 4.3397255413284483 47.076370317083459, 4.3227834435306249 47.092250310403287, 4.2823674990172265 47.101936337121131, 4.2617865404514816 47.1122363214822, 4.2361485282474973 47.1387523212792, 4.2155554243040569 47.149063394898135, 4.1956635839072476 47.14843341943795, 4.1571734738475641 47.128097304645635, 4.1374875768115942 47.124733387065405, 4.1208475292763183 47.135131414547843, 4.0774855385832325 47.128265403713655, 4.0581805487547911 47.119438354432461, 4.0574145098604788 47.072948312914278, 4.0477524218580925 47.039840365371006, 4.0260324380889472 47.009067322683634, 4.0067714532521563 47.000221439266014, 4.0156704946996626 46.986862403906756, 4.0358474874422541 46.982067267978707, 4.0447364957516641 46.96868535002379, 4.0428425209118757 46.938564285292429, 4.0726305558665672 46.909469416965905, 4.0903195063823716 46.882721422853066, 4.0872875624590108 46.8689573655508, 4.0616504303548595 46.838050371668928, 4.0586424251469566 46.824299339844188, 4.0686035710724582 46.794548269082483, 4.0655975020841879 46.78078438780021, 4.04676547790578 46.76649438283799, 4.0076564816438349 46.75974630538137, 3.9691345119702248 46.744781439867509, 3.9396745782331379 46.713722364734551, 3.9167914545252245 46.702007355862591, 3.8390795194050611 46.682922390992317, 3.79947449887743 46.684288305932554, 3.778751492198694 46.6972194367532, 3.7530675387834549 46.723652355125992, 3.7126075892784343 46.735874301501539, 3.633069447005596 46.741214395245905, 3.6156744498339037 46.729850370187208, 3.632639430227357 46.694717312929086, 3.6939795722412327 46.614917428966024, 3.7061455442674287 46.557918291366533, 3.7278245153843557 46.53135635035828, 3.8491415247713974 46.489170349061524, 3.9490835495236638 46.467998315448185, 3.9578935248681262 46.454624318391765, 3.9685904342537128 46.413974267322871, 3.9726015772508276 46.356674311600628, 3.9926335295409956 46.294468327371405, 3.9169875407679342 46.2536014197038, 3.8872535439429612 46.230697349619859, 3.8803984463467032 46.216789307984996, 3.9206455877122153 46.201782373699118, 3.9776385646128745 46.170898438432872, 3.9973705788800942 46.168819290588274, 4.0546904248585633 46.189891344860641, 4.0779505833347685 46.1933902697552, 4.1173934894732156 46.189228277646762, 4.1557535207776368 46.201423292967419, 4.1753105711981107 46.202053268427605, 4.19540149017709 46.194477369068451, 4.2175995441753 46.154197311969213, 4.237664588219161 46.146625285049296, 4.2756875412876809 46.16423027404106, 4.3584054842557691 46.15585330781424, 4.3693004161036981 46.169853407891608, 4.3677744990139047 46.1944124177008, 4.3730424245719917 46.235588416429621, 4.3948175025906551 46.263580343645927, 4.413571549923887 46.27782035893766, 4.4920414270198989 46.27743135481164, 4.5308645668562235 46.284031399476376, 4.5506025658022793 46.281875330906431, 4.590713467713698 46.266628305386249, 4.6679344831472349 46.28794133099278, 4.6876814591116158 46.285759387487744, 4.6884494342255607 46.272129281380032, 4.6704445278698472 46.244285386955582, 4.6904645108023146 46.236629398511653, 4.7131105356153284 46.182590388689206, 4.7528114870247009 46.172737319023113, 4.7753534840374812 46.189758273765946, 4.777748587721959 46.217163350413855, 4.8246225287871312 46.292225304938015, 4.8560595187882143 46.364101298068093, 4.868083442701419 46.432762286509629, 4.8934065551852655 46.474407378449271, 4.9274685309471238 46.499874299245775, 4.9665185605202851 46.506340392716012, 5.0662034201014876 46.4814833811035, 5.1448024958529288 46.483383340622154, 5.1900294180913136 46.443477325951775, 5.2501045046057868 46.42027631018432, 5.2698645060476963 46.417995267438144, 5.2892525773003172 46.423900385275047, 5.300412419197869 46.437816347808408, 5.3205725140236666 46.448516425553393))'),
('Sarthe', '72', 'POLYGON ((0.85823841680365831 48.1083104294414, 0.8749075076333952 48.136650348131482, 0.89405548765168419 48.145977294117628, 0.90037249221029469 48.160015414507754, 0.8865014147683894 48.172901308197012, 0.80181556857456826 48.198051393053774, 0.79563145909071409 48.21412236803728, 0.76068146259777336 48.201110268032025, 0.74083556341221879 48.19720033651565, 0.72027555122247122 48.198707419469017, 0.69860256478438032 48.208358418213507, 0.6388004852379936 48.259533407160674, 0.61822551135111325 48.261024296277142, 0.57849446052745179 48.253162364472374, 0.536572489180486 48.261577351011951, 0.51450046547830652 48.273887307370742, 0.48463955825747007 48.313133423186613, 0.41978552965190374 48.33925637039836, 0.40981857506747588 48.352317403954331, 0.41010143915369213 48.379707342885112, 0.39825142296740523 48.406360286216042, 0.3940985838972324 48.436206407759684, 0.39628545596130493 48.450035416429571, 0.36626454659091223 48.489227318095786, 0.30645947470509327 48.477287355706594, 0.20225354228375636 48.489883344511, 0.16360747853374846 48.473755339058343, 0.093151438473597636 48.422687370250841, 0.073653530761873753 48.41596939220851, 0.051792554999536833 48.4255063300147, 0.049826587993436533 48.439056347037663, -0.012603469653129196 48.44596442664384, -0.026043474197024352 48.425907303498448, -0.1079874573723032 48.398624384707304, -0.12218945235125034 48.38398339593185, -0.11815049819941237 48.356876321087285, -0.12628754921183827 48.328952337578059, -0.16352650934948088 48.304546289119784, -0.16920244918998151 48.260345387266241, -0.20313645843614836 48.214222347378282, -0.24992344563784741 48.1727062780741, -0.23293047806970435 48.113571314200826, -0.24657149741534568 48.068813309153242, -0.2872555203377658 48.068794298996878, -0.30616147290209028 48.059288340704782, -0.29806050598278944 48.032436318791682, -0.26699245383153425 47.98794533603332, -0.32445346782319007 47.9648624296634, -0.36824353907485374 47.959098303819658, -0.38709158107019448 47.9495733353712, -0.35446751241488528 47.921665369678934, -0.35240843084650919 47.908123273554466, -0.36239245936766906 47.893699317397747, -0.39966257503934344 47.871956275012977, -0.41723147993795351 47.854282286194362, -0.4187765832041066 47.837726376203094, -0.41269350918102532 47.824436340670687, -0.39460252906170012 47.811988384658136, -0.37416643492838375 47.810650280872622, -0.36409457244394616 47.797626387529604, -0.37959946721508686 47.766399389348592, -0.38238251890578567 47.757980354349783, -0.37427151884841692 47.731117419198782, -0.35304456700549736 47.724369341742161, -0.31343250567923064 47.729847435140314, -0.25177447160581323 47.723091436785225, -0.23215651827689499 47.727157321991925, -0.22216844129650326 47.74155434709381, -0.20215356294309572 47.742897379438361, -0.19212957788951712 47.729873310075376, -0.21614257376253931 47.700840400777068, -0.20610644333129358 47.687793272798487, -0.20211255029087738 47.660667363817495, -0.18093646821830589 47.653869296690388, -0.16134157350501255 47.657920396219922, -0.11897251144307575 47.644333415004, -0.10058458564023454 47.656532302763921, -0.10455154762576058 47.683685318819769, -0.084547582510282382 47.685024302705116, -0.066560454171195715 47.672500306067022, -0.026181473850783732 47.672454364855739, -0.0065554236034017777 47.676498423586608, 0.014211412047018257 47.672386421148659, 0.035773505906178116 47.6628493073225, 0.059637412867544981 47.637004295637908, 0.10116457142962076 47.628746318908483, 0.11909150094012944 47.61622637072962, 0.15980544725684354 47.613376431451641, 0.21786457709472984 47.630825290733085, 0.25422748585896215 47.630424317249336, 0.26809750718106784 47.617626433543322, 0.28883142709773324 47.613456344516422, 0.32854945244386613 47.588581378867346, 0.34890950595163872 47.587116364685969, 0.36850246444529944 47.591118354644848, 0.36663753289997203 47.604702343521339, 0.34690956709198417 47.630832331531749, 0.35704655696406462 47.645183415422352, 0.37593244325219644 47.654590274473279, 0.39704744639638534 47.647709301941958, 0.40689241914401464 47.63462837812979, 0.42690342505815693 47.635875303572632, 0.46470054450961129 47.654670363558054, 0.52431146637238157 47.661098436715505, 0.56324743500724139 47.671726346274212, 0.6193254601218996 47.705265366715494, 0.63175246975845312 47.733413423642091, 0.67003857267690137 47.749439337514175, 0.67446758707455956 47.777080280917218, 0.73355555361678171 47.788849327918896, 0.7722635763950052 47.802127394093574, 0.78406149067117781 47.835670286974121, 0.77122347441280681 47.903347323802805, 0.8107244671402043 47.911163314396291, 0.82854543263087521 47.898529305279126, 0.84796043493838624 47.905147303980456, 0.85424452376324211 47.919204434526975, 0.84372257822437291 48.000705375446515, 0.85404456508126714 48.015003301307232, 0.844245533544921 48.028110276074457, 0.80110251169017488 48.047466311693185, 0.80564453090636334 48.075122392813327, 0.82227243306394371 48.10345843906417, 0.85823841680365831 48.1083104294414))'),
('Savoie', '73', 'POLYGON ((6.8141605446219558 45.775673414759709, 6.7877285063489978 45.77078639640915, 6.7300775668134634 45.740142376357269, 6.710732444432665 45.737209355655082, 6.6912125342251159 45.742443309359643, 6.6748115218043722 45.783256354917526, 6.6628694471756091 45.796795282682595, 6.64332154979337 45.802028356287323, 6.6045114354345742 45.798854364250971, 6.5524075891240727 45.866546362776816, 6.5712125062276243 45.894096303857154, 6.5553295205683639 45.907581369512471, 6.51632842454589 45.909828440405093, 6.4858514474422293 45.882122369614436, 6.4448655502772283 45.810562332324267, 6.414486440274942 45.782848340635113, 6.3722015157570127 45.765892337259928, 6.3647864986472484 45.752117366719759, 6.3621585205470694 45.705616411963675, 6.3397004850583016 45.675266345255878, 6.3206274895457568 45.664047360649576, 6.2975035705236166 45.658271441468074, 6.2586684613295915 45.660442295715214, 6.2388945543103205 45.673805379533732, 6.2307715848952228 45.687355396556669, 6.2113565825877117 45.687057394753353, 6.1721645049015592 45.700138318565521, 6.1635905723321969 45.7273173855764, 6.1476514363036188 45.740757390120294, 6.1279864856436461 45.748642380540659, 6.0891015627990726 45.750744410980886, 6.0860745474347766 45.723377354645763, 6.0748715806454356 45.709533384278714, 6.0391405835610215 45.733547436271536, 5.978645513406434 45.800865392368493, 5.9392494285790747 45.816581335079533, 5.9002905773485566 45.818622286591378, 5.8842664236761379 45.832004380566261, 5.8798794780504977 45.84560033880048, 5.8818544220748947 45.900287278119706, 5.8735865882273117 45.913799274829884, 5.8177894909792371 45.948314325985578, 5.8043155145818162 45.890682396606437, 5.7757275837588793 45.821834298940487, 5.7689754578430552 45.79436532704473, 5.7699954935490609 45.767059349637989, 5.7593665278705544 45.739536339612513, 5.7065054436640708 45.700275438119448, 5.6887054245493971 45.658920427084652, 5.6665225082683151 45.631153277365613, 5.6284134814361835 45.613990274509817, 5.6253324279421406 45.594806386418341, 5.64626841878038 45.554218294377691, 5.6942674794715629 45.514160374476191, 5.7354894194116639 45.446636298998428, 5.7745075893708986 45.436428373079863, 5.8139034981782913 45.41530632913701, 5.8333885564324817 45.410194357269248, 5.8719784698131718 45.410892276436513, 5.9111344634061993 45.395195343881866, 5.9260864794624979 45.40912626811236, 5.929484544916221 45.422863394359737, 5.924118576236765 45.466491351222245, 5.9815945519255536 45.481155398613325, 6.0134145613737928 45.454349317911507, 6.1306225606622888 45.41253630292384, 6.1693575144954025 45.407665302390242, 6.2078694510309163 45.410984334878989, 6.2237024470196616 45.397552427253586, 6.2283565909545189 45.3702923910581, 6.2210244792489959 45.356544351572794, 6.2021635877960932 45.342582271808212, 6.1879684575958436 45.30136138798791, 6.1688644825691767 45.295597438164137, 6.1538665253015949 45.28171139902507, 6.1170584620420243 45.226452394814643, 6.1366345226188912 45.215839270933131, 6.1644465574294145 45.186210358028191, 6.15757156957693 45.158760396288827, 6.235141456584131 45.135345340242068, 6.2540375520303257 45.146560276389138, 6.2733895391898216 45.141388281712793, 6.2664744187849806 45.113937439873595, 6.2746125259172061 45.097679355665676, 6.2938055670469453 45.0979463779549, 6.3317274846546638 45.11488337117369, 6.3474624375220685 45.1014322773719, 6.3443495244141275 45.074066277156575, 6.352397509323481 45.060512387694374, 6.3719455827256866 45.047119380481533, 6.410338529763834 45.044906281442437, 6.4489685756968811 45.034477274445905, 6.4639605482855984 45.048339374869514, 6.4748095389222442 45.075809402885071, 6.4939305878856715 45.078788364798513, 6.5509114194086351 45.104107428823127, 6.570022435233966 45.107059283661712, 6.6085604227245085 45.102062428852051, 6.6308795784596839 45.108898340271949, 6.64007943803 45.115505425735378, 6.6721875921634251 45.122501339304833, 6.6905765740860659 45.138500322122027, 6.7146775799423608 45.143299330489313, 6.74587148636968 45.1387023930436, 6.7727734979532386 45.154304274816312, 6.8233785342488034 45.148403381458607, 6.859067462561228 45.133499418853134, 6.8964614962893336 45.140201379078505, 6.901964584522716 45.1445003147209, 6.8962715707454549 45.1532974406078, 6.9008644597319631 45.164306433394032, 6.9538635435921776 45.175800361188024, 6.9762605001525628 45.208294351088071, 7.0108515919337719 45.218799398710146, 7.0332455561547249 45.219501366336644, 7.0503425515231015 45.227001401090249, 7.0670475504260253 45.221195382494457, 7.0781385685166356 45.222294275145472, 7.1081464524095281 45.248794433145477, 7.1286455616908313 45.255893318395366, 7.1320434511246162 45.286796439837971, 7.11314647557856 45.321991280104342, 7.1132445186999291 45.33189029098169, 7.132743482531481 45.341690378637836, 7.1379364235838239 45.356987393828533, 7.1577414861371551 45.362293339699406, 7.1634315075749839 45.383190430125055, 7.1851324811877362 45.403682322587755, 7.1789404508053849 45.413189336999622, 7.1216394389633138 45.437481324519595, 7.11009059293977 45.452434396695722, 7.1006825017490769 45.466423407515165, 7.0928365877612691 45.474781363585592, 7.0570404632892405 45.478477430842659, 7.0538444687570632 45.499981438112869, 7.0224444429489665 45.502578436698954, 7.0064454601317721 45.510780439079028, 7.001544536203852 45.524582340674087, 7.0114525240994965 45.528877403877217, 6.9953665874188289 45.542179408767325, 6.9917595862648341 45.555977437923119, 6.9976585434029346 45.56997630586072, 6.9863594697118856 45.593071357608309, 6.9854584235032462 45.62187227259075, 6.9907645453940859 45.631580301804419, 7.0123454733896722 45.63967141160559, 7.0118494491239858 45.64837630303002, 6.9905575459134468 45.6471744386986, 6.9678694523284435 45.654476274969866, 6.9259714196969355 45.65247739223004, 6.9067614806504025 45.67847043670649, 6.8831714607569268 45.67747134737651, 6.8670735547185586 45.684070335921447, 6.8242765881180105 45.721870271692396, 6.8121685266607983 45.760463353432456, 6.8141605446219558 45.775673414759709))'),
('Seine-Et-Marne', '77', 'POLYGON ((3.5322814702942082 48.641521377311349, 3.527088529241837 48.654976343552377, 3.5057654704972094 48.66511526964409, 3.443126477150372 48.679214292942632, 3.4256524470137037 48.692203334332291, 3.4356435163335277 48.7198643440115, 3.4304424783626928 48.733318430152693, 3.4036235482033135 48.759609300412521, 3.4065815637407297 48.7733573398978, 3.4461844720287615 48.7911834099675, 3.4450674493212148 48.804790281439651, 3.4223214451672277 48.831234289070338, 3.4428054167314315 48.831989414726721, 3.4667275863017153 48.841037369065916, 3.4688114866853823 48.865673299600459, 3.405247508414476 48.887893356094494, 3.3783405682718239 48.914180353915029, 3.3580424737922669 48.910698326937265, 3.3370545570639081 48.915374297347952, 3.3158265491012173 48.922767311961891, 3.2982435626052791 48.935730302396493, 3.2772514213977217 48.940406272807209, 3.26375157006521 48.953540354649263, 3.2478935792412074 48.993847342803363, 3.2343845748704609 49.006977376186214, 3.1918335081631426 49.0217213366421, 3.1865194653738058 49.03514831570844, 3.1935424860181172 49.049053365003871, 3.1734804343136602 49.089191373990147, 3.1599395703289588 49.102298348757344, 3.1083954675119969 49.114811432157509, 3.0598695790610009 49.112049326842836, 3.0206525065396193 49.088661377870935, 2.9792195186596473 49.089725418568563, 2.9388055103658814 49.079929379371649, 2.9179885090250082 49.081817369532573, 2.8963734331559294 49.091850331604448, 2.8549355167168926 49.092880400448522, 2.7916394408350129 49.1066243914746, 2.7718104395662522 49.097618329887425, 2.7538495382021893 49.069576413000661, 2.7129685489372548 49.065132436905841, 2.6918494973338056 49.069687305579563, 2.6740704245951861 49.082573375288788, 2.6686305275297855 49.0959743034001, 2.6467065366194333 49.108696322500535, 2.6255885411358122 49.113254359533656, 2.6049954371923718 49.112365282682745, 2.5654395262354228 49.094280287242285, 2.5750334945107625 49.081047282179028, 2.5757895002669784 49.031959361974955, 2.5894734684844707 49.018905369217649, 2.610011478178393 49.019798318507824, 2.6313655164371141 49.012531334189916, 2.6291254863431277 48.993324387482843, 2.6441315405291732 48.966678308930582, 2.6347375309358085 48.936248329157976, 2.589542468311322 48.893360360234752, 2.6069325369239493 48.842250322655232, 2.6259655759041038 48.815773399290819, 2.6237644462227365 48.796569268903184, 2.6062235284988162 48.765789361437143, 2.6239195198132563 48.752899419288653, 2.629347447520928 48.739494442718112, 2.6184255846181372 48.725372360803945, 2.5985105095857364 48.719047435346866, 2.6011925258156339 48.691848302059796, 2.6063444542158152 48.681160369692506, 2.5867124192895687 48.672115407692743, 2.5896475522313551 48.642200286322222, 2.578745579584762 48.628074331968818, 2.5251404589797914 48.590225286627216, 2.5142574964895914 48.576088419035884, 2.5128864769703512 48.548717314241529, 2.4933405158077449 48.539646301286709, 2.4906164308058294 48.525867282287308, 2.4963254624000513 48.509727307476922, 2.461895428888198 48.445373351596245, 2.4673085709186751 48.43196133422704, 2.52749243777248 48.401847310294343, 2.5329085721423894 48.3884433898436, 2.4443895391376032 48.335323380266388, 2.431447495079027 48.3019413696352, 2.4333365413597505 48.282909386774847, 2.4523014606128584 48.256439328189131, 2.5090335759231266 48.218017337856523, 2.5187375566775358 48.202049334553422, 2.4863615001550556 48.159610392564772, 2.4836875808435934 48.14582838122594, 2.5254664479577968 48.134033283269233, 2.5874515271289908 48.123123389724142, 2.6265765412079247 48.138492397081151, 2.6912865854808672 48.141315405304269, 2.7150344952843284 48.147800332910904, 2.7342245440746069 48.159561282994119, 2.7435514900607529 48.190025410640217, 2.7632544610334833 48.196323405042435, 2.7941605748155496 48.170314342749023, 2.8186924775498881 48.168625431170241, 2.8586634435878864 48.17575441583439, 2.947726554309213 48.179458403989926, 2.9672114365434368 48.188442287061307, 2.9659995390739198 48.202053383012654, 2.9449975407482327 48.209396407956106, 2.947818436731751 48.223159409138546, 2.9873484727536095 48.235702415933034, 3.0063874964126285 48.250141333786942, 3.0149024622932075 48.291435441913322, 3.0365594309143091 48.32236443829099, 3.0369554758389938 48.363346286996759, 3.0519955018785652 48.377594399206956, 3.1165425516625191 48.385627422419176, 3.3333334949716118 48.377636291958979, 3.3728575463146342 48.392757287183159, 3.3572415829445958 48.433132395064334, 3.3590475478011115 48.460476392783832, 3.3698914338587542 48.477264297091, 3.404484461859596 48.503132367391217, 3.4214925671448668 48.544696314126256, 3.4613665461813241 48.557075270311955, 3.4713755695377415 48.584739272330594, 3.4917835004764015 48.585487357188313, 3.497730511065356 48.612980443819495, 3.5322814702942082 48.641521377311349))'),
('Seine-Maritime', '76', 'POLYGON ((1.7446534937786282 49.792755325561089, 1.7331335150295786 49.819473396279662, 1.7293874581020248 49.887466388948226, 1.7094924493458166 49.913746345970125, 1.6911814442683237 49.926471357409994, 1.6249365058872911 49.953155280255046, 1.6107695388816694 49.96609538809399, 1.525082491118269 50.013576422023689, 1.4196435388314512 50.085399433143849, 1.2977835078476971 50.024727286902944, 1.2098824809453674 49.973827417163463, 1.12278850558954 49.94022731779377, 1.0170054342681567 49.919735425331069, 0.96000348034922922 49.920730290181851, 0.93600245383390757 49.908435295520221, 0.84351452262396265 49.893436282132839, 0.80031957487909722 49.879242384072327, 0.698018530535478 49.875438416575818, 0.609532413264418 49.861538295839424, 0.61403253972855509 49.858238273507069, 0.56863241384309049 49.84784341438403, 0.47553158110969207 49.804546375058592, 0.36894849904047078 49.767048313530253, 0.32664949292521328 49.745342411358436, 0.28855243545078224 49.739154429435317, 0.23695341440426887 49.720150433749623, 0.20635357536397692 49.716350338692351, 0.15896442385678711 49.680355311658175, 0.15025055541406118 49.643554289197269, 0.062156434608453992 49.518257292347172, 0.065861478883817881 49.508064328125741, 0.086166438142072366 49.501163289318256, 0.0972595684722819 49.486766440236337, 0.10296155926783968 49.48456531055497, 0.12596244033335324 49.490360415912804, 0.11222144164673864 49.476204362145111, 0.11465456564397414 49.466365374076375, 0.12675646640235527 49.463764327031058, 0.19244641382894656 49.456878425940673, 0.24526842160287288 49.453975328632808, 0.31189549933122862 49.448108407128629, 0.36432955909893394 49.446518418771021, 0.41271357545690535 49.4508784333418, 0.43391958092377081 49.453144338370848, 0.49492141256200739 49.462497335312023, 0.51674049557226454 49.455593304165077, 0.54946753590800768 49.430198375534886, 0.571629505813064 49.420597366460882, 0.61446642894603087 49.412197341618437, 0.68022255988003621 49.418773271547778, 0.70128352489450663 49.417278333972106, 0.72342542852339875 49.407631383686848, 0.76439654001120516 49.41272733773765, 0.78542441327195434 49.411213390005585, 0.82588049033773814 49.388942287721264, 0.88930242049568164 49.381641331549829, 0.90762257861140938 49.3690143632313, 0.90529541863401164 49.355217390195335, 0.88607051789034585 49.34320437952006, 0.9102744954270463 49.31724143445787, 0.95226353038125922 49.314151403945559, 0.95168143235196112 49.2868044138866, 0.9723044596897239 49.287964385466, 1.01601549797644 49.27129740687586, 1.0370014784851662 49.269729421014048, 1.0562334200274961 49.281723421532959, 1.079885574969154 49.324005353711456, 1.1624574213650192 49.328533291330317, 1.2013715635240203 49.349769396211471, 1.2216684258638111 49.3536032871023, 1.2640114369707192 49.347683383588205, 1.2836735713112262 49.356922319591078, 1.3372605618596367 49.428054276322669, 1.3521284403719562 49.442493370196516, 1.3718454929420432 49.451725441420692, 1.4125705285166248 49.45932439939547, 1.4552875820523923 49.450641334446871, 1.5480075075782338 49.441787354110815, 1.6234855733032418 49.4374542705949, 1.6645714498092161 49.442253278962184, 1.7323954633099561 49.431999411832336, 1.7719184585331789 49.450340340304123, 1.8086524173868384 49.493095414152648, 1.8029495464914476 49.5064504010527, 1.7812855370716534 49.513580441836652, 1.7394955806995824 49.514228371333431, 1.7363485197181205 49.541362377232886, 1.6990395036338271 49.6104503901132, 1.72049352123355 49.641529355502385, 1.7214435009928764 49.668865432323386, 1.7608325450215716 49.689914427980156, 1.7717394462272011 49.704075410306913, 1.7618495883881451 49.717235367084029, 1.7208735483412738 49.709766311844575, 1.699747455939189 49.711418435250337, 1.7019924145922118 49.727905345414754, 1.7167344388284675 49.745014310140832, 1.7552224366485518 49.7741894435721, 1.7446534937786282 49.792755325561089))'),
('Seine-Saint-Denis', '93', 'POLYGON ((2.6259655759041038 48.815773399290819, 2.6069325369239493 48.842250322655232, 2.589542468311322 48.893360360234752, 2.6347375309358085 48.936248329157976, 2.6441315405291732 48.966678308930582, 2.6291254863431277 48.993324387482843, 2.6313655164371141 49.012531334189916, 2.610011478178393 49.019798318507824, 2.5894734684844707 49.018905369217649, 2.5718714718321394 48.988124405631808, 2.552427426230139 48.976364335648427, 2.5119014692376709 48.969120409946115, 2.4708294983090582 48.967315325189432, 2.3864905874692681 48.985378318134067, 2.3468155109949578 48.969940310950179, 2.3060304526117648 48.965355342862196, 2.2863644458319925 48.956276409008908, 2.287786511141519 48.942680274754721, 2.3121325367912107 48.946521382464184, 2.3329145101587585 48.944736363983665, 2.3425565318849522 48.931526417536034, 2.28442241754135 48.896103279373065, 2.283275471439481 48.890281418980308, 2.3259835479569233 48.892551372468589, 2.34564251393806 48.901638403240369, 2.3869274690261761 48.900779425803719, 2.4082765787258325 48.8935472934392, 2.4356494437198535 48.867469407338874, 2.5225284986965448 48.863136323822985, 2.6259655759041038 48.815773399290819))'),
('Somme', '80', 'POLYGON ((1.7446534937786282 49.792755325561089, 1.7888515793127056 49.77312434675467, 1.8409344792471813 49.721107278287647, 1.8617514805880546 49.722118336975356, 1.9425705201572896 49.747841366823152, 1.956594558950087 49.734871335589915, 1.9970094473436859 49.74769931871019, 2.0181404683048356 49.745990340855215, 2.040489547434305 49.733379390353647, 2.0836304570494519 49.721771401621353, 2.1341914883533661 49.718692284346943, 2.1811705133385715 49.709934410912595, 2.3116514742227139 49.702247442954544, 2.3760985446656946 49.686042340756572, 2.4441624733808 49.634521296555235, 2.4657784293497116 49.627273322393691, 2.4851814622994937 49.64176927071675, 2.5056914848187262 49.645370287191881, 2.5270145435633538 49.640857311270182, 2.5422524160453008 49.614250309150506, 2.5636025818647852 49.609703361375281, 2.6254035441509984 49.617805384414382, 2.619803468916075 49.590309305443796, 2.6413715474540993 49.583046369585119, 2.6616164839037708 49.589347356326741, 2.6755655381908241 49.617218357826019, 2.695293503998812 49.628933366697979, 2.7797774552910255 49.618824364000588, 2.7995024287595811 49.630539372872548, 2.8106754721545997 49.644630299252626, 2.8132775753197166 49.661094326821356, 2.8330565869179907 49.672805287234084, 2.8541094550139974 49.670929442450856, 2.8746555616264118 49.6744993033919, 2.89417758407356 49.688911290190916, 2.9121515109151517 49.676010434804496, 2.9319055276781683 49.687702385060859, 2.9306494491970625 49.701275284679454, 2.9114215561139645 49.727768401880795, 2.9317504540876769 49.734028375970226, 2.95234549425075 49.737568313516974, 2.981142536793925 49.697830397914615, 2.9965245696284342 49.712082382564077, 3.0171294669096369 49.715599437515166, 3.0384625587923608 49.710994403150991, 3.05877244660968 49.717231318624826, 3.1053434573124434 49.710865380515528, 3.098719473932249 49.737850297503329, 3.102873545142188 49.784340339021512, 3.0606585005509714 49.788150291196914, 3.0684334784922669 49.840229318692124, 3.0450495779795972 49.866546415926948, 3.0479764379829533 49.880275445255862, 3.0631954763284739 49.89723232873088, 3.084354484464285 49.895313359055834, 3.1333005325753618 49.957107280543411, 3.1835264218630357 49.959011288521296, 3.1983244204486425 49.981369344669062, 3.1586685301506918 50.001674303927317, 3.1268925256941031 50.027691287119225, 3.1236764648857331 50.062957415472042, 3.0642174482541122 50.068843347132614, 3.0202585738545338 50.088920360534232, 2.998764423702454 50.093528387237839, 2.9832394626550922 50.0793114305617, 2.9845194798516559 50.065731314124477, 2.933350475583353 50.028312285561114, 2.8987734653994721 50.037826340771673, 2.90169557286373 50.051563290999056, 2.8919845513106281 50.064792423623047, 2.8699674458380287 50.074798278620065, 2.8490295187801564 50.073978377616, 2.7879655520937376 50.052425436795104, 2.7662064918920635 50.059692421113013, 2.7606794649432231 50.073097397683554, 2.7831975232405739 50.101242286250752, 2.7818585393552269 50.114822402687977, 2.7679404645822672 50.12786829852682, 2.7464185032754926 50.132423343220509, 2.70550952683584 50.119854285470964, 2.7095435524286415 50.079166390109307, 2.689388562181847 50.070144310705174, 2.6016864378416926 50.104602331391717, 2.5961094212223941 50.1179844253666, 2.6017464606502756 50.145462374280626, 2.5962044720043025 50.158863302391936, 2.5748954948570031 50.160667331028847, 2.5370725004704582 50.118206386544372, 2.5230984513481474 50.131225351328325, 2.5015495589864827 50.13574941650792, 2.4802734975729095 50.137546404346168, 2.4598574697157858 50.131221302869122, 2.4433784804498941 50.086914436995713, 2.3913404656068735 50.100986353219426, 2.3899305456750142 50.114555380398755, 2.4021524920505612 50.158657359031125, 2.42143741560281 50.175850285281243, 2.462609541892391 50.185821288324874, 2.4738155010211642 50.199924360082647, 2.4566794292202303 50.242756354656549, 2.4350875879867147 50.247261409679723, 2.3731195827522527 50.233665275425537, 2.3590775899228618 50.246673326971589, 2.3380465483027137 50.245731444130726, 2.3181885037394636 50.23396644558828, 2.3112015671882773 50.220039393797023, 2.2907864194309866 50.21367627200722, 2.2049374332983973 50.226162424352495, 2.1640784465292597 50.213405377278733, 2.1433475189520266 50.20973236863729, 2.1220644167397893 50.211483415264254, 2.1004394837525808 50.215931439818306, 2.0745844389298895 50.2583353538336, 2.0604524998976217 50.2712972881484, 2.0159264891659063 50.291019445297493, 1.9726204728221717 50.299881346532075, 1.9066594546471265 50.321293295359808, 1.825179460103584 50.366424286716452, 1.8038125723873009 50.368126399792729, 1.7619784350036412 50.363369284177466, 1.7217645614118169 50.345047365862072, 1.6802974256583525 50.337558420366364, 1.6231044900757183 50.375209443245623, 1.5589684469135818 50.362705336863755, 1.5428705408752137 50.280513341555647, 1.5577625341229293 50.2632063543672, 1.5884595361847573 50.262413384418025, 1.5850625268508338 50.248207340979818, 1.5903624880428424 50.246910425866488, 1.5945625004640362 50.255912438994429, 1.5991654225886407 50.254310305259125, 1.6017555563960286 50.240608383005068, 1.6275595554284337 50.2165182903867, 1.6166605751212728 50.212917273911572, 1.6197604627517137 50.210411277648163, 1.6362565259543658 50.215210286015449, 1.6521305345953294 50.204517425089094, 1.6717484879242477 50.193706278745239, 1.662352542111222 50.188411422132262, 1.6796595292996699 50.181518304223246, 1.6085645367610368 50.194717337432948, 1.5897634920967505 50.205616317740109, 1.5776665198974626 50.203411315619476, 1.5663685023261849 50.210510376889331, 1.5740625110829 50.221313426314723, 1.5401665221494909 50.215316426055281, 1.5182694622940289 50.206211441246936, 1.4935685803918375 50.181423429461304, 1.4711665192524208 50.142917301584689, 1.4631655316740932 50.114318281503856, 1.4464624689908021 50.098720272170411, 1.4196435388314512 50.085399433143849, 1.525082491118269 50.013576422023689, 1.6107695388816694 49.96609538809399, 1.6249365058872911 49.953155280255046, 1.6911814442683237 49.926471357409994, 1.7094924493458166 49.913746345970125, 1.7293874581020248 49.887466388948226, 1.7331335150295786 49.819473396279662, 1.7446534937786282 49.792755325561089))'),
('Tarn', '81', 'POLYGON ((2.0328874211001562 43.416851317818086, 2.038158515017642 43.403907337539877, 2.05437048199434 43.391071433521105, 2.0732524958432066 43.389320386894113, 2.0918335155493253 43.390281279891369, 2.1099095339715177 43.396721322406549, 2.1452385014523827 43.41774743546766, 2.1845634742132631 43.397869324628218, 2.2029144358231463 43.40154233326966, 2.21646251662645 43.415943406830749, 2.2213174993431153 43.443603360390185, 2.2399305546831272 43.444557388608743, 2.3738004279827578 43.41295229953964, 2.4477284618825763 43.422111322477704, 2.5226664983503042 43.420303421401528, 2.5410345338969478 43.423931368931548, 2.5551865392054083 43.43283428281832, 2.5911815662395838 43.448269297662776, 2.6279595300848939 43.455505302466591, 2.6416484268614226 43.469852337897962, 2.6429444618749471 43.497295434858628, 2.6132115211697737 43.536949388936947, 2.5946324376832877 43.577144428392344, 2.5996644964862412 43.604774282537491, 2.6171084272086205 43.61931229963254, 2.6537355419426092 43.629264292519807, 2.6724105563108651 43.63012731841566, 2.7487824514258818 43.614536349880879, 2.7674745397308982 43.615413281354094, 2.822560516314212 43.628906267907908, 2.8585275561737546 43.646972429211942, 2.859966519400075 43.674408309353979, 2.8697824488532149 43.69128827210362, 2.86861455637532 43.704925419009996, 2.8562255670515526 43.718067421750547, 2.8185835211905896 43.719093266115451, 2.7420695779625817 43.734729295761682, 2.6644444206859248 43.720138296656714, 2.6454895345709133 43.721988266504852, 2.6258154308726773 43.732025277035959, 2.591456509427303 43.779682330932175, 2.5712555779692821 43.795139348272457, 2.5328075366816165 43.804260350897735, 2.5203245526957119 43.8173523639678, 2.5353295507619578 43.859150417258334, 2.5363485303481639 43.889324287979647, 2.5175995875939634 43.929519327435074, 2.4793154208951478 43.935886321664142, 2.4980705243481509 43.977890318315517, 2.4968375044826416 43.991527289201926, 2.479274584262896 44.018070396073753, 2.4667405544867052 44.031154312225354, 2.4281265263706189 44.04021828438151, 2.4082804511650977 44.050209353701334, 2.3504744380390719 44.102157422341449, 2.3107375785565409 44.12208129837218, 2.2913905199560816 44.126602371212343, 2.2699435431550512 44.152904330730038, 2.2508545298255456 44.154693397669789, 2.176550517277235 44.139953309653166, 2.1752164619509529 44.153587288200143, 2.206749558853744 44.179863372782748, 2.2016595894818067 44.193302321206843, 2.1448324233896017 44.193142319057259, 2.1055185398866172 44.207557298195738, 2.0866625769927793 44.206569298123625, 2.0503024845480127 44.190982378048076, 2.0311794993649812 44.192726383876376, 1.9956935220739638 44.168926372162829, 1.9585724953139163 44.1614912887769, 1.9386255606675604 44.171413358269845, 1.8815315483061283 44.173828352210549, 1.8638105621564307 44.161926410134143, 1.8269975703378236 44.151691377140722, 1.8110084446387305 44.123417289918095, 1.7930375101365996 44.11421936656744, 1.6960485723626562 44.136299311168088, 1.658701535965605 44.131488333443073, 1.6407564763985363 44.122253269879494, 1.6248405750055497 44.093940282244247, 1.6633305090452382 44.087879386736958, 1.6803965248994928 44.034011292302, 1.6668215130412989 44.019554420411524, 1.6483174140605286 44.015777383969848, 1.6347304328446057 44.001316287600176, 1.6362005516050147 43.9876823090532, 1.6185985549526833 43.975742346664035, 1.6087775209205404 43.961467303398948, 1.5557215826111133 43.928310422304989, 1.5459484260098293 43.914051396856863, 1.5554874760556174 43.8953932804054, 1.5973684347503934 43.856655334232883, 1.6167084525521602 43.816612376028544, 1.6420804985867221 43.790638341708487, 1.6435294949511388 43.777019324858642, 1.6613735190574346 43.75059943196338, 1.6455584771052543 43.722313375383024, 1.7047955325591033 43.695469274368449, 1.7116794974298557 43.665710282708218, 1.6935835887514656 43.659214265843687, 1.6800545181045266 43.644741376136253, 1.7994025681460357 43.580120397966354, 1.8809445217177654 43.516040329153569, 1.9379394348380572 43.508159387192435, 1.9927384988759513 43.522064436487867, 2.0119155221887297 43.517589304858987, 2.0170024992212632 43.504173415050516, 2.0146244694735174 43.490333317122733, 2.0013574925567355 43.4731903805431, 2.0301355249435176 43.44731931790345, 2.0351985632605931 43.433891282717312, 2.0328874211001562 43.416851317818086))'),
('Tarn-Et-Garonne', '82', 'POLYGON ((1.9386255606675604 44.171413358269845, 1.9447674253594585 44.185432292483611, 1.9390575136654036 44.204303393094577, 1.9225785243995119 44.217132432334651, 1.9028964998027789 44.224308414329883, 1.8939465885849529 44.237533322474647, 1.9431594829652852 44.275772428062069, 1.936604499411942 44.30284130657391, 1.8523974275270803 44.309295430686419, 1.8589385055030334 44.356243300137507, 1.82689354253759 44.335331424034692, 1.8074505530554177 44.33975938231255, 1.7504774664109846 44.33939730924142, 1.7318784926682724 44.335636290616705, 1.7141365601425491 44.323692279768309, 1.6749214238408001 44.335239365592187, 1.6560364176524729 44.334186414152455, 1.6017104952845784 44.309234351758036, 1.5822335339488518 44.313617424944411, 1.5694525481596315 44.326610338773335, 1.5363474169358255 44.316520346232309, 1.5483405373548749 44.276077294644082, 1.5385054217254037 44.261806299838256, 1.5193384315507217 44.263466344142515, 1.4960064569281712 44.303260410114191, 1.4582554547079383 44.301105397664045, 1.4288224520257131 44.258285372447872, 1.3740584159611728 44.238659322200519, 1.3561244456519717 44.229389406683524, 1.3425615791714733 44.214889409901261, 1.2832754141469422 44.236080277651, 1.2779685881762362 44.249477333323071, 1.2824104520314563 44.2771603454981, 1.26955043327726 44.290119287473473, 1.2503765783238805 44.29173638290591, 1.1969075211530367 44.261127390827355, 1.1777405309783546 44.262737269441189, 1.1591874984469257 44.2917863725764, 1.138759501232073 44.3042683004425, 1.1000585192525136 44.3101693698202, 1.089331510452638 44.336956440365626, 1.0691805686651037 44.346691400634157, 1.0638174163051133 44.3600963772047, 1.1003244854219076 44.373256333981843, 1.1138364821321147 44.38779030261766, 1.1009194329087677 44.4007342828959, 1.0262765819248898 44.387962274124973, 0.95643854796722394 44.367221313409644, 0.93755547799855776 44.366066270389311, 0.90785650914691018 44.391647428144083, 0.88832656580126468 44.395919432731617, 0.86974343385554675 44.392025343012207, 0.86171357900272483 44.364086397805849, 0.86497646112215421 44.336845371766756, 0.8848315133459721 44.32985737909577, 0.92206448880475023 44.304756403809662, 0.9307195665786594 44.264133283795687, 0.92642855183473216 44.236423340565764, 0.8718614821127062 44.216564415902681, 0.86973850529648189 44.202713404736969, 0.87890456903321024 44.189579322894915, 0.87086344890252576 44.161651290926457, 0.85205958791880221 44.160450306694869, 0.81344256746325527 44.166267414548528, 0.795284523736683 44.15962230877237, 0.7760105134223636 44.130951296525225, 0.7582055657486535 44.121593371024986, 0.74650358235422232 44.093410286125064, 0.76649047353296851 44.053535426988745, 0.78561645105543221 44.052013382338217, 0.80485648951622579 44.080661335969737, 0.82233351199232629 44.09273929801266, 0.860905471336423 44.086937327876129, 0.87005358103655794 44.073795325135578, 0.86792655576110178 44.059951354768529, 0.81486551287264319 44.029171271282522, 0.799385436916765 44.000740350269709, 0.7689155006117403 43.971370362735527, 0.74972545182146177 43.942703398947614, 0.75513542549254 43.929344363588328, 0.77486444742032745 43.922374324953964, 0.81136341961868652 43.932926369907094, 0.84884951178929668 43.935295422636514, 0.88764642465062593 43.926757398140339, 0.90425250033234761 43.914074279452521, 0.91337051061822194 43.900951286868334, 0.914976516792791 43.887321356780589, 0.90163649158989756 43.872772426447611, 0.90700351638915322 43.859390332472728, 0.89363550401157 43.84484140213975, 0.895271433580433 43.831203375133512, 0.88515943854361012 43.78942538811917, 0.92319946554889043 43.786335357606859, 0.97492944545047067 43.795059435207648, 1.0313385641221657 43.795795374687671, 1.1226975032668634 43.82057933801407, 1.1242535197709174 43.820449435278775, 1.141726493787786 43.819000438914358, 1.1781914941325908 43.79651230401133, 1.217791586101157 43.779697292629336, 1.2364794499269465 43.780830333153844, 1.2723514390045523 43.796688323977847, 1.3640895251571123 43.818546307400723, 1.3738195568665788 43.83282135066581, 1.3648265207569636 43.846000317599319, 1.3457934817768091 43.847633430848717, 1.3092485683671669 43.837249308943669, 1.2899194638033293 43.841598410276518, 1.2808935119599596 43.854763295612727, 1.2984015139501537 43.866779298627435, 1.3355635533623911 43.871719298987912, 1.362511506157233 43.90072633335113, 1.380955582329392 43.904544382444968, 1.3999965422080436 43.902908276856138, 1.4254805369413077 43.876964341950369, 1.4445454355354173 43.875339325619407, 1.479622518444188 43.899292298683875, 1.5459484260098293 43.914051396856863, 1.5557215826111133 43.928310422304989, 1.6087775209205404 43.961467303398948, 1.6185985549526833 43.975742346664035, 1.6362005516050147 43.9876823090532, 1.6347304328446057 44.001316287600176, 1.6483174140605286 44.015777383969848, 1.6668215130412989 44.019554420411524, 1.6803965248994928 44.034011292302, 1.6633305090452382 44.087879386736958, 1.6248405750055497 44.093940282244247, 1.6407564763985363 44.122253269879494, 1.658701535965605 44.131488333443073, 1.6960485723626562 44.136299311168088, 1.7930375101365996 44.11421936656744, 1.8110084446387305 44.123417289918095, 1.8269975703378236 44.151691377140722, 1.8638105621564307 44.161926410134143, 1.8815315483061283 44.173828352210549, 1.9386255606675604 44.171413358269845))'),
('Territoire-de-Belfort', '90', 'POLYGON ((7.1369054746399172 47.502224399111341, 7.1614834946054771 47.52418130575542, 7.1491085868790378 47.551399273178916, 7.1246604696487452 47.578514268921978, 7.0842545582734431 47.597316369706064, 7.0442205770874295 47.591568437699252, 7.0240784362981969 47.596862414212396, 7.0197985108121941 47.613201291584929, 7.0276264707634084 47.626907438318213, 7.0593195698157842 47.654422351425225, 7.07497355349858 47.681831300512371, 7.06252454136623 47.709015296082313, 7.0220524464835137 47.72508627106582, 6.9575615470688774 47.732746307968981, 6.892748531115501 47.756729380447709, 6.8764175746414367 47.770233280239424, 6.8721325445764023 47.783832406833042, 6.8476624248503128 47.799984351001157, 6.79974943792277 47.777706383938138, 6.7721565479705816 47.7501673560957, 6.7683995778050985 47.736484267978071, 6.77728946621437 47.695640418926061, 6.8225424394078118 47.641517271559607, 6.8228795176437131 47.625148294772757, 6.8074585843965849 47.592266356866489, 6.8363244507466447 47.551612433358358, 6.9209034528207951 47.53054037908602, 6.9411284990142406 47.519798408589011, 6.9616225037165407 47.492698374543082, 6.9382854245149588 47.451568317025519, 6.9479615941146733 47.436142279199359, 6.9961644859270677 47.464790408850817, 6.9849974272109137 47.495208419265694, 7.0312535381935959 47.504566344765934, 7.07696750767937 47.495029406959745, 7.1036074255327719 47.504020330829789, 7.12627756508121 47.505645347160723, 7.1369054746399172 47.502224399111341))'),
('Val-D''Oise', '95', 'POLYGON ((2.5894734684844707 49.018905369217649, 2.5757895002669784 49.031959361974955, 2.5750334945107625 49.081047282179028, 2.5654395262354228 49.094280287242285, 2.5221095711762302 49.114204339292982, 2.5009484508007915 49.118747414628942, 2.4789994650552387 49.131416275699493, 2.4377535863996798 49.170528440320837, 2.4127325241783808 49.1721423673939, 2.370115449983615 49.183872337962995, 2.3304604397854973 49.206638408393175, 2.3101405188300816 49.202995323146055, 2.246752560525664 49.175544305286891, 2.2261265408484974 49.1745872847289, 2.220562549706699 49.187976419502448, 2.2002475573103482 49.18429531394257, 2.1793555714637307 49.186065370725927, 2.1581585430151335 49.190536277875609, 2.0930584384963709 49.217521370883375, 2.0724324188191758 49.216526330012627, 1.9885335578956926 49.187973427163016, 1.9073285065398693 49.173118398108258, 1.8661315614350258 49.171104377651304, 1.8237005403448734 49.179947444749459, 1.8139205189648919 49.1931074015266, 1.7923754990424925 49.200225296932885, 1.751772445304681 49.192737407556976, 1.706264419179746 49.238201428690289, 1.6937814351938414 49.228065318918041, 1.6931345618168905 49.19799037141793, 1.6798135467703617 49.170021326797283, 1.6437234689542493 49.124504323654051, 1.6241065717451306 49.1152953110455, 1.709539446676871 49.092342307410874, 1.7152224273160357 49.078968310354426, 1.7145794263783216 49.048889314395083, 1.7325774679553376 49.036155325936917, 1.8150834828837219 49.037521416897121, 1.8580145766987641 49.023273304686924, 1.8817575579431605 49.032623309288667, 1.9427935374548611 49.041069275342366, 1.9645445007381 49.031204412338539, 1.9851055690476471 49.032196284849888, 2.0693744239407863 49.017109437499229, 2.1301324679253639 49.028167363836147, 2.1618195822988753 49.002361428584109, 2.1826325351804883 49.000599292699249, 2.20051457959957 48.987793312074771, 2.2048504794349242 48.947048386243935, 2.1845784359104243 48.905132399575834, 2.1792645691410542 48.877586330934761, 2.2050754329521567 48.906078330875928, 2.243786448069784 48.929729429697787, 2.287786511141519 48.942680274754721, 2.2863644458319925 48.956276409008908, 2.3060304526117648 48.965355342862196, 2.3468155109949578 48.969940310950179, 2.3864905874692681 48.985378318134067, 2.4708294983090582 48.967315325189432, 2.5119014692376709 48.969120409946115, 2.552427426230139 48.976364335648427, 2.5718714718321394 48.988124405631808, 2.5894734684844707 49.018905369217649))'),
('Val-De-Marne', '94', 'POLYGON ((2.6011925258156339 48.691848302059796, 2.5985105095857364 48.719047435346866, 2.6184255846181372 48.725372360803945, 2.629347447520928 48.739494442718112, 2.6239195198132563 48.752899419288653, 2.6062235284988162 48.765789361437143, 2.6237644462227365 48.796569268903184, 2.6259655759041038 48.815773399290819, 2.5225284986965448 48.863136323822985, 2.4356494437198535 48.867469407338874, 2.4419465580222379 48.845913298158578, 2.4616085163427783 48.85498431111337, 2.4831954290172007 48.8450203488684, 2.4613694812282176 48.816745381545942, 2.4195844534152116 48.823063442224324, 2.3789175044295519 48.818496428172907, 2.3458764444735607 48.819732440377848, 2.3557395472777216 48.803802281367567, 2.3383665526018547 48.772987345928172, 2.3370235202572758 48.746154334171464, 2.3736224717966081 48.750011283677949, 2.3848504334211782 48.720485342453387, 2.4047524829760789 48.726833326526091, 2.4257344150255733 48.722324399063623, 2.4393845874094779 48.709285368003506, 2.4788584730620471 48.724708413490234, 2.4998625836273334 48.720157417255777, 2.5134775520179176 48.707122434654863, 2.5559724683559182 48.692608356275244, 2.6011925258156339 48.691848302059796))'),
('Var', '83', 'MULTIPOLYGON (((6.4345984634661386 43.006126302586935 0 0, 6.4441964983844855 43.005020394483168 0 0, 6.4534924648565095 43.01681936487914 0 0, 6.4702944507609743 43.016422263834684 0 0, 6.4764975704012215 43.032524394352251 0 0, 6.4889965722040586 43.03951643548244 0 0, 6.5080834899379907 43.042225414687579 0 0, 6.5088915809602668 43.050823430072015 0 0, 6.4697934979362515 43.048519328710213 0 0, 6.4566955001873225 43.027721337525733 0 0, 6.43869253005127 43.0241203210506 0 0, 6.4345984634661386 43.006126302586935 0 0)), ((6.369496425420329 43.001724414559042 0 0, 6.39079556094066 42.996120296915862 0 0, 6.4027914976791749 42.997520359729563 0 0, 6.4219005679558876 43.013221353348129 0 0, 6.4149935537984959 43.014427429554061 0 0, 6.4139944644685158 43.019222389462115 0 0, 6.3805955559205643 43.01352339100599 0 0, 6.369496425420329 43.001724414559042 0 0)), ((6.161515442219196 42.999923391225877 0 0, 6.1890055672385813 42.99152036713069 0 0, 6.1911054854392091 42.983425384890253 0 0, 6.210802471733075 42.986122362817341 0 0, 6.2157095563598261 42.993126373305259 0 0, 6.2489025184261395 43.000126316652981 0 0, 6.23914045420355 43.022693327181983 0 0, 6.2283074813838653 43.014629324455669 0 0, 6.2128034667125291 43.014923277799753 0 0, 6.19790654490572 43.003921325812186 0 0, 6.1720115435506386 43.007724413208891 0 0, 6.161515442219196 42.999923391225877 0 0)), ((5.6308235526723891 43.202697325494469 0 0, 5.6292784435516694 43.1837123440982 0 0, 5.6317534603009562 43.184520275744532 0 0, 5.6467605706067729 43.185814374538424 0 0, 5.6613594906102662 43.179622344156073 0 0, 5.6901554770336134 43.177215271113866 0 0, 5.6955455699732944 43.1729122969129 0 0, 5.6850505459645149 43.166519417848079 0 0, 5.6841544218650446 43.157917325471445 0 0, 5.6926535523985251 43.146419345830864 0 0, 5.7155384363061046 43.14711726499813 0 0, 5.7344415725509634 43.134109389472044 0 0, 5.7530324493752119 43.132518344994665 0 0, 5.7677825705299313 43.136463304484366 0 0, 5.7782325479901369 43.133316417398063 0 0, 5.7705365796548 43.127319416732576 0 0, 5.7748404420468109 43.123710314196551 0 0, 5.7693394868659755 43.117515307668349 0 0, 5.8082344231164882 43.1142193092749 0 0, 5.8148284826379459 43.109718327212704 0 0, 5.8080335876696632 43.102020407600996 0 0, 5.8122355201162321 43.0902212812485 0 0, 5.7990335269516464 43.071418311446777 0 0, 5.827834422408813 43.050319308887865 0 0, 5.859232511997277 43.04692441179354 0 0, 5.870435478786618 43.063320319635253 0 0, 5.8891344318703034 43.076118379361233 0 0, 5.9107234567843534 43.073421401434146 0 0, 5.91542847048953 43.067325301933565 0 0, 5.9310254237031756 43.072918336369824 0 0, 5.9414204588461814 43.069618314037442 0 0, 5.95472948874992 43.073120417187006 0 0, 5.9457234429478092 43.082420422222654 0 0, 5.9146265235220312 43.08641431526307 0 0, 5.9016295612339036 43.080116320860853 0 0, 5.893229501098368 43.083114279151175 0 0, 5.9160234452742051 43.093013306346371 0 0, 5.9076225329936527 43.0966183546742 0 0, 5.9111314527275054 43.101612384089613 0 0, 5.9062264986796151 43.103614282311852 0 0, 5.887627524936903 43.101120431426139 0 0, 5.8852245083376085 43.105022246311442 0 0, 5.8898265423786995 43.114616410319385 0 0, 5.9061284555582745 43.1149212769014 0 0, 5.9112265218486755 43.12492026711972 0 0, 5.9178314950725053 43.118915345961781 0 0, 5.92392847467292 43.121715295569246 0 0, 5.9348274526702678 43.118011302986318 0 0, 5.926430440858419 43.107418436228322 0 0, 5.9316314604479032 43.102718340682245 0 0, 5.9423274897336569 43.109016335084434 0 0, 5.97762952615966 43.105713320412619 0 0, 5.9851274486736372 43.10841733913837 0 0, 5.9905275652266141 43.103912284115168 0 0, 6.00491842962964 43.10351535909065 0 0, 6.0195224519370436 43.090812332434268 0 0, 6.0144175203380881 43.078319323604219 0 0, 6.03872253614054 43.076320274262812 0 0, 6.0812204448179727 43.084617327424823 0 0, 6.1231105565509836 43.0789183289687 0 0, 6.1307125283605117 43.048717367562553 0 0, 6.1168104499091953 43.039623279602139 0 0, 6.0936115355021485 43.040619354563965 0 0, 6.09511845331474 43.029819319506728 0 0, 6.1008204441102976 43.027225313260075 0 0, 6.1098185847989441 43.033622406903433 0 0, 6.1325094947034415 43.03452626943151 0 0, 6.1543125598967663 43.024124369509835 0 0, 6.1740144748283647 43.030418324021795 0 0, 6.156216567874651 43.033420335981859 0 0, 6.151711525267066 43.038818340051215 0 0, 6.1536165853608162 43.051117372687493 0 0, 6.1477135441787167 43.057220342943829 0 0, 6.1597065157509121 43.085518373633462 0 0, 6.1919095446462791 43.112217434195642 0 0, 6.2072074399368091 43.115413428727791 0 0, 6.2347015826877907 43.112911304903676 0 0, 6.25149247933436 43.119964424962248 0 0, 6.2782065015937008 43.119423339585168 0 0, 6.296206479390321 43.106418280378549 0 0, 6.3171965083582791 43.1032143649479 0 0, 6.3236025790199335 43.093719319893736 0 0, 6.3602015305592658 43.088714368165611 0 0, 6.3625945220041444 43.0848193983464 0 0, 6.3702005016321568 43.0911143882642 0 0, 6.3582024717994443 43.106315308698143 0 0, 6.3577974266050621 43.123817322152817 0 0, 6.3671045055864113 43.134815405557774 0 0, 6.3851965418255361 43.144008400349392 0 0, 6.4230925844981641 43.151016283276576 0 0, 6.4340985849449623 43.149414325561239 0 0, 6.4368995906722546 43.144512345513547 0 0, 6.4581985346814577 43.155811419204596 0 0, 6.4842875100396782 43.156013314106204 0 0, 6.495996534232745 43.15191240092615 0 0, 6.5348934264350476 43.167915432202577 0 0, 6.5417905928032951 43.183906318101307 0 0, 6.5588875881716717 43.189411342554322 0 0, 6.5833904476115208 43.189106299952343 0 0, 6.6005844299814385 43.184211360703287 0 0, 6.6085824252203338 43.1662143752461 0 0, 6.6196774917701759 43.161819332701967 0 0, 6.633775458948918 43.173515331417534 0 0, 6.6445825465657187 43.172111407269512 0 0, 6.6414865611168015 43.181812373637726 0 0, 6.6485815544529885 43.191406352854884 0 0, 6.6598785159044667 43.197807318937507 0 0, 6.677378420976197 43.197910290617912 0 0, 6.685072458971721 43.202407422772133 0 0, 6.6653764995588176 43.214309366819023 0 0, 6.6660794989651837 43.242107319693666 0 0, 6.6850775343119153 43.2511063408207 0 0, 6.6987815458300854 43.270004345829321 0 0, 6.6782824595242687 43.279903383363873 0 0, 6.6723805100467359 43.279705360901531 0 0, 6.6627844295317971 43.269615368360505 0 0, 6.6396855053449144 43.275207346676993 0 0, 6.6251844524428236 43.268104412967872 0 0, 6.59507958154839 43.267505417021809 0 0, 6.5859885030984255 43.274608341054211 0 0, 6.5881794228407387 43.281505341079182 0 0, 6.6118824475527163 43.28950527253771 0 0, 6.6283765745357357 43.3069034380688 0 0, 6.6745735418974679 43.316005433837766 0 0, 6.669181503818332 43.325203353608728 0 0, 6.6783745179667449 43.339306425646143 0 0, 6.7145705598027234 43.3456992948103 0 0, 6.7324784791568675 43.412780328032326 0 0, 6.7602715038109693 43.426502316562576 0 0, 6.7922754541242227 43.409198321713589 0 0, 6.794966447372417 43.415302342112696 0 0, 6.8231745271075965 43.41990227189784 0 0, 6.8367724215614487 43.420200273701155 0 0, 6.85087144485999 43.4125023925052 0 0, 6.8575674204064967 43.432399337481044 0 0, 6.8715735051627291 43.427597336774326 0 0, 6.8955685469991579 43.435196294749105 0 0, 6.9123164871669927 43.449466403206358 0 0, 6.8867635002137888 43.456867344967534 0 0, 6.8753255549628287 43.470413309447615 0 0, 6.8961434316357337 43.566280300809559 0 0, 6.8809305505631357 43.579784375850252 0 0, 6.8398464342568275 43.576648404126686 0 0, 6.7456115048791219 43.613952315631948 0 0, 6.7378604572186473 43.627525378333495 0 0, 6.7410775439082791 43.654899309648677 0 0, 6.7367895601769305 43.682190328093938 0 0, 6.6872645823959829 43.722633379682165 0 0, 6.6683584538116918 43.730629438701428 0 0, 6.6119924600317859 43.735431439408146 0 0, 6.6001345013012251 43.762619316068722 0 0, 6.6111445459418423 43.773700279122963 0 0, 6.5919055895120664 43.795322409037638 0 0, 6.5731474937196026 43.795089358601942 0 0, 6.5213504502107469 43.761650317501633 0 0, 6.4835184788059337 43.774818371197242 0 0, 6.4649504845773151 43.766369412804139 0 0, 6.4088344391498993 43.760166293163891 0 0, 6.3761165518524194 43.718692292631729 0 0, 6.3575974911745163 43.710224324082233 0 0, 6.3198204379992262 43.720626400023875 0 0, 6.2435374329673152 43.765953301603261 0 0, 6.2246374650818552 43.7711453625558 0 0, 6.1875155582219747 43.756897426365569 0 0, 6.1729145259789107 43.742992377070138 0 0, 6.1360004986994738 43.723270395941014 0 0, 6.1171515766043285 43.72570035157888 0 0, 6.0987564339828282 43.714458308356981 0 0, 6.0733674900315009 43.686687286198676 0 0, 6.03614648393048 43.67787132617535 0 0, 6.0177854891825007 43.666622418174754 0 0, 6.0069625495008836 43.652759437651312 0 0, 5.9882345531227088 43.652446298130869 0 0, 5.9691705346284607 43.663036363396785 0 0, 5.9416075680705944 43.703552287251156 0 0, 5.9027715787767079 43.74385434684622 0 0, 5.884176477473261 43.738052376709661 0 0, 5.8701255076255734 43.710453326058669 0 0, 5.851583564352012 43.704620376408016 0 0, 5.8201814263043161 43.745048290279144 0 0, 5.8012365733274009 43.750148292789177 0 0, 5.7824744290757053 43.749797308975943 0 0, 5.7641294521446866 43.7385022837441 0 0, 5.7380863902085792 43.732521304973055 0 0, 5.7434215831830784 43.688888415880044 0 0, 5.7622375895444975 43.686527284049092 0 0, 5.78136359810108 43.675968370353708 0 0, 5.7781175828643256 43.66222737563065 0 0, 5.72264946693366 43.642006377896408 0 0, 5.7043425103154277 43.630699383306862 0 0, 5.6806915951488133 43.561870291361856 0 0, 5.6812045096959878 43.548198296937542 0 0, 5.7083795282476331 43.521423371769785 0 0, 5.7126075308524475 43.507843444794105 0 0, 5.7064595038692065 43.47216435627633 0 0, 5.7111754293958938 43.4449314310376 0 0, 5.7191514221389639 43.431419434327424 0 0, 5.753589573936936 43.407497251845207 0 0, 5.7466404603108856 43.393699411621284 0 0, 5.7283005879588984 43.385120374472919 0 0, 5.6721824302918549 43.389461378887304 0 0, 5.6578184999846286 43.375488378583874 0 0, 5.6557145489800176 43.331703422050182 0 0, 5.6418524063727862 43.304096277779252 0 0, 5.660878428041741 43.293541410370082 0 0, 5.6979985747019555 43.297031358246343 0 0, 5.713381487636326 43.28366440198856 0 0, 5.7138704680772321 43.270015275832471 0 0, 5.7069375726818805 43.256210391789963 0 0, 5.6701594328166038 43.244522313972894 0 0, 5.6519774503746021 43.233215319383348 0 0, 5.6308235526723891 43.202697325494469 0 0)))'),
('Vaucluse', '84', 'MULTIPOLYGON (((4.8489265025629864 44.313175450360141 0 0, 4.8800475198260074 44.297611401328552 0 0, 4.9169145497743614 44.317749317638587 0 0, 4.9550464592021228 44.3133083338832 0 0, 4.97383659062848 44.31653636404927 0 0, 5.0172355455145521 44.358677304234604 0 0, 5.0310464394312895 44.3863983431378 0 0, 5.0107574826865857 44.413223427580604 0 0, 4.9717444173063825 44.43406630385654 0 0, 4.9336825638252719 44.435802388786371 0 0, 4.8964555730453867 44.421131300596628 0 0, 4.878202478536906 44.406959405031941 0 0, 4.8720454791506072 44.379448375159 0 0, 4.8810105165932978 44.352344281837105 0 0, 4.8779335200280514 44.338581280676593 0 0, 4.8595654844814078 44.327140334892519 0 0, 4.8489265025629864 44.313175450360141 0 0)), ((4.6231014954745557 44.284885338525868 0 0, 4.6409645278565677 44.2361712799737 0 0, 4.6689034730629544 44.209648415398007 0 0, 4.6817525785791929 44.182659273931009 0 0, 4.6826045152171787 44.097896330991873 0 0, 4.6946564263050448 44.084560354248211 0 0, 4.7493484702033015 44.050571426772464 0 0, 4.7734035348483417 44.023887327907445 0 0, 4.7861394523070846 43.9969023983747 0 0, 4.7800674747609548 43.969383273333435 0 0, 4.73710858559861 43.927127395537823 0 0, 4.8392094794328671 43.919063389383652 0 0, 4.9156304841185658 43.896526320929908 0 0, 4.9700095645163458 43.862430373314524 0 0, 5.0083704759205716 43.84702633798419 0 0, 5.056706438827689 43.779915381367843 0 0, 5.0723674633091491 43.766651396790493 0 0, 5.1143915262367159 43.751308264368575 0 0, 5.1708905911112879 43.747249419960511 0 0, 5.2456124750601134 43.754547383792541 0 0, 5.4175554671187172 43.682003394889492 0 0, 5.47430342422598 43.669601380088196 0 0, 5.51195655934481 43.664947412173333 0 0, 5.5492794810064652 43.66849527061855 0 0, 5.6831775175007522 43.6958843294495 0 0, 5.7016205375531115 43.70446037425846 0 0, 5.7380864007997632 43.732521294666157 0 0, 5.7300834941998176 43.746044387269691 0 0, 5.7109214325842 43.756584286845126 0 0, 5.65395855509783 43.774593417680038 0 0, 5.6303935300395835 43.80144543959311 0 0, 5.6111904557717764 43.811988331507976 0 0, 5.5922255365186686 43.817051369825052 0 0, 5.5547945385975765 43.813511432278304 0 0, 5.5358104267102162 43.818592414740074 0 0, 5.5459935402714109 43.846145358051743 0 0, 5.5813075366697538 43.904300417820238 0 0, 5.5807525551006734 43.917984386988863 0 0, 5.5651885176207543 43.931305402035363 0 0, 5.5079874968697879 43.949226333485086 0 0, 5.51762158868616 43.990451277657343 0 0, 5.5165165325975636 44.017761305012542 0 0, 5.48148854287627 44.044353335585605 0 0, 5.4868015488736406 44.099144304161136 0 0, 5.4832994526750269 44.110111412588722 0 0, 5.4447514320463881 44.111896431069212 0 0, 5.4209635657105366 44.138713425008959 0 0, 5.4015124793099005 44.151943437732783 0 0, 5.38239055024664 44.156982361314434 0 0, 5.3773174666810473 44.186943430633363 0 0, 5.3805175118827417 44.200687408660038 0 0, 5.3761335684966411 44.214283373156505 0 0, 5.3604545899785876 44.227581329587409 0 0, 5.3415364920365676 44.227146384250133 0 0, 5.3005854468249538 44.212520357171812 0 0, 5.2241174448082006 44.22983931371796 0 0, 5.167803552938409 44.220268404058217 0 0, 5.1487805470963508 44.222538357546526 0 0, 5.1399524416953284 44.24965634562902 0 0, 5.1279644100507413 44.26305041342696 0 0, 5.1455755737804312 44.290821421869083 0 0, 5.14493943938686 44.304496422319104 0 0, 5.1257515028361809 44.3094753230922 0 0, 5.1070905700652531 44.303543274200408 0 0, 5.0704384604960353 44.277996264319128 0 0, 5.0515295155922786 44.2775194262298 0 0, 5.0357095450810334 44.290802420963544 0 0, 5.0165404426667521 44.295761431480415 0 0, 4.9976255130841309 44.295265407214728 0 0, 4.9233315336739167 44.265960371048195 0 0, 4.8857975640724192 44.259483364340028 0 0, 4.8667604766330328 44.261703328157822 0 0, 4.8295255649546505 44.249740307153033 0 0, 4.8070055704376671 44.317482295349365 0 0, 4.7987085172756565 44.330940429949791 0 0, 4.7790525436339806 44.344074335771907 0 0, 4.7410375114639578 44.3457373724156 0 0, 4.7036255236992588 44.336467280878665 0 0, 4.6657604605406959 44.335376309126147 0 0, 4.6466754956704222 44.337555436311717 0 0, 4.6310945690478507 44.345306300826991 0 0, 4.6333775262704879 44.304348382978759 0 0, 4.6303575646738864 44.290561273609413 0 0, 4.6231014954745557 44.284885338525868 0 0)))'),
('Vende', '85', 'MULTIPOLYGON (((-2.146720579427289 46.882129301383209 0 0, -2.1392135140185644 46.867233425998663 0 0, -2.1338165658250148 46.817035347865712 0 0, -2.1080174953516746 46.7984353180032 0 0, -2.0487304502273105 46.771839405141421 0 0, -1.9779325793921885 46.719043272302585 0 0, -1.9651315273267755 46.694240298819793 0 0, -1.9359354475195119 46.6914403492123 0 0, -1.8541375609164561 46.603344292187089 0 0, -1.8283444751219804 46.545848426242074 0 0, -1.817547586395392 46.5061532834916 0 0, -1.8010464186137085 46.488151369475318 0 0, -1.7912524916563939 46.490146379775908 0 0, -1.7286515186223141 46.464557301122639 0 0, -1.7267545514430935 46.459152432030564 0 0, -1.7105575461635567 46.456852379127994 0 0, -1.6597555435254776 46.434253351646063 0 0, -1.637755518159536 46.435856380104781 0 0, -1.6446574311692761 46.423053383100381 0 0, -1.6165614758804452 46.413257337999241 0 0, -1.523760581169995 46.406059353508212 0 0, -1.5032635841282627 46.396156294171632 0 0, -1.4772724758714446 46.369457409629419 0 0, -1.4651735674525241 46.347862400036533 0 0, -1.4539674323037843 46.343460316693765 0 0, -1.432665495955149 46.342456298804692 0 0, -1.4131675882433967 46.346763331365551 0 0, -1.3990784220629848 46.340759290307446 0 0, -1.354170448003913 46.3442613835614 0 0, -1.3187835699540642 46.327362410655368 0 0, -1.2988825765189915 46.296669281032834 0 0, -1.2884845490365535 46.290764339215869 0 0, -1.2754844192643346 46.290756432442905 0 0, -1.2916775615404155 46.297565392969034 0 0, -1.291378493306155 46.307567381240133 0 0, -1.2773815615882143 46.31156127428055 0 0, -1.2595845348129728 46.2979623237069 0 0, -1.1962914328233583 46.267158279431136 0 0, -1.2025834597573113 46.282665294216244 0 0, -1.1941874846106657 46.299362386520627 0 0, -1.1858844467698191 46.304062295646773 0 0, -1.1520894932971828 46.310161387486787 0 0, -1.1276924218572049 46.304657419153571 0 0, -1.1137995179394693 46.294464278912173 0 0, -1.1122364606367228 46.287777280383963 0 0, -1.1101124277006988 46.320030298949845 0 0, -1.0531414532958649 46.339244286455582 0 0, -1.0436175409671762 46.353733369999944 0 0, -1.0258375881287236 46.366081346671521 0 0, -0.98811351696335237 46.377205280495886 0 0, -0.92870343388241849 46.376213407984537 0 0, -0.92657040195862084 46.362644401100304 0 0, -0.94004246795873192 46.347881407021852 0 0, -0.93400955577325817 46.33460633635768 0 0, -0.83385841930075344 46.350399375814035 0 0, -0.81392644635155875 46.3491403049935 0 0, -0.79623151115691826 46.336734417752936 0 0, -0.7631605278066047 46.333694376911112 0 0, -0.72557058385572759 46.339222283959785 0 0, -0.68448945988885157 46.328537343931927 0 0, -0.66498257515880255 46.329963281680719 0 0, -0.58713756894394464 46.36311734645524 0 0, -0.56927048622205234 46.375400371759142 0 0, -0.55959854145739951 46.38983135937049 0 0, -0.57190849746032768 46.419151366578276 0 0, -0.6147065201806754 46.44075429706966 0 0, -0.62520646322371931 46.483925306099067 0 0, -0.62933745948949371 46.511093293221727 0 0, -0.6223524754865366 46.569252393030936 0 0, -0.60318354098098481 46.625545340497005 0 0, -0.61556444149752565 46.654873433306889 0 0, -0.668900427573675 46.692176288692352 0 0, -0.67908951935584128 46.732608427042649 0 0, -0.70683044209988566 46.758037327526395 0 0, -0.71931342787991381 46.7873263498213 0 0, -0.70777143237445994 46.815628419221831 0 0, -0.7138135062117783 46.82891440734646 0 0, -0.73558541587104287 46.84104535139933 0 0, -0.77707455412033255 46.851719378189259 0 0, -0.78705542414136453 46.864719320817692 0 0, -0.78594452596900322 46.908729433352683 0 0, -0.79203044261589639 46.9220013345025 0 0, -0.85542156927971291 46.944774269711374 0 0, -0.89477945777431955 46.9665563885287 0 0, -0.9209564431157844 47.005806376783838 0 0, -0.95686258006688263 47.030567281494612 0 0, -0.97261143851164888 47.054103439278336 0 0, -0.99321651181284665 47.058036429410336 0 0, -1.011241484444696 47.045700422096488 0 0, -1.0169624853966468 47.031540319869563 0 0, -1.035410434008071 47.021900410382941 0 0, -1.0559954410330761 47.025840441313605 0 0, -1.1253365706252509 47.059017388683756 0 0, -1.1678985505704986 47.050270428487337 0 0, -1.1894275526759657 47.059597374473455 0 0, -1.2435345062054921 47.096618421892529 0 0, -1.2641934416164133 47.10052131261024 0 0, -1.3028085258523276 47.092003354390258 0 0, -1.3123945732291702 47.077530288662857 0 0, -1.3303345282172074 47.065139363119457 0 0, -1.3514444267823649 47.071731310865729 0 0, -1.3707504781953603 47.0674703928606 0 0, -1.3650375467323081 46.985504394653105 0 0, -1.4441944517224954 46.957267286835375 0 0, -1.4866235365930152 47.066578326345777 0 0, -1.525202536735776 47.058002281536844 0 0, -1.543084578886611 47.045585287245963 0 0, -1.5266385336032218 47.01941340621719 0 0, -1.5334034804957395 46.988643362662565 0 0, -1.5306375052421117 46.972362407124464 0 0, -1.4961435764824103 46.933899404139638 0 0, -1.4938725750014816 46.920345326397211 0 0, -1.5112684441458555 46.9051974123784 0 0, -1.5128944918652945 46.891330409745386 0 0, -1.5004365498990178 46.864845351226883 0 0, -1.5388585177785785 46.856266325964484 0 0, -1.5997075640858327 46.862388300400156 0 0, -1.6413614570238053 46.872749363689607 0 0, -1.6696355442464039 46.897956302995581 0 0, -1.6946574865675643 46.904163295075065 0 0, -1.7116064491440852 46.933021416546623 0 0, -1.7257734161497069 46.9456144130116 0 0, -1.75036058915353 46.949093271629962 0 0, -1.7695594389421387 46.944770397272109 0 0, -1.7897304470058657 46.945869289923124 0 0, -1.8009154597586132 46.96418328734002 0 0, -1.8628574140380465 46.975570371014342 0 0, -1.9786935137074693 47.023746331771875 0 0, -1.9889225620220259 47.016021343501066 0 0, -2.0200284584660722 47.007125294392992 0 0, -2.0293274172775284 46.998123281265052 0 0, -2.0396205368599 46.943226350125784 0 0, -2.0463224970852707 46.937427372328656 0 0, -2.0775155234127567 46.929535341109627 0 0, -2.0959675204834127 46.917114316151967 0 0, -2.1128184544960638 46.902633314485463 0 0, -2.1060194619265262 46.895427418713957 0 0, -2.1115185324858032 46.889537267996772 0 0, -2.1430225860941334 46.886528382689008 0 0, -2.146720579427289 46.882129301383209 0 0)), ((-2.2985105357884095 47.0256272849072 0 0, -2.288203511618244 47.006324391951878 0 0, -2.2925094876527394 46.986526386026249 0 0, -2.2535124313203596 46.959926420469642 0 0, -2.2219055820515905 46.961631349865385 0 0, -2.1876165405329289 46.948326352635817 0 0, -2.1494094705794282 46.897628377797943 0 0, -2.1441174050199625 46.9186284401871 0 0, -2.1517155081608621 46.945831269610338 0 0, -2.1831104293899273 46.964325335453012 0 0, -2.2123054530773913 46.975132433337635 0 0, -2.2265125526353984 46.974224346330331 0 0, -2.2285135670728642 46.987228339209928 0 0, -2.21321653899005 46.990524331695852 0 0, -2.2158124748904129 47.011127284351872 0 0, -2.2610084176147041 47.026531319682206 0 0, -2.2985105357884095 47.0256272849072 0 0)), ((-2.3915015424154373 46.724041363140557 0 0, -2.3749984198752543 46.6959454042355 0 0, -2.3386015392574677 46.690445308341552 0 0, -2.3295034192278194 46.684047334598361 0 0, -2.3041054982581954 46.693443280411387 0 0, -2.2766055548583974 46.686542417440741 0 0, -2.2930044470294604 46.706043317675025 0 0, -2.3170065296645816 46.719242350884727 0 0, -2.3661064192263837 46.731842388148365 0 0, -2.3821064581633777 46.723941379911039 0 0, -2.3915015424154373 46.724041363140557 0 0)))'),
('Vienne', '86', 'POLYGON ((1.1687165153546175 46.384384430850488, 1.1677404846402339 46.425434399283304, 1.1817905743880885 46.439956398561421, 1.2190115804891093 46.458534425928107, 1.2252395189446474 46.472580291196763, 1.2079434449941573 46.485290340939471, 1.1664564189844668 46.502105352321465, 1.139661427540517 46.527954412465292, 1.1010414147455663 46.55311241822055, 1.0408385377353966 46.560566335742905, 1.0198895214196284 46.5703083368101, 0.98095953746363307 46.565250403072056, 0.93968655173324578 46.57925437558869, 0.91667352529003665 46.605289312817163, 0.91328144451514959 46.632499359342162, 0.93795645148227891 46.688785440057231, 0.93063648515445152 46.715747298429434, 0.94007854819869863 46.735485297375519, 0.86613044802268746 46.755756284780219, 0.84695148849027646 46.782009310747227, 0.84745349743479892 46.809444310789431, 0.79459857392714639 46.850120412813354, 0.75202744094366381 46.872207398212694, 0.724844501493493 46.897964399914017, 0.697751508246256 46.953861300483126, 0.66874852234226978 46.993202291060967, 0.62994351256247683 47.015491347381882, 0.56740942711567754 47.036293387025594, 0.58464847059704539 46.996242331902792, 0.58604448495151473 46.9552154220856, 0.56271550266839654 46.951034419820772, 0.50201554527276926 46.958194383999043, 0.45855955991757469 46.955455337299966, 0.38212746597397995 46.931404321114186, 0.34190443934389236 46.934337341816345, 0.32105346614949326 46.941230283705394, 0.29907244477001882 46.9562534118282, 0.27560458273330823 46.98214330860425, 0.26979046721908162 46.995498295504305, 0.27604956120867996 47.037033374964849, 0.27195252046789165 47.066909419902814, 0.25424455979572258 47.079483406211395, 0.1933675263137502 47.086490409038745, 0.18752243128543 47.099819344983743, 0.1975314546418474 47.114177293653043, 0.19167157393630418 47.127502357158775, 0.15358842203923473 47.114055311816244, 0.13224652915820911 47.123630269935219, 0.092641508630578073 47.121013381092908, 0.071705517792338469 47.127853340972038, 0.055586489357978053 47.156959298556458, 0.015572574448128762 47.1570473085397, -0.0034655691110572207 47.150295358643845, -0.0094585209112665325 47.136181373648142, -0.0071355854130672469 47.119884389027632, -0.02614046119856539 47.11310938051615, -0.0672985058908182 47.121330393052617, -0.086700482720829086 47.117279293523083, -0.0773914907712765 47.024635408622785, -0.056065439687216667 47.015113432513758, -0.036288540328541785 47.016441327141209, -0.0009724223052103298 46.936523333780613, 0.0018164380443863593 46.832489372866561, -0.00019547017299714753 46.818615303085224, -0.017965565893348412 46.803711340479779, -0.01765154627304355 46.773574433951453, 0.023252501607515796 46.76533141891916, 0.040906424149937948 46.752811294720331, 0.031018502530514525 46.738422366536909, -0.006774568461707986 46.7249073774873, -0.020578582296366221 46.710266388711844, -0.030527582844200651 46.668445276805684, -0.020821489850163744 46.627941322309042, 0.042370558231482391 46.6294674154188, 0.052112559298677752 46.616398284944367, 0.042262481972045407 46.602001435862476, 0.02302754809028329 46.597973394948568, 0.0030334400929064032 46.5993732817423, -0.015435454894543454 46.589897422864496, -0.032732584964833222 46.572250365100743, -0.02690350775344541 46.55893727095274, 0.010012455745595616 46.577884412189221, 0.023687446944791191 46.565082304004036, 0.016142527099731296 46.534408360557833, -0.002316510769588831 46.524929333320628, -0.021899436125153215 46.523601438693177, -0.041162533201571705 46.492103369763711, -0.039237578847661325 46.478511283968757, -0.021667441809285037 46.465999432708358, -0.021373488465201262 46.435833306865575, 0.0058444789582949852 46.382801307271578, 0.033095538135484048 46.357196386821315, 0.03109243091645908 46.34334132719637, 0.05212752099583895 46.333774289975921, 0.08852950619262856 46.355434426956421, 0.12707154214243133 46.333313293683588, 0.12100448593631086 46.291763428545849, 0.11506944470508529 46.277641346631682, 0.097061546009939548 46.26545337210969, 0.098965553987824251 46.2518693832332, 0.0738054359929663 46.206264370106695, 0.11388553441022964 46.200733294698651, 0.12355554331111307 46.187652370886482, 0.14453254680157102 46.178070371968843, 0.18200649359448562 46.191543292246465, 0.19552957956256023 46.178745408540451, 0.180357538548094 46.117347355957591, 0.19776256885788257 46.104786395126538, 0.23813855683886231 46.096489341964528, 0.27996653352371936 46.077285387596888, 0.39736551447589363 46.079452369404763, 0.41082153683672118 46.066600271549063, 0.43169345640714596 46.05697233142017, 0.45079355899454754 46.060939293405696, 0.46879758525042803 46.073078334377, 0.47868057831078659 46.087417272889937, 0.47122050008960059 46.114387404200542, 0.48111141404848468 46.128727398833249, 0.5635665592065493 46.098327342454965, 0.58335842026238538 46.096832404879294, 0.66084346564571206 46.104404431799182, 0.74128951890585881 46.15053944104487, 0.760422537227015 46.154453421020506, 0.78024256147747906 46.152923279451514, 0.82549958313018124 46.136509417573208, 0.82598046967871142 46.163948290054677, 0.80149943671469259 46.233753408278645, 0.81930244816879849 46.248562320102153, 0.87412351470251792 46.282016322899622, 0.8880495103739463 46.296573350151064, 0.92576654074065345 46.309799314415656, 0.98570045924196847 46.302414396720181, 1.0049084620688404 46.306293348722434, 1.0227864580286905 46.321048398436218, 1.0490935221254176 46.363708421502807, 1.0683025810720892 46.367588429624888, 1.1282965223819872 46.360111277466942, 1.1471924418082153 46.366710442031874, 1.1687165153546175 46.384384430850488))'),
('Paris', '75', 'POLYGON ((2.4356494437198535 48.867469407338874, 2.4082765787258325 48.8935472934392, 2.3869274690261761 48.900779425803719, 2.34564251393806 48.901638403240369, 2.3259835479569233 48.892551372468589, 2.283275471439481 48.890281418980308, 2.2515075639013276 48.856380325467867, 2.2722795041307791 48.854599355446609, 2.2819085003794441 48.841377439641249, 2.3038045041151065 48.828750295302754, 2.3458764444735607 48.819732440377848, 2.3789175044295519 48.818496428172907, 2.4195844534152116 48.823063442224324, 2.4613694812282176 48.816745381545942, 2.4831954290172007 48.8450203488684, 2.4616085163427783 48.85498431111337, 2.4419465580222379 48.845913298158578, 2.4356494437198535 48.867469407338874))'),
('Vosges', '88', 'POLYGON ((5.4328364644924818 48.43248728188702, 5.4024094770593081 48.3973463037304, 5.42323545541845 48.386875403981819, 5.4360664308781566 48.3735082717041, 5.4495015068629868 48.3465154338178, 5.4900475301316476 48.35007138918148, 5.5310925700053986 48.3427044255226, 5.5520014537687814 48.329498351514232, 5.5821945106664543 48.289169360864278, 5.6233814226332015 48.276321311467839, 5.657553586894096 48.236072409902661, 5.6779785917695165 48.233734336687334, 5.703413476932127 48.206916286627788, 5.7039644194273365 48.19329427743854, 5.6640705501346531 48.176189361171666, 5.5947804663327361 48.087585310523039, 5.5912885822368708 48.073894301506911, 5.6321125410326545 48.066494422114275, 5.6735555620507228 48.042728382254282, 5.7349984997250374 48.024761320191388, 5.7446845264428816 47.98401234590132, 5.7699784196123005 47.95720327286007, 5.790470488094968 47.949386402166752, 5.8104635399725453 47.955185379963851, 5.8500185708296613 47.977718399958363, 5.8701205790665085 47.980777274936585, 5.8867734760593464 47.967422288036559, 5.9229374822614034 47.973491280462312, 5.9432535307775538 47.9710963527978, 5.9517954277129945 47.957607414703219, 5.9719794612542216 47.95794343681932, 6.0714985100269416 48.003158389700005, 6.1116495444907457 48.011959388026142, 6.1321224267970535 48.00409340776217, 6.1446854998677054 47.990631400722478, 6.1536385794449586 47.963489297904559, 6.1831745538075609 47.923019315261442, 6.2238635052890459 47.912696272284748, 6.3079894319693608 47.935691344691364, 6.3481904561036231 47.941673383253672, 6.3885764772226992 47.942215348730585, 6.4089764872628621 47.934280368639733, 6.4295975783809922 47.918190383499834, 6.4505015335853386 47.891166390079476, 6.4911214852399155 47.880752344780078, 6.51127647548671 47.880989443675006, 6.5750984990285417 47.911747348645221, 6.6153255741178612 47.917652290462186, 6.6356914362845316 47.909687386977012, 6.7259215593838917 47.842449343944836, 6.7666664852147278 47.821037395117131, 6.8476624248503128 47.799984351001157, 6.8757205355740041 47.808414299237867, 6.8875524217037309 47.82215529792451, 6.89533655268329 47.835876406354927, 6.8946085341017636 47.876777285876088, 6.9532904225812047 47.983646400390924, 6.9932444907024376 48.011245275021977, 7.0130345915586076 48.03865440012909, 7.0530164708345353 48.068958349605666, 7.0689364206867822 48.08816934477197, 7.080645444879849 48.1155122863717, 7.0760145355806117 48.156376377719837, 7.1402574228624189 48.200454417636749, 7.1522144591883432 48.216884297332015, 7.17555646694899 48.2933693732855, 7.2035885267176241 48.326255359651, 7.1425685650228559 48.328598361425392, 7.1016595885832317 48.34467338486813, 7.0973875839957259 48.35826828698255, 7.1167624537508516 48.426551360555962, 7.0998504553673172 48.467308431764465, 7.107811486413226 48.480991343862158, 7.0994394487454713 48.4972913208221, 7.0587485610443821 48.488804342116211, 7.0182454866475439 48.472168343040167, 7.0021375474710794 48.458419423455055, 6.941490572085371 48.430668291552976, 6.8601955745266707 48.419067343619318, 6.7997425731440728 48.385810307164391, 6.7794555679224118 48.3828883757201, 6.7385175481882982 48.393383390204079, 6.6846265711576791 48.436447379093849, 6.664192589263962 48.438964288595187, 6.6394964599008688 48.449604343531561, 6.6143894999358963 48.476593308978593, 6.5940625381818165 48.473632301101745, 6.5739455682478365 48.462513295836445, 6.5786945869446356 48.435318387028573, 6.5583734338494537 48.432361427610957, 6.5181715296153584 48.410080292188539, 6.47782352880904 48.395965427093032, 6.396252531942821 48.40040641084839, 6.3559075234759348 48.386268311117291, 6.3473895652559236 48.399776435388205, 6.2857554698979641 48.418041323234448, 6.2655415129624146 48.4123004320263, 6.2537425425664139 48.398510323769, 6.2336234603928347 48.3900603092561, 6.1727414983517974 48.383739432258253, 6.133368472140063 48.342254342468195, 6.07625949808147 48.346843359015409, 6.0645175581546482 48.333034416621715, 6.0038955776041973 48.321167326498667, 5.9628424408119827 48.331413272730018, 5.9461004777161008 48.344764387190807, 5.93290250062617 48.37182640092395, 5.9122544784531783 48.379665274113094, 5.91177253578482 48.3932913317616, 5.8990684707209766 48.406704405250608, 5.8589565126897867 48.389671305130079, 5.8502984425764453 48.403137360629, 5.8615015853857244 48.430606332524761, 5.8604804935599475 48.457851407023085, 5.8309225167014915 48.484600281235785, 5.7536685855342284 48.477787428431512, 5.7461484845044595 48.461300342247128, 5.7303955776004614 48.447380331254536, 5.71002249861516 48.447006288825676, 5.6688285458497205 48.457149439396588, 5.5835935173603559 48.447342310941778, 5.5635855037856459 48.438778411510512, 5.494817495204444 48.426521437161639, 5.4328364644924818 48.43248728188702))'),
('Yonne', '89', 'POLYGON ((4.2578104254276923 47.953109400478681, 4.23100047228661 47.941555273856139, 4.2106435871382359 47.943664345095, 4.1976165254358193 47.956916360314651, 4.1772524234688149 47.958992339799821, 4.1620434182613621 47.944877298684318, 4.1413225238222253 47.952423274649178, 4.1015455317873091 47.942970298367, 4.0780984401066576 47.931308271504989, 4.0381325786476623 47.924560370068335, 4.0176215000086017 47.929359378435649, 3.9576965585255834 47.919216403884704, 3.9167775489478629 47.926029432708944, 3.911764500301274 47.939537380959919, 3.9360575439410468 47.994938433283309, 3.915664574699548 47.997001387290979, 3.8958845069814458 47.990871315936843, 3.87549241783978 47.992916315907891, 3.8694535248282875 48.020015293834021, 3.8391545039108053 48.046295426875858, 3.825003554722116 48.073124390173334, 3.7946615849327827 48.099380408479774, 3.7310745480462515 48.1354183843858, 3.7036344434250168 48.175411352919625, 3.6831965890920344 48.177421324917376, 3.6531255140311885 48.146331270270295, 3.6333035535610634 48.140178316320529, 3.6126474344696078 48.1449053325215, 3.6153965143067524 48.161384321787395, 3.5981254351914913 48.174423352847541, 3.5578474903318522 48.170231437344782, 3.55271157974866 48.183693268364507, 3.5818794963612675 48.22571134661321, 3.57674446587788 48.239166312854238, 3.59059354082396 48.269691343408752, 3.5773374771451074 48.282863269543626, 3.5564065908858993 48.290317363085947, 3.5379825809899046 48.316940383022583, 3.4859704410819745 48.356010302851971, 3.4649825243536156 48.363418279163071, 3.4241145605661814 48.364639329670851, 3.3825664556281083 48.374008344428987, 3.3728575463146342 48.392757287183159, 3.3333334949716118 48.377636291958979, 3.1165425516625191 48.385627422419176, 3.0519955018785652 48.377594399206956, 3.0369554758389938 48.363346286996759, 3.0365594309143091 48.32236443829099, 3.0149024622932075 48.291435441913322, 3.0063874964126285 48.250141333786942, 2.9873484727536095 48.235702415933034, 2.947818436731751 48.223159409138546, 2.9449975407482327 48.209396407956106, 2.9659995390739198 48.202053383012654, 3.0312855206773577 48.199230374789565, 3.0487014642250472 48.186290442970559, 3.0672914609494626 48.1597364228608, 3.0830475362128595 48.119403383751646, 3.0830934774241143 48.072971428822413, 3.0883355280471392 48.059517342681218, 3.1189955659159807 48.033420270404562, 3.1216205516767559 48.003482442458349, 3.1308784978360222 47.990177269208843, 3.1292344713486955 47.962806340434454, 3.0953205283786929 47.934139376646542, 3.035582520100121 47.923545438941389, 3.0164155299254389 47.911811419913036, 3.0067624189413209 47.884105349122379, 3.0083235400244348 47.821327300001983, 2.9866304873101797 47.793110419268473, 2.9670234472191908 47.786827386563445, 2.8670324889162089 47.777195397975319, 2.8476905348948094 47.768177367030447, 2.8383924561831861 47.737732425560679, 2.8594675027949847 47.727680277312473, 2.8795485646558063 47.728534326190058, 2.8928305032697494 47.7154233029636, 2.9033535049284183 47.688533436757709, 2.9241395267551695 47.681202381171985, 2.9374094960113837 47.668090301825728, 2.9373174375689075 47.624370286520744, 2.9465685189494479 47.611080427008304, 2.9638135471096803 47.598133278370696, 3.0050775558217708 47.58616233646741, 3.0251045795528739 47.586971324233545, 3.1037874408083894 47.606578364324534, 3.1250175610106794 47.593769391360652, 3.1537274736704148 47.540264426116622, 3.2400904381052555 47.516342432566276, 3.254375514508439 47.489570323718013, 3.2741464291882494 47.493072416971941, 3.2943575698043333 47.4911303886813, 3.3357064201402977 47.4763144360591, 3.3747844368881488 47.488750422713949, 3.3925675580860286 47.516761360086619, 3.4892334992213705 47.51218044045784, 3.5089155238181036 47.56756635506413, 3.528736428168429 47.571022331086837, 3.5348835734592967 47.543914376142439, 3.5439684919914782 47.530601281994436, 3.5648344268830385 47.520435424847832, 3.5789695342747052 47.493629344146015, 3.6408484734061233 47.471271287998249, 3.6709554565401561 47.445022310490472, 3.67723144844652 47.415207344480919, 3.6980215187325314 47.404998362442527, 3.7179974966733482 47.405712299426753, 3.7387724292422035 47.395530424463217, 3.758361515296599 47.40166841671585, 3.798286540123371 47.403061438730916, 3.8092474794587474 47.417095334641843, 3.811033554059037 47.447200381556243, 3.8310135804590857 47.447902349182741, 3.8515975313642912 47.440406362888368, 3.8605925036935673 47.427051375988313, 3.8316354590008359 47.385097369007454, 3.8366275612713991 47.371597341654976, 3.8535825085267561 47.358505328584911, 3.8739404497949295 47.353733427292482, 3.9328075112791794 47.369396387993575, 3.953174429565621 47.364616389782682, 3.9701084304450092 47.351516279794154, 3.9879834340653986 47.324794336636316, 4.025611574349 47.301437367178536, 4.0476244553424294 47.329467314707571, 4.06738551290411 47.332851298563995, 4.0876975129610287 47.328045425418011, 4.1027215211836392 47.342178420570079, 4.1014154530320468 47.361274298678282, 4.0955765187025293 47.388385421982107, 4.1007365440211743 47.429538362095329, 4.10761153187363 47.44615535101498, 4.1419285605669529 47.471824342733058, 4.1229555443953814 47.514930400394846, 4.1656954805268072 47.535392369463224, 4.18079042479593 47.549526420735091, 4.24695245777275 47.641693291526124, 4.2719675353151843 47.688888293010208, 4.2751015708191176 47.702652350312476, 4.2411615768940862 47.728904320159685, 4.2353295073432662 47.756042374518344, 4.2384455888106345 47.769790414003651, 4.2878434801757805 47.814964354232146, 4.2818635538530714 47.844818396674285, 4.2613565236732711 47.849647328435864, 4.2443285281317742 47.862793379635647, 4.2465395149312712 47.890159379851, 4.263977460974786 47.931644293621062, 4.2578104254276923 47.953109400478681))'),
('Yvelines', '78', 'POLYGON ((2.226188499876713 48.784191368837313, 2.1774325533294814 48.817424290556815, 2.170458466235857 48.844402342765946, 2.1792645691410542 48.877586330934761, 2.1845784359104243 48.905132399575834, 2.2048504794349242 48.947048386243935, 2.20051457959957 48.987793312074771, 2.1826325351804883 49.000599292699249, 2.1618195822988753 49.002361428584109, 2.1301324679253639 49.028167363836147, 2.0693744239407863 49.017109437499229, 1.9851055690476471 49.032196284849888, 1.9645445007381 49.031204412338539, 1.9427935374548611 49.041069275342366, 1.8817575579431605 49.032623309288667, 1.8580145766987641 49.023273304686924, 1.8150834828837219 49.037521416897121, 1.7325774679553376 49.036155325936917, 1.7145794263783216 49.048889314395083, 1.7152224273160357 49.078968310354426, 1.709539446676871 49.092342307410874, 1.6241065717451306 49.1152953110455, 1.5848745375265878 49.096920410720159, 1.50079754439696 49.07343635484655, 1.4815395518996013 49.06151540261375, 1.4810294460366151 49.031440279093673, 1.5020995640893489 48.958782405272288, 1.4955285627190733 48.944767343497787, 1.4756694620360236 48.938266398074163, 1.4769915480045768 48.927425328336014, 1.5183025540477217 48.926849391005547, 1.5397544594078454 48.919757370534356, 1.5552744918961423 48.893249291635854, 1.5770555545936418 48.883438290741779, 1.5843415490679433 48.8564984348654, 1.6120875763909908 48.830597272811488, 1.6005014141345271 48.789020300598921, 1.6341844189084611 48.747036370223739, 1.6128335490091104 48.718612313989624, 1.6106685034208965 48.702114314567339, 1.6317514709311638 48.66220829989696, 1.6828854472261412 48.610183310531468, 1.6957315604029475 48.56983530972515, 1.7095084671627774 48.556881296308845, 1.7304844145334073 48.552471292067551, 1.76209055972231 48.526756359138218, 1.7733084882088122 48.499977385511258, 1.7967205519161098 48.473827331224655, 1.8607545034976738 48.449707315211995, 1.9017044925894879 48.448997426687, 1.9333495381910097 48.458767414928857, 1.9460044936841996 48.492183397413569, 1.9900774290220795 48.5380443435714, 1.9842224768756012 48.554168300564825, 1.986817539242054 48.567951368023458, 2.047921462460863 48.570915368239739, 2.0505364150835135 48.584697379578571, 2.0691434857446893 48.6019744433727, 2.0224554217641924 48.654365378248585, 2.0302664837986129 48.695724437742612, 2.092993487128723 48.685066428769645, 2.1128404424340772 48.6914823565494, 2.1031964844882509 48.70467734129987, 2.0597005426006376 48.727192407257789, 2.0582084213444034 48.740764426776579, 2.1408434589082503 48.736499286967742, 2.1607064320305653 48.742893388271668, 2.1715374686306461 48.757068276175787, 2.1913995616531281 48.763450408121983, 2.2022304222332423 48.7776263521459, 2.226188499876713 48.784191368837313))');

*/